/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.OpenBrowserEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.DedicatedDomainNotExistedNotification;
import com.alibabacloud.intellij.cosy.ui.search.component.LoginOptionPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.WrappedHtmlEditorKit;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.alibabacloud.intellij.cosy.util.ThemeUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SystemMessageCard
extends RoundRectPanel {
    private static final Logger LOGGER = Logger.getInstance(SystemMessageCard.class);
    JPanel headerPanel;
    JLabel titleLabel;
    JTextPane contentPane;
    JPanel loginOptionPanel;
    private Font originalFont;
    private Color originalColor;
    private Project project;
    private String originalText;

    public SystemMessageCard(final Project project, String text) {
        this.setLayout(new BorderLayout());
        this.project = project;
        this.originalText = text;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)12, (int)12));
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.setPreferredSize(new Dimension(-1, 40));
        this.headerPanel.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.titleLabel = new JLabel(CosyBundle.message("cosy.plugin.name", new Object[0]), LingmaIcons.Logo20Icon, 10);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 14.0f));
        this.headerPanel.add((Component)this.titleLabel, "West");
        this.add((Component)this.headerPanel, "North");
        this.contentPane = new JTextPane();
        this.contentPane.setEditable(false);
        this.contentPane.setBorder((Border)JBUI.Borders.empty());
        this.contentPane.setCursor(Cursor.getPredefinedCursor(2));
        this.contentPane.setFont(this.contentPane.getFont().deriveFont(13.0f));
        this.originalFont = this.contentPane.getFont();
        this.originalColor = ColorUtil.getTextPaneForegroundColor();
        this.contentPane.setEditorKit(new WrappedHtmlEditorKit());
        this.contentPane.setText(this.buildText(text));
        this.contentPane.setOpaque(false);
        this.contentPane.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.setBackground(ColorUtil.getChatCardBackgroundColor());
        this.contentPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SystemMessageCard.this.sendTelemetry(e.getDescription());
                    UrlUtil.performHyperlink(project, e, SystemMessageCard.this);
                }
            }
        });
        this.add((Component)this.contentPane, "Center");
        this.loginOptionPanel = new JPanel();
        this.loginOptionPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        this.loginOptionPanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        SwingUtil.foreachChildComponent(this, cp -> {
            if (cp instanceof JPanel) {
                Color color = ColorUtil.getChatCardBackgroundColor();
                cp.setBackground(color);
            }
        });
        SwingUtil.preventRecursiveBackgroundUpdateOnToolwindow(this);
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.originalColor = ColorUtil.getTextPaneForegroundColor();
        this.titleLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.contentPane.setText(this.buildText(this.originalText));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public void addLoginOptions() {
        LoginOptionPanel aliyunLogin = new LoginOptionPanel(this.project, LingmaIcons.AliyunGrey20Icon, CosyBundle.message("login.option.individual", new Object[0]), CosyBundle.message("login.option.hint.individual", new Object[0]));
        aliyunLogin.addLoginMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TelemetryService.getInstance().telemetryOpenBrowser(SystemMessageCard.this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.BEFORE_LOGIN_TO_ALIYUN_ACCOUNT.getId());
                UserAuthService.getInstance().login(SystemMessageCard.this.project, null, LoginParams.fromAliyun());
            }
        });
        LoginOptionPanel alibabaCloudLogin = new LoginOptionPanel(this.project, LingmaIcons.AliyunGrey20Icon, CosyBundle.message("login.option.enterprise.standard", new Object[0]), CosyBundle.message("login.option.hint.enterprise.standard", new Object[0]));
        alibabaCloudLogin.addLoginMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TelemetryService.getInstance().telemetryOpenBrowser(SystemMessageCard.this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.BEFORE_LOGIN_TO_ALIYUN_CLOUD_ACCOUNT.getId());
                UserAuthService.getInstance().login(SystemMessageCard.this.project, null, LoginParams.fromAliyunCloud());
            }
        });
        LoginOptionPanel enterpriseDedicatedLogin = new LoginOptionPanel(this.project, LingmaIcons.EditionIndividualProGrey20Icon, CosyBundle.message("login.option.enterprise.dedicated", new Object[0]), CosyBundle.message("login.option.hint.enterprise.dedicated", new Object[0]));
        enterpriseDedicatedLogin.addLoginMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
                if (cosySetting != null && StringUtils.isBlank((CharSequence)cosySetting.getDedicatedDomainUrl())) {
                    DedicatedDomainNotExistedNotification.notify(SystemMessageCard.this.project);
                } else {
                    TelemetryService.getInstance().telemetryOpenBrowser(SystemMessageCard.this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.BEFORE_LOGIN_TO_ENTERPRISE_DEDICATED.getId());
                    UserAuthService.getInstance().login(SystemMessageCard.this.project, null, LoginParams.fromDedicatedDomain());
                }
            }
        });
        this.loginOptionPanel.add(Box.createVerticalStrut(12));
        this.loginOptionPanel.add(aliyunLogin);
        this.loginOptionPanel.add(Box.createVerticalStrut(12));
        this.loginOptionPanel.add(alibabaCloudLogin);
        this.loginOptionPanel.add(Box.createVerticalStrut(12));
        this.loginOptionPanel.add(enterpriseDedicatedLogin);
        JTextPane textAfterOptionsPane = new JTextPane();
        textAfterOptionsPane.setEditable(false);
        textAfterOptionsPane.setBorder((Border)JBUI.Borders.empty());
        textAfterOptionsPane.setCursor(Cursor.getPredefinedCursor(2));
        textAfterOptionsPane.setFont(textAfterOptionsPane.getFont().deriveFont(13.0f));
        textAfterOptionsPane.setEditorKit(new WrappedHtmlEditorKit());
        textAfterOptionsPane.setText(this.buildText(CosyBundle.message("message.chat.not.login.after.options", new Object[0])));
        textAfterOptionsPane.setOpaque(false);
        textAfterOptionsPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    UrlUtil.performHyperlink(SystemMessageCard.this.project, e, SystemMessageCard.this);
                }
            }
        });
        this.loginOptionPanel.add(Box.createVerticalStrut(12));
        this.add((Component)this.loginOptionPanel, "South");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private String buildText(String text) {
        return ThemeUtil.getMarkdownContent(this.originalColor, this.originalFont, text);
    }

    private void sendTelemetry(String description) {
        if (description.startsWith("url:")) {
            String refId = description.substring("url:".length());
            if (refId.equals(LingmaUrls.HELP_DOCUMENT_URL.getRefId())) {
                TelemetryService.getInstance().telemetryOpenBrowser(this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.AFTER_LOGIN_TO_DOCS.getId());
            } else if (refId.equals(LingmaUrls.SURVEY_URL.getRefId())) {
                TelemetryService.getInstance().telemetryOpenBrowser(this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.AFTER_LOGIN_TO_SHARE_FEEDBACK.getId());
            } else if (refId.equals(LingmaUrls.HOMEPAGE_URL.getRefId())) {
                TelemetryService.getInstance().telemetryOpenBrowser(this.project, TrackEventTypeEnum.OPEN_BROWSER, OpenBrowserEnum.AFTER_LOGIN_TO_WEBSITE.getId());
            }
        }
    }

    @Generated
    public JPanel getLoginOptionPanel() {
        return this.loginOptionPanel;
    }
}

