/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import lombok.Generated;

public class RoundRectLabel
extends JLabel {
    private Color backgroundColor;
    private int leftRightPadding;
    private int topBottomPadding;
    private int leftRightMargin;
    private int cornerRadius;

    public RoundRectLabel(String text, Color backgroundColor, int leftRightPadding, int topBottomPadding, int cornerRadius, int leftRightMargin) {
        super(text);
        this.backgroundColor = backgroundColor;
        this.setOpaque(false);
        this.leftRightPadding = leftRightPadding;
        this.topBottomPadding = topBottomPadding;
        this.leftRightMargin = leftRightMargin;
        this.cornerRadius = cornerRadius;
        this.setBorder(BorderFactory.createEmptyBorder(topBottomPadding, leftRightPadding + leftRightMargin, topBottomPadding, leftRightPadding + leftRightMargin));
        this.setForeground(ColorUtil.getTextForegroundColor());
        this.setFont(FontUtil.LABEL_DEFAILT_FONT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension arcs = new Dimension(this.cornerRadius, this.cornerRadius);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.backgroundColor);
        g2.fillRoundRect(this.leftRightMargin / 2, 0, this.getWidth() - this.leftRightMargin, this.getHeight(), arcs.width, arcs.height);
        super.paintComponent(g2);
        g2.dispose();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.revalidate();
        this.repaint();
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public int getLeftRightPadding() {
        return this.leftRightPadding;
    }

    @Generated
    public int getTopBottomPadding() {
        return this.topBottomPadding;
    }

    @Generated
    public int getLeftRightMargin() {
        return this.leftRightMargin;
    }

    @Generated
    public int getCornerRadius() {
        return this.cornerRadius;
    }
}

