/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.BooleanFunction;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class PrettyListPopup<T extends PrettyBaseListItem> {
    AbstractPopup jbPopup;
    Consumer<T> itemSelectedConsumer;
    int maxItemWidth = 0;
    private int hoverIndex = -1;
    int visibleRowCount = 10;
    private final Project project;
    private int hoverCallbackIndex = -1;

    public PrettyListPopup(Project project, Consumer<T> itemSelectedConsumer, int maxItemWidth) {
        this.project = project;
        this.itemSelectedConsumer = itemSelectedConsumer;
        this.maxItemWidth = maxItemWidth;
    }

    private AbstractPopup createPopup(List<? extends T> data, int selectIndex) {
        if (this.jbPopup != null && this.jbPopup.isVisible()) {
            this.jbPopup.cancel();
            this.jbPopup = null;
        }
        DefaultListModel<PrettyBaseListItem> listModel = new DefaultListModel<PrettyBaseListItem>();
        for (PrettyBaseListItem item : data) {
            listModel.addElement(item);
        }
        final JBList list = new JBList(listModel);
        list.setCellRenderer((ListCellRenderer)new InternalListCellRenderer(this, this.maxItemWidth));
        list.setSelectedIndex(selectIndex);
        list.setVisibleRowCount(this.visibleRowCount);
        list.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0) {
                    PrettyListPopup.this.hoverIndex = index;
                    list.repaint();
                }
            }
        });
        list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                PrettyListPopup.this.hoverIndex = -1;
                PrettyListPopup.this.hoverCallbackIndex = -1;
                list.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrettyBaseListItem selectedValue;
                int index;
                if (evt.getClickCount() == 1 && (index = list.locationToIndex(evt.getPoint())) >= 0 && (selectedValue = (PrettyBaseListItem)list.getModel().getElementAt(index)).isEnabled()) {
                    PrettyListPopup.this.itemSelectedConsumer.accept(selectedValue);
                    if (PrettyListPopup.this.jbPopup != null) {
                        PrettyListPopup.this.jbPopup.cancel();
                    }
                }
            }
        });
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PrettyBaseListItem selectedValue = (PrettyBaseListItem)list.getSelectedValue();
                    if (selectedValue != null && selectedValue.isEnabled()) {
                        PrettyListPopup.this.itemSelectedConsumer.accept(selectedValue);
                        if (PrettyListPopup.this.jbPopup != null) {
                            PrettyListPopup.this.jbPopup.cancel();
                        }
                    }
                } else if (e.getKeyCode() == 27 && PrettyListPopup.this.jbPopup != null) {
                    PrettyListPopup.this.jbPopup.cancel();
                }
            }
        });
        JBScrollPane scrollPane = new JBScrollPane((Component)list);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        panel.setBorder(JBUI.Borders.empty((int)8));
        SwingUtil.foreachChildComponent(panel, cp -> cp.setBackground(ColorUtil.getListBackground()));
        this.jbPopup = new CustomAbstractPopup(this.project, panel, null, false, true, true, null, false, null, null, true, Collections.emptySet(), false, null, null, null, true, null, true, true, true, null, 0.0f, null, true, false, new Component[0], null, 2, true, Collections.emptyList(), null, null, false, true, true, null, true, null);
        return this.jbPopup;
    }

    public void showUnderneathOf(Component component, List<? extends T> data, int selectIndex) {
        this.jbPopup = this.createPopup(data, selectIndex);
        this.jbPopup.showUnderneathOf(component);
    }

    public void showAbove(Component component, List<? extends T> data, int selectIndex) {
        this.jbPopup = this.createPopup(data, selectIndex);
        Point targetPoint = component.getLocationOnScreen();
        Dimension size = this.jbPopup.getContent().getPreferredSize();
        targetPoint.setLocation((double)targetPoint.x, (double)targetPoint.y - size.getHeight() - 4.0);
        this.jbPopup.showInScreenCoordinates(component, targetPoint);
    }

    public void cancel() {
        if (this.jbPopup != null && this.jbPopup.isVisible()) {
            this.jbPopup.cancel();
        }
    }

    public void showLeftOrRight(Component component, List<? extends T> data, int selectIndex) {
        this.jbPopup = this.createPopup(data, selectIndex);
        Point targetPoint = component.getLocationOnScreen();
        Dimension size = this.jbPopup.getContent().getPreferredSize();
        if ((double)targetPoint.x - size.getWidth() - 12.0 < 0.0) {
            targetPoint.setLocation((double)targetPoint.x + size.getWidth() + 12.0, (double)targetPoint.y);
        } else {
            targetPoint.setLocation((double)targetPoint.x - size.getWidth() - 12.0, (double)targetPoint.y);
        }
        this.jbPopup.showInScreenCoordinates(component, targetPoint);
    }

    public void showAtPoint(Component component, Point screenPoint, List<? extends T> data, int selectIndex, boolean aboveOfPoint) {
        this.jbPopup = this.createPopup(data, selectIndex);
        if (aboveOfPoint) {
            Dimension size = this.jbPopup.getContent().getPreferredSize();
            screenPoint.y -= size.height - 8;
        }
        this.jbPopup.showInScreenCoordinates(component, screenPoint);
    }

    public void showAtRelativePoint(RelativePoint relativePoint, List<? extends T> data, int selectIndex, boolean aboveOfPoint) {
        this.jbPopup = this.createPopup(data, selectIndex);
        if (aboveOfPoint) {
            Dimension size = this.jbPopup.getContent().getPreferredSize();
            relativePoint.getPoint().y -= size.height - 8;
        }
        this.jbPopup.show(relativePoint);
    }

    private static WindowManagerEx getWndManager() {
        return ApplicationManager.getApplication() != null ? WindowManagerEx.getInstanceEx() : null;
    }

    @Generated
    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public static interface PrettyBaseListItem {
        public String getDisplayName();

        public Icon getIcon();

        default public String getTooltip() {
            return "";
        }

        default public boolean isEnabled() {
            return true;
        }

        default public void hoverCallback(Point point, int hoverIndex) {
        }
    }

    static class CustomAbstractPopup
    extends AbstractPopup {
        public CustomAbstractPopup(Project project, JComponent component, JComponent title, boolean requestFocus, boolean focusable, boolean movable, String dimensionServiceKey, boolean resizable, String text, Computable<Boolean> callback, boolean cancelOnWindowDeactivation, Set<? extends JBPopupListener> listeners, boolean headerAlwaysVisible, ActiveComponent activeComponent, IconButton iconButton, MouseChecker cancelOnMouseOutCallback, boolean cancelOnWindow, ActiveIcon activeIcon, boolean cancelOnClickOutside, boolean inStack, boolean modalContext, Dimension size, float alpha, MaskProvider maskProvider, boolean undecorated, boolean showShadow, Component[] focusOwners, String adText, int adTextAlignment, boolean footerAlwaysVisible, List<? extends Pair<ActionListener, KeyStroke>> keyboardActions, Component componentToFocus, Processor<? super JBPopup> focusedCallback, boolean reflectDimension, boolean locateByContent, boolean shareDimension, Color headerColor, boolean useDimServiceForXYLocation, BooleanFunction<KeyEvent> keyEventHandler) {
            this.init(project, component, title, requestFocus, focusable, movable, dimensionServiceKey, resizable, text, callback, cancelOnWindowDeactivation, listeners, headerAlwaysVisible, activeComponent, iconButton, cancelOnMouseOutCallback, cancelOnWindow, activeIcon, cancelOnClickOutside, inStack, modalContext, size, alpha, maskProvider, undecorated, showShadow, focusOwners, adText, adTextAlignment, footerAlwaysVisible, keyboardActions, componentToFocus, focusedCallback, reflectDimension, locateByContent, shareDimension, headerColor, useDimServiceForXYLocation, keyEventHandler);
        }

        protected void onSpeedSearchPatternChanged() {
        }
    }

    static class InternalListCellRenderer
    extends DefaultListCellRenderer {
        int maxItemWidth = 0;
        private final PrettyListPopup<?> parentPopup;

        public InternalListCellRenderer(PrettyListPopup<?> parentPopup, int maxItemWidth) {
            this.parentPopup = parentPopup;
            this.maxItemWidth = maxItemWidth;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(ColorUtil.getListBackground());
            RoundRectPanel opaquePanel = new RoundRectPanel(new FlowLayout(0), 8){

                @Override
                public AccessibleContext getAccessibleContext() {
                    return super.getAccessibleContext();
                }
            };
            opaquePanel.setBorder((Border)JBUI.Borders.empty());
            opaquePanel.setOpaque(true);
            opaquePanel.setCornorBackgroundColor(ColorUtil.getListBackground());
            JLabel component = this.getItemLabel(value);
            opaquePanel.add(component);
            boolean isHovered = this.parentPopup != null && index == this.parentPopup.hoverIndex;
            boolean isEnabled = ((PrettyBaseListItem)value).isEnabled();
            SwingUtil.foreachChildComponent(opaquePanel, cp -> {
                if (isSelected && isEnabled) {
                    cp.setBackground(ColorUtil.getItemSelectionBackground());
                } else if (isHovered) {
                    cp.setBackground(ColorUtil.getItemSelectionBackground());
                    list.setSelectedIndex(index);
                } else {
                    cp.setBackground(ColorUtil.getListBackground());
                }
                cp.setToolTipText(((PrettyBaseListItem)value).getTooltip());
                cp.setEnabled(isEnabled);
            });
            if (isHovered && this.parentPopup.hoverIndex != this.parentPopup.hoverCallbackIndex) {
                ((PrettyBaseListItem)value).hoverCallback(this.getRightSidePoint(list), this.parentPopup.hoverIndex);
                this.parentPopup.hoverCallbackIndex = this.parentPopup.hoverIndex;
            }
            opaquePanel.setCursor(new Cursor(isEnabled ? 0 : 12));
            return opaquePanel;
        }

        private Point getRightSidePoint(JList<?> list) {
            Dimension size = list.getSize();
            Point location = list.getLocationOnScreen();
            Insets insets = list.getInsets();
            return new Point(location.x + size.width - insets.right, location.y);
        }

        @NotNull
        private Icon getTypeIcon(@NotNull SearchValue paramSearchValue) {
            if (paramSearchValue == null) {
                InternalListCellRenderer.$$$reportNull$$$0(0);
            }
            Icon icon = IconUtil.getEmptyIcon((boolean)false);
            if (icon == null) {
                InternalListCellRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        private JLabel getItemLabel(Object paramItem) {
            JLabel label = new JLabel();
            PrettyBaseListItem item = (PrettyBaseListItem)paramItem;
            String displayName = item.getDisplayName();
            if (this.maxItemWidth > 0) {
                displayName = FontUtil.getStringAdaptiveWidth(this, displayName, this.maxItemWidth, false);
            }
            label.setText(displayName);
            label.setBackground(ColorUtil.getListBackground());
            label.setOpaque(false);
            if (item.getIcon() != null) {
                label.setIcon(item.getIcon());
            }
            label.setCursor(new Cursor(item.isEnabled() ? 0 : 12));
            return label;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSearchValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/search/component/PrettyListPopup$InternalListCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/component/PrettyListPopup$InternalListCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeIcon";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

