/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.WrappedHtmlEditorKit;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.alibabacloud.intellij.cosy.util.ThemeUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jdesktop.swingx.VerticalLayout;

public class LoginOptionPanel
extends RoundRectPanel {
    private static final int DEFAULT_HEIGHT = 58;
    JPanel textPanel;
    JLabel loginOptionLabel;
    JTextPane loginOptionHintPane;
    JLabel iconLabel;
    JLabel loginLabel;
    MessageBusConnection messageBusConnection;
    private Font hintFont;
    private Color hintColor;

    public LoginOptionPanel(Project project, Icon icon, String loginOption, String loginOptionHint) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.iconLabel = new JLabel(icon);
        this.iconLabel.setBorder(JBUI.Borders.empty((int)16));
        this.add((Component)this.iconLabel, "West");
        this.loginOptionLabel = new JLabel(loginOption);
        this.loginOptionLabel.setOpaque(false);
        this.loginOptionLabel.setFont(this.loginOptionLabel.getFont().deriveFont(14.0f));
        this.loginOptionLabel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        this.loginOptionHintPane = new JTextPane();
        Dimension dimension = this.loginOptionHintPane.getPreferredSize();
        dimension.height = 20;
        this.loginOptionHintPane.setPreferredSize(dimension);
        this.loginOptionHintPane.setEditable(false);
        this.loginOptionHintPane.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        this.loginOptionHintPane.setEditorKit(new WrappedHtmlEditorKit());
        this.loginOptionHintPane.setOpaque(false);
        this.loginOptionHintPane.setText(ThemeUtil.getMarkdownContent(ColorUtil.getAuxiliaryForegroundColor(), this.loginOptionHintPane.getFont().deriveFont(12.0f), loginOptionHint));
        this.loginOptionHintPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                UrlUtil.performHyperlink(project, e, this);
            }
        });
        this.textPanel = new JPanel((LayoutManager)new VerticalLayout(6));
        this.textPanel.setOpaque(false);
        this.textPanel.setBorder((Border)JBUI.Borders.empty((int)9, (int)0));
        this.textPanel.add(this.loginOptionLabel);
        this.textPanel.add(this.loginOptionHintPane);
        this.add((Component)this.textPanel, "Center");
        this.loginLabel = new JLabel(LingmaIcons.SendDisabledIcon);
        this.loginLabel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        this.loginLabel.setCursor(new Cursor(12));
        this.add((Component)this.loginLabel, "East");
        SwingUtil.foreachChildComponent(this, cp -> cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LoginOptionPanel.this.loginLabel.setIcon(LingmaIcons.SendActiveIcon);
                LoginOptionPanel.this.setBorderColor(ColorUtil.getLinkForegroundColor());
                LoginOptionPanel.this.invalidate();
                LoginOptionPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LoginOptionPanel.this.loginLabel.setIcon(LingmaIcons.SendDisabledIcon);
                LoginOptionPanel.this.setBorderColor(null);
                LoginOptionPanel.this.invalidate();
                LoginOptionPanel.this.repaint();
            }
        }));
    }

    public void addLoginMouseListener(MouseListener l) {
        SwingUtil.foreachChildComponent(this, cp -> cp.addMouseListener(l));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 58;
        return dimension;
    }
}

