/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.component.CodeTextPane;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CodeTextPlusPane
extends JPanel {
    private static final int EDITOR_MAX_HEIGHT = 320;
    private CodeTextPane codeTextPane;
    private JBScrollPane editorScrollPane;

    public CodeTextPlusPane(String code, String language, boolean scrollable) {
        super(new BorderLayout());
        this.codeTextPane = new CodeTextPane(null, code, language, null, null, null);
        this.codeTextPane.setBackground(ColorUtil.getEditorBackgroundColor());
        this.codeTextPane.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        if (scrollable) {
            this.editorScrollPane = new JBScrollPane(10);
            this.editorScrollPane.setBackground(this.codeTextPane.getBackground());
            this.editorScrollPane.setForeground(this.codeTextPane.getBackground());
            this.editorScrollPane.setViewportView((Component)this.codeTextPane);
            this.editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.editorScrollPane.setHorizontalScrollBarPolicy(30);
            this.editorScrollPane.setVerticalScrollBarPolicy(21);
            this.add((Component)this.editorScrollPane, "Center");
            int actualHeight = this.codeTextPane.getPreferredSize().height;
            if (actualHeight > 320) {
                this.editorScrollPane.setPreferredSize(new Dimension(-1, 320));
                this.editorScrollPane.setPreferredSize(new Dimension(-1, 320));
                this.editorScrollPane.setVerticalScrollBarPolicy(20);
                this.editorScrollPane.setHorizontalScrollBarPolicy(30);
                this.codeTextPane.validate();
                if (this.editorScrollPane.getVerticalScrollBar() != null) {
                    SwingUtilities.invokeLater(() -> this.editorScrollPane.getVerticalScrollBar().setValue(0));
                }
            } else {
                Dimension editorDim = this.codeTextPane.getPreferredSize();
                this.editorScrollPane.setPreferredSize(new Dimension(-1, editorDim.height));
                this.editorScrollPane.setVerticalScrollBarPolicy(21);
                this.editorScrollPane.setHorizontalScrollBarPolicy(31);
            }
        } else {
            this.add((Component)this.codeTextPane, "Center");
        }
    }

    public Color getSelectionColor() {
        return this.codeTextPane.getSelectionColor();
    }

    public void setText(String text) {
        this.codeTextPane.setText(text);
    }

    public String getText() {
        return this.codeTextPane.getText();
    }

    public void setLanguage(String language) {
        this.codeTextPane.setLanguage(language);
    }

    public void copy() {
        this.codeTextPane.copy();
    }

    public CodeTextPane getCodeTextPane() {
        return this.codeTextPane;
    }
}

