/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.textpane.RichTextPane;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatAskTagLabel;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatInputFocusMoveNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class AutoHeightTextArea
extends RichTextPane
implements RefreshColorComponent {
    Color defaultColor;
    List<EnterKeyListener> listeners = new ArrayList<EnterKeyListener>();
    List<OnShowPlaceHolderListener> placeHolderListeners = new ArrayList<OnShowPlaceHolderListener>();
    AtomicBoolean inputMethodCommit = new AtomicBoolean(false);
    AtomicBoolean pinyinInputStatus = new AtomicBoolean(false);
    boolean showPlaceHolder = true;
    Project project;
    private String placeholder;
    int maxHeight;
    protected AtomicReference<String> textBeforeDeleted = new AtomicReference();

    public AutoHeightTextArea(final Project project, final AskInputPanel parentPanel, String placeholderText, int maxHeight) {
        this.project = project;
        this.placeholder = placeholderText;
        this.maxHeight = maxHeight;
        this.setEditable(true);
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.defaultColor = ColorUtil.getTextForegroundColor();
        this.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                if (event.getCommittedCharacterCount() > 0) {
                    AutoHeightTextArea.this.inputMethodCommit.getAndSet(true);
                    AutoHeightTextArea.this.pinyinInputStatus.getAndSet(false);
                } else if (event.getText() != null && event.getText().getEndIndex() - event.getText().getBeginIndex() > 0) {
                    AutoHeightTextArea.this.pinyinInputStatus.getAndSet(true);
                } else {
                    AutoHeightTextArea.this.pinyinInputStatus.getAndSet(false);
                }
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean pinyinComment = false;
                if (e.getKeyCode() == 10) {
                    if (e.isControlDown() || e.isMetaDown() || e.isShiftDown()) {
                        if (e.isMetaDown() && parentPanel instanceof InlineChatInputPanel) {
                            return;
                        }
                        e.consume();
                        int pos = AutoHeightTextArea.this.getCaretPosition();
                        AutoHeightTextArea.this.insertText(pos, "\n");
                        AutoHeightTextArea.this.inputMethodCommit.getAndSet(false);
                    } else if (e.getModifiersEx() == 0) {
                        e.consume();
                        if (pinyinComment) {
                            return;
                        }
                        if (AutoHeightTextArea.this.canSend()) {
                            AutoHeightTextArea.this.doSendMessage();
                        }
                    }
                    AutoHeightTextArea.this.revalidate();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 8 && "".equals(AutoHeightTextArea.this.getText()) && StringUtils.isEmpty((CharSequence)AutoHeightTextArea.this.textBeforeDeleted.get()) && project != null && !parentPanel.getInputTagsPanel().getTags().isEmpty()) {
                    ((ChatInputFocusMoveNotifier)project.getMessageBus().syncPublisher(ChatInputFocusMoveNotifier.TOPIC)).notifyMoveFocus(4);
                }
                AutoHeightTextArea.this.textBeforeDeleted.getAndSet("");
            }
        });
        this.getEmptyText().setText(this.placeholder);
    }

    public void doSendMessage() {
        String content = this.getText().trim();
        this.listeners.forEach(listener -> listener.onEnterKeyPressed(content));
    }

    public boolean canSend() {
        return true;
    }

    public void clearTextArea() {
        this.setText("");
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(ColorUtil.getEditorBackgroundColor());
    }

    public void disablePlaceHolder() {
        this.showPlaceHolder = false;
    }

    public void enablePlaceHolder() {
        this.showPlaceHolder = true;
        this.getEmptyText().setText(this.placeholder);
    }

    public void addEnterKeyListener(EnterKeyListener listener) {
        this.listeners.add(listener);
    }

    public void addOnShowPlaceHolderListener(OnShowPlaceHolderListener listener) {
        this.placeHolderListeners.add(listener);
    }

    public void setPlaceholder(String placeholder) {
        if (StringUtils.isBlank((CharSequence)placeholder)) {
            return;
        }
        this.placeholder = placeholder;
        this.getEmptyText().setText(placeholder);
        this.showPlaceHolder = true;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.setBackground(ColorUtil.getEditorBackgroundColor());
    }

    public List<Component> getEmbedComponents() {
        Element element;
        ArrayList<Component> components = new ArrayList<Component>();
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((element = iterator.next()) != null) {
            AttributeSet attributes = element.getAttributes();
            Component comp = StyleConstants.getComponent(attributes);
            if (comp == null) continue;
            components.add(comp);
        }
        return components;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintSecondaryPlaceholder(g);
    }

    private void paintSecondaryPlaceholder(Graphics g) {
        ChatAskTag tag;
        Component comp;
        if (this.getText().isEmpty() || this.isFocusOwner() || StringUtils.isBlank((CharSequence)this.placeholder)) {
            return;
        }
        List<Element> elements = this.getUIElements();
        if (elements.isEmpty() || elements.size() > 2) {
            return;
        }
        int validCount = elements.size();
        Element lastElement = elements.get(elements.size() - 1);
        StyledDocument doc = this.getStyledDocument();
        try {
            int end;
            int start;
            String text;
            if (lastElement.getName().equals("content") && "\n".equals(text = doc.getText(start = lastElement.getStartOffset(), (end = lastElement.getEndOffset()) - start))) {
                --validCount;
            }
        }
        catch (Exception e) {
            return;
        }
        if (validCount != 1) {
            return;
        }
        String childPlaceholder = null;
        Element firstElement = elements.get(0);
        Component targetComp = null;
        if (firstElement.getName().equals("component") && (comp = StyleConstants.getComponent(firstElement.getAttributes())) instanceof ChatAskTagLabel && (tag = ((ChatAskTagLabel)comp).getTag()) != null && ("agent".equals(tag.getType()) || "task".equals(tag.getType()))) {
            targetComp = comp;
            childPlaceholder = this.placeholder;
        }
        if (targetComp == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(ColorUtil.getAuxiliaryForegroundColor());
        FontMetrics fm = g2.getFontMetrics();
        int x = targetComp.getLocation().x + targetComp.getWidth() + 8;
        int y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
        g2.drawString(childPlaceholder, x, y);
        g2.dispose();
    }

    public boolean isPinyinInput() {
        return this.pinyinInputStatus.get();
    }

    @Generated
    public boolean isShowPlaceHolder() {
        return this.showPlaceHolder;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public String getPlaceholder() {
        return this.placeholder;
    }

    public static interface OnShowPlaceHolderListener {
        public void onShowPlaceHolder();

        public void onHiddenPlaceHolder();
    }

    public static interface EnterKeyListener {
        public void onEnterKeyPressed(String var1);
    }
}

