/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.ui.search.CosyJBTableCell;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnySearchNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.CommonIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CosyKeywordTableCell
implements CosyJBTableCell {
    private static final int WIDTH_OFFSET = 20;
    private static final int HEIGHT_OFFSET = 10;
    public static final String SEARCH_VALUE_PROP = "cosy.search.value";
    private JPanel contentPane;
    private JLabel conditionDescriptionLabel;
    private LinkLabel xLinkLabel;
    private static final JBColor BG_NLP_LABEL_COLOR = new JBColor(new Color(0xEBEBEB), new Color(0xCAC8C8));
    private static final JBColor BG_API_LABEL_COLOR = new JBColor(new Color(11656183), new Color(5276311));
    private static final JBColor TEXT_NLP_LABEL_COLOR = new JBColor(new Color(0x575757), new Color(13487823));
    private static final JBColor TEXT_API_LABEL_COLOR = new JBColor(new Color(746913), new Color(7254734));
    private SearchValue searchValue;
    private Project paramProject;

    private void initialize(SearchValue searchValue) {
        if (SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
            this.contentPane.setBackground((Color)BG_NLP_LABEL_COLOR);
        } else {
            this.contentPane.setBackground((Color)BG_API_LABEL_COLOR);
        }
        if (SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
            this.conditionDescriptionLabel.setForeground((Color)TEXT_NLP_LABEL_COLOR);
            this.xLinkLabel.setForeground((Color)TEXT_NLP_LABEL_COLOR);
        } else {
            this.conditionDescriptionLabel.setForeground((Color)TEXT_API_LABEL_COLOR);
            this.xLinkLabel.setForeground((Color)TEXT_API_LABEL_COLOR);
        }
        this.xLinkLabel.setIcon(CommonIcons.xIcon);
        this.contentPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent param1MouseEvent) {
                Component component = param1MouseEvent.getComponent();
                if (!component.hasFocus()) {
                    component.requestFocusInWindow();
                }
            }
        });
    }

    public CosyKeywordTableCell(SearchValue searchValue, final Project paramProject) {
        this.$$$setupUI$$$();
        this.initialize(searchValue);
        this.searchValue = searchValue;
        this.paramProject = paramProject;
        this.contentPane.putClientProperty(SEARCH_VALUE_PROP, searchValue);
        if (searchValue.getNiceName().length() > 45) {
            this.conditionDescriptionLabel.setText(searchValue.getNiceName().substring(0, 45) + "...");
        } else {
            this.conditionDescriptionLabel.setText(searchValue.getNiceName());
        }
        this.conditionDescriptionLabel.setText(searchValue.getNiceName());
        this.conditionDescriptionLabel.setToolTipText(searchValue.getPack());
        this.xLinkLabel.setCursor(new Cursor(12));
        this.xLinkLabel.setListener((LinkListener)new LinkListener<SearchValue>(){

            public void linkSelected(LinkLabel linkLabel, SearchValue searchValue) {
                SearchContext context = new SearchContext(OperationEnum.DELETE.text, SearchActionTypeEnum.DELETE_LABEL_TRIGGER.getType(), -1);
                ((AnySearchNotifier)paramProject.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
            }
        }, (Object)searchValue);
    }

    @Override
    public JComponent getComponent() {
        return this.contentPane;
    }

    @Override
    public int getPreferredWidth() {
        return (int)((double)((int)this.conditionDescriptionLabel.getPreferredSize().getWidth()) + this.xLinkLabel.getPreferredSize().getWidth()) + 20;
    }

    @Override
    public int getPreferredHeight() {
        return (int)this.conditionDescriptionLabel.getPreferredSize().getHeight() + 10;
    }

    public SearchValue getSearchValue() {
        return this.searchValue;
    }

    public Project getParamProject() {
        return this.paramProject;
    }

    private void createUIComponents() {
        this.xLinkLabel = new CloseLinkLabel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(2, 5, 2, 0), -1, -1, false, false));
        this.conditionDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        LinkLabel linkLabel = this.xLinkLabel;
        linkLabel.setText("");
        linkLabel.setToolTipText("\u5220\u9664");
        jPanel.add((Component)linkLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static class CloseLinkLabel<T>
    extends LinkLabel<T> {
        CloseLinkLabel() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getPreferredSize();
            int height = (int)dim.getHeight();
            int lineHeight = (int)((double)height * 0.1);
            g.setColor((Color)new JBColor(new Color(219, 219, 219), new Color(43, 48, 52)));
            g.drawLine(0, lineHeight, 0, height - lineHeight);
        }
    }
}

