/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibabacloud.intellij.cosy.search.result.SearchCodeResult;
import com.alibabacloud.intellij.cosy.ui.search.CosyJBTableCell;
import com.alibabacloud.intellij.cosy.ui.search.topic.SearchCodeCellActionNotifier;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import icons.CommonIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyCodeTableCell
implements CosyJBTableCell {
    private static Logger logger = Logger.getInstance(CosyCodeTableCell.class);
    @NotNull
    private final Project project;
    private final SearchCodeResult searchCodeResult;
    private final String DATE_FORMATE = "yyyy-MM-dd-HH-mm-ss";
    private final String SAMPLE_PREFIX = "Sample-";
    private JPanel contentPane;
    private JPanel headerPanel;
    private JScrollPane editorScrollPane;
    private JPanel editorPanel;
    private LinkLabel<String> repoNameLabel;
    private EditorTextField editorTextField;
    private JBLabel licenseLabel;
    private JLabel openLabel;
    private boolean firstGain;
    private boolean haveScroll;
    private ReadOnlyLightVirtualFile readOnlyLightVirtualFile;
    private final MouseWheelListener[] mouseWheelListeners;
    private static final int CODE_LINE_HEIGHT = 21;
    private static final int BORDER_HEIGHT = 6;
    private static final int MAX_HEIGHT = 300;

    public CosyCodeTableCell(SearchCodeResult paramSearchCodeResult, @NotNull Project paramProject) {
        Icon githubIcon;
        Icon xIcon;
        if (paramProject == null) {
            CosyCodeTableCell.$$$reportNull$$$0(0);
        }
        this.DATE_FORMATE = "yyyy-MM-dd-HH-mm-ss";
        this.SAMPLE_PREFIX = "Sample-";
        this.searchCodeResult = paramSearchCodeResult;
        this.project = paramProject;
        this.firstGain = true;
        this.haveScroll = true;
        this.$$$setupUI$$$();
        if ("error".equalsIgnoreCase(this.searchCodeResult.getLicense())) {
            this.searchCodeResult.setLicense("Other");
        } else if ("null".equalsIgnoreCase(this.searchCodeResult.getLicense())) {
            this.searchCodeResult.setLicense("Other");
        }
        this.licenseLabel.setText(this.searchCodeResult.getLicense());
        if (this.searchCodeResult.getRepoName().length() > 60) {
            this.repoNameLabel.setText(this.searchCodeResult.getRepoName().substring(0, 60) + "...");
            this.repoNameLabel.setToolTipText(this.searchCodeResult.getRepoName());
        } else {
            this.repoNameLabel.setText(this.searchCodeResult.getRepoName());
        }
        Icon stackOverflowIcon = CommonIcons.stackOverflowIcon;
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        if (color == null) {
            xIcon = CommonIcons.fullScreenIcon;
            githubIcon = CommonIcons.githubIcon;
        } else {
            githubIcon = CommonIcons.lightGithubIcon;
            xIcon = CommonIcons.lightFullScreenIcon;
        }
        if ("StackOverflow".equalsIgnoreCase(this.searchCodeResult.getSource())) {
            this.repoNameLabel.setIcon(stackOverflowIcon);
        } else {
            this.repoNameLabel.setIcon(githubIcon);
        }
        this.repoNameLabel.setToolTipText(this.searchCodeResult.getUrl());
        this.openLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.editorScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sBar;
                if (CosyCodeTableCell.this.haveScroll && (sBar = CosyCodeTableCell.this.editorScrollPane.getVerticalScrollBar()).getValue() + sBar.getHeight() == sBar.getMaximum() && sBar.getValue() > 0) {
                    CosyCodeTableCell.this.haveScroll = false;
                    ((SearchCodeCellActionNotifier)CosyCodeTableCell.this.project.getMessageBus().syncPublisher(SearchCodeCellActionNotifier.SEARCH_CODE_CLICK)).searchCodeClick(CosyCodeTableCell.this.searchCodeResult, "mouse_scroll");
                }
            }
        });
        this.openLabel.setIcon(xIcon);
        this.openLabel.setToolTipText("\u653e\u5927");
        this.openLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Document document = CosyCodeTableCell.this.editorTextField.getDocument();
                if (document != null && StringUtils.isNotBlank((CharSequence)document.getText())) {
                    CosyCodeTableCell.this.openVirtualFile(document);
                    ((SearchCodeCellActionNotifier)CosyCodeTableCell.this.project.getMessageBus().syncPublisher(SearchCodeCellActionNotifier.SEARCH_CODE_CLICK)).searchCodeClick(CosyCodeTableCell.this.searchCodeResult, "enlarge_open");
                }
            }
        });
        this.repoNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BrowserUtil.browse((String)CosyCodeTableCell.this.searchCodeResult.getUrl());
                ((SearchCodeCellActionNotifier)CosyCodeTableCell.this.project.getMessageBus().syncPublisher(SearchCodeCellActionNotifier.SEARCH_CODE_CLICK)).searchCodeClick(CosyCodeTableCell.this.searchCodeResult, "repo_jump");
            }
        });
        this.editorScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.editorScrollPane.getHorizontalScrollBar().setUnitIncrement(30);
        this.editorScrollPane.setVerticalScrollBarPolicy(21);
        this.editorScrollPane.setHorizontalScrollBarPolicy(31);
        this.editorScrollPane.setWheelScrollingEnabled(false);
        this.mouseWheelListeners = (MouseWheelListener[])this.editorScrollPane.getListeners(MouseWheelListener.class);
        for (int i = 0; i < this.mouseWheelListeners.length; ++i) {
            this.editorScrollPane.removeMouseWheelListener(this.mouseWheelListeners[i]);
        }
        this.contentPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent((Component)CosyCodeTableCell.this.editorTextField, 1005));
            }
        });
        int actualHeight = this.headerPanel.getPreferredSize().height + this.editorScrollPane.getPreferredSize().height;
        if (actualHeight > 300) {
            this.contentPane.setPreferredSize(new Dimension(-1, 300));
        } else {
            this.contentPane.setPreferredSize(new Dimension(-1, actualHeight));
        }
    }

    private void openVirtualFile(Document document) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile[] virtualFiles = fileEditorManager.getOpenFiles();
        boolean isOpen = false;
        for (VirtualFile virtualFile : virtualFiles) {
            if (!(virtualFile instanceof ReadOnlyLightVirtualFile) || !((ReadOnlyLightVirtualFile)virtualFile).getContent().toString().equals(document.getText())) continue;
            fileEditorManager.openFile(virtualFile, true, true);
            isOpen = true;
        }
        if (!isOpen) {
            VirtualFile virtualFile;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            String virtualName = "Sample-" + simpleDateFormat.format(calendar.getTime());
            virtualFile = new ReadOnlyLightVirtualFile(virtualName, JavaFileType.INSTANCE.getLanguage(), (CharSequence)document.getText());
            fileEditorManager.openFile(virtualFile, true, true);
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            DaemonCodeAnalyzer.getInstance((Project)this.project).setHighlightingEnabled(psiFile, false);
            TextEditor editor = (TextEditor)ObjectUtils.tryCast((Object)fileEditorManager.getSelectedEditor(), TextEditor.class);
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            ResultCodeProcessor resultCodeProcessor = null;
            try {
                resultCodeProcessor = new ResultCodeProcessor(this.searchCodeResult, editorColorsScheme);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
            if (resultCodeProcessor != null) {
                try {
                    resultCodeProcessor.getCodeHighlights().forEach(codeHighlight -> editor.getEditor().getMarkupModel().addRangeHighlighter(codeHighlight.getStartIndex(), codeHighlight.getEndIndex(), 0, codeHighlight.getTextAttributes(), codeHighlight.getArea()));
                }
                catch (RuntimeException runtimeException) {
                    logger.info("Enlarge CodeHighLights error: " + runtimeException.getMessage() + ".");
                }
            }
        }
    }

    private void createUIComponents() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (this.project.isDisposed()) {
            return;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        ResultCodeProcessor resultCodeProcessor = null;
        try {
            resultCodeProcessor = new ResultCodeProcessor(this.searchCodeResult, editorColorsScheme);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        final ResultCodeProcessor finalProcessor = resultCodeProcessor;
        String str = resultCodeProcessor != null ? resultCodeProcessor.getProcessedCode() : this.searchCodeResult.getSnippetCode();
        Document document = EditorFactory.getInstance().createDocument((CharSequence)str);
        this.editorTextField = new EditorTextField(document, this.project, (FileType)JavaFileType.INSTANCE, true, false){

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                if (finalProcessor != null) {
                    try {
                        finalProcessor.getCodeHighlights().forEach(codeHighlight -> editorEx.getMarkupModel().addRangeHighlighter(codeHighlight.getStartIndex(), codeHighlight.getEndIndex(), 0, codeHighlight.getTextAttributes(), codeHighlight.getArea()));
                    }
                    catch (RuntimeException runtimeException) {
                        logger.info("get CodeHighLights error: " + runtimeException.getMessage() + ".");
                    }
                }
                editorEx.setContextMenuGroupId("CosyStoryCellPopupMenu");
                return editorEx;
            }
        };
        this.editorTextField.setRequestFocusEnabled(false);
        this.editorTextField.ensureWillComputePreferredSize();
        this.editorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        this.editorTextField.setHorizontalSizeReferent((JComponent)this.editorTextField);
        this.editorTextField.setBackground(editorColorsScheme.getDefaultBackground());
        this.editorTextField.setBorder(BorderFactory.createEmptyBorder());
        this.editorTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent param1FocusEvent) {
                CosyCodeTableCell.this.editorScrollPane.setWheelScrollingEnabled(true);
                CosyCodeTableCell.this.editorScrollPane.setVerticalScrollBarPolicy(20);
                CosyCodeTableCell.this.editorScrollPane.setHorizontalScrollBarPolicy(30);
                if (CosyCodeTableCell.this.firstGain) {
                    CosyCodeTableCell.this.firstGain = false;
                    ((SearchCodeCellActionNotifier)CosyCodeTableCell.this.project.getMessageBus().syncPublisher(SearchCodeCellActionNotifier.SEARCH_CODE_CLICK)).searchCodeClick(CosyCodeTableCell.this.searchCodeResult, "mouse_click");
                }
                for (int i = 0; i < CosyCodeTableCell.this.mouseWheelListeners.length; ++i) {
                    CosyCodeTableCell.this.editorScrollPane.addMouseWheelListener(CosyCodeTableCell.this.mouseWheelListeners[i]);
                }
            }

            @Override
            public void focusLost(FocusEvent param1FocusEvent) {
                CosyCodeTableCell.this.editorScrollPane.setWheelScrollingEnabled(false);
                CosyCodeTableCell.this.editorScrollPane.setVerticalScrollBarPolicy(21);
                CosyCodeTableCell.this.editorScrollPane.setHorizontalScrollBarPolicy(31);
                for (int i = 0; i < CosyCodeTableCell.this.mouseWheelListeners.length; ++i) {
                    CosyCodeTableCell.this.editorScrollPane.removeMouseWheelListener(CosyCodeTableCell.this.mouseWheelListeners[i]);
                }
            }
        });
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        double d1 = this.headerPanel.getPreferredSize().getHeight();
        int editorHeight = this.getCodeCellHeight();
        return (int)(d1 + (double)editorHeight);
    }

    private int getCodeCellHeight() {
        int height = 0;
        if (this.editorTextField.getText() != null) {
            height = this.editorTextField.getText().split("\n").length * 21;
        }
        return height + 6;
    }

    @Override
    public JComponent getComponent() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JScrollPane jScrollPane;
        JLabel jLabel;
        JBLabel jBLabel;
        LinkLabel linkLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setPreferredSize(new Dimension(163, 300));
        this.headerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(4, 0, 0, 15), 5, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        this.repoNameLabel = linkLabel = new LinkLabel();
        linkLabel.setText("repo");
        jPanel2.add((Component)linkLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.licenseLabel = jBLabel = new JBLabel();
        jBLabel.setText("license");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.openLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.editorScrollPane = jScrollPane = new JScrollPane();
        ((Component)jScrollPane).setEnabled(false);
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.editorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jScrollPane.setViewportView(jPanel);
        EditorTextField editorTextField = this.editorTextField;
        jPanel.add((Component)editorTextField, new GridConstraints(0, 0, 2, 2, 1, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramProject", "com/alibabacloud/intellij/cosy/ui/search/CosyCodeTableCell", "<init>"));
    }

    static class CodeHighlight {
        private int startIndex;
        private int endIndex;
        private TextAttributes textAttributes;
        private HighlighterTargetArea area;

        public CodeHighlight(int param1Int1, int param1Int2, TextAttributes param1TextAttributes, HighlighterTargetArea param1HighlighterTargetArea) {
            this.startIndex = param1Int1;
            this.endIndex = param1Int2;
            this.textAttributes = param1TextAttributes;
            this.area = param1HighlighterTargetArea;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(int param1Int) {
            this.startIndex = param1Int;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(int param1Int) {
            this.endIndex = param1Int;
        }

        public TextAttributes getTextAttributes() {
            return this.textAttributes;
        }

        public void setTextAttributes(TextAttributes param1TextAttributes) {
            this.textAttributes = param1TextAttributes;
        }

        public HighlighterTargetArea getArea() {
            return this.area;
        }

        public void setArea(HighlighterTargetArea param1HighlighterTargetArea) {
            this.area = param1HighlighterTargetArea;
        }
    }

    static class ResultCodeProcessor {
        private final String fullCode;
        private final int lineOffset;
        private final SearchCodeResult searchCodeResult;
        private final HighlighterTargetArea area;
        private final TextAttributes textAttributes;
        private final int firstLineCharOffset;

        public ResultCodeProcessor(SearchCodeResult param1SearchCodeResult, EditorColorsScheme param1EditorColorsScheme) {
            this.searchCodeResult = param1SearchCodeResult;
            String str1 = param1SearchCodeResult.getSnippetCode().replaceAll("(\r\n|\r|\n|\n\r)", "\n");
            String str2 = str1.replaceFirst("^\\s+", "");
            String[] arrayOfString1 = str1.split("\n");
            String[] arrayOfString2 = str2.split("\n");
            this.lineOffset = arrayOfString1.length - arrayOfString2.length;
            this.firstLineCharOffset = arrayOfString1[this.lineOffset].length() - arrayOfString2[0].length();
            this.fullCode = str2.trim();
            this.area = HighlighterTargetArea.EXACT_RANGE;
            this.textAttributes = param1EditorColorsScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        }

        public String getProcessedCode() {
            return this.fullCode;
        }

        public Stream<CodeHighlight> getCodeHighlights() {
            String snippet = this.searchCodeResult.getSnippetCode();
            CodeHighlight[] highlights = new CodeHighlight[]{};
            Stream.Builder<CodeHighlight> streamBuilder = Stream.builder();
            ArrayList<String> words = new ArrayList<String>();
            for (String searchKeyword : this.searchCodeResult.getSearchKeyword()) {
                String[] wordArray = searchKeyword.split("\\.");
                words.addAll(Arrays.asList(wordArray));
            }
            block1: for (String keyword : words) {
                int start = 0;
                int end = 0;
                for (int lastIndex = 0; lastIndex != -1; ++lastIndex) {
                    boolean boolAfter;
                    start = lastIndex = snippet.toUpperCase().indexOf(keyword.toUpperCase(), lastIndex);
                    end = start + keyword.length();
                    if (lastIndex == -1) continue block1;
                    char beforeWord = '\u0000';
                    char afterWord = '\u0000';
                    if (start != 0) {
                        beforeWord = snippet.charAt(start - 1);
                    }
                    if (end != snippet.length()) {
                        afterWord = snippet.charAt(end);
                    }
                    boolean boolBefore = Character.isLetterOrDigit(beforeWord) || beforeWord == '_';
                    boolean bl = boolAfter = Character.isLetterOrDigit(afterWord) || afterWord == '_';
                    if (boolBefore || boolAfter) continue;
                    CodeHighlight codeHighlight = new CodeHighlight(start, end, this.textAttributes, this.area);
                    streamBuilder.add(codeHighlight);
                }
            }
            return streamBuilder.build();
        }
    }
}

