/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.notifications;

import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import icons.CommonIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class NotificationFactory {
    public static final NotificationGroup BALLOON_NOTIFICATION_GROUP = NotificationGroup.findRegisteredGroup((String)ActionUtil.getActionIdWithLowerCase("cosyBalloonNotifications"));
    public static final NotificationGroup STICKY_NOTIFICATION_GROUP = NotificationGroup.findRegisteredGroup((String)ActionUtil.getActionIdWithLowerCase("cosyStickyNotifications"));

    public static void showInfoNotification(Project project, String info) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            String message = String.format("%s: %s", CosyBundle.message("cosy.plugin.name", new Object[0]), info);
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
            notification.setIcon(CommonIcons.AI);
            notification.notify(project);
        }
    }

    public static Notification createInfoStickyNotification(String content) {
        return NotificationFactory.createInfoStickyNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), content);
    }

    public static void showInfoNotificationWithTitle(Project project, String content) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), content, NotificationType.INFORMATION, (NotificationListener)new DefaultUrlOpeningListener(project, null, false));
            notification.setIcon(CommonIcons.AI);
            notification.notify(project);
        }
    }

    public static Notification createInfoStickyNotification(String title, String content) {
        return NotificationFactory.createStickyNotification(title, content, NotificationType.INFORMATION);
    }

    public static Notification createStickyNotification(String title, String content, NotificationType type) {
        if (STICKY_NOTIFICATION_GROUP != null) {
            Notification notification = STICKY_NOTIFICATION_GROUP.createNotification(title, content, type, (NotificationListener)new DefaultUrlOpeningListener(null, null, false));
            notification.setIcon(CommonIcons.AI);
            return notification;
        }
        return null;
    }

    public static void showWarnStickyNotification(Project project, String content) {
        Notification notification = NotificationFactory.createInfoStickyNotification(content);
        if (notification != null) {
            notification.notify(project);
        }
    }

    public static void showWarnNotification(Project project, String content) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), content, NotificationType.WARNING, (NotificationListener)new DefaultUrlOpeningListener(project, null, false));
            notification.setIcon(CommonIcons.AI);
            notification.notify(project);
        }
    }

    public static void showErrorNotification(Project project, String title, String content) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(title, content, NotificationType.ERROR, (NotificationListener)new DefaultUrlOpeningListener(project, null, false));
            notification.setIcon(CommonIcons.AI);
            notification.notify(project);
        }
    }

    public static void showNotification(Project project, NotificationType notificationType, String content, AnAction ... actions) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), content, notificationType, (NotificationListener)new DefaultUrlOpeningListener(project, null, false));
            notification.setIcon(CommonIcons.AI);
            if (actions != null) {
                for (AnAction action : actions) {
                    notification.addAction(action);
                }
            }
            notification.notify(project);
        }
    }

    public static void showNotification(Project project, NotificationType notificationType, String title, String content) {
        if (BALLOON_NOTIFICATION_GROUP != null) {
            Notification notification = BALLOON_NOTIFICATION_GROUP.createNotification(title, content, notificationType, (NotificationListener)new DefaultUrlOpeningListener(project, null, true));
            notification.setIcon(CommonIcons.AI);
            notification.notify(project);
        }
    }

    public static Balloon showToast(JComponent jComponent, MessageType type, String text) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text, type, (HyperlinkListener)new DefaultHyperlinkListener(jComponent)).setFadeoutTime(7500L).createBalloon();
        balloon.show(RelativePoint.getCenterOf((JComponent)jComponent), Balloon.Position.below);
        return balloon;
    }

    public static Balloon showToast(JComponent jComponent, Icon icon, String text) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text, icon, ColorUtil.getToolWindowBackgroundColor(), (HyperlinkListener)new DefaultHyperlinkListener(jComponent)).setFadeoutTime(7500L).createBalloon();
        balloon.show(RelativePoint.getCenterOf((JComponent)jComponent), Balloon.Position.below);
        return balloon;
    }

    public static class DefaultUrlOpeningListener
    extends NotificationListener.Adapter {
        private final boolean expireNotification;
        private final JComponent component;
        private final Project project;

        public DefaultUrlOpeningListener(Project project, JComponent component, boolean expireNotification) {
            this.expireNotification = expireNotification;
            this.component = component;
            this.project = project;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                DefaultUrlOpeningListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                DefaultUrlOpeningListener.$$$reportNull$$$0(1);
            }
            UrlUtil.performHyperlink(this.project, event, this.component);
            if (this.expireNotification) {
                notification.expire();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/NotificationFactory$DefaultUrlOpeningListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultHyperlinkListener
    implements HyperlinkListener {
        JComponent component;

        private DefaultHyperlinkListener(JComponent component) {
            this.component = component;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Project project = ProjectUtil.guessCurrentProject((JComponent)this.component);
                UrlUtil.performHyperlink(project, e, this.component);
            }
        }
    }
}

