/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.inlinediff;

import com.alibabacloud.intellij.cosy.ui.ineditordiff.OffsetRange;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.SequenceDiff;
import com.alibabacloud.intellij.cosy.ui.inlinediff.Array2D;
import com.alibabacloud.intellij.cosy.ui.inlinediff.DiffAlgorithmResult;
import com.alibabacloud.intellij.cosy.ui.inlinediff.ISequence;
import com.alibabacloud.intellij.cosy.ui.inlinediff.ITimeout;
import com.alibabacloud.intellij.cosy.ui.inlinediff.PrefixDiffingAlgorithm;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/alibabacloud/intellij/cosy/ui/inlinediff/PrefixDiffingAlgorithm;", "", "()V", "compute", "Lcom/alibabacloud/intellij/cosy/ui/inlinediff/DiffAlgorithmResult;", "sequence1", "Lcom/alibabacloud/intellij/cosy/ui/inlinediff/ISequence;", "sequence2", "timeout", "Lcom/alibabacloud/intellij/cosy/ui/inlinediff/ITimeout;", "PendingRange", "cosy-intellij"})
public final class PrefixDiffingAlgorithm {
    @NotNull
    public final DiffAlgorithmResult compute(@NotNull ISequence sequence1, @NotNull ISequence sequence2, @NotNull ITimeout timeout) {
        int row;
        Intrinsics.checkNotNullParameter((Object)sequence1, (String)"sequence1");
        Intrinsics.checkNotNullParameter((Object)sequence2, (String)"sequence2");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        if (sequence1.length() == 0 || sequence2.length() == 0) {
            return DiffAlgorithmResult.Companion.trivial(sequence1, sequence2);
        }
        Array2D<Double> costMatrix = new Array2D<Double>(2 * sequence1.length() + 1, sequence2.length() + 1);
        Array2D<Boolean> pathMatrix = new Array2D<Boolean>(2 * sequence1.length() + 1, sequence2.length() + 1);
        int col = 0;
        int n = sequence2.length();
        if (col <= n) {
            while (true) {
                costMatrix.set(0, col, Double.valueOf(col));
                pathMatrix.set(0, col, col > 0);
                if (col == n) break;
                ++col;
            }
        }
        if ((row = 0) <= (n = 2 * sequence1.length())) {
            while (true) {
                costMatrix.set(row, 0, (double)(row + 1) / (double)2);
                pathMatrix.set(row, 0, false);
                if (row == n) break;
                ++row;
            }
        }
        if ((col = 1) <= (n = sequence2.length())) {
            while (true) {
                int n2;
                int row2;
                if ((row2 = 1) <= (n2 = 2 * sequence1.length())) {
                    while (true) {
                        if (!timeout.isValid()) {
                            return DiffAlgorithmResult.Companion.trivialTimedOut(sequence1, sequence2);
                        }
                        if (row2 % 2 == 0) {
                            Double d = (Double)costMatrix.get(row2, col - 1);
                            Double verticalMove = d != null ? Double.valueOf(d + 1.0) : null;
                            Double horizontalMove = (Double)costMatrix.get(row2 - 1, col);
                            Double d2 = verticalMove;
                            Intrinsics.checkNotNull((Object)d2);
                            double d3 = d2;
                            Double d4 = horizontalMove;
                            Intrinsics.checkNotNull((Object)d4);
                            if (d3 < d4) {
                                costMatrix.set(row2, col, verticalMove);
                                pathMatrix.set(row2, col, true);
                            } else {
                                costMatrix.set(row2, col, horizontalMove);
                                pathMatrix.set(row2, col, false);
                            }
                        } else {
                            boolean match = Intrinsics.areEqual((Object)sequence1.getElement(Math.floorDiv(row2, 2)), (Object)sequence2.getElement(col - 1));
                            Double diagonalMove = match ? (Double)costMatrix.get(row2 - 1, col - 1) : Double.valueOf(2.147483647E9);
                            Double d = (Double)costMatrix.get(row2 - 1, col);
                            Double horizontalMove = d != null ? Double.valueOf(d + 0.4) : null;
                            Double d5 = diagonalMove;
                            Intrinsics.checkNotNull((Object)d5);
                            double d6 = d5;
                            Double d7 = horizontalMove;
                            Intrinsics.checkNotNull((Object)d7);
                            if (d6 < d7) {
                                costMatrix.set(row2, col, diagonalMove);
                                pathMatrix.set(row2, col, true);
                            } else {
                                costMatrix.set(row2, col, horizontalMove);
                                pathMatrix.set(row2, col, false);
                            }
                        }
                        if (row2 == n2) break;
                        ++row2;
                    }
                }
                if (col == n) break;
                ++col;
            }
        }
        double minCost = 2.147483647E9;
        int minRow = -1;
        int row3 = 0;
        int match = 2 * sequence1.length();
        if (row3 <= match) {
            while (true) {
                Double cost;
                Double d = cost = (Double)costMatrix.get(row3, sequence2.length());
                Intrinsics.checkNotNull((Object)d);
                if (d < minCost) {
                    minCost = cost;
                    minRow = row3;
                }
                if (row3 == match) break;
                ++row3;
            }
        }
        List result = new ArrayList();
        int backtrackRow = minRow;
        int backtrackCol = sequence2.length();
        PendingRange pendingRange = null;
        while (backtrackRow >= 0 && backtrackCol >= 0) {
            if (Intrinsics.areEqual(pathMatrix.get(backtrackRow, backtrackCol), (Object)true)) {
                if (backtrackRow % 2 == 0) {
                    if (pendingRange == null) {
                        pendingRange = new PendingRange(Math.floorDiv(backtrackRow, 2), backtrackCol);
                    }
                    --backtrackCol;
                    continue;
                }
                if (pendingRange != null) {
                    if (pendingRange.getX() != Math.floorDiv(backtrackRow, 2) + 1 || pendingRange.getY() != backtrackCol) {
                        result.add(new SequenceDiff(new OffsetRange(Math.floorDiv(backtrackRow, 2) + 1, pendingRange.getX()), new OffsetRange(backtrackCol, pendingRange.getY())));
                    }
                    pendingRange = null;
                }
                --backtrackRow;
                --backtrackCol;
                continue;
            }
            if (pendingRange == null) {
                pendingRange = new PendingRange(Math.floorDiv(backtrackRow + 1, 2), backtrackCol);
            }
            --backtrackRow;
        }
        if (pendingRange != null && (pendingRange.getX() != Math.floorDiv(backtrackRow, 2) + 1 || pendingRange.getY() != backtrackCol)) {
            result.add(new SequenceDiff(new OffsetRange(Math.floorDiv(backtrackRow, 2) + 1, pendingRange.getX()), new OffsetRange(backtrackCol, pendingRange.getY())));
        }
        CollectionsKt.sortWith((List)result, (arg_0, arg_1) -> PrefixDiffingAlgorithm.compute$lambda$0(compute.1.INSTANCE, arg_0, arg_1));
        return new DiffAlgorithmResult(result, false);
    }

    private static final int compute$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/alibabacloud/intellij/cosy/ui/inlinediff/PrefixDiffingAlgorithm$PendingRange;", "", "x", "", "y", "(II)V", "getX", "()I", "setX", "(I)V", "getY", "setY", "cosy-intellij"})
    private static final class PendingRange {
        private int x;
        private int y;

        public PendingRange(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }
    }
}

