/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.ineditordiff.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;

public class CodeBlockFinder {
    public static FoldRegion findFoldableBlock(Editor editor, int offset) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion[] allRegions;
            for (FoldRegion region : allRegions = foldingModel.getAllFoldRegions()) {
                if (!region.isValid() || !CodeBlockFinder.containsOffset(region, offset, editor)) continue;
                regions.add(region);
            }
        });
        return CodeBlockFinder.findSmallestRegion(regions);
    }

    private static boolean containsOffset(FoldRegion region, int offset, Editor editor) {
        int regionStartLine = editor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = editor.getDocument().getLineNumber(region.getEndOffset());
        int line = editor.getDocument().getLineNumber(offset);
        return regionStartLine <= line && line <= regionEndLine;
    }

    private static FoldRegion findSmallestRegion(List<FoldRegion> regions) {
        if (regions.isEmpty()) {
            return null;
        }
        FoldRegion smallest = regions.get(0);
        int smallestLength = smallest.getEndOffset() - smallest.getStartOffset();
        for (FoldRegion region : regions) {
            int length = region.getEndOffset() - region.getStartOffset();
            if (length >= smallestLength) continue;
            smallest = region;
            smallestLength = length;
        }
        return smallest;
    }
}

