/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.ineditordiff;

import com.alibabacloud.intellij.cosy.ui.ineditordiff.DiffAlgorithmResult;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.InfiniteTimeout;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.LinesSequence;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.PrefixDiffingAlgorithm;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class PrefixDiffingAlgorithMain {
    static String target = "package com.macro.mall.service.impl;\n\nimport cn.hutool.core.util.StrUtil;\nimport com.github.pagehelper.PageHelper;\nimport com.macro.mall.dto.PmsBrandParam;\nimport com.macro.mall.mapper.PmsBrandMapper;\nimport com.macro.mall.mapper.PmsProductMapper;\nimport com.macro.mall.model.PmsBrand;\nimport com.macro.mall.model.PmsBrandExample;\nimport com.macro.mall.model.PmsProduct;\nimport com.macro.mall.model.PmsProductExample;\nimport com.macro.mall.service.PmsBrandService;\nimport org.springframework.beans.BeanUtils;\nimport org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.stereotype.Service;\n\nimport java.util.List;\n\n/**\n * \u5546\u54c1\u54c1\u724c\u7ba1\u7406Service\u5b9e\u73b0\u7c7b\n * Created by macro on 2018/4/26.\n */\n@Service\npublic class PmsBrandServiceImpl implements PmsBrandService {\n    @Autowired\n    private PmsBrandMapper brandMapper;\n    @Autowired\n    private PmsProductMapper productMapper;\n\n    @Override\n    public List<PmsBrand> listAllBrand() {\n        return brandMapper.selectByExample(new PmsBrandExample());\n    }\n\n    @Override\n    public int createBrand(PmsBrandParam pmsBrandParam) {\n        PmsBrand pmsBrand = new PmsBrand();\n        BeanUtils.copyProperties(pmsBrandParam, pmsBrand);\n        //\u5982\u679c\u521b\u5efa\u65f6\u9996\u5b57\u6bcd\u4e3a\u7a7a\uff0c\u53d6\u540d\u79f0\u7684\u7b2c\u4e00\u4e2a\u4e3a\u9996\u5b57\u6bcd\n        if (StrUtil.isEmpty(pmsBrand.getFirstLetter())) {\n            pmsBrand.setFirstLetter(pmsBrand.getName().substring(0, 1));\n        }\n        return brandMapper.insertSelective(pmsBrand);\n    }\n\n    @Override\n    public int updateBrand(Long id, PmsBrandParam pmsBrandParam) {\n        //\u521d\u59cb\u5316\n        PmsBrand pmsBrand = new PmsBrand();\n        //copyProperties\u53c2\u6570\n        BeanUtils.copyProperties(pmsBrandParam, pmsBrand);\n        pmsBrand.setId(id);\n        //\u5982\u679c\u521b\u5efa\u65f6\u9996\u5b57\u6bcd\u4e3a\u7a7a\uff0c\u53d6\u540d\u79f0\u7684\u7b2c\u4e00\u4e2a\u4e3a\u9996\u5b57\u6bcd\n        if (StrUtil.isEmpty(pmsBrand.getFirstLetter())) {\n            pmsBrand.setFirstLetter(pmsBrand.getName().substring(0, 2));\n        }\n        PmsProduct product = new PmsProduct();\n        product.setBrandName(pmsBrand.getName());\n        PmsProductExample example = new PmsProductExample();\n        example.createCriteria().andBrandIdEqualTo(id);\n        return brandMapper.updateByPrimaryKeySelective(pmsBrand);\n    }";

    public static void main(String[] args) throws IOException {
        String filePath = "/Users/lihua.llh/Documents/codes/lab/java/mall/mall-admin/src/main/java/com/macro/mall/service/impl/PmsBrandServiceImpl.java";
        String code = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        LinesSequence seq1 = new LinesSequence(code.split("\n"));
        LinesSequence seq2 = new LinesSequence(target.split("\n"));
        PrefixDiffingAlgorithm algorithm = new PrefixDiffingAlgorithm();
        DiffAlgorithmResult result = algorithm.compute(seq1, seq2, InfiniteTimeout.instance);
        System.out.println(result);
    }

    public static void main2(String[] args) {
        LinesSequence seq1 = new LinesSequence("abchello world".split("|"));
        LinesSequence seq2 = new LinesSequence("abchalblo".split("|"));
        PrefixDiffingAlgorithm algorithm = new PrefixDiffingAlgorithm();
        DiffAlgorithmResult result = algorithm.compute(seq1, seq2, InfiniteTimeout.instance);
        System.out.println(result);
    }
}

