/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.ineditordiff;

import com.alibabacloud.intellij.cosy.ui.ineditordiff.InlineDiffSingleChangeComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.DiffOperationNotifier;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class InlineDiffActionPanel
extends JPanel {
    private JPanel rejectToolTip;
    private JPanel acceptToolTip;
    private Editor editor;
    private final JLabel numberLabel;

    public InlineDiffActionPanel(int radius, String count, final InlineDiffSingleChangeComponent component, final Editor editor) {
        this.editor = editor;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(new Color(0, 0, 0, 0));
        this.setOpaque(false);
        SideRoundRect leftPanel = new SideRoundRect(radius, 0);
        leftPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        leftPanel.setForeground(ColorUtil.getToolWindowBackgroundColor());
        leftPanel.setOpaque(false);
        leftPanel.setLayout(new GridBagLayout());
        leftPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        this.numberLabel = new JLabel(count, 0);
        this.numberLabel.setForeground(ColorUtil.getLabelForegroundColor());
        this.numberLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.numberLabel.setOpaque(false);
        leftPanel.add(this.numberLabel);
        final SideRoundRect rightPanel = new SideRoundRect(radius, 1);
        rightPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        rightPanel.setForeground(ColorUtil.getToolWindowBackgroundColor());
        rightPanel.setOpaque(false);
        rightPanel.setLayout(new BoxLayout(rightPanel, 0));
        rightPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        final JLabel rejectButton = new JLabel();
        rejectButton.setIcon(LingmaIcons.ErrorRed16Icon);
        rejectButton.setBorder(JBUI.Borders.empty((int)2));
        final RoundRectPanel rejectToolTip = new RoundRectPanel((LayoutManager)new BorderLayout(), radius);
        this.rejectToolTip = rejectToolTip;
        rejectToolTip.setOpaque(false);
        rejectToolTip.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        String shortCutText = KeyboardUtil.getShortcutText(ActionUtil.getActionIdWithAddPrefix("RejectSingleInlineChatChangesAction"));
        JLabel rejectTipText = new JLabel(CosyBundle.message("inline.tab.diff.action.reject", new Object[0]) + " " + shortCutText);
        rejectTipText.setOpaque(false);
        rejectTipText.setForeground(ColorUtil.getLabelForegroundColor());
        rejectTipText.setBackground(ColorUtil.getToolWindowBackgroundColor());
        rejectToolTip.add((Component)rejectTipText, "Center");
        rejectToolTip.setForeground(ColorUtil.getLabelForegroundColor());
        rejectToolTip.setBackground(ColorUtil.getToolWindowBackgroundColor());
        rejectToolTip.setVisible(false);
        editor.getContentComponent().add((Component)rejectToolTip, 0);
        rejectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                Rectangle rejectButtonBounds = InlineDiffActionPanel.this.getBounds();
                rejectButtonBounds.y += 34;
                int x = rejectButtonBounds.x + rightPanel.getWidth() + rejectButton.getBounds().x;
                rejectButtonBounds.x = x += (rejectButton.getWidth() - rejectToolTip.getPreferredSize().width) / 2 - rejectToolTip.getPreferredSize().width / 2;
                rejectButtonBounds.width = rejectToolTip.getPreferredSize().width;
                rejectButtonBounds.height = rejectToolTip.getPreferredSize().height;
                rejectToolTip.setBounds(rejectButtonBounds);
                rejectToolTip.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
                rejectToolTip.setVisible(false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                component.reject(true);
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
                ((DiffOperationNotifier)component.getProject().getMessageBus().syncPublisher(DiffOperationNotifier.DIFF_OPERATION_NOTIFICATION)).operate(component);
            }
        });
        final JLabel acceptButton = new JLabel();
        acceptButton.setIcon(LingmaIcons.AcceptGreen16Icon);
        acceptButton.setBorder(JBUI.Borders.empty((int)2));
        acceptButton.setOpaque(false);
        final RoundRectPanel acceptToolTip = new RoundRectPanel((LayoutManager)new BorderLayout(), radius);
        this.acceptToolTip = acceptToolTip;
        acceptToolTip.setOpaque(false);
        acceptToolTip.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        shortCutText = KeyboardUtil.getShortcutText(ActionUtil.getActionIdWithAddPrefix("AcceptSingleInlineChatChangesAction"));
        JLabel toolTipText = new JLabel(CosyBundle.message("inline.tab.diff.action.accept", new Object[0]) + " " + shortCutText);
        toolTipText.setOpaque(false);
        toolTipText.setForeground(ColorUtil.getLabelForegroundColor());
        toolTipText.setBackground(ColorUtil.getToolWindowBackgroundColor());
        acceptToolTip.add((Component)toolTipText, "Center");
        acceptToolTip.setForeground(ColorUtil.getLabelForegroundColor());
        acceptToolTip.setBackground(ColorUtil.getToolWindowBackgroundColor());
        acceptToolTip.setVisible(false);
        editor.getContentComponent().add((Component)acceptToolTip, 0);
        acceptButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                Rectangle acceptButtonBounds = InlineDiffActionPanel.this.getBounds();
                acceptButtonBounds.y += 34;
                int x = acceptButtonBounds.x + rightPanel.getWidth() + acceptButton.getBounds().x;
                acceptButtonBounds.x = x += (acceptButton.getWidth() - acceptToolTip.getPreferredSize().width) / 2 - acceptToolTip.getPreferredSize().width / 2;
                acceptButtonBounds.width = acceptToolTip.getPreferredSize().width;
                acceptButtonBounds.height = acceptToolTip.getPreferredSize().height;
                acceptToolTip.setBounds(acceptButtonBounds);
                acceptToolTip.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
                acceptToolTip.setVisible(false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                component.accept(true);
                editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
                ((DiffOperationNotifier)component.getProject().getMessageBus().syncPublisher(DiffOperationNotifier.DIFF_OPERATION_NOTIFICATION)).operate(component);
            }
        });
        rightPanel.add(rejectButton);
        rightPanel.add(Box.createHorizontalStrut(12));
        rightPanel.add(acceptButton);
        this.add(leftPanel);
        this.add(Box.createHorizontalStrut(1));
        this.add(rightPanel);
    }

    public void dispose() {
        if (this.acceptToolTip != null) {
            this.editor.getContentComponent().remove(this.acceptToolTip);
        }
        if (this.rejectToolTip != null) {
            this.editor.getContentComponent().remove(this.rejectToolTip);
        }
    }

    @Generated
    public JLabel getNumberLabel() {
        return this.numberLabel;
    }

    public static class SideRoundRect
    extends JComponent {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;
        private int arc;
        private int side;

        public SideRoundRect(int arc, int side) {
            this.arc = arc;
            this.side = side;
            this.setOpaque(false);
        }

        public void setArc(int arc) {
            this.arc = arc;
            this.repaint();
        }

        public void setSide(int side) {
            this.side = side;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Path2D.Float path = new Path2D.Float();
            if (this.side == 0) {
                ((Path2D)path).moveTo(this.arc, 0.0);
                ((Path2D)path).lineTo(w, 0.0);
                ((Path2D)path).lineTo(w, h);
                ((Path2D)path).lineTo(this.arc, h);
                ((Path2D)path).quadTo(0.0, h, 0.0, h - this.arc);
                ((Path2D)path).lineTo(0.0, this.arc);
                ((Path2D)path).quadTo(0.0, 0.0, this.arc, 0.0);
            } else {
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(w - this.arc, 0.0);
                ((Path2D)path).quadTo(w, 0.0, w, this.arc);
                ((Path2D)path).lineTo(w, h - this.arc);
                ((Path2D)path).quadTo(w, h, w - this.arc, h);
                ((Path2D)path).lineTo(0.0, h);
                path.closePath();
            }
            g2.fill(path);
            g2.dispose();
        }
    }
}

