/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.ineditordiff;

import com.alibabacloud.intellij.cosy.ui.diff.ComponentInlayAlignment;
import com.alibabacloud.intellij.cosy.ui.diff.ComponentInlayRenderer;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.ComponentInlaysContainer;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.EditorHostedComponent;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.WriteIntentReadAction;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.util.DisposerUtilKt;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.util.RemoveUserDataKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002\b\u000f\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\u00162\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0002R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001e\u0010\u0011\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer;", "Ljavax/swing/JComponent;", "Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/EditorHostedComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "contentResizeListener", "com/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer$contentResizeListener$1", "Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer$contentResizeListener$1;", "contentSizeAwareInlayCount", "", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "foldingListener", "com/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer$foldingListener$1", "Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer$foldingListener$1;", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/alibabacloud/intellij/cosy/ui/diff/ComponentInlayRenderer;", "isInputFocusOwner", "", "()Z", "visibleAreaAwareInlaysCount", "visibleAreaListener", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "add", "", "inlay", "dispose", "doLayout", "invalidate", "isValidateRoot", "isVerticalScrollbarFlipped", "scrollPane", "Ljavax/swing/JScrollPane;", "remove", "Companion", "cosy-intellij"})
final class ComponentInlaysContainer
extends JComponent
implements EditorHostedComponent,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    private int visibleAreaAwareInlaysCount;
    private int contentSizeAwareInlayCount;
    @NotNull
    private final List<Inlay<ComponentInlayRenderer<?>>> inlays;
    @NotNull
    private final contentResizeListener.1 contentResizeListener;
    @NotNull
    private final VisibleAreaListener visibleAreaListener;
    @NotNull
    private final foldingListener.1 foldingListener;
    private final boolean isInputFocusOwner;
    @NotNull
    private static final Key<ComponentInlaysContainer> INLAYS_CONTAINER = new Key("INLAYS_CONTAINER");

    private ComponentInlaysContainer(EditorEx editor) {
        this.editor = editor;
        this.inlays = new ArrayList();
        this.contentResizeListener = new ComponentAdapter(this){
            final /* synthetic */ ComponentInlaysContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(@Nullable ComponentEvent e) {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
        this.visibleAreaListener = arg_0 -> ComponentInlaysContainer.visibleAreaListener$lambda$0(this, arg_0);
        this.foldingListener = new FoldingListener(this){
            final /* synthetic */ ComponentInlaysContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFoldProcessingEnd() {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
        this.isInputFocusOwner = true;
        this.editor.getFoldingModel().addListener((FoldingListener)this.foldingListener, (Disposable)this);
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @Override
    public boolean isInputFocusOwner() {
        return this.isInputFocusOwner;
    }

    private final boolean remove(Inlay<ComponentInlayRenderer<?>> inlay) {
        if (!this.inlays.remove(inlay)) {
            return false;
        }
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"inlay.renderer");
        ComponentInlayRenderer renderer = (ComponentInlayRenderer)editorCustomElementRenderer;
        ComponentInlayAlignment componentInlayAlignment = renderer.getAlignment();
        switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
            case 1: 
            case 2: {
                this.contentSizeAwareInlayCount += -1;
                if (this.contentSizeAwareInlayCount != 0) break;
                this.editor.getContentComponent().removeComponentListener(this.contentResizeListener);
                break;
            }
            case 3: 
            case 4: {
                this.visibleAreaAwareInlaysCount += -1;
                if (this.visibleAreaAwareInlaysCount != 0) break;
                this.editor.getScrollingModel().removeVisibleAreaListener(this.visibleAreaListener);
                break;
            }
        }
        this.remove((Component)renderer.getComponent());
        if (!this.editor.isDisposed()) {
            this.revalidate();
            this.repaint();
        }
        return true;
    }

    private final void add(Inlay<ComponentInlayRenderer<?>> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"inlay.renderer");
        ComponentInlayRenderer renderer = (ComponentInlayRenderer)editorCustomElementRenderer;
        this.inlays.add(inlay);
        this.add((Component)renderer.getComponent());
        ((Component)renderer.getComponent()).setVisible(!EditorUtil.isInlayFolded(inlay));
        ComponentInlayAlignment componentInlayAlignment = ((ComponentInlayRenderer)inlay.getRenderer()).getAlignment();
        switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
            case 1: 
            case 2: {
                int n = this.contentSizeAwareInlayCount;
                this.contentSizeAwareInlayCount = n + 1;
                if (n != 0) break;
                this.editor.getContentComponent().addComponentListener(this.contentResizeListener);
                break;
            }
            case 3: 
            case 4: {
                int n = this.visibleAreaAwareInlaysCount;
                this.visibleAreaAwareInlaysCount = n + 1;
                if (n != 0) break;
                this.editor.getScrollingModel().addVisibleAreaListener(this.visibleAreaListener);
                break;
            }
        }
        if (((Component)renderer.getComponent()).isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        super.invalidate();
        RepaintManager.currentManager(this).addInvalidComponent(this);
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doLayout() {
        List<Inlay<ComponentInlayRenderer<?>>> inlays = this.inlays;
        if (inlays.isEmpty()) {
            return;
        }
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        JComponent content = jComponent;
        int initialContentWidth = content.getWidth();
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        JScrollPane scrollPane = jScrollPane;
        int viewportReservedWidth = !this.isVerticalScrollbarFlipped(scrollPane) ? this.editor.getScrollPane().getVerticalScrollBar().getWidth() + content.getInsets().left : content.getInsets().left;
        int viewportWidth = scrollPane.getViewport().getWidth();
        int contentXInViewport = scrollPane.getViewport().getViewPosition().x;
        for (Inlay<ComponentInlayRenderer<?>> inlay : inlays) {
            Dimension dimension;
            ComponentInlayRenderer it = (ComponentInlayRenderer)inlay.getRenderer();
            boolean bl = false;
            ComponentInlayRenderer componentInlayRenderer = it;
            ComponentInlayAlignment componentInlayAlignment = it.getAlignment();
            switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
                case 1: {
                    Object $this$doLayout_u24lambda_u243_u24lambda_u241;
                    Object t = it.getComponent();
                    ComponentInlayRenderer componentInlayRenderer2 = componentInlayRenderer;
                    boolean bl2 = false;
                    dimension = new Dimension(((Component)$this$doLayout_u24lambda_u243_u24lambda_u241).getMinimumSize().width, ((Component)$this$doLayout_u24lambda_u243_u24lambda_u241).getPreferredSize().height);
                    componentInlayRenderer = componentInlayRenderer2;
                    break;
                }
                case 3: 
                case 4: {
                    void $this$doLayout_u24lambda_u243_u24lambda_u242;
                    Object $this$doLayout_u24lambda_u243_u24lambda_u241 = it.getComponent();
                    ComponentInlayRenderer componentInlayRenderer2 = componentInlayRenderer;
                    boolean bl3 = false;
                    dimension = new Dimension($this$doLayout_u24lambda_u243_u24lambda_u242.getMinimumSize().width + viewportReservedWidth, $this$doLayout_u24lambda_u243_u24lambda_u242.getPreferredSize().height);
                    componentInlayRenderer = componentInlayRenderer2;
                    break;
                }
                default: {
                    Dimension dimension2 = ((Component)it.getComponent()).getPreferredSize();
                    dimension = dimension2;
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"{\n                      \u2026ize\n                    }");
                }
            }
            componentInlayRenderer.setInlaySize$cosy_intellij(dimension);
        }
        WriteIntentReadAction.run(() -> ComponentInlaysContainer.doLayout$lambda$6(this, inlays));
        if (content.getWidth() < initialContentWidth && content.getWidth() < viewportWidth) {
            content.setSize(new Dimension(Math.min(initialContentWidth, viewportWidth), content.getHeight()));
        }
        this.setBounds(SwingUtilities.calculateInnerArea(content, null));
        ReadAction.run(() -> ComponentInlaysContainer.doLayout$lambda$7(inlays, contentXInViewport, this, viewportWidth, viewportReservedWidth));
    }

    private final boolean isVerticalScrollbarFlipped(JScrollPane scrollPane) {
        Object flipProperty = scrollPane.getClientProperty(JBScrollPane.Flip.class);
        return flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH;
    }

    public void dispose() {
    }

    private static final void visibleAreaListener$lambda$0(ComponentInlaysContainer this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.revalidate();
        this$0.repaint();
    }

    private static final void doLayout$lambda$6$lambda$5(List $inlays) {
        Intrinsics.checkNotNullParameter((Object)$inlays, (String)"$inlays");
        for (Inlay inlay : $inlays) {
            ComponentInlayRenderer it = (ComponentInlayRenderer)inlay.getRenderer();
            boolean bl = false;
            if (it.getInlaySize$cosy_intellij().width == inlay.getWidthInPixels() && it.getInlaySize$cosy_intellij().height == inlay.getHeightInPixels()) continue;
            inlay.update();
        }
    }

    private static final void doLayout$lambda$6(ComponentInlaysContainer this$0, List $inlays) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inlays, (String)"$inlays");
        this$0.editor.getInlayModel().execute(true, () -> ComponentInlaysContainer.doLayout$lambda$6$lambda$5($inlays));
    }

    private static final void doLayout$lambda$7(List $inlays, int $contentXInViewport, ComponentInlaysContainer this$0, int $viewportWidth, int $viewportReservedWidth) {
        Intrinsics.checkNotNullParameter((Object)$inlays, (String)"$inlays");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (Inlay inlay : $inlays) {
            Object component = ((ComponentInlayRenderer)inlay.getRenderer()).getComponent();
            Rectangle componentBounds = inlay.getBounds();
            if (componentBounds == null) {
                ((Component)component).setVisible(false);
                continue;
            }
            ((Component)component).setVisible(true);
            ComponentInlayAlignment alignment = ((ComponentInlayRenderer)inlay.getRenderer()).getAlignment();
            int n = componentBounds.x = alignment == ComponentInlayAlignment.FIT_VIEWPORT_X_SPAN ? $contentXInViewport : 0;
            if (alignment == ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH || alignment == ComponentInlayAlignment.FIT_CONTENT_WIDTH) {
                componentBounds.width = this$0.getBounds().width;
            } else if (alignment == ComponentInlayAlignment.FIT_VIEWPORT_WIDTH || alignment == ComponentInlayAlignment.FIT_VIEWPORT_X_SPAN) {
                componentBounds.width = Math.max(((Component)component).getMinimumSize().width, $viewportWidth - $viewportReservedWidth);
            } else if (alignment == ComponentInlayAlignment.COMPONENT_WIDTH_ONLY) {
                componentBounds.width = ((Component)component).getPreferredSize().width;
            }
            ((Component)component).setBounds(componentBounds);
        }
    }

    public /* synthetic */ ComponentInlaysContainer(EditorEx editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    public static final /* synthetic */ boolean access$remove(ComponentInlaysContainer $this, Inlay inlay) {
        return $this.remove(inlay);
    }

    public static final /* synthetic */ List access$getInlays$p(ComponentInlaysContainer $this) {
        return $this.inlays;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer$Companion;", "", "()V", "INLAYS_CONTAINER", "Lcom/intellij/openapi/util/Key;", "Lcom/alibabacloud/intellij/cosy/ui/ineditordiff/ComponentInlaysContainer;", "addInlay", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/alibabacloud/intellij/cosy/ui/diff/ComponentInlayRenderer;", "cosy-intellij"})
    public static final class Companion {
        private Companion() {
        }

        public final void addInlay(@NotNull Inlay<ComponentInlayRenderer<?>> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorEx editor2 = (EditorEx)editor;
            if (editor2.isDisposed()) {
                return;
            }
            ComponentInlaysContainer componentInlaysContainer = (ComponentInlaysContainer)editor2.getUserData(INLAYS_CONTAINER);
            if (componentInlaysContainer == null) {
                ComponentInlaysContainer componentInlaysContainer2;
                ComponentInlaysContainer container = componentInlaysContainer2 = new ComponentInlaysContainer(editor2, null);
                boolean bl = false;
                editor2.putUserData(INLAYS_CONTAINER, (Object)container);
                editor2.getContentComponent().add(container);
                DisposerUtilKt.whenDisposed(container, (Function0<Unit>)((Function0)new Function0<Unit>(editor2, container){
                    final /* synthetic */ EditorEx $editor;
                    final /* synthetic */ ComponentInlaysContainer $container;
                    {
                        this.$editor = $editor;
                        this.$container = $container;
                        super(0);
                    }

                    public final void invoke() {
                        this.$editor.getContentComponent().remove(this.$container);
                        RemoveUserDataKt.removeUserData((UserDataHolder)this.$editor, ComponentInlaysContainer.access$getINLAYS_CONTAINER$cp());
                    }
                }));
                EditorUtil.disposeWithEditor((Editor)((Editor)editor2), (Disposable)container);
                componentInlaysContainer = componentInlaysContainer2;
            }
            ComponentInlaysContainer inlaysContainer2 = componentInlaysContainer;
            inlaysContainer2.add(inlay);
            DisposerUtilKt.whenDisposed((Disposable)inlay, (Function0<Unit>)((Function0)new Function0<Unit>(inlaysContainer2, inlay){
                final /* synthetic */ ComponentInlaysContainer $inlaysContainer;
                final /* synthetic */ Inlay<ComponentInlayRenderer<?>> $inlay;
                {
                    this.$inlaysContainer = $inlaysContainer;
                    this.$inlay = $inlay;
                    super(0);
                }

                public final void invoke() {
                    if (ComponentInlaysContainer.access$remove(this.$inlaysContainer, this.$inlay) && ComponentInlaysContainer.access$getInlays$p(this.$inlaysContainer).isEmpty()) {
                        Disposer.dispose((Disposable)this.$inlaysContainer);
                    }
                }
            }));
            Disposer.register((Disposable)inlaysContainer2, (Disposable)((Disposable)inlay));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentInlayAlignment.values().length];
            try {
                nArray[ComponentInlayAlignment.FIT_CONTENT_WIDTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.FIT_VIEWPORT_X_SPAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.FIT_VIEWPORT_WIDTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

