/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.config;

import com.alibabacloud.intellij.cosy.chat.enums.ResponseLanguageEnum;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ToolAutoRunEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.McpAutoRunEnum;
import com.alibabacloud.intellij.cosy.search.enums.ProxyModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.LingmaAgentUtil;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyConfigurable
implements SearchableConfigurable,
ImmediateConfigurable {
    private static final Logger log = Logger.getInstance(CosyConfigurable.class);
    private ConfigMainForm mainForm;

    @NotNull
    public String getId() {
        String string = CosyBundle.message("cosy.plugin.name", new Object[0]);
        if (string == null) {
            CosyConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return CosyBundle.message("settings.main.panel.title", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        if (null == this.mainForm) {
            CosyBundle.updateBundle();
            this.mainForm = new ConfigMainForm();
        }
        return this.mainForm.getMainPanel();
    }

    public boolean isModified() {
        GlobalEndpointConfig endpointConfig;
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.mainForm.getMainPanel());
        GlobalConfig globalConfig = CosyConfigurable.getGlobalConfig(project);
        if (globalConfig == null) {
            return !this.mainForm.getProxyMode().getType().equals(ProxyModeEnum.SYSTEM.getType()) || !this.mainForm.getCommandAllowList().isEmpty() || !this.mainForm.getCommandDenyList().isEmpty() || !this.mainForm.getMcpAutoRun().getType().equals(McpAutoRunEnum.DISABLE.getType()) || !this.mainForm.getEnableChatModeUseTool() || !this.mainForm.getChatLanguage().equals(CosyConfig.isQoderEnabled() ? ResponseLanguageEnum.EN.getName() : ResponseLanguageEnum.ZH.getName());
        }
        if (!this.mainForm.getProxyMode().getType().equals(globalConfig.getProxyMode())) {
            return true;
        }
        if (this.mainForm.getProxyMode().getType().equals(ProxyModeEnum.MANUAL.getType()) && !this.mainForm.getProxyUrl().trim().equals(globalConfig.getHttpProxy())) {
            return true;
        }
        if (this.mainForm.getTerminalRunMode().getId().equals(globalConfig.getTerminalRunMode())) {
            if (ToolAutoRunEnum.ASK_EVERYTIME.getId().equals(globalConfig.getTerminalRunMode()) && !this.mainForm.getCommandAllowList().equals(globalConfig.getCommandAllowList())) {
                return true;
            }
            if (ToolAutoRunEnum.ENABLE_AUTO_RUN.getId().equals(globalConfig.getTerminalRunMode()) && !this.mainForm.getCommandDenyList().equals(globalConfig.getCommandDenyList())) {
                return true;
            }
        } else {
            return true;
        }
        if (this.mainForm.isWebToolSettingModified(globalConfig.getWebToolsExecutionMode())) {
            return true;
        }
        if (!String.valueOf(this.mainForm.getEnableChatModeUseTool()).equals(globalConfig.getAskModeUseTools())) {
            return true;
        }
        if (!this.mainForm.getChatLanguage().equals(ResponseLanguageEnum.getName(globalConfig.getPreferredLanguage()))) {
            return true;
        }
        if (LoginModeEnum.DEDICATED.getLabel().equals(this.mainForm.getLoginMode()) && ((endpointConfig = this.mainForm.getEndpointConfig(project)) == null ? StringUtils.isNotBlank((CharSequence)this.mainForm.getDedicatedUrlField(false)) : LoginModeEnum.DEDICATED.getLabel().equalsIgnoreCase(this.mainForm.getLoginMode()) && !this.mainForm.getDedicatedUrlField(false).equals(endpointConfig.getEndpoint()))) {
            return true;
        }
        if (globalConfig.getMcpAutoRun() != null && !this.mainForm.getMcpAutoRun().getType().equals(globalConfig.getMcpAutoRun())) {
            return true;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            ChangeUserSettingParams params = setting.getParameter();
            boolean isDocumentOpenModeChange = setting.getDefaultDocumentOpenMode() != this.mainForm.getDocumentOpenMode();
            boolean cloudCompletionSwitchChange = params.getCloud().getEnable() == null || params.getCloud().getEnable().booleanValue() != this.mainForm.getCloudCodeCompletionSwitch();
            boolean cloudCompletionAutoSwitchChange = params.getCloud().getAutoTrigger().getEnable() == null || params.getCloud().getAutoTrigger().getEnable().booleanValue() != this.mainForm.getEnableCloudAutoTrigger();
            boolean cloudCompletionAutoModelLevel = !params.getCloud().getAutoTrigger().getModelLevel().equals(this.mainForm.getCloudAutoModelPower().getLabel());
            boolean cloudCompletionAutoGenLength = !params.getCloud().getAutoTrigger().getGenerateLength().equals(this.mainForm.getCloudAutoGenLengthLevel().getLabel());
            boolean cloudCompletionManualModelLevel = !params.getCloud().getManualTrigger().getModelLevel().equals(this.mainForm.getCloudManualModelPower().getLabel());
            boolean cloudCompletionManualGenLength = !params.getCloud().getManualTrigger().getGenerateLength().equals(this.mainForm.getCloudManualGenLength().getLabel());
            boolean exceptionResolveMode = !setting.getExceptionResolveV2ModeEnum().getType().equals(this.mainForm.getExceptionResolveMode().getType());
            boolean methodQuickSwitch = !setting.getMethodQuickSwitchEnum().getType().equals(this.mainForm.getMethodQuickSwitchEnum().getType());
            boolean upgradeCheck = !setting.getUpgradeStrategy().equals(this.mainForm.getUpgradeCheckValue());
            boolean loginMode = !setting.getLoginMode().equals(this.mainForm.getLoginMode());
            boolean showInlineSuggestions = params.getCloud().isShowInlineWhenIDECompletion() != this.mainForm.getShowInlineSuggestions().booleanValue();
            boolean langConfigChanged = !StringUtils.join((Object[])new List[]{this.mainForm.getDisableLanguages()}).equals(StringUtils.join((Object[])new List[]{params.getCloud().getDisableLanguages()}));
            boolean localStoragePathChanged = this.localStoragePathChanged(setting, this.mainForm.getLocalStoragePath(false));
            boolean dedicatedUrlChanged = this.dedicatedDomainUrlChanged(setting, this.mainForm.getDedicatedUrlField(false));
            boolean displayLanguageChanged = !setting.getDisplayLanguage().equals(this.mainForm.getDisplayLanguage());
            boolean transportTypeChanged = !setting.getTransportType().equals(this.mainForm.getTransportTypeEnum().getTransportType());
            boolean nesEnableChanged = setting.getNesConfig().getEnabled().booleanValue() != this.mainForm.getEnableNESNextEdit();
            boolean nesSuggestModeChanged = !Objects.equals(setting.getNesConfig().getSuggestMode(), this.mainForm.getNesSuggestModel());
            boolean nesCodeShiftChanged = setting.getNesConfig().getCodeShiftEnabled().booleanValue() != this.mainForm.getEnableNESCodeShift();
            return isDocumentOpenModeChange || cloudCompletionSwitchChange || cloudCompletionAutoSwitchChange || cloudCompletionAutoModelLevel || cloudCompletionAutoGenLength || cloudCompletionManualModelLevel || cloudCompletionManualGenLength || exceptionResolveMode || methodQuickSwitch || upgradeCheck || showInlineSuggestions || loginMode || langConfigChanged || localStoragePathChanged || dedicatedUrlChanged || displayLanguageChanged || transportTypeChanged || nesEnableChanged || nesSuggestModeChanged || nesCodeShiftChanged;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        boolean killProcess = false;
        boolean localStorageChanged = false;
        final Project project = ProjectUtil.guessCurrentProject((JComponent)this.mainForm.getMainPanel());
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            String transportType;
            String dedicatedDomainUrl;
            ChangeUserSettingParams params;
            if (setting.getParameter() == null) {
                setting.setParameter(CosySetting.DEFAULT_PARAMS);
            }
            boolean showInlineChanged = (params = setting.getParameter()).getCloud().isShowInlineWhenIDECompletion() != this.mainForm.getShowInlineSuggestions().booleanValue();
            boolean approve = true;
            params.setAllowReportUsage(approve);
            setting.setAllowReportUsage(approve);
            setting.setLoginMode(this.mainForm.getLoginMode());
            setting.setDefaultDocumentOpenMode(this.mainForm.getDocumentOpenMode());
            params.getCloud().setEnable(this.mainForm.getCloudCodeCompletionSwitch());
            params.getCloud().getAutoTrigger().setEnable(this.mainForm.getEnableCloudAutoTrigger());
            params.getCloud().getAutoTrigger().setModelLevel(this.mainForm.getCloudAutoModelPower().getLabel());
            params.getCloud().getAutoTrigger().setGenerateLength(this.mainForm.getCloudAutoGenLengthLevel().getLabel());
            params.getCloud().getManualTrigger().setModelLevel(this.mainForm.getCloudManualModelPower().getLabel());
            params.getCloud().getManualTrigger().setGenerateLength(this.mainForm.getCloudManualGenLength().getLabel());
            params.getCloud().setShowInlineWhenIDECompletion(this.mainForm.getShowInlineSuggestions());
            params.getCloud().setDisableLanguages(this.mainForm.getDisableLanguages());
            setting.setExceptionResolveV2ModeEnum(this.mainForm.getExceptionResolveMode());
            setting.setMethodQuickSwitchEnum(this.mainForm.getMethodQuickSwitchEnum());
            setting.setUpgradeStrategy(this.mainForm.getUpgradeCheckValue());
            if (!setting.getDisplayLanguage().equals(this.mainForm.getDisplayLanguage())) {
                setting.setDisplayLanguage(this.mainForm.getDisplayLanguage());
                CosyBundle.updateBundle();
                I18NConstant.loadI18NConstants();
                ((LanguageChangedNotifier)project.getMessageBus().syncPublisher(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER)).updateUiLanguage();
            }
            if (LoginModeEnum.DEDICATED.getLabel().equals(this.mainForm.getLoginMode())) {
                dedicatedDomainUrl = this.mainForm.getDedicatedUrlField(true);
            } else {
                dedicatedDomainUrl = "";
                this.mainForm.setDedicatedUrlField("");
            }
            setting.setDedicatedDomainUrl(dedicatedDomainUrl);
            this.mainForm.updateLingmaEndpointConfig(project);
            this.mainForm.updateLingmaGlobalConfig(project);
            ThreadUtil.execute(() -> {
                if (showInlineChanged) {
                    TelemetryService.getInstance().telemetry(project, TrackEventTypeEnum.SHOW_INLINE_SUGGESTIONS, "", Map.of("switch", this.mainForm.getShowInlineSuggestions().toString()));
                }
            });
            Cosy.INSTANCE.updateConfig(params);
            String localStoragePath = this.mainForm.getLocalStoragePath(true);
            if (StringUtils.isNotBlank((CharSequence)localStoragePath)) {
                localStorageChanged = this.localStoragePathChanged(setting, localStoragePath);
                if (localStorageChanged) {
                    killProcess = true;
                }
                setting.setLocalStoragePath(localStoragePath);
            }
            if (this.transportTypeChanged(setting, transportType = this.mainForm.getTransportTypeEnum().getTransportType())) {
                killProcess = true;
                setting.setTransportType(transportType);
            }
            setting.getNesConfig().setEnabled(this.mainForm.getEnableNESNextEdit());
            setting.getNesConfig().setSuggestMode(this.mainForm.getNesSuggestModel());
            setting.getNesConfig().setCodeShiftEnabled(this.mainForm.getEnableNESCodeShift());
            final boolean finalLocalStorageChanged = localStorageChanged;
            final ConfigMainForm finalMainForm = this.mainForm;
            if (killProcess) {
                ProgressManager.getInstance().run((Task)new Task.Modal(project, CosyBundle.message("task.progress.apply.setting", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator progressIndicator) {
                        if (progressIndicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        progressIndicator.setText(CosyBundle.message("task.progress.getauth.startup.state", new Object[0]));
                        ThreadUtil.sleep(2000L);
                        ApplicationUtil.killCosyProcess();
                        Cosy.INSTANCE.close(project);
                        boolean succeed = ProcessUtils.checkAndWaitCosyState(progressIndicator, project);
                        if (finalLocalStorageChanged) {
                            if (succeed) {
                                log.info("Update endpoint and proxy config after local storage path changed.");
                                finalMainForm.updateLingmaEndpointConfig(project);
                                finalMainForm.updateLingmaGlobalConfig(project);
                            } else {
                                log.warn("Update endpoint and proxy config error because the lingma agent failed to start.");
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/alibabacloud/intellij/cosy/ui/config/CosyConfigurable$1", "run"));
                    }
                });
            }
            CosyStatusBarWidget.updateStatusBar(null, project);
        }
    }

    private boolean localStoragePathChanged(CosySetting setting, String localStoragePath) {
        boolean localStoragePathChanged = false;
        if (!StringUtils.isBlank((CharSequence)setting.getLocalStoragePath()) || !StringUtils.isBlank((CharSequence)localStoragePath)) {
            localStoragePathChanged = !localStoragePath.equals(setting.getLocalStoragePath());
        }
        return localStoragePathChanged;
    }

    private boolean transportTypeChanged(CosySetting setting, String transportType) {
        boolean changed = false;
        if (!StringUtils.isBlank((CharSequence)setting.getTransportType()) || !StringUtils.isBlank((CharSequence)transportType)) {
            changed = !transportType.equals(setting.getTransportType());
        }
        return changed;
    }

    public void reset() {
        GlobalEndpointConfig endpointConfig;
        Project project;
        GlobalConfig globalConfig;
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            ChangeUserSettingParams params = setting.getParameter();
            this.mainForm.setLoginMode(setting.getLoginMode());
            this.mainForm.setDocumentOpenMode(setting.getDefaultDocumentOpenMode());
            this.mainForm.setCloudCodeCompletionSwitch(params.getCloud().getEnable());
            this.mainForm.setCloudAutoModelPower(params.getCloud().getAutoTrigger().getModelLevel());
            this.mainForm.setCloudAutoGenLengthLevel(params.getCloud().getAutoTrigger().getGenerateLength());
            this.mainForm.setEnableCloudAutoTrigger(params.getCloud().getAutoTrigger().getEnable(), params.getCloud().getAutoTrigger().getGenerateLength());
            this.mainForm.setCloudManualModelPower(params.getCloud().getManualTrigger().getModelLevel());
            this.mainForm.setCloudManualGenLength(params.getCloud().getManualTrigger().getGenerateLength());
            this.mainForm.setExceptionResolveMode(setting.getExceptionResolveV2ModeEnum());
            this.mainForm.setMethodQuickSwitch(setting.getMethodQuickSwitchEnum());
            this.mainForm.setUpgradeCheckValue(setting.getUpgradeStrategy());
            this.mainForm.setShowInlineSuggestions(params.getCloud().isShowInlineWhenIDECompletion());
            this.mainForm.setDisableLanguages(params.getCloud().getDisableLanguages());
            this.mainForm.setLocalStoragePath(CosyConfig.getHomeDirectory().toFile().getAbsolutePath());
            this.mainForm.setDisplayLanguage(setting.getDisplayLanguage());
            this.mainForm.setTransportTypeEnum(setting.getTransportType());
            this.mainForm.setEnableNES(setting.getNesConfig().getEnabled());
            this.mainForm.setNesSuggestModel(setting.getNesConfig().getSuggestMode());
            this.mainForm.setEnableNESCodeShift(setting.getNesConfig().getCodeShiftEnabled());
        }
        if ((globalConfig = CosyConfigurable.getGlobalConfigDirectly(project = ProjectUtil.guessCurrentProject((JComponent)this.mainForm.getMainPanel()))) != null) {
            this.mainForm.setProxyMode(globalConfig.getProxyMode());
            this.mainForm.setProxyUrl(globalConfig.getHttpProxy());
            this.mainForm.setTerminalRunMode(ToolAutoRunEnum.getById(globalConfig.getTerminalRunMode()), globalConfig);
            this.mainForm.setMcpAutoRun(globalConfig.getMcpAutoRun());
            this.mainForm.setWebToolsSetting(globalConfig.getWebToolsExecutionMode());
            this.mainForm.setEnableChatModeUseTool(Boolean.parseBoolean(globalConfig.getAskModeUseTools()));
            this.mainForm.setChatLanguage(ResponseLanguageEnum.getName(globalConfig.getPreferredLanguage()));
        }
        if ((endpointConfig = LingmaAgentUtil.getGlobalEndpointConfigDirectly(project)) != null) {
            this.mainForm.setDedicatedUrlField(endpointConfig.getEndpoint() == null ? "" : endpointConfig.getEndpoint());
        }
    }

    public static GlobalConfig getGlobalConfig(Project project) {
        GlobalConfig globalConfig = (GlobalConfig)CosyCacheKeys.KEY_GLOBAL_CONFIG.get((UserDataHolder)project);
        if (globalConfig == null) {
            if (!Cosy.INSTANCE.checkCosy(project)) {
                return null;
            }
            globalConfig = Cosy.INSTANCE.getLanguageService(project).getGlobalConfig(2000L);
            if (globalConfig != null) {
                CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
            }
        }
        return globalConfig;
    }

    public static GlobalConfig getGlobalConfigDirectly(Project project) {
        if (Cosy.INSTANCE.checkCosy(project)) {
            GlobalConfig globalConfig = Cosy.INSTANCE.getLanguageService(project).getGlobalConfig(2000L);
            if (globalConfig == null) {
                globalConfig = (GlobalConfig)CosyCacheKeys.KEY_GLOBAL_CONFIG.get((UserDataHolder)project);
            } else {
                CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
            }
            return globalConfig;
        }
        return (GlobalConfig)CosyCacheKeys.KEY_GLOBAL_CONFIG.get((UserDataHolder)project);
    }

    private boolean dedicatedDomainUrlChanged(CosySetting setting, String dedicatedDomainUrl) {
        boolean dedicatedUrlChanged = false;
        if (!StringUtils.isBlank((CharSequence)setting.getDedicatedDomainUrl()) || !StringUtils.isBlank((CharSequence)dedicatedDomainUrl)) {
            dedicatedUrlChanged = !dedicatedDomainUrl.equals(setting.getDedicatedDomainUrl());
        }
        return dedicatedUrlChanged;
    }

    @NotNull
    public JComponent createComponent(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            CosyConfigurable.$$$reportNull$$$0(1);
        }
        if (null == this.mainForm) {
            CosyBundle.updateBundle();
            this.mainForm = new ConfigMainForm();
        }
        JPanel jPanel = this.mainForm.getMainPanel();
        if (jPanel == null) {
            CosyConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.mainForm != null) {
            Disposer.dispose((Disposable)this.mainForm);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/config/CosyConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/config/CosyConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

