/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.config;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.chat.enums.ResponseLanguageEnum;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.common.LingmaNesConfig;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.CosyStartupAdapter;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ToolAutoRunEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.UpdateConfigResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.search.enums.CompletionGenerateLengthLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.ExceptionResolveModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.McpAutoRunEnum;
import com.alibabacloud.intellij.cosy.search.enums.MethodQuickSwitchEnum;
import com.alibabacloud.intellij.cosy.search.enums.ModelPowerLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.ProxyModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.UpgradeChecklEnum;
import com.alibabacloud.intellij.cosy.search.enums.WebToolsExecutionModeEnum;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.ConfigAccessKeyUI;
import com.alibabacloud.intellij.cosy.ui.config.ConfigAccessTokenUI;
import com.alibabacloud.intellij.cosy.ui.config.ConfigDedicatedAccessTokenUI;
import com.alibabacloud.intellij.cosy.ui.config.ConfigIntlAccessKeyUI;
import com.alibabacloud.intellij.cosy.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.enums.TransportTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.IDEUtil;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.alibabacloud.intellij.cosy.util.LingmaAgentUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import icons.LingmaIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigMainForm
implements Disposable {
    private static final int MAX_ORG_NAME_DISPLAY_LENGTH = 24;
    private JPanel mainPanel;
    private JButton btnLogin;
    private JButton btnLogout;
    private JLabel labelLoginState;
    private JCheckBox cloudModelCheckBox;
    private JComboBox<KeyValue> autoTriggerLengthComboBox;
    private JComboBox<KeyValue> manualTriggerLengthComboBox;
    private JPanel cloudModelPanel;
    private JLabel cloudManualShortcutLabel;
    private JLabel loginWarnLabel;
    private JPanel exceptionPanel;
    private JPanel methodQuickPanel;
    private JPanel auxiliaryPanel;
    private TitledSeparator auxiliaryTitleSeparator;
    private JCheckBox autoUpdateCheckBox;
    private JTextField proxyUrlTextField;
    private JRadioButton systemProxyConfigurationRadioButton;
    private JRadioButton manualProxyConfigurationRadioButton;
    private JPanel manualProxyUrlPanel;
    private JRadioButton loggedInByAccountRadioButton;
    private JRadioButton loggedInByAKRadioButton;
    private JTextField akTextField;
    private JPasswordField skTextField;
    private JButton akLogInButton;
    private JPanel akConfigPanel;
    private JPanel loginModeConfigPanel;
    private JLabel getAkLabel;
    private JCheckBox showInlineCheckBox;
    private JComboBox<Object> orgIdComboBox;
    private JTextField langTriggerTextField;
    private JRadioButton logInByAccessTokenRadioButton;
    private JPanel tokenConfigPanel;
    private JTextField accessTokenTextField;
    private JComboBox<Object> orgIdTokenComboBox;
    private JButton tokenLogInButton;
    private JPanel tokenConfigHeaderPanel;
    private JPanel akConfigHeaderPanel;
    private JPanel privacyPanel;
    private TitledSeparator privacyTitleLabel;
    private TextFieldWithBrowseButton localStoragePathField;
    private JRadioButton aliyunAccountRadioButton;
    private JRadioButton dedicatedDomainRadioButton;
    private JBTextField dedicatedUrlField;
    private JPanel accountPanel;
    private JPanel dedicatedPanel;
    private JPanel dedicatedConfigPanel;
    private JLabel aliyunAccountRadioLabel;
    private JCheckBox exceptionSolvingAssistantCheckBox;
    private JCheckBox inlineCommandsAboveMethodCheckBox;
    private JRadioButton displayChineseRadioButton;
    private JRadioButton displayEnglishRadioButton;
    private JLabel getAccessTokenLabel;
    private JPanel dedicatedTokenConfigPanel;
    private JTextField dedicatedAccessTokenTextField;
    private JComboBox<Object> dedicatedOrgIdTokenComboBox;
    private JButton dedicatedLoginByTokenBtn;
    private JRadioButton dedicatedLoginByAccountRadioBtn;
    private JButton dedicatedLoginByAccountBtn;
    private JPanel dedicatedAccountConfigHeaderPanel;
    private JPanel dedicatedTokenConfigHeaderPanel;
    private JRadioButton dedicatedLoginByTokenRadioBtn;
    private JLabel dedicatedGetAccessTokenLabel;
    private JLabel commandAllowTipsLabel;
    private JTextField commandAllowTextField;
    private ConfigAccessKeyUI configAccessKeyUI;
    private ConfigIntlAccessKeyUI configIntlAccessKeyUI;
    private JRadioButton aliyunIntlAccountRadioButton;
    private JLabel aliyunIntlAccountRadioLabel;
    private JRadioButton loggedInByIntlAccountRadioButton;
    private JRadioButton loggedInByIntlAKRadioButton;
    private JLabel getIntlAkLabel;
    private JButton akIntlLogInButton;
    private JButton btnIntlLogin;
    private JPanel accountIntlPanel;
    private JPanel loginIntlModeConfigPanel;
    private JPanel akIntlConfigHeaderPanel;
    private JPanel akIntlConfigPanel;
    private JTextField akIntlTextField;
    private JPasswordField skIntlTextField;
    private JComboBox<Object> orgIntlIdComboBox;
    private JPanel akSkDetailPanel;
    private JCheckBox enableNESNextEditCheckBox;
    private JRadioButton nesSuggestModelInlineRadioButton;
    private JRadioButton nesSuggestModelSideBySideRadioButton;
    private JRadioButton nesCodeShiftYesRadioButton;
    private JRadioButton nesCodeShiftNoRadioButton;
    private JPanel nesConfigPanel;
    private JPanel nesCodeShiftConfigPanel;
    private JRadioButton nesSuggestModelAutoRadioButton;
    private JPanel mcpAutoRunPanel;
    private JPanel webToolsSettingPanel;
    private JPanel toolUsagePanel;
    private JCheckBox toolUsageCheckBox;
    private JPanel toolUsageTipPanel;
    private JLabel toolUsageTipLabel;
    private JRadioButton websocketRadioButton;
    private JRadioButton stdioRadioButton;
    private JRadioButton webToolAskEveryTimeRadioBtn;
    private JRadioButton webToolAutoExecuteRadioBtn;
    private JRadioButton webToolDisabledRadioBtn;
    private JRadioButton mcpAskEveryTimeRadioBtn;
    private JRadioButton mcpAutoExecuteRadioBtn;
    private JPanel terminalPanel;
    private JRadioButton terminalAskEveryTimeRadioBtn;
    private JRadioButton terminalAutoRunRadioBtn;
    private JTextField commandDenyTextField;
    private JButton btnTotalLogin;
    private JComboBox<String> responseLanguageComboBox;
    private ConfigAccessTokenUI configAccessTokenUI;
    private ConfigDedicatedAccessTokenUI configDedicatedAccessTokenUI;
    private MessageBusConnection messageBusConnection;
    private static final String systemDefaultLang = Locale.getDefault().getLanguage();
    private static final Logger log = Logger.getInstance(ConfigMainForm.class);

    public ConfigMainForm() {
        this.$$$setupUI$$$();
        ArrayList<KeyValue> autoGenLengthList = new ArrayList<KeyValue>();
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel(), CosyBundle.message("settings.completion.generate.length.line", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel(), CosyBundle.message("settings.completion.generate.length.level1", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_2.getLabel(), CosyBundle.message("settings.completion.generate.length.level2", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_3.getLabel(), CosyBundle.message("settings.completion.generate.length.level3", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.NO.getLabel(), CosyBundle.message("settings.completion.generate.length.disabled", new Object[0])));
        ArrayList<KeyValue> manualGenLengthList = new ArrayList<KeyValue>();
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel(), CosyBundle.message("settings.completion.generate.length.line", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel(), CosyBundle.message("settings.completion.generate.length.level1", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_2.getLabel(), CosyBundle.message("settings.completion.generate.length.level2", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_3.getLabel(), CosyBundle.message("settings.completion.generate.length.level3", new Object[0])));
        this.autoTriggerLengthComboBox.setModel(new DefaultComboBoxModel<KeyValue>(autoGenLengthList.toArray(new KeyValue[0])));
        this.manualTriggerLengthComboBox.setModel(new DefaultComboBoxModel<KeyValue>(manualGenLengthList.toArray(new KeyValue[0])));
        this.configCombox(this.autoTriggerLengthComboBox);
        this.configCombox(this.manualTriggerLengthComboBox);
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.getMainPanel());
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.initLoginPanel(project);
        this.cloudModelCheckBox.addChangeListener(e -> {
            if (this.cloudModelCheckBox.isSelected()) {
                this.cloudModelPanel.setVisible(true);
                this.cloudModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
            } else {
                this.cloudModelPanel.setVisible(false);
                this.cloudModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
            }
        });
        String triggerShortcut = KeyboardUtil.getShortcutText("TriggerInlayCompletionAction");
        this.cloudManualShortcutLabel.setText(String.format(CosyBundle.message("settings.cloud.manual.shortcut.text", new Object[0]), triggerShortcut));
        this.cloudManualShortcutLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        if (IDEUtil.IDE_ONLY_WITH_METHOD_QUICK_PANEL.stream().anyMatch(ide -> CosyConfig.IDE_NAME.toLowerCase(Locale.ROOT).contains((CharSequence)ide))) {
            this.exceptionPanel.setVisible(false);
        } else if (!CosyConfig.IDE_NAME.toLowerCase(Locale.ROOT).contains("idea")) {
            this.auxiliaryPanel.setVisible(false);
            this.auxiliaryTitleSeparator.setVisible(false);
        }
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.privacyPanel.setVisible(false);
            this.privacyTitleLabel.setVisible(false);
            this.exceptionPanel.setVisible(false);
        }
        this.initGlobalConfigPanel(project);
        this.initLanguageSettings();
        this.initNesConfig();
        this.initMethodQuickPanel();
        this.initChannelType();
    }

    private void initChannelType() {
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        if (settings != null) {
            this.setTransportTypeEnum(settings.getTransportType());
        } else {
            this.setTransportTypeEnum(TransportTypeEnum.WEBSOCKET.getTransportType());
        }
    }

    private void initMethodQuickPanel() {
        if (CosyConfig.isQoderEnabled()) {
            this.methodQuickPanel.setVisible(false);
            CosySetting setting = CosyPersistentSetting.getInstance().getState();
            if (null != setting) {
                setting.setMethodQuickSwitchEnum(MethodQuickSwitchEnum.DISABLED);
            }
        }
    }

    private void initLanguageSettings() {
        this.initDisplayLanguage();
    }

    private void initNesConfig() {
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        boolean nesEnabled = settings != null && settings.getNesConfig().getEnabled() != false;
        this.setEnableNES(nesEnabled);
        String nesSuggestModel = settings == null ? LingmaNesConfig.SuggestMode.INLINE.name() : settings.getNesConfig().getSuggestMode();
        this.setNesSuggestModel(nesSuggestModel);
        this.enableNESNextEditCheckBox.addChangeListener(e -> this.setEnableNES(this.enableNESNextEditCheckBox.isSelected()));
        this.nesSuggestModelInlineRadioButton.addChangeListener(this::changeNesSuggestModel);
        this.nesSuggestModelSideBySideRadioButton.addChangeListener(this::changeNesSuggestModel);
        this.nesSuggestModelAutoRadioButton.addChangeListener(this::changeNesSuggestModel);
    }

    private void changeNesSuggestModel(ChangeEvent e) {
        if (this.nesSuggestModelInlineRadioButton.isSelected()) {
            this.setNesSuggestModel(LingmaNesConfig.SuggestMode.INLINE.name());
        } else if (this.nesSuggestModelSideBySideRadioButton.isSelected()) {
            this.setNesSuggestModel(LingmaNesConfig.SuggestMode.SIDE_BY_SIDE.name());
        } else if (this.nesSuggestModelAutoRadioButton.isSelected()) {
            this.setNesSuggestModel(LingmaNesConfig.SuggestMode.AUTO.name());
        }
    }

    public void initDisplayLanguage() {
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        if (settings != null) {
            this.setDisplayLanguage(settings.getDisplayLanguage());
        } else {
            this.setDisplayLanguage(Locale.getDefault().getLanguage());
        }
    }

    private void initGlobalConfigPanel(final Project project) {
        this.systemProxyConfigurationRadioButton.addActionListener(e -> this.manualProxyUrlPanel.setVisible(false));
        this.manualProxyConfigurationRadioButton.addActionListener(e -> this.manualProxyUrlPanel.setVisible(true));
        this.terminalAskEveryTimeRadioBtn.addActionListener(e -> this.setTerminalRunMode(project, ToolAutoRunEnum.ASK_EVERYTIME));
        this.terminalAutoRunRadioBtn.addActionListener(e -> this.setTerminalRunMode(project, ToolAutoRunEnum.ENABLE_AUTO_RUN));
        CosyStartupAdapter startupListener = new CosyStartupAdapter(){

            @Override
            public void onStartup() {
                log.debug("start to get global config");
                if (Cosy.INSTANCE.getLanguageService(project) != null) {
                    GlobalConfig globalConfig = Cosy.INSTANCE.getLanguageService(project).getGlobalConfig(2000L);
                    if (globalConfig != null) {
                        CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
                        SwingUtilities.invokeLater(() -> {
                            log.debug("get global config:" + globalConfig);
                            ConfigMainForm.this.setProxyMode(globalConfig.getProxyMode());
                            ConfigMainForm.this.setProxyUrl(globalConfig.getHttpProxy());
                            ConfigMainForm.this.setTerminalRunMode(ToolAutoRunEnum.getById(globalConfig.getTerminalRunMode()), globalConfig);
                            ConfigMainForm.this.setCommandAllowList(ConfigMainForm.this.commandDenyTextField, globalConfig.getCommandDenyList());
                            ConfigMainForm.this.setCommandAllowList(ConfigMainForm.this.commandAllowTextField, globalConfig.getCommandAllowList());
                            ConfigMainForm.this.setMcpAutoRun(globalConfig.getMcpAutoRun());
                            ConfigMainForm.this.setWebToolsSetting(globalConfig.getWebToolsExecutionMode());
                            ConfigMainForm.this.setUsageToolSetting(globalConfig.getAskModeUseTools());
                            ConfigMainForm.this.setChatLanguage(ResponseLanguageEnum.getName(globalConfig.getPreferredLanguage()));
                        });
                    } else {
                        ConfigMainForm.this.setUsageToolSetting(Boolean.TRUE.toString());
                    }
                    GlobalEndpointConfig endpointConfig = Cosy.INSTANCE.getLanguageService(project).getEndpointConfig(2000L);
                    if (endpointConfig != null) {
                        CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)endpointConfig);
                        SwingUtilities.invokeLater(() -> {
                            log.debug("get endpoint config:" + endpointConfig);
                            ConfigMainForm.this.setEndpoint(endpointConfig.getEndpoint());
                        });
                    } else {
                        LingmaAgentUtil.addDefaultEndpointToCache(project);
                    }
                }
            }
        };
        if (Cosy.INSTANCE.checkCosy(project, true, List.of(startupListener))) {
            log.debug("get global config directly");
            startupListener.onStartup();
        } else {
            GlobalConfig globalConfig = (GlobalConfig)CosyCacheKeys.KEY_GLOBAL_CONFIG.get((UserDataHolder)project);
            if (globalConfig != null) {
                log.debug("get global config from cache:" + globalConfig);
                this.setProxyMode(globalConfig.getProxyMode());
                this.setProxyUrl(globalConfig.getHttpProxy());
                this.setTerminalRunMode(ToolAutoRunEnum.getById(globalConfig.getTerminalRunMode()), globalConfig);
                this.setMcpAutoRun(globalConfig.getMcpAutoRun());
                this.setWebToolsSetting(globalConfig.getWebToolsExecutionMode());
                this.setUsageToolSetting(globalConfig.getAskModeUseTools());
                this.setChatLanguage(ResponseLanguageEnum.getName(globalConfig.getPreferredLanguage()));
            }
        }
    }

    private void setUsageToolSetting(String askModeUseTools) {
        this.toolUsageCheckBox.setSelected(StringUtils.isEmpty((CharSequence)askModeUseTools) || Boolean.TRUE.toString().equals(askModeUseTools));
    }

    private void configCombox(JComboBox<KeyValue> comboBox) {
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                KeyValue pair = (KeyValue)value;
                this.setText(pair.getLabel());
                return com;
            }
        });
    }

    private void initModelSlider(JSlider modeLevel, JSlider lengthLevel, boolean isManual) {
        modeLevel.addChangeListener(e -> {
            if (modeLevel.getValue() == ModelPowerLevelEnum.SMALL.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
            } else if (modeLevel.getValue() == ModelPowerLevelEnum.MIDDLE.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                if (isManual) {
                    lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_2.getLevel());
                } else {
                    lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_1.getLevel());
                }
                lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
            } else if (modeLevel.getValue() == ModelPowerLevelEnum.LARGE.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_3.getLevel());
                if (isManual) {
                    lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLevel());
                } else {
                    lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                }
            }
        });
    }

    private void notifyLoginAuth(AuthStatus status) {
        log.info("get login auth object:" + status);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            Object orgName;
            Object loginInfo;
            this.accountPanel.setVisible(false);
            this.accountIntlPanel.setVisible(false);
            this.dedicatedDomainRadioButton.setVisible(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.btnLogin.setVisible(false);
            this.btnIntlLogin.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.akIntlLogInButton.setVisible(false);
            this.btnLogout.setVisible(true);
            this.cloudModelCheckBox.setEnabled(true);
            this.cloudModelPanel.setVisible(true);
            this.loginWarnLabel.setVisible(false);
            this.labelLoginState.setForeground(CosyColor.GREEN_TEXT_COLOR);
            String whiteListText = LoginUtil.getWhitelistText(status);
            if (CosyConfig.isQoderEnabled()) {
                loginInfo = status.getName() + " (" + status.getEmail() + ") ";
                LanguageWebSocketService service = Cosy.INSTANCE.getLanguageService(ProjectUtils.getActiveProject());
                if (null != service) {
                    loginInfo = (String)loginInfo + service.queryUserPlan().getPlanTierName();
                }
            } else {
                loginInfo = String.format(CosyBundle.message("settings.login.account.tips.logged", new Object[0]), status.getName(), status.getId(), whiteListText);
            }
            if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                loginInfo = String.format(CosyBundle.message("settings.login.account.tips.logged.vpc", new Object[0]), status.getName(), whiteListText);
            }
            if (StringUtils.isNotBlank((CharSequence)(orgName = status.getOrgName()))) {
                if (((String)orgName).length() > 24) {
                    orgName = ((String)orgName).substring(0, 24) + "...";
                }
                loginInfo = (String)loginInfo + String.format(CosyBundle.message("settings.login.account.tips.org.label", new Object[0]), orgName);
            }
            this.labelLoginState.setText((String)loginInfo);
            this.loginModeConfigPanel.setVisible(false);
            this.loginIntlModeConfigPanel.setVisible(false);
            this.tokenLogInButton.setVisible(false);
            this.btnTotalLogin.setVisible(false);
        } else {
            this.labelLoginState.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
            this.labelLoginState.setText(CosyBundle.messageVpc("settings.login.account.tips.not.logged", new Object[0]));
            if (CosyConfig.isQoderEnabled()) {
                this.btnTotalLogin.setVisible(true);
                this.btnTotalLogin.setEnabled(true);
            } else {
                this.accountPanel.setVisible(true);
                this.accountIntlPanel.setVisible(true);
                this.dedicatedDomainRadioButton.setVisible(true);
                this.aliyunAccountRadioButton.setVisible(true);
                this.aliyunIntlAccountRadioButton.setVisible(true);
                CosySetting settings = CosyPersistentSetting.getInstance().getState();
                if (settings != null && LoginModeEnum.DEDICATED.getLabel().equalsIgnoreCase(settings.getLoginMode())) {
                    this.akLogInButton.setVisible(false);
                    this.akIntlLogInButton.setVisible(false);
                    this.tokenLogInButton.setVisible(false);
                    this.btnLogin.setVisible(false);
                    this.btnIntlLogin.setVisible(false);
                    this.loginModeConfigPanel.setVisible(false);
                    this.loginIntlModeConfigPanel.setVisible(false);
                    this.dedicatedConfigPanel.setVisible(true);
                } else if (settings != null && LoginModeEnum.ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                    this.akLogInButton.setVisible(true);
                    this.tokenLogInButton.setVisible(false);
                    this.btnLogin.setVisible(false);
                    this.loginModeConfigPanel.setVisible(true);
                    this.loginIntlModeConfigPanel.setVisible(false);
                    this.dedicatedConfigPanel.setVisible(false);
                } else if (settings != null && LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(settings.getLoginMode())) {
                    this.tokenLogInButton.setVisible(true);
                    this.akLogInButton.setVisible(false);
                    this.btnLogin.setVisible(false);
                    this.loginModeConfigPanel.setVisible(true);
                    this.loginIntlModeConfigPanel.setVisible(false);
                    this.dedicatedConfigPanel.setVisible(false);
                } else if (settings != null && LoginModeEnum.INTL_ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                    this.akIntlLogInButton.setVisible(true);
                    this.btnLogin.setVisible(false);
                    this.loginModeConfigPanel.setVisible(false);
                    this.dedicatedConfigPanel.setVisible(false);
                    this.loginIntlModeConfigPanel.setVisible(true);
                    this.aliyunAccountRadioButton.setSelected(false);
                } else if (settings != null && LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel().equals(settings.getLoginMode())) {
                    this.akIntlLogInButton.setVisible(false);
                    this.btnIntlLogin.setVisible(true);
                    this.loginModeConfigPanel.setVisible(false);
                    this.dedicatedConfigPanel.setVisible(false);
                    this.loginIntlModeConfigPanel.setVisible(true);
                } else {
                    this.akLogInButton.setVisible(false);
                    this.tokenLogInButton.setVisible(false);
                    this.btnLogin.setVisible(true);
                    this.loginModeConfigPanel.setVisible(true);
                    this.dedicatedConfigPanel.setVisible(false);
                    this.loginIntlModeConfigPanel.setVisible(false);
                }
                this.btnLogout.setVisible(false);
                this.cloudModelCheckBox.setEnabled(false);
                this.cloudModelPanel.setVisible(false);
                this.loginWarnLabel.setVisible(true);
            }
        }
        this.btnLogin.setEnabled(true);
        this.btnIntlLogin.setEnabled(true);
        this.btnLogout.setEnabled(true);
        this.configAccessKeyUI.setLoginButtonState(this);
        this.configAccessTokenUI.setLoginButtonState(this);
        this.configDedicatedAccessTokenUI.setLoginButtonState(this);
        this.configIntlAccessKeyUI.setLoginButtonState(this);
    }

    private void notifyLogoutAuth(AuthStatus status) {
        log.info("get logout auth object:" + status);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status != null && (status.getStatus() == null || status.getStatus().intValue() == AuthStateEnum.NOT_LOGIN.getValue())) {
            this.labelLoginState.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
            this.labelLoginState.setText(CosyBundle.messageVpc("settings.login.account.tips.not.logged", new Object[0]));
            if (CosyConfig.isQoderEnabled()) {
                this.accountPanel.setVisible(false);
                this.dedicatedPanel.setVisible(false);
                this.accountIntlPanel.setVisible(false);
                this.btnLogout.setVisible(false);
                this.btnLogout.setEnabled(true);
                this.btnTotalLogin.setVisible(true);
                return;
            }
            CosySetting settings = CosyPersistentSetting.getInstance().getState();
            if (settings != null && LoginModeEnum.DEDICATED.getLabel().equals(settings.getLoginMode())) {
                this.akLogInButton.setVisible(false);
                this.akIntlLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.btnIntlLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(false);
                this.loginIntlModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(true);
                this.dedicatedUrlField.setVisible(this.dedicatedDomainRadioButton.isSelected());
            } else if (settings != null && LoginModeEnum.ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                this.akLogInButton.setVisible(true);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.loginIntlModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(false);
            } else if (settings != null && LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(settings.getLoginMode())) {
                this.tokenLogInButton.setVisible(true);
                this.akLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.loginIntlModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(false);
            } else if (settings != null && LoginModeEnum.ALIYUN_ACCOUNT.getLabel().equals(settings.getLoginMode())) {
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(true);
                this.loginModeConfigPanel.setVisible(true);
                this.loginIntlModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(false);
            } else if (settings != null && LoginModeEnum.INTL_ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                this.akIntlLogInButton.setVisible(true);
                this.btnIntlLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(false);
                this.loginIntlModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            } else {
                this.akIntlLogInButton.setVisible(false);
                this.btnIntlLogin.setVisible(true);
                this.loginModeConfigPanel.setVisible(false);
                this.loginIntlModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            }
            this.accountPanel.setVisible(true);
            this.accountIntlPanel.setVisible(true);
            this.dedicatedDomainRadioButton.setVisible(true);
            this.aliyunAccountRadioButton.setVisible(true);
            this.aliyunIntlAccountRadioButton.setVisible(true);
            this.btnLogout.setVisible(false);
            this.cloudModelCheckBox.setEnabled(false);
            this.cloudModelPanel.setVisible(false);
            this.loginWarnLabel.setVisible(true);
        } else {
            this.btnLogout.setVisible(true);
            this.cloudModelCheckBox.setEnabled(true);
            this.cloudModelPanel.setVisible(true);
            this.loginWarnLabel.setVisible(false);
            this.loginModeConfigPanel.setVisible(false);
            this.loginIntlModeConfigPanel.setVisible(false);
        }
        this.btnLogin.setEnabled(true);
        this.btnIntlLogin.setEnabled(true);
        this.btnLogout.setEnabled(true);
        this.configAccessKeyUI.setLoginButtonState(this);
        this.configAccessTokenUI.setLoginButtonState(this);
        this.configDedicatedAccessTokenUI.setLoginButtonState(this);
        this.configIntlAccessKeyUI.setLoginButtonState(this);
    }

    private void initLoginPanel(Project project) {
        this.configAccessKeyUI = new ConfigAccessKeyUI();
        this.configAccessTokenUI = new ConfigAccessTokenUI();
        this.configDedicatedAccessTokenUI = new ConfigDedicatedAccessTokenUI();
        this.configIntlAccessKeyUI = new ConfigIntlAccessKeyUI();
        this.accountPanel.setVisible(true);
        this.loginModeConfigPanel.setVisible(true);
        this.akConfigPanel.setVisible(false);
        this.accountIntlPanel.setVisible(true);
        this.loginIntlModeConfigPanel.setVisible(false);
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.dedicatedPanel.setVisible(false);
            this.aliyunAccountRadioButton.setText(CosyBundle.messageVpc("settings.login.account.panel.title.vpc", new Object[0]));
            this.aliyunAccountRadioLabel.setText("");
            this.btnTotalLogin.setVisible(false);
        } else if (CosyConfig.isQoderEnabled()) {
            this.accountPanel.setVisible(false);
            this.dedicatedPanel.setVisible(false);
            this.accountIntlPanel.setVisible(false);
            this.btnTotalLogin.setVisible(true);
        } else {
            this.dedicatedPanel.setVisible(true);
            this.dedicatedUrlField.setVisible(this.dedicatedDomainRadioButton.isSelected());
            this.btnTotalLogin.setVisible(false);
        }
        this.loggedInByAccountRadioButton.addActionListener(e -> {
            this.akConfigPanel.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.btnLogin.setVisible(true);
            this.btnLogin.setEnabled(true);
            this.loggedInByAccountRadioButton.setSelected(true);
            this.loggedInByAKRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
        });
        this.loggedInByIntlAccountRadioButton.addActionListener(e -> {
            this.akIntlConfigPanel.setVisible(false);
            this.btnIntlLogin.setVisible(true);
            this.btnIntlLogin.setEnabled(true);
            this.akIntlConfigHeaderPanel.setVisible(true);
            this.loggedInByIntlAKRadioButton.setSelected(false);
            this.loggedInByIntlAccountRadioButton.setSelected(true);
            this.aliyunAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.setLoginMode(LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel());
            this.updateLingmaEndpointConfig(project);
        });
        this.configAccessKeyUI.setup(project, this);
        this.configAccessTokenUI.setup(project, this);
        this.configDedicatedAccessTokenUI.setup(project, this);
        this.configIntlAccessKeyUI.setup(project, this);
        this.btnLogin.addActionListener(e -> this.doLogin(project));
        this.btnTotalLogin.addActionListener(e -> this.doLogin(project));
        this.btnIntlLogin.addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    this.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel());
                } else {
                    log.warn("Setting is null when token btnIntlLogin button entered.");
                }
                this.btnIntlLogin.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                UserAuthService.getInstance().login(project, this.labelLoginState, LoginParams.fromAliyunCloud());
            }
        });
        this.btnLogout.addActionListener(e -> {
            if (project != null) {
                this.btnLogout.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.out", new Object[0]));
                UserAuthService.getInstance().logout(project, this.btnLogout);
            }
        });
        this.btnLogin.setVisible(false);
        this.btnLogout.setVisible(false);
        this.cloudModelPanel.setVisible(false);
        this.loginWarnLabel.setForeground(ColorUtil.getInactiveForegroundColor());
        this.loginWarnLabel.setIcon(LingmaIcons.WarningIcon);
        this.loginWarnLabel.setText(CosyBundle.message("settings.cloud.login.require.tips", new Object[0]));
        this.loginWarnLabel.setVisible(true);
        this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.fetch.user", new Object[0]));
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.tokenConfigHeaderPanel.setVisible(true);
            this.akConfigHeaderPanel.setVisible(false);
        } else if (CosyConfig.isQoderEnabled()) {
            this.accountPanel.setVisible(false);
            this.dedicatedPanel.setVisible(false);
            this.accountIntlPanel.setVisible(false);
            this.btnTotalLogin.setVisible(true);
        } else {
            this.tokenConfigHeaderPanel.setVisible(true);
            this.akConfigHeaderPanel.setVisible(true);
        }
        if (!CosyConfig.isQoderEnabled()) {
            this.aliyunAccountRadioButton.setSelected(true);
            this.loggedInByAccountRadioButton.setSelected(true);
            this.loggedInByAKRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.aliyunIntlAccountRadioButton.setSelected(false);
            this.dedicatedLoginByAccountRadioBtn.setSelected(true);
            this.dedicatedLoginByAccountBtn.setVisible(StringUtils.isNotBlank((CharSequence)this.dedicatedUrlField.getText()));
        }
        this.aliyunIntlAccountRadioButton.addActionListener(e -> {
            this.accountIntlPanel.setVisible(true);
            this.loginIntlModeConfigPanel.setVisible(true);
            this.aliyunIntlAccountRadioButton.setSelected(true);
            this.akIntlConfigPanel.setVisible(false);
            this.loginModeConfigPanel.setVisible(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.aliyunAccountRadioButton.setSelected(false);
            this.loggedInByIntlAccountRadioButton.setSelected(true);
            this.setLoginMode(LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel());
            this.updateLingmaEndpointConfig(project);
            this.btnIntlLogin.setVisible(true);
            this.btnIntlLogin.setEnabled(true);
            this.loggedInByIntlAKRadioButton.setSelected(false);
        });
        this.aliyunIntlAccountRadioButton.setSelected(false);
        this.loggedInByIntlAccountRadioButton.setSelected(false);
        this.loggedInByIntlAKRadioButton.setSelected(false);
        this.dedicatedDomainRadioButton.setSelected(false);
        this.dedicatedConfigPanel.setVisible(false);
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && StringUtils.isNotBlank((CharSequence)cosySetting.getDedicatedDomainUrl())) {
            this.setDedicatedUrlField(cosySetting.getDedicatedDomainUrl());
        }
        this.aliyunAccountRadioButton.addActionListener(e -> {
            this.accountPanel.setVisible(true);
            this.loginModeConfigPanel.setVisible(true);
            this.aliyunAccountRadioButton.setSelected(true);
            this.loginIntlModeConfigPanel.setVisible(false);
            this.aliyunIntlAccountRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            if (this.loggedInByAccountRadioButton.isSelected()) {
                this.setLoginMode(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
                this.btnLogin.setVisible(true);
            } else if (this.loggedInByAKRadioButton.isSelected()) {
                this.setLoginMode(LoginModeEnum.ACCESS_KEY.getLabel());
                this.loggedInByAccountRadioButton.setSelected(true);
                this.loggedInByAKRadioButton.setSelected(false);
                this.akConfigPanel.setVisible(false);
                this.btnLogin.setVisible(true);
                this.tokenLogInButton.setVisible(false);
            } else if (this.logInByAccessTokenRadioButton.isSelected()) {
                this.setLoginMode(LoginModeEnum.PERSONAL_TOKEN.getLabel());
                this.btnLogin.setVisible(false);
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(true);
            }
            this.updateLingmaEndpointConfig(project);
        });
        this.dedicatedDomainRadioButton.addActionListener(e -> {
            this.loginModeConfigPanel.setVisible(false);
            this.loginIntlModeConfigPanel.setVisible(false);
            this.dedicatedConfigPanel.setVisible(true);
            this.dedicatedTokenConfigPanel.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(false);
            this.aliyunIntlAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(true);
            this.dedicatedLoginByAccountRadioBtn.setSelected(true);
            this.dedicatedUrlField.setVisible(true);
            this.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
            this.configDedicatedLoginOption();
            this.updateLingmaEndpointConfig(project);
        });
        this.dedicatedLoginByAccountRadioBtn.addActionListener(e -> {
            this.dedicatedDomainRadioButton.setSelected(true);
            this.dedicatedLoginByTokenRadioBtn.setSelected(false);
            this.dedicatedTokenConfigPanel.setVisible(false);
            this.dedicatedLoginByAccountBtn.setVisible(StringUtils.isNotBlank((CharSequence)this.dedicatedUrlField.getText()));
        });
        AuthStatus status = UserAuthService.getInstance().getState(project);
        if (status != null) {
            this.notifyLoginAuth(status);
        }
    }

    private void doLogin(Project project) {
        if (project != null) {
            CosySetting setting = CosyPersistentSetting.getInstance().getState();
            if (setting != null) {
                this.checkEndpointConfigWhenAliyunLogin(project, setting);
                setting.setLoginMode(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
            } else {
                log.warn("Setting is null when token login button entered.");
            }
            this.btnLogin.setEnabled(false);
            this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
            UserAuthService.getInstance().login(project, this.labelLoginState);
        }
    }

    public void checkAndChangeEndpointWhenSelectAkLogin(Project project) {
        if (project == null) {
            log.warn("project is null when checkAndChangeEndpointWhenSelectAkLogin");
            return;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            log.info("checkAndChangeEndpointWhenSelectAkLogin");
            this.checkEndpointConfigWhenAliyunLogin(project, setting);
            setting.setLoginMode(LoginModeEnum.ACCESS_KEY.getLabel());
        }
    }

    public void checkAndChangeEndpointWhenSelectIntlAkLogin(Project project) {
        if (project == null) {
            log.warn("project is null when checkAndChangeEndpointWhenSelectAkLogin");
            return;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            log.info("checkAndChangeEndpointWhenSelectAkLogin");
            this.checkEndpointConfigWhenAliyunLogin(project, setting);
            setting.setLoginMode(LoginModeEnum.INTL_ACCESS_KEY.getLabel());
        }
    }

    public boolean checkEndpointConfigWhenAliyunLogin(Project project, CosySetting setting) {
        boolean hasEndpointConfig;
        GlobalEndpointConfig endpointConfig = LingmaAgentUtil.getGlobalEndpointConfigDirectly(project);
        boolean bl = hasEndpointConfig = endpointConfig != null && StringUtils.isNotBlank((CharSequence)endpointConfig.getEndpoint());
        if (hasEndpointConfig) {
            log.info("hasEndpointConfig when aliyun login, clear all endpoint settings.");
            if (setting != null) {
                setting.setDedicatedDomainUrl("");
            }
            this.dedicatedUrlField.setText("");
            this.updateLingmaEndpointConfig(project);
        } else {
            log.info("No endpoint config, login directly.");
        }
        return hasEndpointConfig;
    }

    public void updateLingmaGlobalConfig(Project project) {
        if (project != null) {
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                GlobalConfig config = new GlobalConfig();
                if (this.getProxyMode().getType().equals(ProxyModeEnum.MANUAL.getType())) {
                    config.setProxyMode(this.getProxyMode().getType());
                    config.setHttpProxy(this.getProxyUrl());
                } else {
                    config.setProxyMode(this.getProxyMode().getType());
                }
                config.setTerminalRunMode(this.getTerminalRunMode().getId());
                config.setCommandAllowList(this.getCommandList(this.commandAllowTextField));
                config.setCommandDenyList(this.getCommandList(this.commandDenyTextField));
                config.setMcpAutoRun(this.getMcpAutoRun().getType());
                config.setWebToolsExecutionMode(this.getWebToolsSetting());
                config.setAskModeUseTools(String.valueOf(this.getEnableChatModeUseTool()));
                config.setPreferredLanguage(ResponseLanguageEnum.getId(this.getChatLanguage()));
                GlobalConfig old = CosyConfigurable.getGlobalConfig(project);
                if (null == old) {
                    log.warn("getGlobalConfig failed");
                } else {
                    config.setIsEnableAutoMemory(old.getIsEnableAutoMemory());
                }
                ThreadUtil.execute(() -> Cosy.INSTANCE.getLanguageService(project).updateGlobalConfig(config, 2000L));
            }
        }
    }

    public void updateLingmaEndpointConfig(Project project) {
        if (project != null) {
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                GlobalEndpointConfig config = new GlobalEndpointConfig();
                if (LoginModeEnum.DEDICATED.getLabel().equals(this.getLoginMode())) {
                    config.setEndpoint(this.getDedicatedUrlField(false));
                } else {
                    config.setEndpoint("");
                }
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)config);
                UpdateConfigResult result = Cosy.INSTANCE.getLanguageService(project).updateEndpoint(config, 2000L);
                if (!BooleanUtils.isTrue((Boolean)result.getSuccess())) {
                    log.warn("UpdateEndpointConfig error. config=" + JSON.toJSONString((Object)config) + ", result=" + JSON.toJSONString((Object)result));
                } else {
                    log.info("UpdateEndpointConfig success.");
                }
            }
        }
    }

    public String getLoginMode() {
        if (this.dedicatedDomainRadioButton.isSelected()) {
            return LoginModeEnum.DEDICATED.getLabel();
        }
        if (this.loggedInByAKRadioButton.isSelected()) {
            return LoginModeEnum.ACCESS_KEY.getLabel();
        }
        if (this.logInByAccessTokenRadioButton.isSelected()) {
            return LoginModeEnum.PERSONAL_TOKEN.getLabel();
        }
        if (this.loggedInByIntlAKRadioButton.isSelected()) {
            return LoginModeEnum.INTL_ACCESS_KEY.getLabel();
        }
        if (this.loggedInByIntlAccountRadioButton.isSelected()) {
            return LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel();
        }
        return LoginModeEnum.ALIYUN_ACCOUNT.getLabel();
    }

    public void setLoginMode(String mode) {
        AuthStatus status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (CosyConfig.isQoderEnabled()) {
            this.accountPanel.setVisible(false);
            this.accountIntlPanel.setVisible(false);
            this.dedicatedPanel.setVisible(false);
            this.btnTotalLogin.setVisible(status != null && status.getStatus() != null && status.getStatus().intValue() != AuthStateEnum.LOGIN.getValue());
            return;
        }
        if (LoginModeEnum.ACCESS_KEY.getLabel().equals(mode)) {
            this.loggedInByAKRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(true);
            this.akLogInButton.setVisible(true);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.loginIntlModeConfigPanel.setVisible(false);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
        } else if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(mode)) {
            this.logInByAccessTokenRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(true);
            this.tokenConfigPanel.setVisible(true);
            this.aliyunAccountRadioButton.setSelected(true);
            this.loginIntlModeConfigPanel.setVisible(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
        } else if (LoginModeEnum.DEDICATED.getLabel().equals(mode)) {
            this.aliyunAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(true);
            this.dedicatedUrlField.setVisible(true);
            this.dedicatedConfigPanel.setVisible(true);
            this.configDedicatedLoginOption();
            this.loginModeConfigPanel.setVisible(false);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.loginIntlModeConfigPanel.setVisible(false);
        } else if (LoginModeEnum.ALIYUN_ACCOUNT.getLabel().equals(mode)) {
            this.loggedInByAccountRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(true);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.loggedInByAKRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
            this.loginIntlModeConfigPanel.setVisible(false);
        } else if (LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel().equals(mode)) {
            this.aliyunIntlAccountRadioButton.setSelected(true);
            this.loggedInByIntlAccountRadioButton.setSelected(true);
            this.loggedInByIntlAKRadioButton.setSelected(false);
            this.akIntlConfigPanel.setVisible(false);
            this.btnIntlLogin.setVisible(true);
            this.akIntlLogInButton.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
        } else {
            this.loggedInByIntlAKRadioButton.setSelected(true);
            this.akIntlConfigPanel.setVisible(true);
            this.akIntlLogInButton.setVisible(true);
            this.btnIntlLogin.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(false);
            this.aliyunIntlAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
            this.loginModeConfigPanel.setVisible(false);
            this.loggedInByIntlAccountRadioButton.setSelected(false);
            this.loginIntlModeConfigPanel.setVisible(true);
        }
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.loginModeConfigPanel.setVisible(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedUrlField.setVisible(false);
        }
    }

    private void configDedicatedLoginOption() {
        if (this.dedicatedLoginByAccountRadioBtn.isSelected()) {
            this.dedicatedLoginByTokenRadioBtn.setSelected(false);
            this.dedicatedTokenConfigPanel.setVisible(false);
            this.dedicatedLoginByAccountBtn.setVisible(StringUtils.isNotBlank((CharSequence)this.dedicatedUrlField.getText()));
        } else if (this.dedicatedLoginByTokenRadioBtn.isSelected()) {
            this.dedicatedLoginByAccountRadioBtn.setSelected(false);
            this.dedicatedTokenConfigPanel.setVisible(true);
            this.dedicatedLoginByAccountBtn.setVisible(false);
        }
    }

    public DocumentOpenModeEnum getDocumentOpenMode() {
        return DocumentOpenModeEnum.OPEN_IN_IDEA;
    }

    public void setDocumentOpenMode(DocumentOpenModeEnum mode) {
    }

    public boolean getCloudCodeCompletionSwitch() {
        return this.cloudModelCheckBox.isSelected();
    }

    public void setCloudCodeCompletionSwitch(Boolean enabled) {
        if (enabled != null && !enabled.booleanValue()) {
            this.cloudModelCheckBox.setSelected(false);
            this.cloudModelPanel.setVisible(false);
            this.cloudModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
        } else {
            this.cloudModelCheckBox.setSelected(true);
            if (this.cloudModelCheckBox.isEnabled()) {
                this.cloudModelPanel.setVisible(true);
            }
            this.cloudModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
        }
    }

    public boolean getEnableCloudAutoTrigger() {
        KeyValue pair = (KeyValue)this.autoTriggerLengthComboBox.getSelectedItem();
        return !pair.getKey().equals(CompletionGenerateLengthLevelEnum.NO.getLabel());
    }

    public void setEnableCloudAutoTrigger(Boolean enabled, String levelLabel) {
        KeyValue pair = null;
        pair = enabled != null && enabled == false ? new KeyValue(CompletionGenerateLengthLevelEnum.NO.getLabel()) : new KeyValue(levelLabel);
        this.autoTriggerLengthComboBox.setSelectedItem(pair);
    }

    public String getUpgradeCheckValue() {
        if (this.autoUpdateCheckBox.isSelected()) {
            return UpgradeChecklEnum.AUTO_INSTALL.getLabel();
        }
        return UpgradeChecklEnum.FORBID_CHECK.getLabel();
    }

    public void setUpgradeCheckValue(String key) {
        if (UpgradeChecklEnum.AUTO_INSTALL.getLabel().equals(key)) {
            this.autoUpdateCheckBox.setSelected(true);
        } else {
            this.autoUpdateCheckBox.setSelected(false);
        }
    }

    public ModelPowerLevelEnum getCloudAutoModelPower() {
        return ModelPowerLevelEnum.LARGE;
    }

    public void setCloudAutoModelPower(String levelLabel) {
    }

    public CompletionGenerateLengthLevelEnum getCloudAutoGenLengthLevel() {
        KeyValue pair = (KeyValue)this.autoTriggerLengthComboBox.getSelectedItem();
        if (pair.getKey().equals(CompletionGenerateLengthLevelEnum.NO.getLabel())) {
            return CompletionGenerateLengthLevelEnum.LEVEL_1;
        }
        return CompletionGenerateLengthLevelEnum.getLevelEnum(pair.getKey());
    }

    public void setCloudAutoGenLengthLevel(String levelLabel) {
        CompletionGenerateLengthLevelEnum level = CompletionGenerateLengthLevelEnum.getLevelEnum(levelLabel);
        if (level != null) {
            this.autoTriggerLengthComboBox.setSelectedItem(new KeyValue(levelLabel));
        }
    }

    public ModelPowerLevelEnum getCloudManualModelPower() {
        return ModelPowerLevelEnum.LARGE;
    }

    public void setCloudManualModelPower(String levelLabel) {
    }

    public CompletionGenerateLengthLevelEnum getCloudManualGenLength() {
        KeyValue pair = (KeyValue)this.manualTriggerLengthComboBox.getSelectedItem();
        return CompletionGenerateLengthLevelEnum.getLevelEnum(pair.getKey());
    }

    public void setCloudManualGenLength(String levelLabel) {
        CompletionGenerateLengthLevelEnum level = CompletionGenerateLengthLevelEnum.getLevelEnum(levelLabel);
        if (level != null) {
            this.manualTriggerLengthComboBox.setSelectedItem(new KeyValue(levelLabel));
        }
    }

    public ExceptionResolveModeEnum getExceptionResolveMode() {
        if (this.exceptionSolvingAssistantCheckBox.isSelected()) {
            return ExceptionResolveModeEnum.USE_GENERATE;
        }
        return ExceptionResolveModeEnum.DISABLED;
    }

    public void setExceptionResolveMode(ExceptionResolveModeEnum mode) {
        if (ExceptionResolveModeEnum.DISABLED.getType().equals(mode.getType())) {
            this.exceptionSolvingAssistantCheckBox.setSelected(false);
        } else {
            this.exceptionSolvingAssistantCheckBox.setSelected(true);
        }
    }

    public MethodQuickSwitchEnum getMethodQuickSwitchEnum() {
        if (this.inlineCommandsAboveMethodCheckBox.isSelected()) {
            return MethodQuickSwitchEnum.ENABLED;
        }
        return MethodQuickSwitchEnum.DISABLED;
    }

    public void setMethodQuickSwitch(MethodQuickSwitchEnum mode) {
        if (MethodQuickSwitchEnum.ENABLED.getType().equals(mode.getType())) {
            this.inlineCommandsAboveMethodCheckBox.setSelected(true);
        } else {
            this.inlineCommandsAboveMethodCheckBox.setSelected(false);
        }
    }

    public McpAutoRunEnum getMcpAutoRun() {
        if (this.mcpAutoExecuteRadioBtn.isSelected()) {
            return McpAutoRunEnum.ENABLE;
        }
        return McpAutoRunEnum.DISABLE;
    }

    public void setMcpAutoRun(String autoRun) {
        if (McpAutoRunEnum.ENABLE.getType().equals(autoRun)) {
            this.mcpAutoExecuteRadioBtn.setSelected(true);
        } else {
            this.mcpAskEveryTimeRadioBtn.setSelected(true);
        }
    }

    public void setWebToolsSetting(String webToolsExecutionMode) {
        if (WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType().equals(webToolsExecutionMode)) {
            this.webToolAskEveryTimeRadioBtn.setSelected(true);
        } else if (WebToolsExecutionModeEnum.AUTO_EXECUTE.getType().equals(webToolsExecutionMode)) {
            this.webToolAutoExecuteRadioBtn.setSelected(true);
        } else if (WebToolsExecutionModeEnum.DISABLED.getType().equals(webToolsExecutionMode)) {
            this.webToolDisabledRadioBtn.setSelected(true);
        } else {
            this.webToolAskEveryTimeRadioBtn.setSelected(true);
        }
    }

    public String getWebToolsSetting() {
        if (this.webToolAskEveryTimeRadioBtn.isSelected()) {
            return WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType();
        }
        if (this.webToolAutoExecuteRadioBtn.isSelected()) {
            return WebToolsExecutionModeEnum.AUTO_EXECUTE.getType();
        }
        if (this.webToolDisabledRadioBtn.isSelected()) {
            return WebToolsExecutionModeEnum.DISABLED.getType();
        }
        return WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType();
    }

    public boolean isWebToolSettingModified(String globalWebToolsExecutionMode) {
        if (this.webToolAskEveryTimeRadioBtn.isSelected()) {
            return !WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType().equals(globalWebToolsExecutionMode);
        }
        if (this.webToolAutoExecuteRadioBtn.isSelected()) {
            return !WebToolsExecutionModeEnum.AUTO_EXECUTE.getType().equals(globalWebToolsExecutionMode);
        }
        if (this.webToolDisabledRadioBtn.isSelected()) {
            return !WebToolsExecutionModeEnum.DISABLED.getType().equals(globalWebToolsExecutionMode);
        }
        return !WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType().equals(globalWebToolsExecutionMode);
    }

    public ProxyModeEnum getProxyMode() {
        if (this.systemProxyConfigurationRadioButton.isSelected()) {
            return ProxyModeEnum.SYSTEM;
        }
        return ProxyModeEnum.MANUAL;
    }

    public void setProxyMode(String mode) {
        if (ProxyModeEnum.SYSTEM.getType().equals(mode)) {
            this.systemProxyConfigurationRadioButton.setSelected(true);
            this.manualProxyConfigurationRadioButton.setSelected(false);
            this.manualProxyUrlPanel.setVisible(false);
        } else {
            this.manualProxyConfigurationRadioButton.setSelected(true);
            this.systemProxyConfigurationRadioButton.setSelected(false);
            this.manualProxyUrlPanel.setVisible(true);
        }
    }

    public void setEndpoint(String endpoint) {
        CosySetting setting;
        if (StringUtils.isNotBlank((CharSequence)endpoint) && (setting = CosyPersistentSetting.getInstance().getState()) != null) {
            setting.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
            this.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
        }
    }

    public String getProxyUrl() {
        return this.proxyUrlTextField.getText();
    }

    public void setProxyUrl(String url) {
        this.proxyUrlTextField.setText(url);
    }

    public void setShowInlineSuggestions(Boolean show) {
        if (show == null || !show.booleanValue()) {
            this.showInlineCheckBox.setSelected(false);
        } else {
            this.showInlineCheckBox.setSelected(true);
        }
    }

    public Boolean getShowInlineSuggestions() {
        return this.showInlineCheckBox.isSelected();
    }

    public ToolAutoRunEnum getTerminalRunMode() {
        return this.terminalAutoRunRadioBtn.isSelected() ? ToolAutoRunEnum.ENABLE_AUTO_RUN : ToolAutoRunEnum.ASK_EVERYTIME;
    }

    public List<String> getDisableLanguages() {
        String text = this.langTriggerTextField.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptyList();
        }
        return Arrays.stream(text.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public void setDisableLanguages(List<String> languages) {
        if (languages == null || languages.isEmpty()) {
            this.langTriggerTextField.setText("");
        } else {
            this.langTriggerTextField.setText(StringUtils.join(languages, (char)','));
        }
    }

    public String getCommandAllowList() {
        return this.getCommandList(this.commandAllowTextField);
    }

    public String getCommandDenyList() {
        return this.getCommandList(this.commandDenyTextField);
    }

    public String getCommandList(JTextField field) {
        String commands = field.getText();
        if (StringUtils.isBlank((CharSequence)commands)) {
            return "";
        }
        return Arrays.stream(commands.split(",")).map(String::trim).filter(command -> !command.contains("*")).collect(Collectors.joining(","));
    }

    public void setTerminalRunMode(Project project, ToolAutoRunEnum mode) {
        if (ToolAutoRunEnum.ENABLE_AUTO_RUN == mode) {
            this.commandAllowTipsLabel.setText(CosyBundle.message("settings.auxiliary.terminal.denylist.tips", new Object[0]));
            this.commandAllowTextField.setVisible(false);
            this.commandDenyTextField.setVisible(true);
        } else {
            this.commandAllowTipsLabel.setText(CosyBundle.message("settings.auxiliary.terminal.allowlist.tips", new Object[0]));
            this.commandAllowTextField.setVisible(true);
            this.commandDenyTextField.setVisible(false);
        }
        SwingUtilities.invokeLater(() -> {
            GlobalConfig config = CosyConfigurable.getGlobalConfig(project);
            if (null == config) {
                this.setCommandAllowList(this.commandAllowTextField, "");
            } else if (ToolAutoRunEnum.ENABLE_AUTO_RUN == mode) {
                this.setCommandAllowList(this.commandDenyTextField, config.getCommandDenyList());
            } else {
                this.setCommandAllowList(this.commandAllowTextField, config.getCommandAllowList());
            }
        });
    }

    public void setTerminalRunMode(ToolAutoRunEnum mode, GlobalConfig config) {
        if (ToolAutoRunEnum.ENABLE_AUTO_RUN == mode) {
            this.terminalAutoRunRadioBtn.setSelected(true);
            this.commandAllowTipsLabel.setText(CosyBundle.message("settings.auxiliary.terminal.denylist.tips", new Object[0]));
            this.setCommandAllowList(this.commandDenyTextField, config.getCommandDenyList());
            this.commandAllowTextField.setVisible(false);
            this.commandDenyTextField.setVisible(true);
        } else {
            this.terminalAskEveryTimeRadioBtn.setSelected(true);
            this.commandAllowTipsLabel.setText(CosyBundle.message("settings.auxiliary.terminal.allowlist.tips", new Object[0]));
            this.setCommandAllowList(this.commandAllowTextField, config.getCommandAllowList());
            this.commandAllowTextField.setVisible(true);
            this.commandDenyTextField.setVisible(false);
        }
    }

    public void setCommandAllowList(JTextField field, String commands) {
        if (commands == null || commands.isEmpty()) {
            field.setText("");
            return;
        }
        String filteredCommands = Arrays.stream(commands.split(",")).map(String::trim).filter(command -> !command.contains("*")).collect(Collectors.joining(","));
        field.setText(filteredCommands);
    }

    public void setLocalStoragePath(String path) {
        this.localStoragePathField.setText(path);
    }

    public String getLocalStoragePath(boolean verify) {
        String path = this.localStoragePathField.getText();
        if (!verify) {
            return path;
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.empty", new Object[0]));
            return "";
        }
        File localStoragePathFile = new File(path);
        if (!localStoragePathFile.exists() && !localStoragePathFile.mkdirs()) {
            NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.invalid", new Object[0]));
            return "";
        }
        try {
            File testFile = new File(localStoragePathFile, "testLingmaPermission.txt");
            testFile.createNewFile();
            if (!testFile.exists()) {
                testFile.delete();
                NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.no.permission", new Object[0]));
                return "";
            }
            testFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.no.permission", new Object[0]));
            return "";
        }
        return path;
    }

    public void setDedicatedUrlField(String url) {
        this.dedicatedUrlField.setText(url);
    }

    public String getDisplayLanguage() {
        if (this.displayChineseRadioButton.isSelected()) {
            return Locale.CHINESE.getLanguage();
        }
        return Locale.ENGLISH.getLanguage();
    }

    public void setDisplayLanguage(String displayLanguage) {
        if (displayLanguage.equals("default")) {
            if (CosyConfig.isQoderEnabled()) {
                this.displayEnglishRadioButton.setSelected(true);
            } else {
                this.displayChineseRadioButton.setSelected(true);
            }
        } else if (displayLanguage.equals(Locale.CHINESE.getLanguage())) {
            this.displayChineseRadioButton.setSelected(true);
        } else if (displayLanguage.equals(Locale.ENGLISH.getLanguage())) {
            this.displayEnglishRadioButton.setSelected(true);
        }
    }

    public static String getDefaultLang() {
        return systemDefaultLang;
    }

    public String getChatLanguage() {
        return String.valueOf(this.responseLanguageComboBox.getSelectedItem());
    }

    public void setChatLanguage(String chatLanguage) {
        this.responseLanguageComboBox.setSelectedItem(chatLanguage);
    }

    public String getDedicatedUrlField(boolean verify) {
        String url = this.dedicatedUrlField.getText();
        if (url != null) {
            url = url.replaceAll("[\\p{Cntrl}\\u200B-\\u200F\\uFEFF]", "");
            url = url.trim();
        }
        if (!verify) {
            return url;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            NotificationFactory.showToast((JComponent)this.dedicatedUrlField, MessageType.ERROR, CosyBundle.message("notifications.dedicated.url.empty", new Object[0]));
            return "";
        }
        boolean isUrlValid = UrlUtil.verifyDomain(url);
        if (!isUrlValid) {
            NotificationFactory.showToast((JComponent)this.dedicatedUrlField, MessageType.ERROR, CosyBundle.message("notifications.dedicated.url.invalid", new Object[0]));
            return "";
        }
        return url;
    }

    public TransportTypeEnum getTransportTypeEnum() {
        return this.websocketRadioButton.isSelected() ? TransportTypeEnum.WEBSOCKET : TransportTypeEnum.STDIO;
    }

    public void setTransportTypeEnum(String transportType) {
        if (TransportTypeEnum.WEBSOCKET.getTransportType().equals(transportType)) {
            this.websocketRadioButton.setSelected(true);
        } else if (TransportTypeEnum.STDIO.getTransportType().equals(transportType)) {
            this.stdioRadioButton.setSelected(true);
        } else {
            this.websocketRadioButton.setSelected(true);
        }
    }

    protected GlobalEndpointConfig getEndpointConfig(Project project) {
        GlobalEndpointConfig globalConfig = (GlobalEndpointConfig)CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project);
        if (globalConfig == null) {
            if (!Cosy.INSTANCE.checkCosy(project)) {
                return null;
            }
            globalConfig = Cosy.INSTANCE.getLanguageService(project).getEndpointConfig(2000L);
            if (globalConfig != null) {
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
            } else {
                LingmaAgentUtil.addDefaultEndpointToCache(project);
            }
        }
        return globalConfig;
    }

    public void setEnableNES(Boolean enableNESNextEdit) {
        boolean isEnable = enableNESNextEdit == null ? false : enableNESNextEdit;
        this.enableNESNextEditCheckBox.setSelected(isEnable);
        this.nesConfigPanel.setVisible(isEnable);
    }

    public boolean getEnableNESNextEdit() {
        return this.enableNESNextEditCheckBox.isSelected();
    }

    public String getNesSuggestModel() {
        if (this.nesSuggestModelInlineRadioButton.isSelected()) {
            return LingmaNesConfig.SuggestMode.INLINE.name();
        }
        if (this.nesSuggestModelSideBySideRadioButton.isSelected()) {
            return LingmaNesConfig.SuggestMode.SIDE_BY_SIDE.name();
        }
        return LingmaNesConfig.SuggestMode.AUTO.name();
    }

    public void setNesSuggestModel(String nesSuggestModel) {
        if (nesSuggestModel != null && nesSuggestModel.equals(LingmaNesConfig.SuggestMode.INLINE.name())) {
            this.nesSuggestModelInlineRadioButton.setSelected(true);
            this.nesCodeShiftConfigPanel.setVisible(true);
        } else if (nesSuggestModel != null && nesSuggestModel.equals(LingmaNesConfig.SuggestMode.SIDE_BY_SIDE.name())) {
            this.nesSuggestModelSideBySideRadioButton.setSelected(true);
            this.nesCodeShiftConfigPanel.setVisible(false);
        } else {
            this.nesSuggestModelAutoRadioButton.setSelected(true);
            this.nesCodeShiftConfigPanel.setVisible(true);
        }
    }

    public boolean getEnableNESCodeShift() {
        return this.nesCodeShiftYesRadioButton.isSelected();
    }

    public void setEnableNESCodeShift(Boolean enableNESCodeShift) {
        enableNESCodeShift = enableNESCodeShift == null ? true : enableNESCodeShift;
        this.nesCodeShiftYesRadioButton.setSelected(enableNESCodeShift);
        this.nesCodeShiftNoRadioButton.setSelected(enableNESCodeShift == false);
    }

    private void createUIComponents() {
        this.proxyUrlTextField = new JBTextField();
        ((JBTextField)this.proxyUrlTextField).getEmptyText().setText(CosyBundle.message("settings.proxy.panel.tips", new Object[0]));
        this.langTriggerTextField = new JBTextField();
        ((JBTextField)this.langTriggerTextField).getEmptyText().setText(CosyBundle.message("settings.completion.cloud.language.placeholder", new Object[0]));
        this.localStoragePathField = new TextFieldWithBrowseButton();
        this.responseLanguageComboBox = new ComboBox((Object[])ResponseLanguageEnum.getNames());
        SwingHelper.installFileCompletionAndBrowseDialog(null, (TextFieldWithBrowseButton)this.localStoragePathField, (String)"Local Storage Path Selector", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix).withFileFilter(VirtualFile::isDirectory));
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
        }
    }

    public boolean getEnableChatModeUseTool() {
        return this.toolUsageCheckBox.isSelected();
    }

    public void setEnableChatModeUseTool(boolean chatModeUseTool) {
        this.toolUsageCheckBox.setSelected(chatModeUseTool);
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public JButton getBtnLogin() {
        return this.btnLogin;
    }

    @Generated
    public JButton getBtnLogout() {
        return this.btnLogout;
    }

    @Generated
    public JLabel getLabelLoginState() {
        return this.labelLoginState;
    }

    @Generated
    public JCheckBox getCloudModelCheckBox() {
        return this.cloudModelCheckBox;
    }

    @Generated
    public JComboBox<KeyValue> getAutoTriggerLengthComboBox() {
        return this.autoTriggerLengthComboBox;
    }

    @Generated
    public JComboBox<KeyValue> getManualTriggerLengthComboBox() {
        return this.manualTriggerLengthComboBox;
    }

    @Generated
    public JPanel getCloudModelPanel() {
        return this.cloudModelPanel;
    }

    @Generated
    public JLabel getCloudManualShortcutLabel() {
        return this.cloudManualShortcutLabel;
    }

    @Generated
    public JLabel getLoginWarnLabel() {
        return this.loginWarnLabel;
    }

    @Generated
    public JPanel getExceptionPanel() {
        return this.exceptionPanel;
    }

    @Generated
    public JPanel getMethodQuickPanel() {
        return this.methodQuickPanel;
    }

    @Generated
    public JPanel getAuxiliaryPanel() {
        return this.auxiliaryPanel;
    }

    @Generated
    public TitledSeparator getAuxiliaryTitleSeparator() {
        return this.auxiliaryTitleSeparator;
    }

    @Generated
    public JCheckBox getAutoUpdateCheckBox() {
        return this.autoUpdateCheckBox;
    }

    @Generated
    public JTextField getProxyUrlTextField() {
        return this.proxyUrlTextField;
    }

    @Generated
    public JRadioButton getSystemProxyConfigurationRadioButton() {
        return this.systemProxyConfigurationRadioButton;
    }

    @Generated
    public JRadioButton getManualProxyConfigurationRadioButton() {
        return this.manualProxyConfigurationRadioButton;
    }

    @Generated
    public JPanel getManualProxyUrlPanel() {
        return this.manualProxyUrlPanel;
    }

    @Generated
    public JRadioButton getLoggedInByAccountRadioButton() {
        return this.loggedInByAccountRadioButton;
    }

    @Generated
    public JRadioButton getLoggedInByAKRadioButton() {
        return this.loggedInByAKRadioButton;
    }

    @Generated
    public JTextField getAkTextField() {
        return this.akTextField;
    }

    @Generated
    public JPasswordField getSkTextField() {
        return this.skTextField;
    }

    @Generated
    public JButton getAkLogInButton() {
        return this.akLogInButton;
    }

    @Generated
    public JPanel getAkConfigPanel() {
        return this.akConfigPanel;
    }

    @Generated
    public JPanel getLoginModeConfigPanel() {
        return this.loginModeConfigPanel;
    }

    @Generated
    public JLabel getGetAkLabel() {
        return this.getAkLabel;
    }

    @Generated
    public JCheckBox getShowInlineCheckBox() {
        return this.showInlineCheckBox;
    }

    @Generated
    public JComboBox<Object> getOrgIdComboBox() {
        return this.orgIdComboBox;
    }

    @Generated
    public JTextField getLangTriggerTextField() {
        return this.langTriggerTextField;
    }

    @Generated
    public JRadioButton getLogInByAccessTokenRadioButton() {
        return this.logInByAccessTokenRadioButton;
    }

    @Generated
    public JPanel getTokenConfigPanel() {
        return this.tokenConfigPanel;
    }

    @Generated
    public JTextField getAccessTokenTextField() {
        return this.accessTokenTextField;
    }

    @Generated
    public JComboBox<Object> getOrgIdTokenComboBox() {
        return this.orgIdTokenComboBox;
    }

    @Generated
    public JButton getTokenLogInButton() {
        return this.tokenLogInButton;
    }

    @Generated
    public JPanel getTokenConfigHeaderPanel() {
        return this.tokenConfigHeaderPanel;
    }

    @Generated
    public JPanel getAkConfigHeaderPanel() {
        return this.akConfigHeaderPanel;
    }

    @Generated
    public JPanel getPrivacyPanel() {
        return this.privacyPanel;
    }

    @Generated
    public TitledSeparator getPrivacyTitleLabel() {
        return this.privacyTitleLabel;
    }

    @Generated
    public TextFieldWithBrowseButton getLocalStoragePathField() {
        return this.localStoragePathField;
    }

    @Generated
    public JRadioButton getAliyunAccountRadioButton() {
        return this.aliyunAccountRadioButton;
    }

    @Generated
    public JRadioButton getDedicatedDomainRadioButton() {
        return this.dedicatedDomainRadioButton;
    }

    @Generated
    public JBTextField getDedicatedUrlField() {
        return this.dedicatedUrlField;
    }

    @Generated
    public JPanel getAccountPanel() {
        return this.accountPanel;
    }

    @Generated
    public JPanel getDedicatedPanel() {
        return this.dedicatedPanel;
    }

    @Generated
    public JPanel getDedicatedConfigPanel() {
        return this.dedicatedConfigPanel;
    }

    @Generated
    public JLabel getAliyunAccountRadioLabel() {
        return this.aliyunAccountRadioLabel;
    }

    @Generated
    public JCheckBox getExceptionSolvingAssistantCheckBox() {
        return this.exceptionSolvingAssistantCheckBox;
    }

    @Generated
    public JCheckBox getInlineCommandsAboveMethodCheckBox() {
        return this.inlineCommandsAboveMethodCheckBox;
    }

    @Generated
    public JRadioButton getDisplayChineseRadioButton() {
        return this.displayChineseRadioButton;
    }

    @Generated
    public JRadioButton getDisplayEnglishRadioButton() {
        return this.displayEnglishRadioButton;
    }

    @Generated
    public JLabel getGetAccessTokenLabel() {
        return this.getAccessTokenLabel;
    }

    @Generated
    public JPanel getDedicatedTokenConfigPanel() {
        return this.dedicatedTokenConfigPanel;
    }

    @Generated
    public JTextField getDedicatedAccessTokenTextField() {
        return this.dedicatedAccessTokenTextField;
    }

    @Generated
    public JComboBox<Object> getDedicatedOrgIdTokenComboBox() {
        return this.dedicatedOrgIdTokenComboBox;
    }

    @Generated
    public JButton getDedicatedLoginByTokenBtn() {
        return this.dedicatedLoginByTokenBtn;
    }

    @Generated
    public JRadioButton getDedicatedLoginByAccountRadioBtn() {
        return this.dedicatedLoginByAccountRadioBtn;
    }

    @Generated
    public JButton getDedicatedLoginByAccountBtn() {
        return this.dedicatedLoginByAccountBtn;
    }

    @Generated
    public JPanel getDedicatedAccountConfigHeaderPanel() {
        return this.dedicatedAccountConfigHeaderPanel;
    }

    @Generated
    public JPanel getDedicatedTokenConfigHeaderPanel() {
        return this.dedicatedTokenConfigHeaderPanel;
    }

    @Generated
    public JRadioButton getDedicatedLoginByTokenRadioBtn() {
        return this.dedicatedLoginByTokenRadioBtn;
    }

    @Generated
    public JLabel getDedicatedGetAccessTokenLabel() {
        return this.dedicatedGetAccessTokenLabel;
    }

    @Generated
    public JLabel getCommandAllowTipsLabel() {
        return this.commandAllowTipsLabel;
    }

    @Generated
    public JTextField getCommandAllowTextField() {
        return this.commandAllowTextField;
    }

    @Generated
    public ConfigAccessKeyUI getConfigAccessKeyUI() {
        return this.configAccessKeyUI;
    }

    @Generated
    public ConfigIntlAccessKeyUI getConfigIntlAccessKeyUI() {
        return this.configIntlAccessKeyUI;
    }

    @Generated
    public JRadioButton getAliyunIntlAccountRadioButton() {
        return this.aliyunIntlAccountRadioButton;
    }

    @Generated
    public JLabel getAliyunIntlAccountRadioLabel() {
        return this.aliyunIntlAccountRadioLabel;
    }

    @Generated
    public JRadioButton getLoggedInByIntlAccountRadioButton() {
        return this.loggedInByIntlAccountRadioButton;
    }

    @Generated
    public JRadioButton getLoggedInByIntlAKRadioButton() {
        return this.loggedInByIntlAKRadioButton;
    }

    @Generated
    public JLabel getGetIntlAkLabel() {
        return this.getIntlAkLabel;
    }

    @Generated
    public JButton getAkIntlLogInButton() {
        return this.akIntlLogInButton;
    }

    @Generated
    public JButton getBtnIntlLogin() {
        return this.btnIntlLogin;
    }

    @Generated
    public JPanel getAccountIntlPanel() {
        return this.accountIntlPanel;
    }

    @Generated
    public JPanel getLoginIntlModeConfigPanel() {
        return this.loginIntlModeConfigPanel;
    }

    @Generated
    public JPanel getAkIntlConfigHeaderPanel() {
        return this.akIntlConfigHeaderPanel;
    }

    @Generated
    public JPanel getAkIntlConfigPanel() {
        return this.akIntlConfigPanel;
    }

    @Generated
    public JTextField getAkIntlTextField() {
        return this.akIntlTextField;
    }

    @Generated
    public JPasswordField getSkIntlTextField() {
        return this.skIntlTextField;
    }

    @Generated
    public JComboBox<Object> getOrgIntlIdComboBox() {
        return this.orgIntlIdComboBox;
    }

    @Generated
    public JPanel getAkSkDetailPanel() {
        return this.akSkDetailPanel;
    }

    @Generated
    public JCheckBox getEnableNESNextEditCheckBox() {
        return this.enableNESNextEditCheckBox;
    }

    @Generated
    public JRadioButton getNesSuggestModelInlineRadioButton() {
        return this.nesSuggestModelInlineRadioButton;
    }

    @Generated
    public JRadioButton getNesSuggestModelSideBySideRadioButton() {
        return this.nesSuggestModelSideBySideRadioButton;
    }

    @Generated
    public JRadioButton getNesCodeShiftYesRadioButton() {
        return this.nesCodeShiftYesRadioButton;
    }

    @Generated
    public JRadioButton getNesCodeShiftNoRadioButton() {
        return this.nesCodeShiftNoRadioButton;
    }

    @Generated
    public JPanel getNesConfigPanel() {
        return this.nesConfigPanel;
    }

    @Generated
    public JPanel getNesCodeShiftConfigPanel() {
        return this.nesCodeShiftConfigPanel;
    }

    @Generated
    public JRadioButton getNesSuggestModelAutoRadioButton() {
        return this.nesSuggestModelAutoRadioButton;
    }

    @Generated
    public JPanel getMcpAutoRunPanel() {
        return this.mcpAutoRunPanel;
    }

    @Generated
    public JPanel getWebToolsSettingPanel() {
        return this.webToolsSettingPanel;
    }

    @Generated
    public JPanel getToolUsagePanel() {
        return this.toolUsagePanel;
    }

    @Generated
    public JCheckBox getToolUsageCheckBox() {
        return this.toolUsageCheckBox;
    }

    @Generated
    public JPanel getToolUsageTipPanel() {
        return this.toolUsageTipPanel;
    }

    @Generated
    public JLabel getToolUsageTipLabel() {
        return this.toolUsageTipLabel;
    }

    @Generated
    public JRadioButton getWebsocketRadioButton() {
        return this.websocketRadioButton;
    }

    @Generated
    public JRadioButton getStdioRadioButton() {
        return this.stdioRadioButton;
    }

    @Generated
    public JRadioButton getWebToolAskEveryTimeRadioBtn() {
        return this.webToolAskEveryTimeRadioBtn;
    }

    @Generated
    public JRadioButton getWebToolAutoExecuteRadioBtn() {
        return this.webToolAutoExecuteRadioBtn;
    }

    @Generated
    public JRadioButton getWebToolDisabledRadioBtn() {
        return this.webToolDisabledRadioBtn;
    }

    @Generated
    public JRadioButton getMcpAskEveryTimeRadioBtn() {
        return this.mcpAskEveryTimeRadioBtn;
    }

    @Generated
    public JRadioButton getMcpAutoExecuteRadioBtn() {
        return this.mcpAutoExecuteRadioBtn;
    }

    @Generated
    public JPanel getTerminalPanel() {
        return this.terminalPanel;
    }

    @Generated
    public JRadioButton getTerminalAskEveryTimeRadioBtn() {
        return this.terminalAskEveryTimeRadioBtn;
    }

    @Generated
    public JRadioButton getTerminalAutoRunRadioBtn() {
        return this.terminalAutoRunRadioBtn;
    }

    @Generated
    public JTextField getCommandDenyTextField() {
        return this.commandDenyTextField;
    }

    @Generated
    public JButton getBtnTotalLogin() {
        return this.btnTotalLogin;
    }

    @Generated
    public JComboBox<String> getResponseLanguageComboBox() {
        return this.responseLanguageComboBox;
    }

    @Generated
    public ConfigAccessTokenUI getConfigAccessTokenUI() {
        return this.configAccessTokenUI;
    }

    @Generated
    public ConfigDedicatedAccessTokenUI getConfigDedicatedAccessTokenUI() {
        return this.configDedicatedAccessTokenUI;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JRadioButton jRadioButton10;
        JPanel jPanel3;
        JRadioButton jRadioButton11;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JCheckBox jCheckBox3;
        JTextField jTextField;
        JTextField jTextField2;
        JRadioButton jRadioButton12;
        JRadioButton jRadioButton13;
        JPanel jPanel4;
        JLabel jLabel2;
        JPanel jPanel5;
        JCheckBox jCheckBox4;
        JPanel jPanel6;
        JRadioButton jRadioButton14;
        JRadioButton jRadioButton15;
        JRadioButton jRadioButton16;
        JPanel jPanel7;
        JRadioButton jRadioButton17;
        JRadioButton jRadioButton18;
        JPanel jPanel8;
        JLabel jLabel3;
        JCheckBox jCheckBox5;
        JPanel jPanel9;
        JCheckBox jCheckBox6;
        JPanel jPanel10;
        JPanel jPanel11;
        TitledSeparator titledSeparator;
        JCheckBox jCheckBox7;
        JLabel jLabel4;
        JPanel jPanel12;
        JLabel jLabel5;
        JRadioButton jRadioButton19;
        JButton jButton;
        JPasswordField jPasswordField;
        JTextField jTextField3;
        JPanel jPanel13;
        JPanel jPanel14;
        JLabel jLabel6;
        JRadioButton jRadioButton20;
        JPanel jPanel15;
        JButton jButton2;
        JRadioButton jRadioButton21;
        JPanel jPanel16;
        JPanel jPanel17;
        JButton jButton3;
        JTextField jTextField4;
        JPanel jPanel18;
        JLabel jLabel7;
        JRadioButton jRadioButton22;
        JPanel jPanel19;
        JButton jButton4;
        JRadioButton jRadioButton23;
        JPanel jPanel20;
        JPanel jPanel21;
        JBTextField jBTextField;
        JRadioButton jRadioButton24;
        JPanel jPanel22;
        JLabel jLabel8;
        JRadioButton jRadioButton25;
        JButton jButton5;
        JTextField jTextField5;
        JPanel jPanel23;
        JLabel jLabel9;
        JRadioButton jRadioButton26;
        JPanel jPanel24;
        JButton jButton6;
        JPasswordField jPasswordField2;
        JTextField jTextField6;
        JPanel jPanel25;
        JLabel jLabel10;
        JRadioButton jRadioButton27;
        JPanel jPanel26;
        JButton jButton7;
        JRadioButton jRadioButton28;
        JPanel jPanel27;
        JPanel jPanel28;
        JButton jButton8;
        JButton jButton9;
        JLabel jLabel11;
        JPanel jPanel29;
        this.createUIComponents();
        this.mainPanel = jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(18, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 20, 10, 0), 10, -1, false, false));
        jPanel29.add((Component)jPanel30, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout(new FlowLayout(0, 5, 5));
        jPanel30.add((Component)jPanel31, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.labelLoginState = jLabel11 = new JLabel();
        jLabel11.setText("Label");
        Component component = jPanel31.add(jLabel11);
        this.btnLogout = jButton9 = new JButton();
        this.$$$loadButtonText$$$(jButton9, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.logout"));
        Component component2 = jPanel31.add(jButton9);
        this.btnTotalLogin = jButton8 = new JButton();
        jButton8.setSelected(true);
        this.$$$loadButtonText$$$(jButton8, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        Component component3 = jPanel31.add(jButton8);
        this.accountPanel = jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel30.add((Component)jPanel28, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loginModeConfigPanel = jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel28.add((Component)jPanel27, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel27.add((Component)jPanel32, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByAccountRadioButton = jRadioButton28 = new JRadioButton();
        jRadioButton28.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton28, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.account"));
        jPanel32.add((Component)jRadioButton28, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel32.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.btnLogin = jButton7 = new JButton();
        this.$$$loadButtonText$$$(jButton7, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel32.add((Component)jButton7, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.akConfigHeaderPanel = jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel27.add((Component)jPanel26, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel33 = new JPanel();
        jPanel33.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel26.add((Component)jPanel33, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByAKRadioButton = jRadioButton27 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton27, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.aksk"));
        jPanel33.add((Component)jRadioButton27, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel33.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.getAkLabel = jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.get.aksk"));
        jPanel33.add((Component)jLabel10, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.akConfigPanel = jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel26.add((Component)jPanel25, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel34 = new JPanel();
        jPanel34.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel34, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.ak"));
        jPanel34.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel34.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.akTextField = jTextField6 = new JTextField();
        jPanel34.add((Component)jTextField6, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.sk"));
        jPanel34.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.skTextField = jPasswordField2 = new JPasswordField();
        jPanel34.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel34.add((Component)jLabel14, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.orgIdComboBox = jComboBox;
        jPanel34.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel35 = new JPanel();
        jPanel35.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel35, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.akLogInButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel35.add((Component)jButton6, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel35.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.tokenConfigHeaderPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel27.add((Component)jPanel24, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel36 = new JPanel();
        jPanel36.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel24.add((Component)jPanel36, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.logInByAccessTokenRadioButton = jRadioButton26 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton26, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.token"));
        jPanel36.add((Component)jRadioButton26, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel36.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.getAccessTokenLabel = jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.get.token"));
        jPanel36.add((Component)jLabel9, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tokenConfigPanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel24.add((Component)jPanel23, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel37 = new JPanel();
        jPanel37.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel37, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.access.token"));
        jPanel37.add((Component)jLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.accessTokenTextField = jTextField5 = new JTextField();
        jPanel37.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel37.add((Component)jLabel16, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.orgIdTokenComboBox = jComboBox2;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel37.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel38 = new JPanel();
        jPanel38.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel38, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.tokenLogInButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel38.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel38.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel39 = new JPanel();
        jPanel39.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel28.add((Component)jPanel39, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.aliyunAccountRadioButton = jRadioButton25 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton25, ResourceBundle.getBundle("messageBundle").getString("settings.login.account.panel.title"));
        jPanel39.add((Component)jRadioButton25, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.aliyunAccountRadioLabel = jLabel8 = new JLabel();
        ((Component)jLabel8).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messageBundle").getString("settings.login.account.panel.tips"));
        jPanel39.add((Component)jLabel8, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel39.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedPanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel30.add((Component)jPanel22, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel40 = new JPanel();
        jPanel40.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel40, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedDomainRadioButton = jRadioButton24 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton24, ResourceBundle.getBundle("messageBundle").getString("settings.login.dedicated.panel.title"));
        jPanel40.add((Component)jRadioButton24, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.dedicatedUrlField = jBTextField = new JBTextField();
        jPanel40.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(250, -1), new Dimension(250, -1)));
        Spacer spacer8 = new Spacer();
        jPanel40.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedConfigPanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel21, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedAccountConfigHeaderPanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel20, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedLoginByAccountRadioBtn = jRadioButton23 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton23, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.account"));
        jPanel20.add((Component)jRadioButton23, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.dedicatedLoginByAccountBtn = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel20.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel20.add((Component)spacer9, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedTokenConfigHeaderPanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel19, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel41, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedLoginByTokenRadioBtn = jRadioButton22 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton22, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.token"));
        jPanel41.add((Component)jRadioButton22, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.dedicatedGetAccessTokenLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.get.token"));
        jPanel41.add((Component)jLabel7, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel41.add((Component)spacer10, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedTokenConfigPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel18, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel42 = new JPanel();
        jPanel42.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel42, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.access.token"));
        jPanel42.add((Component)jLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.dedicatedAccessTokenTextField = jTextField4 = new JTextField();
        jPanel42.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel42.add((Component)jLabel18, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.dedicatedOrgIdTokenComboBox = jComboBox3;
        jPanel42.add(jComboBox3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel43 = new JPanel();
        jPanel43.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel43, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedLoginByTokenBtn = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel43.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel43.add((Component)spacer11, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.accountIntlPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel30.add((Component)jPanel17, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loginIntlModeConfigPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel16, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel44 = new JPanel();
        jPanel44.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel16.add((Component)jPanel44, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByIntlAccountRadioButton = jRadioButton21 = new JRadioButton();
        jRadioButton21.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton21, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.account"));
        jPanel44.add((Component)jRadioButton21, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer12 = new Spacer();
        jPanel44.add((Component)spacer12, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.btnIntlLogin = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel44.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.akIntlConfigHeaderPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel16.add((Component)jPanel15, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel45 = new JPanel();
        jPanel45.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel45, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByIntlAKRadioButton = jRadioButton20 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton20, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.aksk"));
        jPanel45.add((Component)jRadioButton20, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer13 = new Spacer();
        jPanel45.add((Component)spacer13, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.getIntlAkLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.get.aksk"));
        jPanel45.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.akIntlConfigPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.akSkDetailPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.ak"));
        jPanel13.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer14 = new Spacer();
        jPanel13.add((Component)spacer14, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.akIntlTextField = jTextField3 = new JTextField();
        jPanel13.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.sk"));
        jPanel13.add((Component)jLabel20, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.skIntlTextField = jPasswordField = new JPasswordField();
        jPanel13.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel21 = new JLabel();
        this.$$$loadLabelText$$$(jLabel21, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel13.add((Component)jLabel21, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox4 = new JComboBox();
        this.orgIntlIdComboBox = jComboBox4;
        jPanel13.add(jComboBox4, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel46 = new JPanel();
        jPanel46.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel46, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.akIntlLogInButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel46.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer15 = new Spacer();
        jPanel46.add((Component)spacer15, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel47 = new JPanel();
        jPanel47.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel47, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.aliyunIntlAccountRadioButton = jRadioButton19 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton19, ResourceBundle.getBundle("messageBundle").getString("settings.intl_login.account.panel.title"));
        jPanel47.add((Component)jRadioButton19, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.aliyunIntlAccountRadioLabel = jLabel5 = new JLabel();
        ((Component)jLabel5).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messageBundle").getString("settings.intl_login.account.panel.tips"));
        jPanel47.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer16 = new Spacer();
        jPanel47.add((Component)spacer16, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer17 = new Spacer();
        jPanel29.add((Component)spacer17, new GridConstraints(17, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.title"));
        jPanel29.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText(ResourceBundle.getBundle("messageBundle").getString("settings.completion.panel.title"));
        jPanel29.add((Component)titledSeparator3, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.cloudModelPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 10, 0), -1, 5, false, false));
        jPanel29.add((Component)jPanel12, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel48 = new JPanel();
        jPanel48.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 20, 0, 0), 10, -1, false, false));
        jPanel12.add((Component)jPanel48, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel49 = new JPanel();
        jPanel49.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, 5, false, false));
        jPanel48.add((Component)jPanel49, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.auto.trigger.label"));
        jPanel49.add((Component)jLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer18 = new Spacer();
        jPanel49.add((Component)spacer18, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox5 = new JComboBox();
        this.autoTriggerLengthComboBox = jComboBox5;
        jPanel49.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel50 = new JPanel();
        jPanel50.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel48.add((Component)jPanel50, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.manual.trigger.label"));
        jPanel50.add((Component)jLabel23, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer19 = new Spacer();
        jPanel50.add((Component)spacer19, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox6 = new JComboBox();
        this.manualTriggerLengthComboBox = jComboBox6;
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox6.setModel(defaultComboBoxModel2);
        jPanel50.add(jComboBox6, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.cloudManualShortcutLabel = jLabel4 = new JLabel();
        jLabel4.setText("Label");
        jPanel50.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel51 = new JPanel();
        jPanel51.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel48.add((Component)jPanel51, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.showInlineCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.show.inline"));
        jPanel51.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer20 = new Spacer();
        jPanel51.add((Component)spacer20, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel52 = new JPanel();
        jPanel52.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel48.add((Component)jPanel52, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel53 = new JPanel();
        jPanel53.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel52.add((Component)jPanel53, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel24 = new JLabel();
        this.$$$loadLabelText$$$(jLabel24, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.language.title"));
        jPanel53.add((Component)jLabel24, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer21 = new Spacer();
        jPanel53.add((Component)spacer21, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel54 = new JPanel();
        jPanel54.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel52.add((Component)jPanel54, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTextField jTextField7 = this.langTriggerTextField;
        jPanel54.add((Component)jTextField7, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(560, -1), null));
        Spacer spacer22 = new Spacer();
        jPanel54.add((Component)spacer22, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel25 = new JLabel();
        ((Component)jLabel25).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel25, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.language.description"));
        jPanel52.add((Component)jLabel25, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.auxiliaryTitleSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messageBundle").getString("settings.ai.chat.settings"));
        jPanel29.add((Component)titledSeparator, new GridConstraints(8, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.auxiliaryPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 20, 10, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel11, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.exceptionPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel10, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        Spacer spacer23 = new Spacer();
        jPanel10.add((Component)spacer23, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.exceptionSolvingAssistantCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messageBundle").getString("settings.exception.assisted.resolution"));
        jPanel10.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.methodQuickPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel9, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        Spacer spacer24 = new Spacer();
        jPanel9.add((Component)spacer24, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.inlineCommandsAboveMethodCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messageBundle").getString("settings.method.level.quick.operation"));
        jPanel9.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.commandAllowTipsLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messageBundle").getString("settings.auxiliary.terminal.allowlist.tips"));
        jPanel11.add((Component)jLabel3, new GridConstraints(8, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.mcpAutoRunPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel8, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer25 = new Spacer();
        jPanel8.add((Component)spacer25, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel26 = new JLabel();
        this.$$$loadLabelText$$$(jLabel26, ResourceBundle.getBundle("messageBundle").getString("settings.mcp.label"));
        jPanel8.add((Component)jLabel26, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mcpAskEveryTimeRadioBtn = jRadioButton18 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton18, ResourceBundle.getBundle("messageBundle").getString("settings.tool.ask.everytime"));
        jPanel8.add((Component)jRadioButton18, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mcpAutoExecuteRadioBtn = jRadioButton17 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton17, ResourceBundle.getBundle("messageBundle").getString("settings.tool.auto.execute"));
        jPanel8.add((Component)jRadioButton17, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.webToolsSettingPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer26 = new Spacer();
        jPanel7.add((Component)spacer26, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel27 = new JLabel();
        this.$$$loadLabelText$$$(jLabel27, ResourceBundle.getBundle("messageBundle").getString("settings.web.tool.label"));
        jPanel7.add((Component)jLabel27, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webToolAskEveryTimeRadioBtn = jRadioButton16 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton16, ResourceBundle.getBundle("messageBundle").getString("settings.tool.ask.everytime"));
        jPanel7.add((Component)jRadioButton16, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.webToolAutoExecuteRadioBtn = jRadioButton15 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton15, ResourceBundle.getBundle("messageBundle").getString("settings.tool.auto.execute"));
        jPanel7.add((Component)jRadioButton15, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.webToolDisabledRadioBtn = jRadioButton14 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton14, ResourceBundle.getBundle("messageBundle").getString("settings.tool.disable"));
        jPanel7.add((Component)jRadioButton14, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.toolUsagePanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toolUsageCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messageBundle").getString("settings.toolUsage.text"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer27 = new Spacer();
        jPanel6.add((Component)spacer27, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.toolUsageTipPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toolUsageTipLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messageBundle").getString("settings.toolUsage.tips"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.terminalPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel4, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel28 = new JLabel();
        this.$$$loadLabelText$$$(jLabel28, ResourceBundle.getBundle("messageBundle").getString("settings.terminal.label"));
        jPanel4.add((Component)jLabel28, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.terminalAskEveryTimeRadioBtn = jRadioButton13 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton13, ResourceBundle.getBundle("messageBundle").getString("settings.tool.ask.everytime"));
        jPanel4.add((Component)jRadioButton13, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer28 = new Spacer();
        jPanel4.add((Component)spacer28, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.terminalAutoRunRadioBtn = jRadioButton12 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton12, ResourceBundle.getBundle("messageBundle").getString("settings.tool.auto.run"));
        jPanel4.add((Component)jRadioButton12, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel29 = new JLabel();
        ((Component)jLabel29).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel29, ResourceBundle.getBundle("messageBundle").getString("settings.web.tools.enable.tip"));
        jPanel11.add((Component)jLabel29, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel30 = new JLabel();
        ((Component)jLabel30).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel30, ResourceBundle.getBundle("messageBundle").getString("settings.mcp.tip"));
        jPanel11.add((Component)jLabel30, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel55 = new JPanel();
        jPanel55.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel55, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.commandDenyTextField = jTextField2 = new JTextField();
        jPanel55.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(560, -1), null));
        this.commandAllowTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel55.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(560, -1), null));
        Spacer spacer29 = new Spacer();
        jPanel55.add((Component)spacer29, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer30 = new Spacer();
        jPanel11.add((Component)spacer30, new GridConstraints(9, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel56 = new JPanel();
        jPanel56.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel56, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.cloudModelCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messageBundle").getString("settings.completion.enable.cloud.model"));
        jPanel56.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer31 = new Spacer();
        jPanel56.add((Component)spacer31, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.loginWarnLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel56.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText(ResourceBundle.getBundle("messageBundle").getString("settings.update.panel.title"));
        jPanel29.add((Component)titledSeparator4, new GridConstraints(12, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel57 = new JPanel();
        jPanel57.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel57, new GridConstraints(13, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer32 = new Spacer();
        jPanel57.add((Component)spacer32, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.autoUpdateCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messageBundle").getString("settings.update.checkbox.auto.update"));
        jPanel57.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel58 = new JPanel();
        jPanel58.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel58, new GridConstraints(11, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel59 = new JPanel();
        jPanel59.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel58.add((Component)jPanel59, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer33 = new Spacer();
        jPanel59.add((Component)spacer33, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.systemProxyConfigurationRadioButton = jRadioButton11 = new JRadioButton();
        jRadioButton11.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton11, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.enable.item.system"));
        jPanel59.add((Component)jRadioButton11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.manualProxyUrlPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel58.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTextField jTextField8 = this.proxyUrlTextField;
        jTextField8.setText("");
        jTextField8.setToolTipText("");
        jPanel3.add((Component)jTextField8, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer34 = new Spacer();
        jPanel3.add((Component)spacer34, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel31 = new JLabel();
        this.$$$loadLabelText$$$(jLabel31, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.input"));
        jPanel3.add((Component)jLabel31, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel60 = new JPanel();
        jPanel60.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel58.add((Component)jPanel60, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.manualProxyConfigurationRadioButton = jRadioButton10 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton10, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.enable.item.manual"));
        jPanel60.add((Component)jRadioButton10, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer35 = new Spacer();
        jPanel60.add((Component)spacer35, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText(ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.title"));
        jPanel29.add((Component)titledSeparator5, new GridConstraints(10, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        TitledSeparator titledSeparator6 = new TitledSeparator();
        titledSeparator6.setText(ResourceBundle.getBundle("messageBundle").getString("settings.advanced.settings.title"));
        jPanel29.add((Component)titledSeparator6, new GridConstraints(14, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel61 = new JPanel();
        jPanel61.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel61, new GridConstraints(15, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel32 = new JLabel();
        this.$$$loadLabelText$$$(jLabel32, ResourceBundle.getBundle("messageBundle").getString("settings.local.storage.path.label"));
        jPanel61.add((Component)jLabel32, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer36 = new Spacer();
        jPanel61.add((Component)spacer36, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.localStoragePathField;
        jPanel61.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 3, null, new Dimension(200, -1), null));
        JPanel jPanel62 = new JPanel();
        jPanel62.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, true));
        jPanel61.add((Component)jPanel62, new GridConstraints(1, 2, 3, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer37 = new Spacer();
        jPanel62.add((Component)spacer37, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.websocketRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setSelected(false);
        jRadioButton9.setText("websocket");
        jPanel62.add((Component)jRadioButton9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.stdioRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("stdio");
        jPanel62.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox<String> jComboBox7 = this.responseLanguageComboBox;
        jPanel62.add(jComboBox7, new GridConstraints(2, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.displayChineseRadioButton = jRadioButton7 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton7, ResourceBundle.getBundle("messageBundle").getString("settings.language.chinese.label"));
        jPanel62.add((Component)jRadioButton7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.displayEnglishRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messageBundle").getString("settings.language.english.label"));
        jPanel62.add((Component)jRadioButton6, new GridConstraints(1, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel33 = new JLabel();
        this.$$$loadLabelText$$$(jLabel33, ResourceBundle.getBundle("messageBundle").getString("settings.language.response.label"));
        jPanel61.add((Component)jLabel33, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel34 = new JLabel();
        this.$$$loadLabelText$$$(jLabel34, ResourceBundle.getBundle("messageBundle").getString("settings.language.display.label"));
        jPanel61.add((Component)jLabel34, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel35 = new JLabel();
        this.$$$loadLabelText$$$(jLabel35, ResourceBundle.getBundle("messageBundle").getString("settings.transport.type.label"));
        jPanel61.add((Component)jLabel35, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator7 = new TitledSeparator();
        titledSeparator7.setText(ResourceBundle.getBundle("messageBundle").getString("settings.nes.config.panel.title"));
        jPanel29.add((Component)titledSeparator7, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel63 = new JPanel();
        jPanel63.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel63, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.enableNESNextEditCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messageBundle").getString("settings.nes.enabled.title"));
        jPanel63.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer38 = new Spacer();
        jPanel63.add((Component)spacer38, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.nesConfigPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel2, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel64 = new JPanel();
        jPanel64.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel64, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel36 = new JLabel();
        this.$$$loadLabelText$$$(jLabel36, ResourceBundle.getBundle("messageBundle").getString("settings.nes.suggest.model.label.title"));
        jPanel64.add((Component)jLabel36, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer39 = new Spacer();
        jPanel64.add((Component)spacer39, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.nesSuggestModelInlineRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messageBundle").getString("settings.nes.suggest.model.radio.inline"));
        jPanel64.add((Component)jRadioButton5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.nesSuggestModelSideBySideRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messageBundle").getString("settings.nes.suggest.model.radio.sidebyside"));
        jPanel64.add((Component)jRadioButton4, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.nesSuggestModelAutoRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messageBundle").getString("settings.nes.suggest.model.radio.auto"));
        jPanel64.add((Component)jRadioButton3, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.nesCodeShiftConfigPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel65 = new JPanel();
        jPanel65.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel65, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel37 = new JLabel();
        this.$$$loadLabelText$$$(jLabel37, ResourceBundle.getBundle("messageBundle").getString("settings.nes.code.shift.label.title"));
        jPanel65.add((Component)jLabel37, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer40 = new Spacer();
        jPanel65.add((Component)spacer40, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.nesCodeShiftYesRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messageBundle").getString("settings.nes.code.shift.radio.yes"));
        jPanel65.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.nesCodeShiftNoRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messageBundle").getString("settings.nes.code.shift.radio.no"));
        jPanel65.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel66 = new JPanel();
        jPanel66.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel66, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel38 = new JLabel();
        ((Component)jLabel38).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel38, ResourceBundle.getBundle("messageBundle").getString("settings.nes.code.shift.tooltip"));
        jPanel66.add((Component)jLabel38, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer41 = new Spacer();
        jPanel66.add((Component)spacer41, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel67 = new JPanel();
        jPanel67.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel67, new GridConstraints(16, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel39 = new JLabel();
        ((Component)jLabel39).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel39, ResourceBundle.getBundle("messageBundle").getString("settings.language.response.tip.label"));
        jPanel67.add((Component)jLabel39, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton11);
        buttonGroup.add(jRadioButton10);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton9);
        buttonGroup.add(jRadioButton8);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton16);
        buttonGroup.add(jRadioButton15);
        buttonGroup.add(jRadioButton14);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton18);
        buttonGroup.add(jRadioButton17);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton13);
        buttonGroup.add(jRadioButton12);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    static class KeyValue {
        String key;
        String label;

        public KeyValue(String key) {
            this.key = key;
        }

        public KeyValue(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue keyValue = (KeyValue)o;
            return Objects.equals(this.key, keyValue.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "KeyValue{key='" + this.key + "', label='" + this.label + "'}";
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }
    }
}

