/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.config;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.LoginDedicatedType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RegionEnvEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.cosy.ui.config.BaseConfigUI;
import com.alibabacloud.intellij.cosy.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyBrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;

public class ConfigIntlAccessKeyUI
extends BaseConfigUI {
    private static final Logger log = Logger.getInstance(ConfigIntlAccessKeyUI.class);

    @Override
    public void configTextField(Project project, ConfigMainForm configMainForm) {
        this.configTextField(configMainForm.getAkIntlTextField(), project, configMainForm, configMainForm.getOrgIntlIdComboBox());
        this.configTextField(configMainForm.getSkIntlTextField(), project, configMainForm, configMainForm.getOrgIntlIdComboBox());
    }

    @Override
    public void setLoginButtonState(ConfigMainForm configMainForm) {
        configMainForm.getAkIntlLogInButton().setEnabled(this.checkText(configMainForm) && configMainForm.getOrgIntlIdComboBox().getSelectedItem() instanceof AuthOrgItem);
    }

    @Override
    public boolean checkText(ConfigMainForm configMainForm) {
        return StringUtils.isNotBlank((CharSequence)this.getLoginIntlAccessKey(configMainForm)) && StringUtils.isNotBlank((CharSequence)this.getLoginIntlSecretKey(configMainForm));
    }

    @Override
    public JComboBox<Object> getOrgIdComboBox(ConfigMainForm configMainForm) {
        return configMainForm.getOrgIntlIdComboBox();
    }

    @Override
    public GetGrantInfosParams getGrantInfosParams(ConfigMainForm configMainForm) {
        return new GetGrantInfosParams(this.getLoginIntlAccessKey(configMainForm), this.getLoginIntlSecretKey(configMainForm), RegionEnvEnum.INTL);
    }

    @Override
    public void configHelperLabel(ConfigMainForm configMainForm) {
        configMainForm.getGetIntlAkLabel().setForeground(ColorUtil.getLinkForegroundColor());
        configMainForm.getGetIntlAkLabel().setCursor(Cursor.getPredefinedCursor(12));
        configMainForm.getGetIntlAkLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(LingmaUrls.GET_ACCESS_KEY_URL);
            }
        });
    }

    @Override
    public LoginParams getLoginParams(ConfigMainForm configMainForm) {
        return LoginParams.fromAccessKey(this.getLoginIntlAccessKey(configMainForm), this.getLoginIntlSecretKey(configMainForm), this.getOrganizationId(configMainForm), RegionEnvEnum.INTL, LoginDedicatedType.STANDARD);
    }

    @Override
    public void configLoginButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getAkIntlLogInButton().addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    configMainForm.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.INTL_ACCESS_KEY.getLabel());
                } else {
                    log.warn("Setting is null when ak login button entered.");
                }
                configMainForm.getAkIntlLogInButton().setEnabled(false);
                configMainForm.getLabelLoginState().setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = this.getLoginParams(configMainForm);
                UserAuthService.getInstance().login(project, configMainForm.getLabelLoginState(), loginParams);
            }
        });
    }

    @Override
    public void configLoginRadioButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getLoggedInByIntlAKRadioButton().addActionListener(e -> {
            configMainForm.getAkIntlConfigPanel().setVisible(true);
            configMainForm.getBtnIntlLogin().setVisible(false);
            configMainForm.getAkIntlLogInButton().setVisible(true);
            configMainForm.checkAndChangeEndpointWhenSelectIntlAkLogin(project);
            configMainForm.getConfigIntlAccessKeyUI().setLoginButtonState(configMainForm);
            configMainForm.getLoggedInByIntlAKRadioButton().setSelected(true);
            configMainForm.getLoggedInByIntlAccountRadioButton().setSelected(false);
            configMainForm.getDedicatedDomainRadioButton().setSelected(false);
            configMainForm.getAliyunAccountRadioButton().setSelected(false);
        });
    }

    public String getLoginIntlAccessKey(ConfigMainForm configMainForm) {
        return configMainForm.getAkIntlTextField().getText();
    }

    public String getLoginIntlSecretKey(ConfigMainForm configMainForm) {
        return Optional.ofNullable(configMainForm.getSkIntlTextField().getPassword()).map(String::new).orElse(null);
    }
}

