/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.prebuild;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.prebuild.BuildStepCallbackResult;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class BuildStageComponent
extends BaseChatStageComponent {
    private static final int MARGIN = 8;
    private static final int VERTICAL_GAP = 12;
    JLabel textLabel;
    JLabel statusLabel;
    JLabel errorMessageLabel;
    private Project project;

    public BuildStageComponent(Project project, ChatStep chatStep) {
        this.project = project;
        this.chatStep = chatStep;
        this.setup();
    }

    private void setup() {
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        Box box = Box.createHorizontalBox();
        this.textLabel = new JLabel(this.chatStep.getDescription());
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusLabel = new JLabel();
        box.add(this.statusLabel);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.textLabel);
        this.add(box);
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.updateItem(this.chatStep);
    }

    @Override
    public void updateItem(ChatStep stepItem) {
        this.chatStep = stepItem;
        if (ChatStepStatusEnum.DOING.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.StatusBarLoadingIcon);
        } else if (ChatStepStatusEnum.DONE.getKey().equals(stepItem.getStatus())) {
            BuildStepCallbackResult result = (BuildStepCallbackResult)JSON.parseObject((String)JSON.toJSONString((Object)stepItem.getResult()), BuildStepCallbackResult.class);
            if (Boolean.TRUE.equals(result.getSuccessful())) {
                this.statusLabel.setIcon(LingmaIcons.SuccessGreenIcon);
            } else {
                this.statusLabel.setIcon(LingmaIcons.ErrorRedIcon);
                String errorContent = CosyBundle.message("test.agent.build.failed", new Object[0]);
                this.errorMessageLabel = new JLabel(errorContent);
                this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
                this.add(Box.createVerticalStrut(12));
                this.add(this.errorMessageLabel);
            }
        } else if (ChatStepStatusEnum.ERROR.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.ErrorRedIcon);
        }
    }

    @Override
    public void stop() {
        if (!ChatStepStatusEnum.DONE.getKey().equals(this.chatStep.getStatus())) {
            this.chatStep.setStatus(ChatStepStatusEnum.ERROR.getKey());
            this.updateItem(this.chatStep);
        }
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return false;
    }
}

