/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.plan;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.plan.PlanStepCallbackResult;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class PlanStageComponent
extends BaseChatStageComponent {
    private static final int MARGIN = 8;
    JLabel textLabel;
    JLabel statusLabel;
    MarkdownComponent markdownComponent;
    private Project project;

    public PlanStageComponent(Project project, ChatStep chatStep) {
        this.project = project;
        this.chatStep = chatStep;
        this.setup();
    }

    private void setup() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.textLabel = new JLabel(this.chatStep.getDescription());
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusLabel = new JLabel();
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.textLabel);
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.updateItem(this.chatStep);
    }

    @Override
    public void updateItem(ChatStep stepItem) {
        this.chatStep = stepItem;
        if (ChatStepStatusEnum.DOING.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.StatusBarLoadingIcon);
        } else if (ChatStepStatusEnum.DONE.getKey().equals(stepItem.getStatus())) {
            PlanStepCallbackResult result = (PlanStepCallbackResult)JSON.parseObject((String)JSON.toJSONString((Object)stepItem.getResult()), PlanStepCallbackResult.class);
            if (Boolean.FALSE.equals(result.getContextValidFlag())) {
                String errorContent = CosyBundle.message("test.agent.plan.missing.target.file", new Object[0]);
                this.removeAll();
                this.textLabel = null;
                this.statusLabel = null;
                this.setLayout(new BorderLayout());
                this.markdownComponent = new TextMarkdownComponent(this.project, errorContent, 0, 1, List.of(), SessionTypeEnum.DEVELOPER);
                this.add(this.markdownComponent.getComponent(), "Center");
                this.revalidate();
                this.repaint();
            } else {
                this.statusLabel.setIcon(LingmaIcons.SuccessGreenIcon);
            }
        } else if (ChatStepStatusEnum.ERROR.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.ErrorRedIcon);
        }
    }

    @Override
    public void stop() {
        if (!ChatStepStatusEnum.DONE.getKey().equals(this.chatStep.getStatus())) {
            this.chatStep.setStatus(ChatStepStatusEnum.ERROR.getKey());
            this.updateItem(this.chatStep);
        }
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return false;
    }
}

