/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate;

import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.MarkdownRange;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;

public class GenerateCaseTitlePanel
extends JPanel {
    private JLabel planTitleLabel;
    private JLabel planFooterLabel;
    private TextMarkdownComponent textMarkdownComponent;
    private int index;
    private String planContent;
    private List<MarkdownRange> markdownRangeList;

    public GenerateCaseTitlePanel(GenerateCaseStageComponent parentComponent) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.index = 0;
        this.planContent = (String)parentComponent.chatStagePanel.getContext().getContext(ChatStageParseKey.TEST_AGENT_PLAN_CONTENT.getKey());
        this.markdownRangeList = new ArrayList<MarkdownRange>();
        Matcher matcher = FileUtil.MD_URL_PATTERN.matcher(this.planContent);
        while (matcher.find()) {
            this.markdownRangeList.add(new MarkdownRange(matcher.start(), matcher.end()));
        }
        JPanel planPanel = new JPanel();
        planPanel.setLayout(new BorderLayout());
        planPanel.setOpaque(false);
        planPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
        this.planTitleLabel = new JLabel(CosyBundle.message("test.agent.generateCase.plan.title", new Object[0]));
        this.planTitleLabel.setFont(this.planTitleLabel.getFont().deriveFont(14.0f));
        planPanel.add(this.planTitleLabel);
        this.add(planPanel);
        this.textMarkdownComponent = new TextMarkdownComponent(parentComponent.getProject(), "", 0, 1, new ArrayList<ChatAskTag>(), parentComponent.getChatStagePanel().getParentAnswerPanel().getSessionType());
        this.add(this.textMarkdownComponent.getComponent());
    }

    public boolean dynamicLoadingFinish() {
        this.index = Math.min(this.parseIndexConsideringMarkdownRange(this.index + 2), this.planContent.length());
        if (this.index <= this.planContent.length()) {
            this.updatePlanContent(this.planContent.substring(0, this.index));
        }
        if (this.index >= this.planContent.length()) {
            this.textMarkdownComponent.resetTextPanelHeight();
            this.addFooterPanel();
        }
        return this.index >= this.planContent.length();
    }

    public void loadingFinishOnce() {
        this.updatePlanContent(this.planContent);
        this.addFooterPanel();
    }

    private void updatePlanContent(String originContent) {
        Pattern pattern = Pattern.compile("\\[`([^`]+)`\\]\\(file://([^#]+)%23L(\\d+)-L(\\d+)\\)");
        Matcher matcher = pattern.matcher(originContent);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            int startLine = Integer.parseInt(matcher.group(3)) - 1;
            int endLine = Integer.parseInt(matcher.group(4)) - 1;
            matcher.appendReplacement(sb, String.format("[`%s`](file://%s%%23L%d-L%d)", matcher.group(1), matcher.group(2), startLine, endLine));
        }
        matcher.appendTail(sb);
        String targetContent = sb.toString();
        this.textMarkdownComponent.updateText(targetContent, null, false);
    }

    private void addFooterPanel() {
        JPanel planFooterPanel = new JPanel();
        planFooterPanel.setLayout(new BorderLayout());
        planFooterPanel.setOpaque(false);
        planFooterPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
        this.planFooterLabel = new JLabel(CosyBundle.message("test.agent.generateCase.plan.footer", new Object[0]));
        this.planFooterLabel.setFont(this.planFooterLabel.getFont().deriveFont(13.0f));
        planFooterPanel.add(this.planFooterLabel);
        this.add(planFooterPanel);
    }

    private int parseIndexConsideringMarkdownRange(int index) {
        for (MarkdownRange markdownRange : this.markdownRangeList) {
            if (index < markdownRange.start || index > markdownRange.end) continue;
            return markdownRange.end;
        }
        return index;
    }

    @Generated
    public TextMarkdownComponent getTextMarkdownComponent() {
        return this.textMarkdownComponent;
    }
}

