/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseFileListPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseFooterPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseTitlePanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.UpdateScope;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.UpdateScopeEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseFileDTO;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.Timer;
import lombok.Generated;

public class GenerateCaseStageComponent
extends BaseChatStageComponent {
    Project project;
    ChatStagePanel chatStagePanel;
    List<GenerateCaseFileDTO> overallGeneratingList;
    int concurrency = 0;
    Map<String, GenerateCaseMethodDTO> methodMap;
    Map<String, GenerateCaseFileDTO> fileMap;
    GenerateCaseTitlePanel titlePanel;
    GenerateCaseFileListPanel methodPanel;
    GenerateCaseFooterPanel footerPanel;
    private Timer timer;

    public GenerateCaseStageComponent(Project project, ChatStagePanel chatStagePanel, ChatStep chatStep) {
        this.project = project;
        this.chatStagePanel = chatStagePanel;
        this.overallGeneratingList = new ArrayList<GenerateCaseFileDTO>();
        this.methodMap = new ConcurrentHashMap<String, GenerateCaseMethodDTO>();
        this.fileMap = new ConcurrentHashMap<String, GenerateCaseFileDTO>();
        this.chatStep = chatStep;
        this.updateOverallGeneratingList(chatStep);
        this.methodPanel = new GenerateCaseFileListPanel(this);
        this.footerPanel = new GenerateCaseFooterPanel(this);
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void lateInit(boolean isRecoverSession) {
        this.titlePanel = new GenerateCaseTitlePanel(this);
        this.add(this.titlePanel);
        if (isRecoverSession) {
            this.titlePanel.loadingFinishOnce();
            this.add(this.methodPanel);
            this.add(this.footerPanel);
            this.chatStagePanel.getParentAnswerPanel().moveScrollToBottom(true);
        } else {
            this.timer = new Timer(10, e -> this.dynamicLoading());
            this.timer.start();
        }
    }

    private void dynamicLoading() {
        this.chatStagePanel.getParentAnswerPanel().moveScrollToBottom(false);
        if (this.titlePanel.dynamicLoadingFinish()) {
            this.timer.stop();
            this.add(this.methodPanel);
            this.add(this.footerPanel);
            this.chatStagePanel.getParentAnswerPanel().moveScrollToBottom(true);
        }
    }

    @Override
    public void updateItem(ChatStep stepItem) {
        UpdateScope updateScope = this.updateOverallGeneratingList(stepItem);
        if (UpdateScopeEnum.overall.equals((Object)updateScope.getScope())) {
            this.methodPanel.updateSummaryLabel();
            this.methodPanel.updateAllActionArea();
            this.footerPanel.update();
        } else if (UpdateScopeEnum.singleMethod.equals((Object)updateScope.getScope())) {
            this.methodPanel.updateSummaryLabel();
            this.methodPanel.updateSingleMethodActionArea(updateScope.getMethodUuid());
            this.footerPanel.update();
        }
    }

    private UpdateScope updateOverallGeneratingList(ChatStep chatStep) {
        Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), Map.class);
        UpdateScope scope = new UpdateScope();
        if (result.containsKey("concurrency")) {
            this.concurrency = (int)Double.parseDouble(result.get("concurrency").toString());
        }
        if (result.containsKey("overallGeneratingList")) {
            List fileList;
            this.overallGeneratingList = fileList = JSON.parseArray((String)JSON.toJSONString(result.get("overallGeneratingList")), GenerateCaseFileDTO.class);
            this.methodMap.clear();
            fileList.forEach(file -> file.getClasses().forEach(clazz -> clazz.getMethods().forEach(method -> this.methodMap.put(method.getUuid(), (GenerateCaseMethodDTO)method))));
            this.fileMap.clear();
            fileList.forEach(file -> this.fileMap.put(file.getFilePath(), (GenerateCaseFileDTO)file));
            scope.setScope(UpdateScopeEnum.overall);
        } else if (result.containsKey("uuid")) {
            GenerateCaseMethodDTO methodDTO = (GenerateCaseMethodDTO)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), GenerateCaseMethodDTO.class);
            this.mergeIntoOverallGeneratingList(methodDTO);
            scope.setScope(UpdateScopeEnum.singleMethod);
            scope.setMethodUuid(methodDTO.getUuid());
        }
        return scope;
    }

    private void mergeIntoOverallGeneratingList(GenerateCaseMethodDTO methodDTO) {
        GenerateCaseMethodDTO targetMethodDTO = this.methodMap.get(methodDTO.getUuid());
        if (targetMethodDTO != null) {
            targetMethodDTO.setState(methodDTO.getState());
            targetMethodDTO.setStatistics(methodDTO.getStatistics());
            targetMethodDTO.setTempTestFilePath(methodDTO.getTempTestFilePath());
        }
    }

    @Override
    public void stop() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (null != this.methodPanel) {
            this.methodPanel.stop();
        }
        if (null != this.footerPanel) {
            this.remove(this.footerPanel);
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return false;
    }

    @Override
    public void updateUiLanguage() {
        if (this.footerPanel != null) {
            this.footerPanel.updateUiLanguage();
        }
        if (this.methodPanel != null) {
            this.methodPanel.updateUiLanguage();
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public ChatStagePanel getChatStagePanel() {
        return this.chatStagePanel;
    }

    @Generated
    public List<GenerateCaseFileDTO> getOverallGeneratingList() {
        return this.overallGeneratingList;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }
}

