/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate;

import com.alibabacloud.intellij.cosy.chat.model.StepProcessConfirmParam;
import com.alibabacloud.intellij.cosy.chat.model.result.StepProcessConfirmResult;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.enums.GenerateCaseMethodStateEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseConfirmResultParam;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperGenerateStreamStopNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class GenerateCaseFooterPanel
extends JPanel {
    private GenerateCaseStageComponent parentComponent;
    DisplayLabel label;
    JLabel tipsLabel;
    private static final int MARGIN = 8;
    private static final float MINUTE_PER_METHOD = 1.5f;
    private volatile boolean clicking = false;

    public GenerateCaseFooterPanel(GenerateCaseStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.update();
    }

    public void update() {
        final int maxTestCaseCount = Features.AGENT_TESTCASE_MAX_METHOD_COUNT.intValue();
        List<String> currentSelectedMethodUuids = this.parentComponent.methodPanel.getCurrentSelectedMethodUuids();
        boolean allNeedConfirm = true;
        for (GenerateCaseMethodDTO methodDTO : this.parentComponent.methodMap.values()) {
            if (GenerateCaseMethodStateEnum.NEED_CONFIRM.equals((Object)methodDTO.getState())) continue;
            allNeedConfirm = false;
            break;
        }
        if (allNeedConfirm) {
            this.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
            if (this.label == null) {
                this.label = new DisplayLabel(CosyBundle.message("test.agent.button.confirm", new Object[0]), CosyColor.BLUE_BUTTON_COLOR, Color.WHITE);
                this.label.setCursor(Cursor.getPredefinedCursor(12));
                this.add((Component)this.label, "West");
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        List<String> currentSelectedMethodUuids = GenerateCaseFooterPanel.this.parentComponent.methodPanel.getCurrentSelectedMethodUuids();
                        if (currentSelectedMethodUuids.size() > maxTestCaseCount) {
                            NotificationFactory.showToast((JComponent)GenerateCaseFooterPanel.this.label, MessageType.WARNING, CosyBundle.message("test.agent.generateCase.confirm.oversize.notification", new Object[0]));
                            return;
                        }
                        if (currentSelectedMethodUuids.isEmpty()) {
                            NotificationFactory.showToast((JComponent)GenerateCaseFooterPanel.this.label, MessageType.WARNING, CosyBundle.message("test.agent.generateCase.method.keep.atleast.1", new Object[0]));
                            return;
                        }
                        if (GenerateCaseFooterPanel.this.clicking) {
                            return;
                        }
                        GenerateCaseFooterPanel.this.clicking = true;
                        GenerateCaseFooterPanel.this.label.setIcon(LingmaIcons.StatusBarLoadingIcon);
                        final Project project = GenerateCaseFooterPanel.this.parentComponent.project;
                        final String requestId = GenerateCaseFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getRequestId();
                        final String sessionId = GenerateCaseFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getSessionId();
                        GenerateCaseConfirmResultParam resultParam = new GenerateCaseConfirmResultParam();
                        final StepProcessConfirmParam param = new StepProcessConfirmParam();
                        param.setSessionId(sessionId);
                        param.setRequestId(requestId);
                        param.setStep(ChatStepEnum.TEST_AGENT_GENERATE_TESTS.getKey());
                        param.setConfirmResult(resultParam);
                        resultParam.setUuids(currentSelectedMethodUuids);
                        new Task.Backgroundable(project, I18NConstant.CONFIRM_TIP){

                            public void run(@NotNull ProgressIndicator indicator) {
                                StepProcessConfirmResult result;
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (Cosy.INSTANCE.checkCosy(project, false) && (result = Cosy.INSTANCE.getLanguageService(project).stepProcessConfirm(param, 10000L)) != null && result.isSuccessful()) {
                                    return;
                                }
                                try {
                                    SwingUtilities.invokeAndWait(() -> ((AiDeveloperGenerateStreamStopNotifier)project.getMessageBus().syncPublisher(AiDeveloperGenerateStreamStopNotifier.AI_DEVELOPER_GENERATE_STREAM_STOP_NOTIFICATION)).stop(requestId, sessionId, Integer.valueOf("605"), "confirm exception", null));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/ui/chat/testagent/component/generate/GenerateCaseFooterPanel$1$1", "run"));
                            }
                        }.queue();
                    }
                });
                this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToWaiting();
            }
            if (this.tipsLabel == null) {
                this.tipsLabel = new JLabel();
                this.tipsLabel.setFont(this.tipsLabel.getFont().deriveFont(0, 12.0f));
                this.tipsLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                this.tipsLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
                this.add((Component)this.tipsLabel, "Center");
            }
            if (currentSelectedMethodUuids.size() > maxTestCaseCount) {
                this.label.setBackground(ColorUtil.getToolWindowBackgroundColor());
                this.label.setForegroundTextColor(ColorUtil.getAuxiliaryForegroundColor());
                this.tipsLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.confirm.oversize", new Object[0]), currentSelectedMethodUuids.size(), maxTestCaseCount));
            } else if (!currentSelectedMethodUuids.isEmpty()) {
                this.label.setBackground(CosyColor.BLUE_BUTTON_COLOR);
                this.label.setForegroundTextColor(Color.WHITE);
                int estimatedMinutes = this.parentComponent.concurrency <= 0 ? (int)((float)currentSelectedMethodUuids.size() * 1.5f) : (int)(Math.ceil((float)currentSelectedMethodUuids.size() / (float)this.parentComponent.concurrency) * 0.5 + (double)currentSelectedMethodUuids.size());
                this.tipsLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.expected.time", new Object[0]), estimatedMinutes));
            } else if (currentSelectedMethodUuids.isEmpty()) {
                this.label.setBackground(ColorUtil.getToolWindowBackgroundColor());
                this.label.setForegroundTextColor(ColorUtil.getAuxiliaryForegroundColor());
                this.tipsLabel.setText(CosyBundle.message("test.agent.generateCase.method.keep.atleast.1", new Object[0]));
            }
        } else {
            this.parentComponent.remove(this);
            this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToGenerating();
        }
    }

    public void updateUiLanguage() {
        if (this.label != null) {
            this.label.setText(CosyBundle.message("test.agent.button.confirm", new Object[0]));
        }
    }
}

