/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate;

import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseFileItemPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseFileDTO;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class GenerateCaseFileListPanel
extends JPanel {
    private GenerateCaseStageComponent parentComponent;
    private JLabel summaryCountLabel;
    private Box statisticsCountBox;
    JLabel runningSuccessLabel;
    JLabel runningFailedLabel;
    JLabel compileErrorIcon;
    private Box fileListArea;

    public GenerateCaseFileListPanel(GenerateCaseStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setup();
    }

    private void setup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(true);
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.setBorder((Border)new JBEmptyBorder(8, 12, 0, 12));
        JPanel summaryPanel = new JPanel();
        summaryPanel.setOpaque(false);
        summaryPanel.setLayout(new BorderLayout());
        summaryPanel.setPreferredSize(new Dimension(-1, 32));
        summaryPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)0, (int)0, (int)2, (int)0));
        this.summaryCountLabel = new JLabel();
        this.summaryCountLabel.setFont(this.summaryCountLabel.getFont().deriveFont(13.0f));
        this.statisticsCountBox = Box.createHorizontalBox();
        summaryPanel.add((Component)this.statisticsCountBox, "East");
        this.updateSummaryLabel();
        summaryPanel.add((Component)this.summaryCountLabel, "West");
        this.add(summaryPanel);
        this.fileListArea = Box.createVerticalBox();
        for (GenerateCaseFileDTO file : this.parentComponent.overallGeneratingList) {
            GenerateCaseFileItemPanel fileItemPanel = new GenerateCaseFileItemPanel(this, file.getFilePath());
            this.fileListArea.add(fileItemPanel);
        }
        this.add(this.fileListArea);
    }

    public void updateSummaryLabel() {
        int completedMethodCount = 0;
        int needConfirmMethodCount = 0;
        int caseRunningSuccessCount = 0;
        int caseRunningFailedCount = 0;
        int caseCompileFailedCount = 0;
        for (GenerateCaseMethodDTO method : this.parentComponent.methodMap.values()) {
            if (method.getState() == null || method.getState().isNeedConfirm().booleanValue()) {
                ++needConfirmMethodCount;
                continue;
            }
            if (!method.getState().isFinished().booleanValue()) continue;
            ++completedMethodCount;
            if (method.getStatistics() == null) continue;
            caseRunningSuccessCount += method.getStatistics().getCaseRunningSuccessCount();
            caseRunningFailedCount += method.getStatistics().getCaseRunningFailedCount();
            caseRunningFailedCount += method.getStatistics().getCaseRunningSkippedCount();
            caseCompileFailedCount += method.getStatistics().getCaseCompileFailedCount();
        }
        if (needConfirmMethodCount < this.parentComponent.methodMap.size()) {
            if (this.parentComponent.methodMap.size() <= 1) {
                this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.progress.summary.method", new Object[0]), completedMethodCount, this.parentComponent.methodMap.size()));
            } else {
                this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.progress.summary.methods", new Object[0]), completedMethodCount, this.parentComponent.methodMap.size()));
            }
            if (this.statisticsCountBox.getComponents().length == 0) {
                this.runningSuccessLabel = new JLabel();
                this.runningSuccessLabel.setToolTipText(CosyBundle.message("test.agent.run.success.icon.tooltips", new Object[0]));
                this.runningSuccessLabel.setIcon(LingmaIcons.TestRunSuccessIcon);
                this.statisticsCountBox.add(this.runningSuccessLabel);
                this.statisticsCountBox.add(Box.createHorizontalStrut(12));
                this.runningFailedLabel = new JLabel();
                this.runningFailedLabel.setToolTipText(CosyBundle.message("test.agent.run.fail.icon.tooltips", new Object[0]));
                this.runningFailedLabel.setIcon(LingmaIcons.TestRunErrorIcon);
                this.statisticsCountBox.add(this.runningFailedLabel);
                this.statisticsCountBox.add(Box.createHorizontalStrut(12));
                this.compileErrorIcon = new JLabel();
                this.compileErrorIcon.setToolTipText(CosyBundle.message("test.agent.compile.error.icon.tooltips", new Object[0]));
                this.compileErrorIcon.setIcon(LingmaIcons.TestCompileErrorIcon);
                this.statisticsCountBox.add(this.compileErrorIcon);
            }
            this.runningSuccessLabel.setText(String.valueOf(caseRunningSuccessCount));
            this.runningFailedLabel.setText(String.valueOf(caseRunningFailedCount));
            this.compileErrorIcon.setText(String.valueOf(caseCompileFailedCount));
        } else if (this.parentComponent.methodMap.size() <= 1) {
            if (this.parentComponent.overallGeneratingList.size() <= 1) {
                this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.count.summary.method.file", new Object[0]), this.parentComponent.methodMap.size(), this.parentComponent.overallGeneratingList.size()));
            } else {
                this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.count.summary.method.files", new Object[0]), this.parentComponent.methodMap.size(), this.parentComponent.overallGeneratingList.size()));
            }
        } else if (this.parentComponent.overallGeneratingList.size() <= 1) {
            this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.count.summary.methods.file", new Object[0]), this.parentComponent.methodMap.size(), this.parentComponent.overallGeneratingList.size()));
        } else {
            this.summaryCountLabel.setText(String.format(CosyBundle.message("test.agent.generateCase.method.count.summary.methods.files", new Object[0]), this.parentComponent.methodMap.size(), this.parentComponent.overallGeneratingList.size()));
        }
    }

    public void updateAllActionArea() {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof GenerateCaseFileItemPanel)) continue;
            ((GenerateCaseFileItemPanel)component).updateAllActionArea();
        }
    }

    public void removeFileItemInUI(GenerateCaseFileItemPanel fileItemPanel) {
        this.fileListArea.remove(fileItemPanel);
    }

    public void updateSingleMethodActionArea(String methodUuid) {
        Component fileItemComponent;
        Component[] componentArray = this.fileListArea.getComponents();
        int n = componentArray.length;
        for (int i = 0; !(i >= n || (fileItemComponent = componentArray[i]) instanceof GenerateCaseFileItemPanel && ((GenerateCaseFileItemPanel)fileItemComponent).updateSingleMethodActionArea(methodUuid)); ++i) {
        }
    }

    public void stop() {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof GenerateCaseFileItemPanel)) continue;
            ((GenerateCaseFileItemPanel)component).stop();
        }
    }

    public List<String> getCurrentSelectedMethodUuids() {
        ArrayList<String> methodUuids = new ArrayList<String>();
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof GenerateCaseFileItemPanel)) continue;
            methodUuids.addAll(((GenerateCaseFileItemPanel)component).getCurrentSelectedMethodUuids());
        }
        return methodUuids;
    }

    public void updateUiLanguage() {
        this.updateSummaryLabel();
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof GenerateCaseFileItemPanel)) continue;
            ((GenerateCaseFileItemPanel)component).updateUiLanguage();
        }
    }

    @Generated
    public GenerateCaseStageComponent getParentComponent() {
        return this.parentComponent;
    }
}

