/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvBodyPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvFooterPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvTitlePanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.checkEnv.CheckEnvResultItem;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepStatusEnum;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.BoxLayout;
import lombok.Generated;

public class CheckEnvStageComponent
extends BaseChatStageComponent {
    Project project;
    ChatStagePanel chatStagePanel;
    private CheckEnvTitlePanel checkEnvTitlePanel;
    private CheckEnvBodyPanel checkEnvBodyPanel;
    private CheckEnvFooterPanel checkEnvFooterPanel;
    private List<CheckEnvResultItem> checkItemList;
    private boolean isBodyPanelExpanded = true;

    public CheckEnvStageComponent(Project project, ChatStagePanel chatStagePanel, ChatStep chatStep) {
        this.project = project;
        this.chatStagePanel = chatStagePanel;
        this.checkItemList = new ArrayList<CheckEnvResultItem>();
        this.chatStep = chatStep;
        this.updateCheckItemList(chatStep);
        this.setup();
    }

    @Override
    public void updateItem(ChatStep chatStep) {
        this.chatStep = chatStep;
        this.updateCheckItemList(chatStep);
        this.checkEnvTitlePanel.update();
        this.checkEnvBodyPanel.update();
        this.checkEnvFooterPanel.update();
    }

    public String getDescription() {
        return this.chatStep.getDescription();
    }

    public String getStatus() {
        return this.chatStep.getStatus();
    }

    private void setup() {
        this.setLayout(new BoxLayout(this, 1));
        this.checkEnvTitlePanel = new CheckEnvTitlePanel(this);
        this.checkEnvBodyPanel = new CheckEnvBodyPanel(this);
        this.checkEnvFooterPanel = new CheckEnvFooterPanel(this);
        this.add(this.checkEnvTitlePanel);
        this.add(this.checkEnvBodyPanel);
        this.add(this.checkEnvFooterPanel);
    }

    private void updateCheckItemList(ChatStep chatStep) {
        Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), Map.class);
        if (result.containsKey("overallCheckList")) {
            List list = JSON.parseArray((String)JSON.toJSONString(result.get("overallCheckList")), CheckEnvResultItem.class);
            list.forEach(this::mergeIntoCheckItemList);
        } else if (result.containsKey("checkItemKey")) {
            CheckEnvResultItem item = (CheckEnvResultItem)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), CheckEnvResultItem.class);
            this.mergeIntoCheckItemList(item);
        }
    }

    private void mergeIntoCheckItemList(CheckEnvResultItem item) {
        Optional<CheckEnvResultItem> targetItemOptional = this.checkItemList.stream().filter(checkItem -> checkItem.getCheckItemKey().equals(item.getCheckItemKey())).findFirst();
        if (targetItemOptional.isPresent()) {
            CheckEnvResultItem targetItem = targetItemOptional.get();
            targetItem.setCheckItemDescription(item.getCheckItemDescription());
            targetItem.setCheckResult(item.getCheckResult());
            targetItem.setProperties(item.getProperties());
            targetItem.setMetaData(item.getMetaData());
        } else {
            this.checkItemList.add(item);
        }
    }

    public void changeBodyExpandState() {
        this.isBodyPanelExpanded = !this.isBodyPanelExpanded;
        this.checkEnvTitlePanel.updateBorderByExpanded();
        this.checkEnvBodyPanel.setVisible(this.isBodyPanelExpanded);
        if (this.isBodyPanelExpanded) {
            this.chatStagePanel.getParentAnswerPanel().moveDownRelatively(this.checkEnvBodyPanel.getHeight());
        }
    }

    @Override
    public void stop() {
        this.remove(this.checkEnvFooterPanel);
        if (ChatStepStatusEnum.DOING.getKey().equals(this.chatStep.getStatus())) {
            this.chatStep.setStatus(ChatStepStatusEnum.ERROR.getKey());
            this.updateItem(this.chatStep);
        }
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return false;
    }

    @Override
    public void updateUiLanguage() {
        if (null != this.checkEnvFooterPanel) {
            this.checkEnvFooterPanel.updateUiLanguage();
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public ChatStagePanel getChatStagePanel() {
        return this.chatStagePanel;
    }

    @Generated
    public CheckEnvBodyPanel getCheckEnvBodyPanel() {
        return this.checkEnvBodyPanel;
    }

    @Generated
    public List<CheckEnvResultItem> getCheckItemList() {
        return this.checkItemList;
    }

    @Generated
    public boolean isBodyPanelExpanded() {
        return this.isBodyPanelExpanded;
    }
}

