/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.search.util.PopUtil;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvItemComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvSelectionListCellRender;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvSelectionPopup;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.enums.CheckEnvResultItemStatusEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.checkEnv.CheckEnvPropertiesDTO;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.checkEnv.CheckEnvRelatedMetaInfo;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ChatTaskExtra;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CheckEnvItemSelectionComponent
extends JPanel {
    private CheckEnvItemComponent checkEnvItemComponent;
    private List<CheckEnvPropertiesDTO> selectionData;
    private CheckEnvResultItemStatusEnum checkResult;
    private String checkItemKey;
    private String checkItemDescription;
    private CheckEnvRelatedMetaInfo checkEnvRelatedMetaInfo;
    private Box selectionBoxArea;
    private int selectedIndex;
    private JBList<CheckEnvPropertiesDTO> selectionList;
    private CheckEnvSelectionPopup selectionPopup;
    private JScrollPane selectionScrollPane;
    private JPanel contentPanel;
    private JLabel selectedLabel;
    private static final int MAX_DISPLAY_LIST_HEIGHT = 320;
    private static final int MIN_SELECTION_WIDTH = 120;
    private static final String MOCKING_FRAMEWORK = "mockingFramework";
    private static final String TESTING_FRAMEWORK = "testingFramework";
    private static final String BUILD_SYSTEM = "buildSystem";
    private static final String JAVA_VERSION = "javaVersion";
    private static Logger log = Logger.getInstance(CheckEnvItemSelectionComponent.class);

    public CheckEnvItemSelectionComponent(CheckEnvItemComponent checkEnvItemComponent, List<CheckEnvPropertiesDTO> selections) {
        this.checkEnvItemComponent = checkEnvItemComponent;
        this.selectionData = selections;
        this.selectedIndex = 0;
        this.setup();
    }

    public void update(List<CheckEnvPropertiesDTO> selectionData, CheckEnvResultItemStatusEnum checkResult, String checkItemKey, String checkItemDescription, CheckEnvRelatedMetaInfo checkEnvRelatedMetaInfo) {
        this.selectionData = selectionData;
        this.checkResult = checkResult;
        this.checkItemKey = checkItemKey;
        this.checkItemDescription = checkItemDescription;
        this.checkEnvRelatedMetaInfo = checkEnvRelatedMetaInfo;
        this.selectedIndex = 0;
        this.setup();
    }

    private void setup() {
        JLabel emptyLabel;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.removeAll();
        if (CollectionUtils.isNotEmpty(this.selectionData)) {
            this.selectionBoxArea = new Box(0);
            this.selectionBoxArea.setOpaque(false);
            this.selectedLabel = new JLabel(CheckEnvItemSelectionComponent.getUIDisplayName(this.selectionData.get(this.selectedIndex)));
            this.selectionBoxArea.add(this.selectedLabel);
            this.selectionBoxArea.add(Box.createHorizontalStrut(8));
            if (this.selectionData.size() > 1) {
                this.selectionBoxArea.add(new JLabel(LingmaIcons.ArrowdownEmptyGreyIcon));
                this.selectionBoxArea.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionBoxArea.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        CheckEnvItemSelectionComponent.this.initSelectionChooser();
                        CheckEnvItemSelectionComponent.this.showSelectionPopup();
                    }
                });
            } else {
                emptyLabel = new JLabel();
                emptyLabel.setPreferredSize(new Dimension(LingmaIcons.ArrowdownEmptyGreyIcon.getIconWidth(), LingmaIcons.ArrowdownEmptyGreyIcon.getIconHeight()));
                this.selectionBoxArea.add(emptyLabel);
            }
            this.add((Component)this.selectionBoxArea, "West");
        }
        if (this.checkResult == CheckEnvResultItemStatusEnum.NOT_FOUND) {
            this.selectionBoxArea = new Box(0);
            this.selectionBoxArea.setOpaque(false);
            this.selectedLabel = new JLabel(CosyBundle.message("test.agent.check.env.how.to.fix", new Object[0]));
            this.selectedLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.selectedLabel.setForeground(ColorUtil.getLinkForegroundColor());
            this.selectedLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CheckEnvItemSelectionComponent.this.triggerHowToFixAction(CheckEnvItemSelectionComponent.this.checkResult, CheckEnvItemSelectionComponent.this.selectionData, CheckEnvItemSelectionComponent.this.checkItemKey, CheckEnvItemSelectionComponent.this.checkItemDescription, CheckEnvItemSelectionComponent.this.checkEnvRelatedMetaInfo);
                }
            });
            this.selectionBoxArea.add(this.selectedLabel);
            this.selectionBoxArea.add(Box.createHorizontalStrut(8));
            emptyLabel = new JLabel();
            emptyLabel.setPreferredSize(new Dimension(LingmaIcons.ArrowdownEmptyGreyIcon.getIconWidth(), LingmaIcons.ArrowdownEmptyGreyIcon.getIconHeight()));
            this.selectionBoxArea.add(emptyLabel);
            this.add((Component)this.selectionBoxArea, "West");
        }
    }

    private void initSelectionChooser() {
        if (this.selectionList == null) {
            this.selectionList = new JBList();
            this.selectionList.setVisibleRowCount(10);
            this.selectionList.setOpaque(false);
            CheckEnvSelectionListCellRender cellRender = new CheckEnvSelectionListCellRender(this.checkEnvItemComponent.getCheckEnvBodyPanel().getBackground());
            this.selectionList.setCellRenderer((ListCellRenderer)cellRender);
            this.selectionList.setBorder(BorderFactory.createEmptyBorder());
            ListUtil.installAutoSelectOnMouseMove(this.selectionList);
            ScrollingUtil.installActions(this.selectionList);
        }
        this.selectionScrollPane = new JBScrollPane();
        this.selectionScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.selectionScrollPane.setViewportView((Component)this.selectionList);
        this.selectionScrollPane.setOpaque(false);
        this.selectionScrollPane.setVerticalScrollBarPolicy(20);
        this.selectionScrollPane.setHorizontalScrollBarPolicy(31);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)this.selectionScrollPane, "Center");
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.selectionList.setBackground(ColorUtil.getListBackground());
        this.selectionList.getEmptyText().setText("");
        this.selectionPopup = new CheckEnvSelectionPopup(this.contentPanel, this.checkEnvItemComponent.getCheckEnvBodyPanel().getCheckEnvStageComponent().project);
        this.selectionList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!PopUtil.isPopUsable((JBPopup)CheckEnvItemSelectionComponent.this.selectionPopup)) {
                    return;
                }
                super.mouseReleased(e);
                CheckEnvItemSelectionComponent.this.selectedIndex = CheckEnvItemSelectionComponent.this.selectionList.getSelectedIndex();
                CheckEnvItemSelectionComponent.this.selectedLabel.setText(CheckEnvItemSelectionComponent.getUIDisplayName(CheckEnvItemSelectionComponent.this.selectionData.get(CheckEnvItemSelectionComponent.this.selectedIndex)));
                CheckEnvItemSelectionComponent.this.selectionPopup.cancel();
                e.consume();
            }
        });
    }

    private void showSelectionPopup() {
        if (CollectionUtils.isEmpty(this.selectionData)) {
            return;
        }
        this.selectionScrollPane.getVerticalScrollBar().setValue(0);
        this.selectionList.setModel((ListModel)new CollectionListModel(this.selectionData));
        this.selectionList.setSelectedIndex(0);
        this.selectionList.getEmptyText().setText("");
        int width = Math.max(120, this.checkEnvItemComponent.getPreferredSize().width);
        Dimension scrollPaneSize = this.selectionScrollPane.getSize();
        scrollPaneSize.height = this.selectionList.getPreferredSize().height >= 320 ? 320 : this.selectionList.getPreferredSize().height;
        this.contentPanel.setSize(new Dimension(this.contentPanel.getSize().width, scrollPaneSize.getSize().height + 16));
        this.selectionScrollPane.getViewport().setSize(scrollPaneSize);
        Dimension dimension = new Dimension(width, this.contentPanel.getSize().height);
        this.selectionPopup.setSize(dimension);
        int popupCurrentWidth = (int)this.selectionPopup.getSize().getWidth();
        int multipleSectionPanelCurrentWidth = (int)this.selectionBoxArea.getSize().getWidth();
        int multipleSectionPanelCurrentHeight = (int)this.selectionBoxArea.getSize().getHeight();
        int x = (int)(this.selectionBoxArea.getLocationOnScreen().getX() + (double)multipleSectionPanelCurrentWidth - (double)popupCurrentWidth);
        int y = (int)(this.selectionBoxArea.getLocationOnScreen().getY() + (double)multipleSectionPanelCurrentHeight);
        Point location = new Point(x, y);
        this.selectionPopup.showInScreenCoordinates(this.selectionBoxArea, new Point(location.x, location.y));
    }

    public static String getUIDisplayName(CheckEnvPropertiesDTO selection) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)selection.getName())) {
            sb.append(selection.getName());
        }
        if (StringUtils.isNotBlank((String)selection.getVersion())) {
            sb.append(" ").append(selection.getVersion());
        }
        return sb.toString().trim();
    }

    public CheckEnvPropertiesDTO getSelectedProperties() {
        if (this.selectionData == null || this.selectionData.isEmpty() || this.selectedIndex < 0 || this.selectedIndex >= this.selectionData.size()) {
            return null;
        }
        return this.selectionData.get(this.selectedIndex);
    }

    private void triggerHowToFixAction(CheckEnvResultItemStatusEnum checkResult, List<CheckEnvPropertiesDTO> selectionData, String checkItemKey, String checkItemDescription, CheckEnvRelatedMetaInfo checkEnvRelatedMetaInfo) {
        String problemDesc;
        switch (checkItemKey) {
            case "mockingFramework": {
                problemDesc = CosyBundle.message("test.agent.check.env.mock.framework.notfound", new Object[0]);
                break;
            }
            case "testingFramework": {
                problemDesc = CosyBundle.message("test.agent.check.env.test.framework.notfound", new Object[0]);
                break;
            }
            case "buildSystem": {
                problemDesc = CosyBundle.message("test.agent.check.env.build.tool.notfound", new Object[0]);
                break;
            }
            case "javaVersion": {
                problemDesc = CosyBundle.message("test.agent.check.env.java.notfound", new Object[0]);
                break;
            }
            default: {
                return;
            }
        }
        switch (checkResult) {
            case NOT_FOUND: {
                BaseChatPanel chatContentPanel = this.getChatContentPanel();
                GenerateInput input = ChatTaskUtil.getInitInput(this.checkEnvItemComponent.getCheckEnvBodyPanel().getCheckEnvStageComponent().project, chatContentPanel.getSessionTab());
                GenerateInput initInput = chatContentPanel.getInitInput();
                input.setChatContext(initInput.getChatContext());
                input.setChatHistory(initInput.getChatHistory());
                ChatAskInput chatAskInput = new ChatAskInput();
                ChatInputElement howToFixChat = new ChatInputElement(problemDesc, null, "text");
                ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
                elements.add(howToFixChat);
                chatAskInput.setChatInputElements(elements);
                input.setChatAskInput(chatAskInput);
                input.setChatTask(ChatTaskEnum.AI_DEVELOPER_TEST_AGENT_FIX_ENV.getName());
                input.setSessionTab(SessionTypeEnum.DEVELOPER.getType());
                input.setTargetAgent("common");
                ChatTaskExtra chatTaskExtra = new ChatTaskExtra();
                HashMap<String, Object> extraInfo = new HashMap<String, Object>();
                extraInfo.put("checkItemKey", checkItemKey);
                extraInfo.put("checkItemDescription", checkItemDescription);
                HashMap<String, String> relatedInfo = new HashMap<String, String>();
                extraInfo.put("relatedInfo", relatedInfo);
                relatedInfo.put("osVersion", System.getProperty("os.name").toLowerCase());
                relatedInfo.put("ideVersion", CosyConfig.IDE_VERSION);
                relatedInfo.put("ideName", CosyConfig.IDE_NAME);
                chatTaskExtra.setExtraInfo(extraInfo);
                input.setExtra(chatTaskExtra);
                String requestId = UUID.randomUUID().toString();
                GenerateAnswerPanel answerPanel = chatContentPanel.getAnswerPanel();
                if (answerPanel != null && answerPanel.getRequestId() != null) {
                    try {
                        chatContentPanel.stopGenerate(answerPanel.getRequestId(), answerPanel.getSessionId(), 200, "Stopped by system", null);
                    }
                    catch (Exception e) {
                        log.warn("stop failed. requestId is " + answerPanel.getRequestId() + ", sessionId is " + answerPanel.getSessionId(), (Throwable)e);
                    }
                }
                chatContentPanel.prepareAndAsynchronousChat(input, problemDesc, problemDesc, requestId);
                break;
            }
            case UNSUPPORTED: {
                break;
            }
            case UNDETERMINED: {
                break;
            }
        }
    }

    private BaseChatPanel getChatContentPanel() {
        return this.checkEnvItemComponent.getCheckEnvBodyPanel().getCheckEnvStageComponent().getChatStagePanel().getParentAnswerPanel().getGenerateContentForm();
    }
}

