/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv;

import com.alibabacloud.intellij.cosy.chat.model.StepProcessConfirmParam;
import com.alibabacloud.intellij.cosy.chat.model.result.StepProcessConfirmResult;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.enums.CheckEnvResultItemStatusEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.checkEnv.CheckEnvConfirmResultParam;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperGenerateStreamStopNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class CheckEnvFooterPanel
extends JPanel {
    private CheckEnvStageComponent parentComponent;
    DisplayLabel label;
    private static final int MARGIN = 8;
    private volatile boolean clicking = false;

    public CheckEnvFooterPanel(CheckEnvStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.setLayout(new BorderLayout());
    }

    public void update() {
        List undeterminedList = this.parentComponent.getCheckItemList().stream().filter(item -> CheckEnvResultItemStatusEnum.UNDETERMINED.equals((Object)item.getCheckResult())).collect(Collectors.toList());
        List unfinishedList = this.parentComponent.getCheckItemList().stream().filter(item -> item.getCheckResult() == null).collect(Collectors.toList());
        if (!undeterminedList.isEmpty() && unfinishedList.isEmpty()) {
            this.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
            if (this.label == null) {
                this.label = new DisplayLabel(CosyBundle.message("test.agent.button.confirm", new Object[0]), CosyColor.BLUE_BUTTON_COLOR, Color.WHITE);
                this.label.setCursor(Cursor.getPredefinedCursor(12));
                this.add((Component)this.label, "West");
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        if (CheckEnvFooterPanel.this.clicking) {
                            return;
                        }
                        CheckEnvFooterPanel.this.clicking = true;
                        CheckEnvFooterPanel.this.label.setIcon(LingmaIcons.StatusBarLoadingIcon);
                        final Project project = CheckEnvFooterPanel.this.parentComponent.project;
                        final String requestId = CheckEnvFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getRequestId();
                        final String sessionId = CheckEnvFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getSessionId();
                        CheckEnvConfirmResultParam resultParam = new CheckEnvConfirmResultParam();
                        final StepProcessConfirmParam param = new StepProcessConfirmParam();
                        param.setSessionId(sessionId);
                        param.setRequestId(requestId);
                        param.setStep(ChatStepEnum.TEST_AGENT_CHECK_ENV.getKey());
                        param.setConfirmResult(resultParam);
                        resultParam.setOverallCheckList(CheckEnvFooterPanel.this.parentComponent.getCheckEnvBodyPanel().getSelectionResult());
                        new Task.Backgroundable(project, I18NConstant.CONFIRM_TIP){

                            public void run(@NotNull ProgressIndicator indicator) {
                                StepProcessConfirmResult result;
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (Cosy.INSTANCE.checkCosy(project, false) && (result = Cosy.INSTANCE.getLanguageService(project).stepProcessConfirm(param, 10000L)) != null && result.isSuccessful()) {
                                    return;
                                }
                                try {
                                    SwingUtilities.invokeAndWait(() -> ((AiDeveloperGenerateStreamStopNotifier)project.getMessageBus().syncPublisher(AiDeveloperGenerateStreamStopNotifier.AI_DEVELOPER_GENERATE_STREAM_STOP_NOTIFICATION)).stop(requestId, sessionId, Integer.valueOf("605"), "confirm exception", null));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/ui/chat/testagent/component/checkEnv/CheckEnvFooterPanel$1$1", "run"));
                            }
                        }.queue();
                    }
                });
                this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToWaiting();
            }
        } else if (undeterminedList.isEmpty() && unfinishedList.isEmpty()) {
            this.parentComponent.remove(this);
            this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToGenerating();
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.removeAll();
            this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToGenerating();
        }
    }

    public void updateUiLanguage() {
        if (this.label != null) {
            this.label.setText(CosyBundle.message("test.agent.button.confirm", new Object[0]));
        }
    }
}

