/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingFileListPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingFooterPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingTitlePanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.UpdateScope;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.UpdateScopeEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.apply.ApplyingFileItem;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepStatusEnum;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ApplyingStageComponent
extends BaseChatStageComponent {
    Project project;
    ChatStagePanel chatStagePanel;
    private List<ApplyingFileItem> fileList;
    private Map<String, ApplyingFileItem> fileUuidMap;
    ApplyingTitlePanel titlePanel;
    ApplyingFileListPanel fileListPanel;
    ApplyingFooterPanel footerPanel;
    boolean waitingMannualConfirm;

    public ApplyingStageComponent(Project project, ChatStagePanel chatStagePanel, ChatStep chatStep) {
        this.project = project;
        this.chatStagePanel = chatStagePanel;
        this.fileList = new ArrayList<ApplyingFileItem>();
        this.fileUuidMap = new ConcurrentHashMap<String, ApplyingFileItem>();
        this.waitingMannualConfirm = false;
        this.chatStep = chatStep;
        this.updateData(chatStep);
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.titlePanel = new ApplyingTitlePanel(this);
        this.fileListPanel = new ApplyingFileListPanel(this);
        this.footerPanel = new ApplyingFooterPanel(this);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.fileListPanel, "Center");
        this.add((Component)this.footerPanel, "South");
        this.fileListPanel.updateCheckBoxEnabledRecursively(this.waitingMannualConfirm);
    }

    public ApplyingFileItem getFileItemByFileUuid(String uuid) {
        return this.fileUuidMap.get(uuid);
    }

    private UpdateScope updateData(ChatStep chatStep) {
        Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), Map.class);
        UpdateScope scope = new UpdateScope();
        if (result.containsKey("overallApplyingList")) {
            List fileList = JSON.parseArray((String)JSON.toJSONString(result.get("overallApplyingList")), ApplyingFileItem.class);
            scope.setScope(UpdateScopeEnum.overallUpdate);
            this.fileList = fileList;
            this.fileUuidMap.clear();
            fileList.forEach(file -> this.fileUuidMap.put(file.getTestFileUuid(), (ApplyingFileItem)file));
        } else {
            ApplyingFileItem fileItem = (ApplyingFileItem)JSON.parseObject((String)JSON.toJSONString((Object)chatStep.getResult()), ApplyingFileItem.class);
            this.mergeIntoFileList(fileItem);
            scope.setScope(UpdateScopeEnum.singleFileUpdate);
            scope.setTestFileUuid(fileItem.getTestFileUuid());
        }
        this.waitingMannualConfirm = ChatStepStatusEnum.MANUAL_CONFIRM.getKey().equals(chatStep.getStatus());
        return scope;
    }

    private void mergeIntoFileList(ApplyingFileItem fileItem) {
        ApplyingFileItem targetFile = this.fileUuidMap.get(fileItem.getTestFileUuid());
        if (targetFile != null) {
            targetFile.setAgentTestFilePath(fileItem.getAgentTestFilePath());
            targetFile.setState(fileItem.getState());
            targetFile.setProjectTestFilePath(fileItem.getProjectTestFilePath());
            targetFile.setTestCases(fileItem.getTestCases());
            targetFile.setTotalCase(fileItem.getTotalCase());
            targetFile.setAppliedCase(fileItem.getAppliedCase());
        }
    }

    @Override
    public void updateItem(ChatStep stepItem) {
        UpdateScope updateScope = this.updateData(stepItem);
        if (UpdateScopeEnum.overallUpdate.equals((Object)updateScope.getScope())) {
            this.titlePanel.updateTitleLabel();
            this.fileListPanel.updateAllFiles();
            this.footerPanel.update();
        } else if (UpdateScopeEnum.singleFileUpdate.equals((Object)updateScope.getScope())) {
            this.fileListPanel.updateSingleFile(updateScope.getTestFileUuid());
            this.footerPanel.update();
        }
        this.fileListPanel.updateCheckBoxEnabledRecursively(this.waitingMannualConfirm);
    }

    public Set<String> getCurrentSelectedTestCase() {
        return this.fileListPanel.getCurrentSelectedTestCase();
    }

    @Override
    public void stop() {
        this.footerPanel.setVisible(false);
        this.fileListPanel.stop();
    }

    @Override
    public void updateUiLanguage() {
        if (this.footerPanel != null) {
            this.footerPanel.updateUiLanguage();
        }
        if (this.fileListPanel != null) {
            this.fileListPanel.updateUiLanguage();
        }
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return false;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public ChatStagePanel getChatStagePanel() {
        return this.chatStagePanel;
    }

    @Generated
    public List<ApplyingFileItem> getFileList() {
        return this.fileList;
    }

    @Generated
    public boolean isWaitingMannualConfirm() {
        return this.waitingMannualConfirm;
    }
}

