/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply;

import com.alibabacloud.intellij.cosy.listener.CosyCurrentFileSelectionListener;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingDiffWindow;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingFileListPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingTestCaseFolderPanel;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.enums.ApplyingFileStateEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.enums.ApplyingTestCaseRunningStateEnum;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.apply.ApplyingFileItem;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.model.apply.ApplyingTestCaseItem;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.ThreeStateCheckBox;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyingFileItemPanel
extends JPanel {
    private static final Logger log = Logger.getInstance(ApplyingFileItemPanel.class);
    public static final int MIN_TOTAL_HEIGHT = 28;
    public static final int MIN_TITLE_PANEL_HEIGHT = 24;
    public static final int SIDE_MARGIN = 4;
    public static final float FILE_PATH_WIDTH_FULLFILE_RATIO = 0.8f;
    public static final int MIN_FILE_PATH_LENGTH = 5;
    public static final int WIDTH_PRE_ENGLISH_CHAR = 6;
    public static final int WIDTH_PRE_CHINESE_CHAR = 12;
    private ApplyingFileListPanel fileListPanel;
    String testFileUuid;
    RoundRectPanel fileNamePanel;
    JLabel fileNameLabel;
    JLabel fileStateLabel;
    ThreeStateCheckBox checkBox;
    Box testCasesArea;
    private ApplyingDiffWindow fileDiffWindow;
    private MouseAdapter hoverMouseAdapter;

    ApplyingFileItemPanel(ApplyingFileListPanel fileListPanel, String testFileUuid) {
        this.fileListPanel = fileListPanel;
        this.testFileUuid = testFileUuid;
        this.hoverMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingFileItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingFileItemPanel.this.onMouseExited();
            }
        };
        this.setup();
    }

    private void setup() {
        ApplyingFileItem fileItem = this.fileListPanel.getParentComponent().getFileItemByFileUuid(this.testFileUuid);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBackground(this.fileListPanel.getBackground());
        JPanel titleOuterPanel = new JPanel(new BorderLayout());
        titleOuterPanel.setOpaque(false);
        titleOuterPanel.setPreferredSize(new Dimension(-1, 28));
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setPreferredSize(new Dimension(-1, 2));
        emptyTopPanel.setOpaque(false);
        JPanel emptyBottomPanel = new JPanel();
        emptyBottomPanel.setPreferredSize(new Dimension(-1, 2));
        emptyBottomPanel.setOpaque(false);
        this.fileNamePanel = new RoundRectPanel(new BorderLayout());
        this.fileNamePanel.setBackground(this.fileListPanel.getBackground());
        this.fileNamePanel.setPreferredSize(new Dimension(-1, 24));
        this.fileNamePanel.setMaximumSize(new Dimension(-1, 24));
        this.fileNamePanel.setMinimumSize(new Dimension(-1, 24));
        this.fileNamePanel.setOpaque(false);
        this.fileNamePanel.setBorder((Border)new JBEmptyBorder(0, 4, 0, 4));
        titleOuterPanel.add((Component)emptyTopPanel, "North");
        titleOuterPanel.add((Component)this.fileNamePanel, "Center");
        titleOuterPanel.add((Component)emptyBottomPanel, "South");
        this.fileNameLabel = new JLabel();
        this.fileStateLabel = new JLabel();
        this.fileStateLabel.setFont(this.fileStateLabel.getFont().deriveFont(12.0f));
        this.fileStateLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.fileNamePanel.add((Component)this.fileNameLabel, "West");
        this.checkBox = new ThreeStateCheckBox();
        this.checkBox.setBackground(this.fileListPanel.getBackground());
        for (MouseListener mouseListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener(mouseListener);
        }
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingFileItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingFileItemPanel.this.onMouseExited();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ApplyingFileItemPanel.this.checkBox.isEnabled()) {
                    return;
                }
                ThreeStateCheckBox.State currentState = ApplyingFileItemPanel.this.checkBox.getState();
                ApplyingFileItemPanel.this.updateCheckBoxStateRecursively(!ThreeStateCheckBox.State.SELECTED.equals((Object)currentState));
            }
        });
        this.add((Component)titleOuterPanel, "North");
        this.fileNamePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int totalWidth = e.getComponent().getWidth();
                int suitableWidth = (int)((float)(totalWidth - 20 - 8 - ((BorderLayout)ApplyingFileItemPanel.this.fileNamePanel.getLayout()).getLayoutComponent("East").getWidth()) * 0.8f);
                ApplyingFileItemPanel.this.fileNameLabel.setText(ApplyingFileItemPanel.this.getDisplayFileName(suitableWidth));
            }
        });
        this.testCasesArea = Box.createVerticalBox();
        this.testCasesArea.setOpaque(false);
        this.add((Component)this.testCasesArea, "Center");
        this.updateFileNamePanel(fileItem);
        SwingUtil.foreachChildComponent(this.fileNamePanel, jComponent -> jComponent.addMouseListener(this.hoverMouseAdapter));
        this.updateTestCaseArea(fileItem);
    }

    private void updateFileNamePanel(ApplyingFileItem fileItem) {
        if (ApplyingFileStateEnum.PENDING.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setVisible(true);
            this.checkBox.setVisible(false);
            this.fileNamePanel.add((Component)this.fileStateLabel, "East");
            this.fileStateLabel.setIcon(LingmaIcons.PendingGreyIcon);
            this.fileStateLabel.setText(CosyBundle.message("test.agent.apply.file.state.pending", new Object[0]));
        } else if (ApplyingFileStateEnum.APPLYING.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setVisible(true);
            this.checkBox.setVisible(false);
            this.fileNamePanel.add((Component)this.fileStateLabel, "East");
            this.fileStateLabel.setIcon(LingmaIcons.StatusBarLoadingIcon);
            this.fileStateLabel.setText(CosyBundle.message("test.agent.apply.file.state.merging", new Object[0]));
        } else if (ApplyingFileStateEnum.APPLIED.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setVisible(false);
            this.checkBox.setVisible(true);
            this.fileNamePanel.add((Component)this.checkBox, "East");
        } else if (ApplyingFileStateEnum.ERROR.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setVisible(true);
            this.checkBox.setVisible(false);
            this.fileNamePanel.add((Component)this.fileStateLabel, "East");
            this.fileStateLabel.setIcon(LingmaIcons.ErrorRedIcon);
            this.fileStateLabel.setText(CosyBundle.message("test.agent.apply.file.state.error", new Object[0]));
        } else if (ApplyingFileStateEnum.CANCELED.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setVisible(true);
            this.checkBox.setVisible(false);
            this.fileNamePanel.add((Component)this.fileStateLabel, "East");
            this.fileStateLabel.setIcon(LingmaIcons.ErrorRedIcon);
            this.fileStateLabel.setText(CosyBundle.message("test.agent.apply.file.state.canceled", new Object[0]));
        } else if (ApplyingFileStateEnum.PROGRESS.equals((Object)fileItem.getState())) {
            this.fileStateLabel.setText(String.format("%s %d/%d", CosyBundle.message("test.agent.apply.file.state.merging", new Object[0]), fileItem.getAppliedCase(), fileItem.getTotalCase()));
        }
        this.fileNameLabel.setIcon(this.getIconByFileType(fileItem));
        this.fileNameLabel.setText(this.getDisplayFileName((int)((float)(this.fileNamePanel.getWidth() - 20 - 8 - ((BorderLayout)this.fileNamePanel.getLayout()).getLayoutComponent("East").getWidth()) * 0.8f)));
    }

    private void updateTestCaseArea(ApplyingFileItem fileItem) {
        this.testCasesArea.removeAll();
        if (CollectionUtils.isNotEmpty(fileItem.getTestCases())) {
            ApplyingTestCaseFolderPanel notAppliedTestCaseFolderPanel;
            List<ApplyingTestCaseItem> runSuccessTestCases = fileItem.getTestCases().stream().filter(item -> ApplyingTestCaseRunningStateEnum.PASS.equals((Object)item.getRunningState())).collect(Collectors.toList());
            List<ApplyingTestCaseItem> runFailedTestCases = fileItem.getTestCases().stream().filter(item -> ApplyingTestCaseRunningStateEnum.FAILED.equals((Object)item.getRunningState())).collect(Collectors.toList());
            List<ApplyingTestCaseItem> compileErrorTestCases = fileItem.getTestCases().stream().filter(item -> ApplyingTestCaseRunningStateEnum.COMPILE_ERROR.equals((Object)item.getRunningState())).collect(Collectors.toList());
            if (!runSuccessTestCases.isEmpty()) {
                ApplyingTestCaseFolderPanel appliedTestCaseFolderPanel = new ApplyingTestCaseFolderPanel(this, runSuccessTestCases, ApplyingTestCaseRunningStateEnum.PASS);
                this.testCasesArea.add(appliedTestCaseFolderPanel);
            }
            if (!runFailedTestCases.isEmpty()) {
                notAppliedTestCaseFolderPanel = new ApplyingTestCaseFolderPanel(this, runFailedTestCases, ApplyingTestCaseRunningStateEnum.FAILED);
                this.testCasesArea.add(notAppliedTestCaseFolderPanel);
            }
            if (!compileErrorTestCases.isEmpty()) {
                notAppliedTestCaseFolderPanel = new ApplyingTestCaseFolderPanel(this, compileErrorTestCases, ApplyingTestCaseRunningStateEnum.COMPILE_ERROR);
                this.testCasesArea.add(notAppliedTestCaseFolderPanel);
            }
            this.updateCheckBoxState();
        }
    }

    public Set<String> getCurrentSelectedTestCase() {
        HashSet<String> resultSet = new HashSet<String>();
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            resultSet.addAll(((ApplyingTestCaseFolderPanel)component).getCurrentSelectedTestCase());
        }
        return resultSet;
    }

    public void updateCheckBoxEnabledRecursively(Boolean isEnabled) {
        this.checkBox.setEnabled(isEnabled.booleanValue());
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            ((ApplyingTestCaseFolderPanel)component).updateCheckBoxEnabledRecursively(isEnabled);
        }
    }

    private Icon getIconByFileType(ApplyingFileItem fileItem) {
        if (fileItem.getTestFileName().endsWith(".java")) {
            return AllIcons.FileTypes.Java;
        }
        return AllIcons.FileTypes.Any_type;
    }

    public void update() {
        ApplyingFileItem fileItem = this.fileListPanel.getParentComponent().getFileItemByFileUuid(this.testFileUuid);
        this.updateTestCaseArea(fileItem);
        this.updateFileNamePanel(fileItem);
    }

    private void onMouseEntered() {
        this.fileNamePanel.setOpaque(true);
        this.fileNamePanel.setBackground(this.fileListPanel.getParentComponent().getBackground());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackground(this.fileListPanel.getParentComponent().getBackground());
    }

    private void onMouseExited() {
        this.fileNamePanel.setOpaque(false);
        this.fileNamePanel.setBackground(this.fileListPanel.getBackground());
        this.checkBox.setOpaque(false);
        this.checkBox.setBackground(this.fileListPanel.getBackground());
    }

    public void openFileDiffView() {
        ApplyingFileItem fileItem;
        if (this.fileDiffWindow != null) {
            try {
                this.fileDiffWindow.show();
                return;
            }
            catch (Throwable t) {
                this.fileDiffWindow = null;
            }
        }
        if (ApplyingFileStateEnum.APPLIED.equals((Object)(fileItem = this.fileListPanel.getParentComponent().getFileItemByFileUuid(this.testFileUuid)).getState())) {
            VirtualFile projectVirtualFile;
            String agentTestFilePath = fileItem.getAgentTestFilePath();
            if (StringUtils.isBlank((CharSequence)agentTestFilePath)) {
                log.warn("Cannot view Diff due to agentTestFilePath is blank");
                return;
            }
            if (!com.intellij.openapi.util.io.FileUtil.exists((String)fileItem.getProjectTestFilePath())) {
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(fileItem.getTestFileName().substring(fileItem.getTestFileName().lastIndexOf(".") + 1));
                projectVirtualFile = FileUtil.buildVirtualFile(fileItem.getTestFileName(), fileType, "", false);
            } else {
                projectVirtualFile = LocalFileSystem.getInstance().findFileByPath(fileItem.getProjectTestFilePath());
            }
            VirtualFile agentVirtualFile = LocalFileSystem.getInstance().findFileByPath(agentTestFilePath);
            DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
            Project project = this.fileListPanel.getParentComponent().getProject();
            if (projectVirtualFile == null) {
                log.warn("Cannot view Diff due to projectVirtualFile is blank: " + fileItem.getProjectTestFilePath());
                return;
            }
            projectVirtualFile.putUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE, (Object)true);
            DiffContent beforeChangeContent = diffContentFactory.create(project, projectVirtualFile);
            if (agentVirtualFile == null) {
                log.warn("Cannot view Diff due to agentVirtualFile is null: " + agentTestFilePath);
                return;
            }
            agentVirtualFile.putUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE, (Object)true);
            DiffContent afterChangeContent = diffContentFactory.create(project, agentVirtualFile);
            SimpleDiffRequest diffRequest = new SimpleDiffRequest("Applying Comparison", beforeChangeContent, afterChangeContent, "Before Change", "After Change");
            SimpleDiffRequestChain diffRequestChain = new SimpleDiffRequestChain((DiffRequest)diffRequest);
            DiffDialogHints diffDialogHints = DiffDialogHints.DEFAULT;
            this.fileDiffWindow = new ApplyingDiffWindow(project, (DiffRequestChain)diffRequestChain, diffDialogHints);
            this.fileDiffWindow.show();
            Disposer.register((Disposable)this.fileDiffWindow.getWrapper(), this::resetFileDiffWindow);
        }
    }

    public void updateCheckBoxState() {
        int selectedCount = 0;
        int unselectedCount = 0;
        int dontCareCount = 0;
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            ThreeStateCheckBox.State state = ((ApplyingTestCaseFolderPanel)component).getCurrentCheckBoxState();
            if (state == ThreeStateCheckBox.State.SELECTED) {
                ++selectedCount;
                continue;
            }
            if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                ++unselectedCount;
                continue;
            }
            if (state != ThreeStateCheckBox.State.DONT_CARE) continue;
            ++dontCareCount;
        }
        if (selectedCount > 0 && unselectedCount == 0 && dontCareCount == 0) {
            this.checkBox.setState(ThreeStateCheckBox.State.SELECTED);
        } else if (selectedCount == 0 && unselectedCount > 0 && dontCareCount == 0) {
            this.checkBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        } else {
            this.checkBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        }
        if (this.fileListPanel.getParentComponent().footerPanel != null) {
            this.fileListPanel.getParentComponent().footerPanel.update();
        }
    }

    private void updateCheckBoxStateRecursively(Boolean isSelected) {
        this.checkBox.setState(isSelected != false ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED);
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            ((ApplyingTestCaseFolderPanel)component).updateCheckBoxStateRecursively(isSelected);
        }
        if (this.fileListPanel.getParentComponent().footerPanel != null) {
            this.fileListPanel.getParentComponent().footerPanel.update();
        }
    }

    private String getDisplayFileName(int width) {
        ApplyingFileItem fileItem = this.fileListPanel.getParentComponent().getFileItemByFileUuid(this.testFileUuid);
        String fileName = fileItem.getTestFileName();
        int maxCharLength = Math.max(width / 6, 5);
        if (fileName.length() <= maxCharLength) {
            return fileName;
        }
        return fileName.substring(0, maxCharLength) + "...";
    }

    public void stop() {
        ApplyingFileItem fileItem = this.fileListPanel.getParentComponent().getFileItemByFileUuid(this.testFileUuid);
        if (fileItem.getState() == null || !fileItem.getState().isFinished()) {
            fileItem.setState(ApplyingFileStateEnum.CANCELED);
        }
        this.updateFileNamePanel(fileItem);
        this.checkBox.setEnabled(false);
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            ((ApplyingTestCaseFolderPanel)component).stop();
        }
    }

    public void updateUiLanguage() {
        for (Component component : this.testCasesArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseFolderPanel)) continue;
            ((ApplyingTestCaseFolderPanel)component).updateUiLanguage();
        }
    }

    private void resetFileDiffWindow() {
        this.fileDiffWindow = null;
    }

    @Generated
    public ApplyingFileListPanel getFileListPanel() {
        return this.fileListPanel;
    }

    @Generated
    public String getTestFileUuid() {
        return this.testFileUuid;
    }
}

