/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.inline;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import icons.CommonIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineChatSelectionListener
implements SelectionListener {
    private RangeHighlighter currentHighlighter = null;

    public void selectionChanged(@NotNull SelectionEvent event) {
        if (event == null) {
            InlineChatSelectionListener.$$$reportNull$$$0(0);
        }
        Editor editor = event.getEditor();
        SelectionModel selectionModel = editor.getSelectionModel();
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(editor.getProject());
        Integer status = authStatus.getStatus();
        if (status == null || status.intValue() != AuthStateEnum.LOGIN.getValue()) {
            return;
        }
        this.addGutterIcon(selectionModel, editor);
    }

    private void addGutterIcon(SelectionModel selectionModel, final Editor editor) {
        MarkupModel markupModel = editor.getMarkupModel();
        if (this.currentHighlighter != null) {
            markupModel.removeHighlighter(this.currentHighlighter);
            this.currentHighlighter = null;
        }
        if (!selectionModel.hasSelection()) {
            return;
        }
        int startOffset = selectionModel.getSelectionStart();
        this.currentHighlighter = markupModel.addRangeHighlighter(startOffset, startOffset, 5001, null, HighlighterTargetArea.LINES_IN_RANGE);
        this.currentHighlighter.setGutterIconRenderer(new GutterIconRenderer(){

            public boolean equals(Object obj) {
                return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = CommonIcons.AI;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            public String getTooltipText() {
                String shortcutText = KeyboardUtil.getShortcutText(ActionUtil.getActionIdWithAddPrefix("ShowInlineChatAction"), null);
                if (shortcutText == null) {
                    return CosyBundle.message("inline.chat.popup.title.no.shortcut", new Object[0]);
                }
                return CosyBundle.message("inline.chat.popup.title", shortcutText);
            }

            @Nullable
            public AnAction getClickAction() {
                return new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                        if (anActionEvent == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        InlineChatPanel.createInlineChatPanel(anActionEvent.getProject(), editor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/alibabacloud/intellij/cosy/ui/chat/inline/InlineChatSelectionListener$1$1", "actionPerformed"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/chat/inline/InlineChatSelectionListener$1", "getIcon"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/cosy/ui/chat/inline/InlineChatSelectionListener", "selectionChanged"));
    }
}

