/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.inline;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.BaseComponent;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.component.AvatarLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatFilteredNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class InlineChatQuestion
implements BaseComponent {
    private static Logger LOG = Logger.getInstance(InlineChatQuestion.class);
    public static final String BASE_PANEL_NAME_PREFIX = "InlineChatQuestion_BasePanel_";
    private static final int CODE_BLOCK_MAX_HEIGHT = 400;
    protected JPanel basePanel;
    protected JPanel headerPanel;
    protected JPanel contentPanel;
    private JPanel filterLabelPanel;
    private JLabel userInfoLabel;
    JPanel userinfoPanel;
    private JLabel filteredIconLabel;
    private Balloon filterBalloon;
    protected MarkdownStreamPanel questionText;
    private String value;
    private String requestId;
    private String sessionId;
    private MessageBusConnection messageBusConnection;
    private Project project;
    private String chatTask;
    private String sessionType;
    ChatContextTagsPanel tagsPanel;
    private GenerateAnswerPanel generateAnswerPanel;

    public InlineChatQuestion(Project project, JComponent parentComponent, String value, Date questionTime, ChatAskInput chatAskInput, String requestId, String chatTask, String sessionType, GenerateAnswerPanel generateAnswerPanel) {
        this.value = value;
        this.project = project;
        this.chatTask = chatTask;
        this.sessionType = sessionType;
        this.requestId = requestId;
        this.generateAnswerPanel = generateAnswerPanel;
        this.questionText = new MarkdownStreamPanel(project, parentComponent, generateAnswerPanel, 400, (LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false), parentComponent.getBackground());
        this.tagsPanel = new ChatContextTagsPanel(new ChatInputContext(project, null, null, sessionType), ChatContextTagsPanel.USAGE_QUESTION_PANEL);
        List<ChatContextTag> tags = null;
        if (chatAskInput != null) {
            if (chatAskInput.getTags() != null) {
                this.questionText.setTags(chatAskInput.getTags());
            }
            if (chatAskInput.getChatInputElements() != null) {
                this.questionText.append(chatAskInput.toMarkdownLabelString(false), false);
                this.questionText.append("\n", false);
            }
            tags = chatAskInput.getContextTags();
        }
        if (tags != null) {
            tags.forEach(this.tagsPanel::addTag);
        }
        this.configInlineChatQuestionForm();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.questionText.append(value, false);
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        ((AvatarLabel)this.userInfoLabel).setStatus(authStatus);
        this.filteredIconLabel.setText("");
        this.filteredIconLabel.setIcon(LingmaIcons.SecurityIcon);
        this.filteredIconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)6));
        this.filteredIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                InlineChatQuestion.this.filterBalloon = NotificationFactory.showToast((JComponent)InlineChatQuestion.this.filteredIconLabel, MessageType.INFO, CosyBundle.message("message.chat.filtered", new Object[0]));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InlineChatQuestion.this.filterBalloon.hide();
            }
        });
        this.filteredIconLabel.setVisible(false);
        this.filteredIconLabel.setEnabled(false);
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            Boolean isCodePane = (Boolean)cp.getClientProperty("codePane");
            if (isCodePane != null && isCodePane.booleanValue()) {
                return;
            }
            if (cp != this.basePanel && cp instanceof JPanel && !(cp instanceof RoundRectPanel) && !(cp instanceof ChatContextTagButton)) {
                cp.setOpaque(false);
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(ChatFilteredNotifier.CHAT_FILTERED_NOTIFICATION, this::showChatFilteredMessage);
        this.configContentPanel(null);
    }

    private void configContentPanel(List<ChatContextTag> tags) {
        this.getTagsPanel().setVisible(false);
        this.questionText.setVisible(true);
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    private void showChatFilteredMessage(String requestId) {
        if (this.requestId.equals(requestId)) {
            this.filteredIconLabel.setEnabled(true);
            this.filteredIconLabel.setVisible(true);
        }
    }

    private void configInlineChatQuestionForm() {
        this.basePanel = new JPanel(new BorderLayout());
        this.userInfoLabel = new AvatarLabel(null, 20);
        ((AvatarLabel)this.userInfoLabel).setHideName(true);
        this.userinfoPanel = new JPanel(new BorderLayout());
        this.userinfoPanel.add((Component)this.userInfoLabel, "North");
        this.filteredIconLabel = new JLabel("");
        this.filterLabelPanel = new JPanel(new BorderLayout());
        this.filterLabelPanel.setBorder((Border)JBUI.Borders.empty());
        this.filterLabelPanel.add((Component)this.filteredIconLabel, "North");
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)0, (int)0, (int)0));
        this.contentPanel.add((Component)this.questionText, "Center");
        this.basePanel.add((Component)this.userinfoPanel, "West");
        this.basePanel.add((Component)this.contentPanel, "Center");
        this.basePanel.add((Component)this.filterLabelPanel, "East");
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public ChatContextTagsPanel getTagsPanel() {
        return this.tagsPanel;
    }
}

