/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.inline;

import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatButtonStateEnum;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayIcon;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class InlineChatInputPanel
extends AskInputPanel {
    private DisplayIcon sendLabel;

    public InlineChatInputPanel(Project project, BaseChatPanel baseChatPanel, String sessionTab) {
        super(project, baseChatPanel, sessionTab);
        this.configBasePanel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    @Override
    protected void configBasePanel() {
        this.basePanel = new RoundRectPanel((LayoutManager)new BorderLayout(), 16);
        this.basePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.basePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.add((Component)this.basePanel, "Center");
        this.basePanel.add((Component)this.inputPanel, "Center");
    }

    @Override
    protected void configInputPanel() {
        this.inputPanel = new RoundRectPanel(new BorderLayout(), 8){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                this.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.inputPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        this.inputPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.inputInternalPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.inputInternalPanel.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        this.inputPanel.add((Component)this.inputTagsPanel, "North");
        this.inputPanel.add((Component)this.jbScrollPane, "Center");
        this.inputPanel.add((Component)this.inputOperationPanel, "South");
        this.inputTagsPanel.setVisible(false);
        this.inputOperationPanel.setVisible(false);
    }

    @Override
    protected void buildInputInternalField() {
        super.buildInputInternalField();
        JPanel sendPanel = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(22, -1);
            }
        };
        sendPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.sendLabel = new DisplayIcon(LingmaIcons.SendActiveIcon);
        sendPanel.add(this.sendLabel);
        this.inputInternalPanel.add((Component)sendPanel, "East");
    }

    @Override
    public void updateSendLayout() {
        int textAreaHeight = this.textArea.getPreferredSize().height;
        int sendBtnSize = this.sendLabel.getPreferredSize().height;
        int scrollBarHeight = this.jbScrollPane.getPreferredSize().height;
        int rightTop = textAreaHeight > scrollBarHeight ? scrollBarHeight - sendBtnSize + this.jbScrollPane.getVerticalScrollBar().getValue() - 8 : scrollBarHeight - sendBtnSize - 8;
        this.sendLabel.setBounds(2, rightTop, sendBtnSize, sendBtnSize);
    }

    public void setSendLabelStatus(InlineChatButtonStateEnum status) {
        for (MouseListener listener : this.sendLabel.getMouseListeners()) {
            this.sendLabel.removeMouseListener(listener);
        }
        switch (status) {
            case INIT: 
            case NEED_CONFIRM: {
                this.sendLabel.setEnabled(false);
                this.sendLabel.setIcon(LingmaIcons.SendDisabledIcon);
                this.sendLabel.setToolTipText(null);
                break;
            }
            case CAN_SEND: {
                this.inputOperationPanel.setSendEnabled(true);
                this.sendLabel.setEnabled(true);
                this.sendLabel.setIcon(LingmaIcons.SendActiveIcon);
                this.sendLabel.setToolTipText(CosyBundle.message("inline.chat.send.tooltip", new Object[0]));
                this.sendLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ((InlineChatPanel)InlineChatInputPanel.this.chatInputContext.getBaseChatPanel()).sendButtonClicked();
                    }
                });
                break;
            }
            case WAIT_FOR_ASK_FINISH: 
            case WAIT_FOR_EDIT_FINISH: {
                this.sendLabel.setEnabled(true);
                this.sendLabel.setIcon(LingmaIcons.StopGrey20Icon);
                this.sendLabel.setToolTipText(CosyBundle.message("inline.chat.stop.tooltip", new Object[0]));
                this.sendLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ((InlineChatPanel)InlineChatInputPanel.this.chatInputContext.getBaseChatPanel()).stopButtonClicked();
                    }
                });
            }
        }
    }

    @Override
    public void setTextAreaPlaceholder() {
        if (CollectionUtils.isEmpty(this.getTags())) {
            boolean isFirstRoundChat;
            this.inputTagsPanel.updateUiTexts();
            GenerateInput initInput = this.chatInputContext.getBaseChatPanel().getInitInput();
            boolean bl = isFirstRoundChat = initInput.getChatHistory() != null && CollectionUtils.isEmpty(initInput.getChatHistory().getAskAnswerList());
            if (BooleanUtils.isTrue((Boolean)isFirstRoundChat)) {
                this.textArea.setPlaceholder(this.getNormalPlaceHolderBySessionTab(this.sessionTab));
            } else {
                this.textArea.setPlaceholder(this.getContinuePlaceHolderBySessionTab(this.sessionTab));
            }
        }
    }

    @Override
    public void clearTagsAfterSend(List<ChatContextTag> tags) {
        this.inputTagsPanel.removeAllTags();
        this.inputTagsPanel.initTags();
    }

    public void setInputTextAreaEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    private String getNormalPlaceHolderBySessionTab(String sessionTab) {
        return CosyBundle.message("inline.chat.placeholder.normal.text", new Object[0]);
    }

    private String getContinuePlaceHolderBySessionTab(String sessionTab) {
        return CosyBundle.message("inline.chat.placeholder.continue.text", new Object[0]);
    }

    @Generated
    public DisplayIcon getSendLabel() {
        return this.sendLabel;
    }
}

