/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat.inline;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class InlineChatAnswerPanel
extends GenerateAnswerPanel {
    protected JPanel cosyLabelPanel;
    protected JLabel chatThinkingLabel;

    public InlineChatAnswerPanel(Project project, BaseChatPanel generateContentForm, JComponent parentComponent, String chatTask, ChatAskInput chatAskInput, SessionTypeEnum sessionType) {
        super(project, generateContentForm, parentComponent, chatTask, chatAskInput, sessionType);
        this.configInlineChatAnswerPanelUI();
    }

    @Override
    protected void configGoodBadCopyListener() {
    }

    @Override
    protected void configContentPanel(JComponent parentComponent) {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        this.markdownPanel = new MarkdownStreamPanel(this.project, parentComponent, this, 0, (LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false), parentComponent.getBackground());
        this.markdownPanel.setOpaque(true);
        this.northPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.contentPanel.add((Component)this.northPanel, "North");
        this.contentPanel.add((Component)this.markdownPanel, "Center");
    }

    private void configInlineChatAnswerPanelUI() {
        this.cosyLabel.setText("");
        this.cosyLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.cosyLabelPanel = new JPanel(new BorderLayout());
        this.cosyLabelPanel.add((Component)this.cosyLabel, "North");
        this.cosyLabelPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.basePanel.setLayout(new BorderLayout());
        this.basePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.basePanel.add((Component)this.cosyLabelPanel, "West");
        this.basePanel.add((Component)this.contentPanel, "Center");
    }

    @Override
    public void showGenerateStatePanel() {
    }

    @Override
    protected MouseAdapter getBasePanelMouseAdapter(JComponent cp) {
        return new MouseAdapter(){};
    }

    @Override
    public void addOrUpdateStep(ChatStep stepItem, boolean isRecoverSession) {
        if (ChatStepEnum.END.getKey().equals(stepItem.getStep())) {
            if (this.chatStagePanel == null) {
                return;
            }
            this.showReferencePanel(ColorUtil.getChatCardChildBackgroundColor(), ColorUtil.getToolWindowBackgroundColor());
            if (this.chatStagePanel != null) {
                this.chatStagePanel.setVisible(false);
                this.chatStagePanel.clearStepsAfterStepEnd();
            }
        } else {
            if (this.chatStagePanel == null) {
                if (ChatStepEnum.START.getKey().equals(stepItem.getStep())) {
                    return;
                }
                this.chatStagePanel = new ChatStagePanel(this.project, this, (LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true), ColorUtil.getToolWindowBackgroundColor());
                this.northPanel.add(this.chatStagePanel);
            }
            if (this.chatStagePanel != null) {
                this.chatStagePanel.setVisible(true);
                this.chatStagePanel.addOrUpdateStepWithBorder(this.project, stepItem, isRecoverSession, ColorUtil.getToolWindowBackgroundColor(), (Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)0));
            }
        }
        if (this.chatStagePanel != null) {
            this.chatStagePanel.revalidate();
            this.chatStagePanel.repaint();
        }
    }

    @Override
    public void updateThinkingPanel(String text, boolean isDone, boolean isRecoverSession, Long thinkTime) {
        if (this.chatThinkingLabel == null) {
            this.chatThinkingLabel = new JLabel();
            this.chatThinkingLabel.setIcon(LingmaIcons.StatusBarLoadingIcon);
            this.chatThinkingLabel.setText(CosyBundle.message("chat.answer.deep.thinking.label", new Object[0]));
            this.chatThinkingLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
            this.northPanel.add(this.chatThinkingLabel);
        }
        if (isDone) {
            this.chatThinkingLabel.setIcon(LingmaIcons.SuccessGreenIcon);
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }
}

