/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

public class ChatMessageQueuePanel
extends JPanel {
    private static final int MAX_DISPLAY_LIST_HEIGHT = 90;
    private int messageCount;
    private final JLabel titleLabel;
    private final JScrollPane scrollPane;
    private final JPanel listPanel;
    private ChatMessageItemPanel lastItemPanel;

    public ChatMessageQueuePanel(Project project, @NotNull List<ChatMessageItem> messages) {
        if (messages == null) {
            ChatMessageQueuePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.messageCount = messages.size();
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)4, (int)12));
        this.lastItemPanel = null;
        this.titleLabel = new JLabel(CosyBundle.message("chat.message.queue.title", this.messageCount));
        this.titleLabel.setIcon(LingmaIcons.ArrowrightEmptyGreyIcon);
        JPanel titlePanel = new JPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        titlePanel.setPreferredSize(new Dimension(-1, 32));
        titlePanel.add((Component)this.titleLabel, "West");
        SwingUtil.foreachChildComponent(titlePanel, cp -> cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ChatMessageQueuePanel.this.scrollPane.isVisible()) {
                    ChatMessageQueuePanel.this.titleLabel.setIcon(LingmaIcons.ArrowrightEmptyGreyIcon);
                    ChatMessageQueuePanel.this.scrollPane.setVisible(false);
                } else {
                    ChatMessageQueuePanel.this.titleLabel.setIcon(LingmaIcons.ArrowdownEmptyGreyIcon);
                    ChatMessageQueuePanel.this.scrollPane.setVisible(true);
                }
                ChatMessageQueuePanel.this.revalidate();
                ChatMessageQueuePanel.this.repaint();
            }
        }));
        this.listPanel = new JPanel((LayoutManager)new VerticalLayout(4)){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.listPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10, (int)0, (int)10));
        for (ChatMessageItem message : messages) {
            this.listPanel.add(new ChatMessageItemPanel(message));
        }
        this.scrollPane = new JBScrollPane(this.listPanel){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 90) {
                    size.height = 90;
                }
                return size;
            }
        };
        this.scrollPane.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setVisible(false);
        RoundRectPanel basePanel = new RoundRectPanel(new BorderLayout(), 16){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        basePanel.add((Component)titlePanel, "North");
        basePanel.add((Component)this.scrollPane, "Center");
        basePanel.setOpaque(true);
        this.add((Component)basePanel, "Center");
        SwingUtil.foreachChildComponent(basePanel, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        titlePanel.setOpaque(false);
        SwingUtil.foreachChildComponent(this.scrollPane, cp -> cp.setOpaque(false));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
    }

    public void offerMessage(ChatMessageItem message) {
        ++this.messageCount;
        this.listPanel.add(new ChatMessageItemPanel(message));
        this.setVisible(true);
        SwingUtilities.invokeLater(this::updateUiTexts);
        this.revalidate();
        this.repaint();
    }

    public ChatMessageItem pollMessage() {
        ChatMessageItem res = null;
        if (ArrayUtils.isNotEmpty((Object[])this.listPanel.getComponents())) {
            ChatMessageItemPanel component = (ChatMessageItemPanel)this.listPanel.getComponents()[0];
            res = component.messageItem;
            --this.messageCount;
            this.listPanel.remove(0);
            this.setVisible(this.messageCount > 0);
            SwingUtilities.invokeLater(this::updateUiTexts);
        }
        return res;
    }

    protected void updateUiTexts() {
        this.titleLabel.setText(CosyBundle.message("chat.message.queue.title", this.messageCount));
        this.revalidate();
        this.repaint();
    }

    public boolean hasMessage() {
        return this.messageCount > 0;
    }

    public void clearMessage() {
        this.messageCount = 0;
        this.listPanel.removeAll();
        this.setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/alibabacloud/intellij/cosy/ui/chat/ChatMessageQueuePanel", "<init>"));
    }

    public static class ChatMessageItem {
        private String text;
        private String actionId;
        private List<ChatAskTag> tags;
        private ChatAskInput chatAskInput;

        @Generated
        public ChatMessageItem() {
        }

        @Generated
        public ChatMessageItem(String text, String actionId, List<ChatAskTag> tags, ChatAskInput chatAskInput) {
            this.text = text;
            this.actionId = actionId;
            this.tags = tags;
            this.chatAskInput = chatAskInput;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getActionId() {
            return this.actionId;
        }

        @Generated
        public List<ChatAskTag> getTags() {
            return this.tags;
        }

        @Generated
        public ChatAskInput getChatAskInput() {
            return this.chatAskInput;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Generated
        public void setTags(List<ChatAskTag> tags) {
            this.tags = tags;
        }

        @Generated
        public void setChatAskInput(ChatAskInput chatAskInput) {
            this.chatAskInput = chatAskInput;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChatMessageItem)) {
                return false;
            }
            ChatMessageItem other = (ChatMessageItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$actionId = this.getActionId();
            String other$actionId = other.getActionId();
            if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
                return false;
            }
            List<ChatAskTag> this$tags = this.getTags();
            List<ChatAskTag> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            ChatAskInput this$chatAskInput = this.getChatAskInput();
            ChatAskInput other$chatAskInput = other.getChatAskInput();
            return !(this$chatAskInput == null ? other$chatAskInput != null : !this$chatAskInput.equals(other$chatAskInput));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChatMessageItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $actionId = this.getActionId();
            result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
            List<ChatAskTag> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            ChatAskInput $chatAskInput = this.getChatAskInput();
            result = result * 59 + ($chatAskInput == null ? 43 : $chatAskInput.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChatMessageQueuePanel.ChatMessageItem(text=" + this.getText() + ", actionId=" + this.getActionId() + ", tags=" + this.getTags() + ", chatAskInput=" + this.getChatAskInput() + ")";
        }
    }

    private class ChatMessageItemPanel
    extends RoundRectPanel {
        private final ChatMessageItem messageItem;
        private final JLabel deleteLabel;
        private final JLabel messageLabel;

        public ChatMessageItemPanel(final ChatMessageItem messageItem) {
            super((LayoutManager)new BorderLayout(), 8);
            this.messageItem = messageItem;
            this.setPreferredSize(new Dimension(0, 24));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            this.setCornorBackgroundColor(ColorUtil.getEditorBackgroundColor());
            this.deleteLabel = new JLabel(LingmaIcons.DeleteGreyIcon);
            this.deleteLabel.setVisible(false);
            this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.messageLabel = new JLabel();
            this.messageLabel.setText(FontUtil.getStringAdaptiveWidth(this.messageLabel, this.getText(messageItem), this.getLabelMaxLength(), false));
            this.messageLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.add((Component)this.messageLabel, "West");
            this.add((Component)this.deleteLabel, "East");
            SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ChatMessageItemPanel.this.handleMouseEntered();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SwingUtil.foreachChildComponent(ChatMessageItemPanel.this, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
                    ChatMessageItemPanel.this.deleteLabel.setVisible(false);
                    ChatMessageQueuePanel.this.lastItemPanel = null;
                }
            });
            this.deleteLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ChatMessageItemPanel.this.handleMouseEntered();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    ChatMessageQueuePanel.this.listPanel.remove(ChatMessageItemPanel.this);
                    --ChatMessageQueuePanel.this.messageCount;
                    ChatMessageQueuePanel.this.setVisible(ChatMessageQueuePanel.this.messageCount > 0);
                    ChatMessageQueuePanel.this.updateUiTexts();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SwingUtilities.invokeLater(() -> {
                        Point locationOnScreen;
                        Rectangle rectangle = new Rectangle(ChatMessageItemPanel.this.getLocationOnScreen(), ChatMessageItemPanel.this.getSize());
                        if (!rectangle.contains(locationOnScreen = MouseInfo.getPointerInfo().getLocation())) {
                            SwingUtil.foreachChildComponent(ChatMessageItemPanel.this, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
                            ChatMessageItemPanel.this.deleteLabel.setVisible(false);
                            ChatMessageQueuePanel.this.lastItemPanel = null;
                        }
                    });
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int maxLength = ChatMessageItemPanel.this.getLabelMaxLength();
                    ChatMessageItemPanel.this.messageLabel.setText(FontUtil.getStringAdaptiveWidth(ChatMessageItemPanel.this.messageLabel, ChatMessageItemPanel.this.getText(messageItem), maxLength, false));
                    ChatMessageItemPanel.this.messageLabel.setSize(new Dimension(maxLength, ChatMessageItemPanel.this.messageLabel.getHeight()));
                    ChatMessageItemPanel.this.revalidate();
                    ChatMessageItemPanel.this.repaint();
                }
            });
        }

        private String getText(ChatMessageItem messageItem) {
            if (null == messageItem.chatAskInput || CollectionUtils.isEmpty(messageItem.chatAskInput.getChatInputElements())) {
                return messageItem.text;
            }
            StringBuilder sb = new StringBuilder();
            for (ChatInputElement element : messageItem.chatAskInput.getChatInputElements()) {
                sb.append("text".equals(element.getType()) ? element.getText() : element.getTag().getDisplayText()).append(" ");
            }
            return sb.toString().trim();
        }

        private void handleMouseEntered() {
            if (null != ChatMessageQueuePanel.this.lastItemPanel && ChatMessageQueuePanel.this.lastItemPanel != this) {
                SwingUtil.foreachChildComponent(ChatMessageQueuePanel.this.lastItemPanel, cp -> cp.setBackground(ColorUtil.getToolWindowBackgroundColor()));
                ChatMessageQueuePanel.this.lastItemPanel.deleteLabel.setVisible(true);
            }
            SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getToolWindowBackgroundColor()));
            this.deleteLabel.setVisible(true);
            ChatMessageQueuePanel.this.lastItemPanel = this;
        }

        private int getLabelMaxLength() {
            Insets insets = this.getInsets();
            return this.getWidth() - insets.left - insets.right - this.deleteLabel.getWidth() - 28;
        }

        @Generated
        public ChatMessageItem getMessageItem() {
            return this.messageItem;
        }

        @Generated
        public JLabel getDeleteLabel() {
            return this.deleteLabel;
        }

        @Generated
        public JLabel getMessageLabel() {
            return this.messageLabel;
        }
    }
}

