/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat;

import com.alibabacloud.intellij.cosy.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.cosy.constants.ActionConstants;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatAgentPanel;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TabLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperGenerateStepCallbackNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperGenerateStreamStopNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatDeleteNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.WorkspaceFileModifiedNotifier;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.RecentQueryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatContentPanel
extends BaseChatAgentPanel {
    private static final Logger log = Logger.getInstance(ChatContentPanel.class);

    public ChatContentPanel(Project project) {
        super(project);
    }

    @Override
    protected String getChatMainVerticalScrollbarKey() {
        return "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY";
    }

    @Override
    protected void registerMessageListener() {
        super.registerMessageListener();
        this.messageBusConnection.subscribe(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION, this::pushGenerate);
        this.messageBusConnection.subscribe(AiDeveloperGenerateStreamStopNotifier.AI_DEVELOPER_GENERATE_STREAM_STOP_NOTIFICATION, this::stopGenerate);
        this.messageBusConnection.subscribe(AiDeveloperStreamPauseNotifier.AI_DEVELOPER_STREAM_PAUSE_NOTIFICATION, this::pauseGenerate);
        this.messageBusConnection.subscribe(AiDeveloperGenerateStepCallbackNotifier.AI_DEVELOPER_GENERATE_PROCESS_STEP_CALLBACK_NOTIFICATION, this::processStepCallback);
        this.messageBusConnection.subscribe(WorkspaceFileModifiedNotifier.WORKSPACE_FILE_MODIFIED_NOTIFICATION, this::updateSendButtonByFileStatus);
        this.messageBusConnection.subscribe(ChatDeleteNotifier.CHAT_DELETE_NOTIFICATION, this::deleteChat);
    }

    @Override
    public void switchPanel(LingmaToolWindowPanel toolWindowPanel) {
        super.switchPanel(toolWindowPanel);
        ((TabLabel)toolWindowPanel.getAiDeveloperTabBtn()).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
        ((TabLabel)toolWindowPanel.getChatTabBtn()).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
    }

    @Override
    public SessionTypeEnum getSessionTypeEnum() {
        return SessionTypeEnum.DEVELOPER;
    }

    @Override
    public String getSessionTab() {
        return "AiDeveloper";
    }

    @Override
    public String getWelcomeMessage() {
        return CosyBundle.messageVpc("message.developer.quick.ask", new Object[0]);
    }

    @Override
    protected void setupTextArea() {
        this.inputPanel.setTextAreaPlaceholder();
        this.inputPanel.addEnterKeyListener(text -> {
            List taskTagList;
            List<ChatInputElement> elements = ChatTaskUtil.convertTextToElements(this.inputPanel.getTextArea());
            List<ChatAskTag> tags = ChatTaskUtil.getTagsByElements(elements);
            List<ChatContextTag> contextTags = this.inputPanel.inputTagsPanel.getTags();
            if (CollectionUtils.isEmpty(elements)) {
                this.inputPanel.clearTextArea();
                this.inputPanel.clearTags();
                return;
            }
            SuggestPromptPopupPanel suggestPromptPopupPanel = this.inputPanel.getChatInputSuggester().getSuggestPromptPopupPanel();
            SuggestPrompt suggestPrompt = suggestPromptPopupPanel.chooseSuggestPromptSelection();
            if (suggestPrompt != null) {
                suggestPromptPopupPanel.triggerChooseSuggestPrompt(suggestPrompt);
                return;
            }
            if (!this.inputPanel.isSendEnabled()) {
                log.info("send button is not enabled");
                NotificationFactory.showToast((JComponent)this.inputPanel.getInputOperationPanel().getSendLabel(), MessageType.INFO, CosyBundle.message("notifications.send.button.answering", new Object[0]));
                return;
            }
            this.inputPanel.clearAfterSent();
            String actionId = null;
            if (CollectionUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(taskTagList = tags.stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList())) && (actionId = InputConstants.TASK_SLASH_ACTION_MAP.get(((ChatAskTag)taskTagList.get(0)).getText())) == null) {
                actionId = ActionConstants.TRIGGER_COSY_CUSTOM_COMMAND_ACTION;
            }
            ChatAskInput chatAskInput = new ChatAskInput();
            chatAskInput.setChatInputElements(elements);
            chatAskInput.setContextTags(contextTags);
            if (StringUtils.isEmpty(actionId)) {
                this.initInput.setChatAskInput(chatAskInput);
                this.triggerAiDeveloperAsk(this.initInput, text);
                return;
            }
            String finalActionId = actionId;
            RecentQueryUtil.addRecentComplexQuery(this.project, chatAskInput);
            SwingUtilities.invokeLater(() -> ActionTriggerHelper.triggerSelectionAction(this.project, finalActionId, TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), chatAskInput));
        });
    }

    private void triggerAiDeveloperAsk(GenerateInput input, String text) {
        this.triggerAgentAsk(input, text);
    }

    @Override
    public String getNewChatText() {
        return CosyBundle.message("main.toolbar.btn.new.task", new Object[0]);
    }
}

