/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileChangedTypeEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.SimpleTextDto;
import com.alibabacloud.intellij.cosy.constants.ActionConstants;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatDeleteResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkingSpaceFileInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkspaceFileSyncResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ListWorkingSpaceFileBySnapshotParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.cosy.editor.InlineDiffManager;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.SnapshotService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.impl.SnapshotServiceImpl;
import com.alibabacloud.intellij.cosy.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotOperateEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.TaskChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskItem;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCreateNewChatNotifier;
import com.alibabacloud.intellij.cosy.util.ChatSessionUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.RecentQueryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChatAgentPanel
extends BaseChatPanel {
    private static final Logger log = Logger.getInstance(BaseChatAgentPanel.class);
    protected final SnapshotService snapshotService = new SnapshotServiceImpl();

    public BaseChatAgentPanel(Project project) {
        super(project);
        SwingUtilities.invokeLater(() -> this.showWelcomeInfoPanel(true));
    }

    @Override
    protected void showWelcomeInfoPanel(boolean startup) {
        super.showWelcomeInfoPanel(startup);
        this.hideWorkingSpacePanel();
    }

    @Override
    protected void hideWelcomeInfoPanel() {
        super.hideWelcomeInfoPanel();
        this.showWorkingSpacePanel();
    }

    protected void showWorkingSpacePanel() {
        if (this.workingSpacePanel != null && !this.workingSpacePanel.isShowing()) {
            this.workingSpacePanel.clear();
            this.workingSpacePanel.setVisible(true);
        }
    }

    private void hideWorkingSpacePanel() {
        if (this.workingSpacePanel != null) {
            this.workingSpacePanel.clear();
            this.workingSpacePanel.setVisible(false);
        }
    }

    @Override
    public void clearChat(String sessionId, String requestId) {
        if (this.answerPanel != null) {
            this.answerPanel.hideBottomPanel();
        }
        super.clearChat(sessionId, requestId);
    }

    @Override
    protected void updateUiTexts() {
        super.updateUiTexts();
        this.workingSpacePanel.updateUiTexts();
    }

    @Override
    protected String getChatTaskForAsynchronousChat(GenerateInput input) {
        return input.getChatTask();
    }

    @Override
    public void prepareAnswer(GenerateInput input, String chatTask, String displayText, String requestId) {
        if (this.answerPanel != null) {
            this.answerPanel.hideBottomPanel();
        }
        if (this.chatQuestionForm != null && StringUtils.isNotEmpty((CharSequence)this.chatQuestionForm.getRequestId())) {
            this.workingSpacePanel.changeCurrentSnapshotStatus(SnapshotOperateEnum.UPDATE_CHAT_RECORD);
        }
        if (ChatTaskEnum.RETRY_TASK.getName().equals(chatTask)) {
            this.processRetry(chatTask, requestId);
            return;
        }
        this.doPrepareAnswer(input, chatTask, displayText, requestId);
    }

    private void processRetry(String chatTask, String requestId) {
        if (!ChatTaskEnum.RETRY_TASK.getName().equals(chatTask)) {
            return;
        }
        this.chatQuestionForm.setRequestId(requestId);
        this.answerPanel.setRequestId(requestId);
        this.answerPanel.clearForRetry();
        InlineDiffManager.Companion.getInstance().closeAllEditor(this.project);
    }

    @Override
    public void scrollToAnswerPanel(String requestId) {
        Component[] components;
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return;
        }
        log.debug("scrollToAnswerPanel requestId=" + requestId);
        for (Component component : components = this.flowPanel.getComponents()) {
            String name = component.getName();
            if (StringUtils.isBlank((CharSequence)name)) continue;
            log.debug("scrollToAnswerPanel name=" + name);
            if (!name.startsWith("GenerateAnswerPanel_BasePanel_" + requestId)) continue;
            if (component instanceof RoundRectPanel) {
                RoundRectPanel roundRectPanel = (RoundRectPanel)component;
                roundRectPanel.setBorderColor(JBUI.CurrentTheme.Focus.focusColor());
                roundRectPanel.invalidate();
                roundRectPanel.repaint();
                Timer timer = this.getScrollFocusTimer(roundRectPanel);
                timer.start();
            }
            Rectangle bounds = component.getBounds();
            this.scrollPane.getVerticalScrollBar().setValue(bounds.y);
            return;
        }
    }

    @NotNull
    private Timer getScrollFocusTimer(final RoundRectPanel roundRectPanel) {
        Timer timer = new Timer(3000, new AbstractAction(){
            private static final long serialVersionUID = 7963242014844964532L;

            @Override
            public void actionPerformed(ActionEvent e) {
                roundRectPanel.setBorderColor(null);
                roundRectPanel.invalidate();
                roundRectPanel.repaint();
            }
        });
        timer.setRepeats(false);
        Timer timer2 = timer;
        if (timer2 == null) {
            BaseChatAgentPanel.$$$reportNull$$$0(0);
        }
        return timer2;
    }

    public void moveDownRelatively(int relativeHeight) {
        this.flowPanel.validate();
        this.scrollPane.validate();
        this.scrollPane.getVerticalScrollBar().setValue(Math.min(this.scrollPane.getVerticalScrollBar().getMaximum(), this.scrollPane.getVerticalScrollBar().getValue() + relativeHeight));
    }

    @Override
    protected void recoverFileListFromSession(GenerateAnswerPanel answerPanel) {
        Component[] components = answerPanel.getMarkdownPanel().getComponents();
        if (components == null || components.length == 0) {
            return;
        }
        if (null == answerPanel.getRequestId()) {
            log.warn("requestId is null, sessionId is " + answerPanel.getSessionId());
            return;
        }
        List<WorkingSpaceFileInfo> list = this.snapshotService.listWorkingSpaceFiles(this.project, ListWorkingSpaceFileBySnapshotParams.builder().sessionId(answerPanel.getSessionId()).requestId(answerPanel.getRequestId()).build());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map fileMap = list.stream().collect(Collectors.toMap(WorkingSpaceFileInfo::getId, Function.identity()));
        for (Component component : components) {
            AIDevFilePanel filePanel;
            if (!(component instanceof AIDevFilePanel) && !(component instanceof ToolPanel)) continue;
            if (component instanceof ToolPanel) {
                AIDevFilePanel aiDevFilePanel = ((ToolPanel)component).getAiDevFilePanel();
                if (null == aiDevFilePanel) continue;
                filePanel = aiDevFilePanel;
            } else {
                filePanel = (AIDevFilePanel)component;
            }
            Component[] fileItemPanels = filePanel.getListPanel().getComponents();
            if (fileItemPanels == null || fileItemPanels.length == 0) continue;
            ArrayList<AIDevFilePanel.FileItem> itemList = new ArrayList<AIDevFilePanel.FileItem>();
            for (Component fileItemComponent : fileItemPanels) {
                AIDevFilePanel.FileItemPanel fileItemPanel;
                AIDevFilePanel.FileItem fileItem;
                if (fileItemComponent == null || !(fileItemComponent instanceof AIDevFilePanel.FileItemPanel) || (fileItem = (fileItemPanel = (AIDevFilePanel.FileItemPanel)fileItemComponent).getFileItem()) == null) continue;
                WorkingSpaceFileInfo fileInfo = (WorkingSpaceFileInfo)fileMap.get(fileItemPanel.getFileItem().getId());
                if (fileInfo != null) {
                    fileItem.setStatus(AIDevFileStatusEnum.getById(fileInfo.getStatus()));
                    fileItem.setChangedType(AIDevFileChangedTypeEnum.getById(fileInfo.getMode()));
                } else {
                    log.warn("find WorkingSpaceFileInfo failed, id: " + fileItemPanel.getFileItem().getId());
                    fileItem.setStatus(AIDevFileStatusEnum.UNKNOWN);
                }
                itemList.add(fileItem);
            }
            filePanel.refreshFileItems(itemList);
        }
    }

    @Override
    protected void recoverToolCallListFromSession(GenerateAnswerPanel answerPanel, List<ToolCallSyncResult> toolCallSyncResults) {
        Component[] components = answerPanel.getMarkdownPanel().getComponents();
        if (components == null || components.length == 0) {
            return;
        }
        if (null == answerPanel.getRequestId()) {
            log.warn("requestId is null, sessionId is " + answerPanel.getSessionId());
            return;
        }
        List list = toolCallSyncResults.stream().filter(t -> answerPanel.getRequestId().equals(t.getRequestId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map toolCallInfoMap = list.stream().collect(Collectors.toMap(ToolCallSyncResult::getToolCallId, Function.identity()));
        for (Component component : components) {
            if (!(component instanceof ToolPanel)) continue;
            ToolPanel toolPanel = (ToolPanel)component;
            ToolCallSyncResult toolCallSyncResult = (ToolCallSyncResult)toolCallInfoMap.get(toolPanel.toolCallId);
            if (toolCallSyncResult == null) continue;
            toolPanel.syncToolCall(toolCallSyncResult);
        }
    }

    @Override
    protected void doRecoverSession(ChatSession chatSession) {
        this.chatViewPanel.getTodoViewPanel().setVisible(false);
        super.doRecoverSession(chatSession);
        this.workingSpacePanel.resetWorkspaceFromHistory(chatSession.getSessionId(), chatSession.getSessionType());
        this.inputPanel.clearAll();
        this.chatViewPanel.getMessageQueuePanel().clearMessage();
    }

    @Override
    public void createNewTask(LingmaToolWindowPanel toolPanel, Point location) {
        this.stopSessionChat();
        toolPanel.switchChatPanel(this);
        this.initFlowPanel();
    }

    @Override
    public void initFlowPanel() {
        super.initFlowPanel();
        this.workingSpacePanel.clear();
        this.chatViewPanel.getTodoViewPanel().setVisible(false);
        this.chatViewPanel.getMessageQueuePanel().clearMessage();
    }

    protected boolean noApplyingFiles(String nonApplyingFileId) {
        MarkdownStreamPanel markdownStreamPanel = this.answerPanel.getMarkdownPanel();
        Component[] components = markdownStreamPanel.getComponents();
        List devFilePanels = Arrays.stream(components).filter(component -> component instanceof AIDevFilePanel).collect(Collectors.toList());
        this.applyingFileIds = new ArrayList();
        for (Component devFilePanel : devFilePanels) {
            Component[] fileItemPanels;
            for (Component fileItemPanel : fileItemPanels = ((AIDevFilePanel)devFilePanel).getListPanel().getComponents()) {
                AIDevFilePanel.FileItem fileItem;
                if (!(fileItemPanel instanceof AIDevFilePanel.FileItemPanel) || (fileItem = ((AIDevFilePanel.FileItemPanel)fileItemPanel).getFileItem()) == null || fileItem.getId() == null || fileItem.getId().equals(nonApplyingFileId) || !AIDevFileStatusEnum.APPLYING.equals((Object)fileItem.getStatus())) continue;
                this.applyingFileIds.add(fileItem.getId());
            }
        }
        return CollectionUtils.isEmpty((Collection)this.applyingFileIds);
    }

    protected void updateSendButtonByFileStatus(WorkspaceFileSyncResult syncResult) {
        WorkingSpaceFileInfo fileInfo = syncResult.getWorkingSpaceFile();
        if (CollectionUtils.isEmpty((Collection)this.applyingFileIds)) {
            return;
        }
        if (AIDevFileStatusEnum.APPLYING.getId().equals(fileInfo.getStatus()) || !this.applyingFileIds.contains(fileInfo.getId())) {
            return;
        }
        if (this.noApplyingFiles(fileInfo.getId())) {
            this.enableSendButton();
        }
    }

    protected void deleteChat(ChatDeleteResult result) {
        Component[] components;
        String requestId = result.getRequestId();
        log.debug("deleteChat requestId=" + requestId);
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return;
        }
        for (Component component : components = this.flowPanel.getComponents()) {
            String name = component.getName();
            if (StringUtils.isBlank((CharSequence)name)) continue;
            if (name.startsWith("GenerateAnswerPanel_BasePanel_" + requestId)) {
                this.flowPanel.remove(component);
                continue;
            }
            if (!name.startsWith("ChatQuestionForm_BasePanel_" + requestId)) continue;
            this.flowPanel.remove(component);
        }
    }

    protected void triggerAgentAsk(GenerateInput input, String text) {
        boolean containsCode;
        List builtInTask;
        List<ChatAskTag> chatAskTags;
        SessionTypeEnum sessionTypeEnum = this.getSessionTypeEnum();
        String requestId = ChatSessionUtil.getRequestId(sessionTypeEnum.getType());
        ChatSessionUtil.updateAnsweringStatus(requestId);
        ChatAskInput chatAskInput = input.getChatAskInput();
        if (StringUtils.isBlank((CharSequence)input.getChatAskInput().getText())) {
            chatAskTags = chatAskInput.getTags();
            if (CollectionUtils.isEmpty(chatAskTags)) {
                return;
            }
            List tagsAllowTextNull = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType()) || AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagsAllowTextNull)) {
                return;
            }
        }
        if (CollectionUtils.isEmpty(builtInTask = (chatAskTags = chatAskInput.getTags()).stream().filter(chatAskTag -> "task".equals(chatAskTag.getType())).collect(Collectors.toList()))) {
            String actionId;
            SuggestPrompt suggestPrompt;
            String actionId2;
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_SELECTION_CODE_ACTION_LIST.contains(actionId2 = (suggestPrompt = InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1))).getActionCommand().substring("action:".length()))) {
                this.inputPanel.addTag(new TaskChatAskTag(suggestPrompt.getId(), suggestPrompt.getText()));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_COSY_CLEAR_HISTORY_ACTION.equals(actionId = InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().substring("action:".length()))) {
                this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.NEW_TASK_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.NEW_TASK_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:")) {
                Point inputLocation = this.inputPanel.getInputPanel().getLocationOnScreen();
                ((LingmaCreateNewChatNotifier)this.project.getMessageBus().syncPublisher(LingmaCreateNewChatNotifier.CREATE_NEW_CHAT_NOTIFICATION)).createNewChat(new Point(inputLocation.x, inputLocation.y + 10));
                return;
            }
        }
        input.setChatTask(ChatTaskEnum.FREE_INPUT.name());
        this.inputPanel.resetRecentQueryIndex();
        RecentQueryUtil.addRecentComplexQuery(this.project, input.getChatAskInput());
        input.setQuestion(text);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        simpleTextDto.setText(text);
        input.setQuestionObject(simpleTextDto);
        boolean isFirstRoundChat = input.getChatHistory() != null && CollectionUtils.isEmpty(input.getChatHistory().getAskAnswerList());
        boolean bl = containsCode = input.getChatContext() != null && StringUtils.isNotBlank((CharSequence)input.getChatContext().getSourceCode()) && StringUtils.isNotBlank((CharSequence)input.getChatContext().getFilePath());
        if (isFirstRoundChat && containsCode) {
            this.questionCodeWithExt = CodeWithExt.builder().content(input.getChatContext().getSourceCode()).filePath(input.getChatContext().getFilePath()).ext(FileUtil.getPathExt(input.getChatContext().getFilePath())).build();
        }
        TelemetryService.getInstance().telemetryChatTask(this.project, TrackEventTypeEnum.CHAT_FREE_INPUT, requestId, input.getChatContext().getSessionId(), ChatTaskEnum.FREE_INPUT.getName(), input, sessionTypeEnum.getTelemetryType());
        this.prepareAndAsynchronousChat(input, text, text, requestId);
        ChatSessionUtil.updateRequestId(sessionTypeEnum.getType());
    }

    protected boolean needShowWorkingSpacePanel() {
        return this.workingSpacePanel != null && !this.workingSpacePanel.isShowing() && 0 != this.workingSpacePanel.getFileCount();
    }

    @Override
    protected void processStepCallback(String requestId, String sessionId, ChatStep chatStep) {
        super.processStepCallback(requestId, sessionId, chatStep);
        this.checkIfNeedShowWorkingSpacePanel();
    }

    protected void checkIfNeedShowWorkingSpacePanel() {
        if (this.needShowWorkingSpacePanel()) {
            this.workingSpacePanel.setVisible(true);
            this.workingSpacePanel.revalidate();
            this.workingSpacePanel.repaint();
        }
    }

    @Override
    public void reloadTodoViewPanel(List<TaskItem> taskItems) {
        this.chatViewPanel.getTodoViewPanel().reloadTaskTree(taskItems);
        this.chatViewPanel.setVisible(true);
        this.chatViewPanel.getTodoViewPanel().setVisible(true);
        this.chatViewPanel.revalidate();
        this.chatViewPanel.repaint();
    }

    @Override
    public void summaryTodoViewPanel() {
        if (this.chatViewPanel.getTodoViewPanel().isVisible()) {
            this.chatViewPanel.getTodoViewPanel().summaryTask();
            this.chatViewPanel.revalidate();
            this.chatViewPanel.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/chat/BaseChatAgentPanel", "getScrollFocusTimer"));
    }
}

