/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.chat;

import com.alibabacloud.intellij.cosy.chat.context.aidev.AIDevFileContextProvider;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileChangedTypeEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileOptionEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.OperateCommonResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkingSpaceFileInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkingSpaceFileParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkspaceFileSyncResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.WorkingSpaceFileOperateParams;
import com.alibabacloud.intellij.cosy.editor.InlineDiffManager;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.ModeService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.enums.TextChangeTypeEnum;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.service.model.AssistantTextChangeSourceMetric;
import com.alibabacloud.intellij.cosy.service.model.BaseTextChangeSourceMetric;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.Snapshot;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.WorkspaceFileModifiedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.IconUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.NumberUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

public class AIDevFilePanel
extends JPanel {
    private static final Logger log = Logger.getInstance(AIDevFilePanel.class);
    private static final Debouncer debouncer = new Debouncer();
    public static final int DEFAULT_CORNER_RADIUS = 8;
    public static final int TOOL_PANEL_CORNER_RADIUS = 16;
    public static final int DEFAULT_LEFT_RIGHT_MARGIN_CHAT_CARD = 12;
    public static final int DEFAULT_FILE_ITEM_MARGIN = 4;
    public static final String NUMBER_UNCHANGED = "0";
    public static final float FONT_SIZE_FILE_NAME = 13.0f;
    public static final float FONT_SIZE_AUXILIARY = 12.0f;
    public static final int MAX_DISPLAY_LIST_HEIGHT = 236;
    private static FileItemPanel lastHovered = null;
    public static final String NAME_FILE_LIST_PANEL = "file_list_panel";
    public static final String NAME_FILE_ITEM_PANEL = "file_item_panel";
    public static final String NAME_FILE_NAME_LABEL = "file_name_label";
    public static final String NAME_FILE_REJECT_LABEL = "file_reject_label";
    public static final String NAME_FILE_ACCEPT_LABEL = "file_accept_label";
    public static final String NAME_UNCHANGED_PANEL = "unchanged_panel";
    public static final String NAME_AI_DEV_FILE_PANEL = "ai_dev_file_panel";
    private static JBPopup filePathTreePopup;
    private JPanel contentPanel;
    private JBScrollPane jbScrollPane;
    private JPanel listPanel;
    private JPanel unchangedPanel;
    private AIDevFileUsageEnum usage;
    private Project project;
    private CosyService cosyService;
    private MessageBusConnection messageBusConnection;

    public AIDevFilePanel(Project project, AIDevFileUsageEnum usage, List<FileItem> referenceItems) {
        super(new BorderLayout());
        this.usage = usage;
        this.project = project;
        this.cosyService = new CosyServiceImpl();
        this.messageBusConnection = project.getMessageBus().connect();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 240));
        JLabel unchangedLabel = new JLabel(CosyBundle.message("ai.dev.file.list.unchanged", new Object[0]), 2){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        unchangedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        unchangedLabel.setPreferredSize(new Dimension(0, 24));
        this.unchangedPanel = new JPanel((LayoutManager)new VerticalLayout(4)){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.unchangedPanel.setName(NAME_UNCHANGED_PANEL);
        this.unchangedPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)12, (int)2, (int)12));
        this.unchangedPanel.add(unchangedLabel);
        this.listPanel = new JPanel((LayoutManager)new VerticalLayout(usage.getVerticalGap()));
        this.listPanel.setName(NAME_FILE_LIST_PANEL);
        this.listPanel.setBorder(usage.getBorder());
        referenceItems.forEach(item -> this.listPanel.add(this.constructFileitemPanel(project, usage, (FileItem)item)));
        this.listPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (Component comp : AIDevFilePanel.this.listPanel.getComponents()) {
                    if (!(comp instanceof FileItemPanel)) continue;
                    FileItemPanel cp = (FileItemPanel)comp;
                    if (AIDevFilePanel.this.listPanel.getWidth() <= 0) continue;
                    cp.getFileItem().getStatus().getContextProvider().handleFileNameArea(AIDevFilePanel.this.listPanel, cp);
                }
                AIDevFilePanel.this.listPanel.revalidate();
                AIDevFilePanel.this.listPanel.repaint();
            }
        });
        this.jbScrollPane = new JBScrollPane(CollectionUtils.isEmpty(referenceItems) ? this.unchangedPanel : this.listPanel){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 236) {
                    size.height = 236;
                }
                return size;
            }
        };
        this.jbScrollPane.setOpaque(false);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.jbScrollPane.setHorizontalScrollBarPolicy(31);
        this.jbScrollPane.setVerticalScrollBarPolicy(20);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.contentPanel, "Center");
        this.setName(NAME_AI_DEV_FILE_PANEL);
        this.contentPanel.add((Component)this.jbScrollPane, "Center");
        if (usage == AIDevFileUsageEnum.WORKING_SPACE) {
            this.listPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        } else {
            this.listPanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        }
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
    }

    private void updateUiTexts() {
        ((JLabel)this.unchangedPanel.getComponents()[0]).setText(CosyBundle.message("ai.dev.file.list.unchanged", new Object[0]));
        for (Component component : this.listPanel.getComponents()) {
            if (!(component instanceof FileItemPanel)) continue;
            ((FileItemPanel)component).updateUiTexts();
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private FileItemPanel constructFileitemPanel(Project project, AIDevFileUsageEnum usage, FileItem item) {
        log.info("file list usage: " + usage + ". id: " + item.getId() + ". fileId: " + item.getFileId() + ". snapShotId: " + Optional.ofNullable(item.getSnapshot()).map(Snapshot::getId).orElse("null") + ". status: " + Optional.ofNullable(item.getStatus()).map(AIDevFileStatusEnum::getId).orElse("null"));
        FileItemPanel itemPanel = new FileItemPanel(project, usage, item);
        AIDevFileContextProvider contextProvider = item.getStatus().getContextProvider();
        contextProvider.handleFileNameArea(this.listPanel, itemPanel);
        contextProvider.handleDefaultStatus(this.listPanel, itemPanel);
        this.addListenerForFileOperation(itemPanel.getRejectLabel(), AIDevFileOptionEnum.REJECT, itemPanel);
        this.addListenerForFileOperation(itemPanel.getAcceptLabel(), AIDevFileOptionEnum.ACCEPT, itemPanel);
        SwingUtil.foreachChildComponent(itemPanel, cp -> {
            if (!NAME_FILE_REJECT_LABEL.equals(cp.getName()) && !NAME_FILE_ACCEPT_LABEL.equals(cp.getName())) {
                this.addListenerForFilePanelChild(itemPanel, (JComponent)cp);
            }
        });
        FileItemPanel fileItemPanel = itemPanel;
        if (fileItemPanel == null) {
            AIDevFilePanel.$$$reportNull$$$0(0);
        }
        return fileItemPanel;
    }

    private void addListenerForFileOperation(JLabel operationLabel, final AIDevFileOptionEnum operation, final FileItemPanel itemPanel) {
        operationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean fileTabExist;
                OperateCommonResult result;
                WorkingSpaceFileOperateParams params;
                FileItem item = itemPanel.getFileItem();
                boolean isReject = AIDevFileOptionEnum.REJECT == operation;
                WorkingSpaceFileOperateParams workingSpaceFileOperateParams = params = isReject ? WorkingSpaceFileOperateParams.builder().id(item.getId()).opType(AIDevFileOptionEnum.REJECT.getId()).build() : WorkingSpaceFileOperateParams.builder().id(item.getId()).opType(AIDevFileOptionEnum.ACCEPT.getId()).content(InlineDiffManager.Companion.getInstance().getFileContent(AIDevFilePanel.this.project, item.getId())).build();
                if (!isReject && CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                    try {
                        String stableFileContent;
                        FileUtil.saveMemeryFileContentToDisk(AIDevFilePanel.this.project, item.getFileId());
                        String localFileContent = "";
                        if (null != LocalFileSystem.getInstance().findFileByPath(item.getFileId())) {
                            localFileContent = new String(LocalFileSystem.getInstance().findFileByPath(item.getFileId()).contentsToByteArray(), StandardCharsets.UTF_8);
                        }
                        if (!(stableFileContent = Cosy.INSTANCE.getLanguageService(itemPanel.getProject()).getLastStableContent(new WorkingSpaceFileParams(item.getId(), null, null, null), 10000L).getContent()).equals(localFileContent)) {
                            InlineDiffManager.Companion.getInstance().showMultipleDiff(itemPanel.getProject(), item.getSnapshot().getId(), null, item.getId(), false, false, true);
                            return;
                        }
                    }
                    catch (IOException ex) {
                        log.warn("operate file error! operation: " + operation.getId(), (Throwable)ex);
                    }
                }
                if (null != (result = Cosy.INSTANCE.getLanguageService(AIDevFilePanel.this.getProject()).operateWorkingSpaceFile(params, 10000L)) && StringUtils.isNotEmpty((CharSequence)result.getErrorMessage())) {
                    log.warn("operation working space file error! params: " + params + ". error messages: " + result.getErrorMessage());
                }
                if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                    AIDevFilePanel.this.syncFileContentToEditor(!isReject, item.id, item.path);
                } else {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.getFileId());
                    if (null != virtualFile) {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                    }
                }
                itemPanel.acceptLabel.setVisible(false);
                itemPanel.rejectLabel.setVisible(false);
                if (!CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false) && (fileTabExist = InlineDiffManager.Companion.getInstance().closeEditor(AIDevFilePanel.this.project, item.getId(), null, false))) {
                    InlineDiffManager.Companion.getInstance().showMultipleDiff(AIDevFilePanel.this.project, item.getSnapshot().getId(), null, null, false, false, false);
                }
                if (!isReject) {
                    AIDevFilePanel.telemetryTextChangeForAIDevFile(AIDevFilePanel.this.project, item.path, item.addedLines, item.getAddedChars());
                }
            }
        });
    }

    public static void telemetryTextChangeForAIDevFile(Project project, String filepath, long addedLines, long addedChars) {
        TelemetryService.getInstance().telemetryTextChange(TextChangeContext.builder().project(project).filePath(filepath).addedText(null).startLineNumber(null).accepted(true).language(LanguageUtil.getLanguageByFilePath(filepath)).source("assistant").changeType(TextChangeTypeEnum.INSERT.getType()).nonLingmaPasted(false).sceneType(FileUtil.detectSceneType(filepath).getKey()).chatTask(ChatTaskEnum.FREE_INPUT.getName()).developerAcceptedInfo(new BaseTextChangeSourceMetric(0L, 0L)).assistantAcceptedInfo(new AssistantTextChangeSourceMetric(addedChars, addedLines, ModeService.getInstance().getModeForTelemetry(project))).build());
    }

    private void syncFileContentToEditor(Boolean isAccept, String fileId, String filePath) {
        if (null == filePath) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
        if (null != virtualFile) {
            if (isAccept.booleanValue()) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                InlineDiffManager.Companion.getInstance().closeEditor(this.project, fileId, null, false);
                FileEditorManager.getInstance((Project)this.project).openFile(virtualFile, true);
            });
        }
    }

    public void addFileItem(FileItem fileItem) {
        this.processFileItemPanel(fileItem);
        if (NAME_UNCHANGED_PANEL.equals(this.jbScrollPane.getViewport().getView().getName())) {
            this.jbScrollPane.setViewportView((Component)this.listPanel);
        } else {
            this.listPanel.revalidate();
            this.listPanel.repaint();
        }
    }

    private void processFileItemPanel(FileItem fileItem) {
        Object[] components = this.listPanel.getComponents();
        if (AIDevFileUsageEnum.CHAT_CARD == this.usage || AIDevFileUsageEnum.TOOL_PANEL == this.usage || ArrayUtils.isEmpty((Object[])components)) {
            this.listPanel.add(this.constructFileitemPanel(this.project, this.usage, fileItem));
        } else {
            boolean updated = false;
            for (Object panel : components) {
                FileItem old;
                if (!(panel instanceof FileItemPanel) || !(old = ((FileItemPanel)panel).getFileItem()).getFileId().equals(fileItem.getFileId())) continue;
                old.setId(fileItem.getId());
                old.setFileId(fileItem.getFileId());
                old.setName(FileUtil.getFileName(fileItem.getFileId()));
                old.setPath(fileItem.getPath());
                old.setChangedType(fileItem.getChangedType());
                old.setAddedLines(fileItem.getAddedLines());
                old.setDeletedLines(fileItem.getDeletedLines());
                old.setAddedChars(fileItem.getAddedChars());
                old.setDeletedChars(fileItem.getDeletedChars());
                old.setStatus(fileItem.getStatus());
                old.setVersion(fileItem.getVersion());
                old.setVersionCount(fileItem.getVersionCount());
                old.setSnapshot(fileItem.getSnapshot());
                old.setIcon(IconUtil.getFileTypeIcon(this.project, fileItem.getFileId()));
                old.getStatus().getContextProvider().handleDefaultStatus((JPanel)this.getParent(), (FileItemPanel)panel);
                updated = true;
            }
            if (!updated) {
                this.listPanel.add(this.constructFileitemPanel(this.project, this.usage, fileItem));
            }
        }
    }

    public void refreshFileItems(List<FileItem> fileItems) {
        this.listPanel.removeAll();
        if (CollectionUtils.isEmpty(fileItems)) {
            if (NAME_FILE_LIST_PANEL.equals(this.jbScrollPane.getViewport().getView().getName())) {
                this.jbScrollPane.setViewportView((Component)this.unchangedPanel);
            }
        } else {
            fileItems.forEach(fileItem -> this.listPanel.add(this.constructFileitemPanel(this.project, this.usage, (FileItem)fileItem)));
            if (NAME_UNCHANGED_PANEL.equals(this.jbScrollPane.getViewport().getView().getName())) {
                this.jbScrollPane.setViewportView((Component)this.listPanel);
            } else {
                this.listPanel.revalidate();
                this.listPanel.repaint();
            }
        }
    }

    private void addListenerForFilePanelChild(final FileItemPanel itemPanel, JComponent cp) {
        cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (null != lastHovered && lastHovered != itemPanel) {
                    lastHovered.getFileItem().getStatus().getContextProvider().handleDefaultStatus(AIDevFilePanel.this.listPanel, lastHovered);
                    lastHovered.revalidate();
                    lastHovered.repaint();
                }
                itemPanel.getFileItem().getStatus().getContextProvider().handleFileHovering(AIDevFilePanel.this.listPanel, itemPanel);
                itemPanel.revalidate();
                itemPanel.repaint();
                lastHovered = itemPanel;
                AIDevFilePanel.this.showFileTree(itemPanel);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                debouncer.debounce(() -> {
                    Point locationOnScreen;
                    Rectangle rectangle = new Rectangle(itemPanel.getLocationOnScreen(), itemPanel.getSize());
                    if (!rectangle.contains(locationOnScreen = MouseInfo.getPointerInfo().getLocation())) {
                        itemPanel.getFileItem().getStatus().getContextProvider().handleDefaultStatus(AIDevFilePanel.this.listPanel, itemPanel);
                        itemPanel.revalidate();
                        itemPanel.repaint();
                    }
                    if (null != filePathTreePopup) {
                        SwingUtilities.invokeLater(() -> {
                            if (null != filePathTreePopup) {
                                filePathTreePopup.cancel();
                            }
                        });
                    }
                }, 15L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AIDevFilePanel.this.cosyService.isHistorySession(AIDevFilePanel.this.project, itemPanel.getFileItem().getSessionId())) {
                    return;
                }
                itemPanel.getFileItem().getStatus().getContextProvider().handleFileClicking(AIDevFilePanel.this.listPanel, itemPanel);
                itemPanel.revalidate();
                itemPanel.repaint();
            }
        });
    }

    public int getFileCount() {
        return this.listPanel.getComponents().length;
    }

    private void showFileTree(FileItemPanel itemPanel) {
        debouncer.debounce(itemPanel.getFileItem().getPath(), () -> {
            SwingUtilities.invokeLater(() -> {
                if (null != filePathTreePopup) {
                    filePathTreePopup.cancel();
                }
                try {
                    filePathTreePopup = SuggestPromptPopupPanel.displayFilePathTree(this.project, this, this.getPreferredSize(), itemPanel.getFileItem().getPath(), this.listPanel, itemPanel.getLocationOnScreen());
                }
                catch (Exception e) {
                    log.warn("showFileTree failed", (Throwable)e);
                }
            });
            return null;
        }, 30L, TimeUnit.MILLISECONDS);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AIDevFilePanel)) {
            return false;
        }
        AIDevFilePanel other = (AIDevFilePanel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JPanel this$contentPanel = this.getContentPanel();
        JPanel other$contentPanel = other.getContentPanel();
        if (this$contentPanel == null ? other$contentPanel != null : !this$contentPanel.equals(other$contentPanel)) {
            return false;
        }
        JBScrollPane this$jbScrollPane = this.getJbScrollPane();
        JBScrollPane other$jbScrollPane = other.getJbScrollPane();
        if (this$jbScrollPane == null ? other$jbScrollPane != null : !this$jbScrollPane.equals(other$jbScrollPane)) {
            return false;
        }
        JPanel this$listPanel = this.getListPanel();
        JPanel other$listPanel = other.getListPanel();
        if (this$listPanel == null ? other$listPanel != null : !this$listPanel.equals(other$listPanel)) {
            return false;
        }
        JPanel this$unchangedPanel = this.getUnchangedPanel();
        JPanel other$unchangedPanel = other.getUnchangedPanel();
        if (this$unchangedPanel == null ? other$unchangedPanel != null : !this$unchangedPanel.equals(other$unchangedPanel)) {
            return false;
        }
        AIDevFileUsageEnum this$usage = this.getUsage();
        AIDevFileUsageEnum other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)((Object)this$usage)).equals((Object)other$usage)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        CosyService this$cosyService = this.getCosyService();
        CosyService other$cosyService = other.getCosyService();
        if (this$cosyService == null ? other$cosyService != null : !this$cosyService.equals(other$cosyService)) {
            return false;
        }
        MessageBusConnection this$messageBusConnection = this.getMessageBusConnection();
        MessageBusConnection other$messageBusConnection = other.getMessageBusConnection();
        return !(this$messageBusConnection == null ? other$messageBusConnection != null : !this$messageBusConnection.equals(other$messageBusConnection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AIDevFilePanel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JPanel $contentPanel = this.getContentPanel();
        result = result * 59 + ($contentPanel == null ? 43 : $contentPanel.hashCode());
        JBScrollPane $jbScrollPane = this.getJbScrollPane();
        result = result * 59 + ($jbScrollPane == null ? 43 : $jbScrollPane.hashCode());
        JPanel $listPanel = this.getListPanel();
        result = result * 59 + ($listPanel == null ? 43 : $listPanel.hashCode());
        JPanel $unchangedPanel = this.getUnchangedPanel();
        result = result * 59 + ($unchangedPanel == null ? 43 : $unchangedPanel.hashCode());
        AIDevFileUsageEnum $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)((Object)$usage)).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        CosyService $cosyService = this.getCosyService();
        result = result * 59 + ($cosyService == null ? 43 : $cosyService.hashCode());
        MessageBusConnection $messageBusConnection = this.getMessageBusConnection();
        result = result * 59 + ($messageBusConnection == null ? 43 : $messageBusConnection.hashCode());
        return result;
    }

    @Generated
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Generated
    public JBScrollPane getJbScrollPane() {
        return this.jbScrollPane;
    }

    @Generated
    public JPanel getListPanel() {
        return this.listPanel;
    }

    @Generated
    public JPanel getUnchangedPanel() {
        return this.unchangedPanel;
    }

    @Generated
    public AIDevFileUsageEnum getUsage() {
        return this.usage;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public CosyService getCosyService() {
        return this.cosyService;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public void setContentPanel(JPanel contentPanel) {
        this.contentPanel = contentPanel;
    }

    @Generated
    public void setJbScrollPane(JBScrollPane jbScrollPane) {
        this.jbScrollPane = jbScrollPane;
    }

    @Generated
    public void setListPanel(JPanel listPanel) {
        this.listPanel = listPanel;
    }

    @Generated
    public void setUnchangedPanel(JPanel unchangedPanel) {
        this.unchangedPanel = unchangedPanel;
    }

    @Generated
    public void setUsage(AIDevFileUsageEnum usage) {
        this.usage = usage;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setCosyService(CosyService cosyService) {
        this.cosyService = cosyService;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    @Override
    @Generated
    public String toString() {
        return "AIDevFilePanel(contentPanel=" + this.getContentPanel() + ", jbScrollPane=" + this.getJbScrollPane() + ", listPanel=" + this.getListPanel() + ", unchangedPanel=" + this.getUnchangedPanel() + ", usage=" + this.getUsage() + ", project=" + this.getProject() + ", cosyService=" + this.getCosyService() + ", messageBusConnection=" + this.getMessageBusConnection() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/chat/AIDevFilePanel", "constructFileitemPanel"));
    }

    public static class FileItemPanel
    extends RoundRectPanel {
        FileItem fileItem;
        JLabel fileNameLabel;
        JLabel changedLinesLabel;
        JLabel fileChangedTypeLabel;
        JLabel fileVersionLabel;
        JLabel fileStatusLabel;
        JLabel fileMessageLabel;
        JLabel rejectLabel;
        JLabel acceptLabel;
        JPanel rightPanel;
        AIDevFileUsageEnum usage;
        Project project;
        MessageBusConnection messageBusConnection;

        public FileItemPanel(Project project, AIDevFileUsageEnum usage, FileItem item) {
            super(new BorderLayout());
            this.setName(AIDevFilePanel.NAME_FILE_ITEM_PANEL);
            if (AIDevFileUsageEnum.TOOL_PANEL.equals((Object)usage)) {
                this.setPreferredSize(new Dimension(0, 28));
            } else {
                this.setPreferredSize(new Dimension(0, 24));
            }
            this.setBorder((Border)(AIDevFileUsageEnum.CHAT_CARD == usage || AIDevFileUsageEnum.TOOL_PANEL == usage ? JBUI.Borders.empty((int)1, (int)8, (int)1, (int)12) : JBUI.Borders.empty((int)1, (int)4)));
            super.setCornerRadius(8);
            this.usage = usage;
            this.project = project;
            this.fileItem = item;
            this.messageBusConnection = project.getMessageBus().connect();
            this.messageBusConnection.subscribe(WorkspaceFileModifiedNotifier.WORKSPACE_FILE_MODIFIED_NOTIFICATION, this::syncWorkspaceFile);
            this.fileNameLabel = new JLabel("", null, 2);
            this.fileNameLabel.setFont(this.fileNameLabel.getFont().deriveFont(13.0f));
            this.fileNameLabel.setIconTextGap(8);
            this.fileNameLabel.setName(AIDevFilePanel.NAME_FILE_NAME_LABEL);
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
            this.rightPanel.setOpaque(false);
            this.changedLinesLabel = new JLabel();
            this.changedLinesLabel.setFont(this.changedLinesLabel.getFont().deriveFont(12.0f));
            this.changedLinesLabel.setHorizontalAlignment(4);
            this.fileChangedTypeLabel = new JLabel();
            this.fileChangedTypeLabel.setFont(this.fileChangedTypeLabel.getFont().deriveFont(12.0f));
            this.fileChangedTypeLabel.setHorizontalAlignment(4);
            this.fileStatusLabel = new JLabel();
            this.fileStatusLabel.setIconTextGap(4);
            this.fileStatusLabel.setFont(this.fileStatusLabel.getFont().deriveFont(12.0f));
            this.fileMessageLabel = new JLabel(CommonIcons.infoIcon);
            this.fileVersionLabel = new JLabel();
            this.fileVersionLabel.setFont(this.fileVersionLabel.getFont().deriveFont(12.0f));
            this.fileVersionLabel.setVisible(false);
            this.rejectLabel = new JLabel(CosyBundle.message("ai.dev.file.action.reject", new Object[0]));
            this.rejectLabel.setVisible(false);
            this.rejectLabel.setName(AIDevFilePanel.NAME_FILE_REJECT_LABEL);
            this.rejectLabel.setCursor(new Cursor(12));
            this.rejectLabel.setFont(this.rejectLabel.getFont().deriveFont(12.0f));
            this.acceptLabel = new JLabel(CosyBundle.message("ai.dev.file.action.accept", new Object[0]));
            this.acceptLabel.setVisible(false);
            this.acceptLabel.setCursor(new Cursor(12));
            this.acceptLabel.setName(AIDevFilePanel.NAME_FILE_ACCEPT_LABEL);
            this.acceptLabel.setFont(this.acceptLabel.getFont().deriveFont(12.0f));
            this.add((Component)this.fileNameLabel, "West");
            this.add((Component)this.rightPanel, "East");
        }

        private void syncWorkspaceFile(WorkspaceFileSyncResult result) {
            SwingUtilities.invokeLater(() -> {
                boolean equals;
                WorkingSpaceFileInfo info = result.getWorkingSpaceFile();
                boolean bl = equals = AIDevFileUsageEnum.CHAT_CARD == this.usage || AIDevFileUsageEnum.TOOL_PANEL == this.usage ? this.fileItem.getId().equals(info.getId()) : this.fileItem.getFileId().equals(info.getFileId());
                if (equals) {
                    this.fileItem.setId(info.getId());
                    this.fileItem.setFileId(info.getFileId());
                    this.fileItem.setName(FileUtil.getFileName(info.getFileId()));
                    this.fileItem.setPath(info.getFileId());
                    this.fileItem.setChangedType(AIDevFileChangedTypeEnum.getById(info.getMode()));
                    if (null != info.getDiffInfo()) {
                        this.fileItem.setAddedLines(NumberUtil.objectToInteger(info.getDiffInfo().getAdd()));
                        this.fileItem.setDeletedLines(NumberUtil.objectToInteger(info.getDiffInfo().getDelete()));
                        this.fileItem.setAddedChars(NumberUtil.objectToInteger(info.getDiffInfo().getAddChars()));
                        this.fileItem.setDeletedChars(NumberUtil.objectToInteger(info.getDiffInfo().getDelChars()));
                    }
                    if (null != info.getLastDiffInfo()) {
                        this.fileItem.setLastAddedLines(NumberUtil.objectToInteger(info.getLastDiffInfo().getAdd()));
                        this.fileItem.setLastDeletedLines(NumberUtil.objectToInteger(info.getLastDiffInfo().getDelete()));
                        this.fileItem.setLastAddedChars(NumberUtil.objectToInteger(info.getLastDiffInfo().getAddChars()));
                        this.fileItem.setLastDeletedChars(NumberUtil.objectToInteger(info.getLastDiffInfo().getDelChars()));
                    }
                    this.fileItem.setStatus(AIDevFileStatusEnum.getById(info.getStatus()));
                    this.fileItem.setVersion(info.getVersion());
                    if (!AIDevFilePanel.NUMBER_UNCHANGED.equals(info.getVersionCount())) {
                        this.fileItem.setVersionCount(info.getVersionCount());
                    }
                    this.fileItem.setIcon(IconUtil.getFileTypeIcon(this.project, info.getFileId()));
                    this.fileItem.setMessage(info.getMessage());
                    this.fileItem.getStatus().getContextProvider().handleDefaultStatus((JPanel)this.getParent(), this);
                    this.revalidate();
                    this.repaint();
                }
            });
            SwingUtilities.invokeLater(() -> {
                if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                    if (AIDevFileStatusEnum.APPLYING.name().equals(result.getWorkingSpaceFile().getStatus())) {
                        InlineDiffManager.Companion.getInstance().showNewDiff(this.project, result.getWorkingSpaceFile().getSnapshotId(), result.getWorkingSpaceFile().getId(), result.getWorkingSpaceFile().getFileId(), null);
                    }
                } else {
                    try {
                        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(result.getWorkingSpaceFile().getFileId());
                            if (null != virtualFile) {
                                CommandProcessor.getInstance().executeCommand(this.project, () -> {
                                    if (AIDevFileStatusEnum.APPLYING.name().equals(result.getWorkingSpaceFile().getStatus()) || AIDevFileStatusEnum.APPLIED.name().equals(result.getWorkingSpaceFile().getStatus())) {
                                        InlineDiffManager.Companion.getInstance().showNewDiff(this.project, result.getWorkingSpaceFile().getSnapshotId(), result.getWorkingSpaceFile().getId(), result.getWorkingSpaceFile().getFileId(), AIDevFileStatusEnum.valueOf(result.getWorkingSpaceFile().getStatus()));
                                    }
                                }, "Refresh File", null);
                            }
                        });
                    }
                    catch (Exception e) {
                        log.warn("Failed to schedule refresh operation", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return super.getAccessibleContext();
        }

        public void updateUiTexts() {
            this.fileStatusLabel.setText(this.getFileItem().getStatus().getName());
            this.rejectLabel.setText(CosyBundle.message("ai.dev.file.action.reject", new Object[0]));
            this.acceptLabel.setText(CosyBundle.message("ai.dev.file.action.accept", new Object[0]));
        }

        @Generated
        public FileItem getFileItem() {
            return this.fileItem;
        }

        @Generated
        public JLabel getFileNameLabel() {
            return this.fileNameLabel;
        }

        @Generated
        public JLabel getChangedLinesLabel() {
            return this.changedLinesLabel;
        }

        @Generated
        public JLabel getFileChangedTypeLabel() {
            return this.fileChangedTypeLabel;
        }

        @Generated
        public JLabel getFileVersionLabel() {
            return this.fileVersionLabel;
        }

        @Generated
        public JLabel getFileStatusLabel() {
            return this.fileStatusLabel;
        }

        @Generated
        public JLabel getFileMessageLabel() {
            return this.fileMessageLabel;
        }

        @Generated
        public JLabel getRejectLabel() {
            return this.rejectLabel;
        }

        @Generated
        public JLabel getAcceptLabel() {
            return this.acceptLabel;
        }

        @Generated
        public JPanel getRightPanel() {
            return this.rightPanel;
        }

        @Generated
        public AIDevFileUsageEnum getUsage() {
            return this.usage;
        }

        @Generated
        public Project getProject() {
            return this.project;
        }

        @Generated
        public MessageBusConnection getMessageBusConnection() {
            return this.messageBusConnection;
        }
    }

    public static class FileItem {
        private String id;
        private String sessionId;
        private Snapshot snapshot;
        private String fileId;
        private String name;
        private String path;
        private AIDevFileChangedTypeEnum changedType;
        private int addedLines;
        private int deletedLines;
        private int addedChars;
        private int deletedChars;
        private int lastAddedLines;
        private int lastDeletedLines;
        private int lastAddedChars;
        private int lastDeletedChars;
        private AIDevFileStatusEnum status;
        private String version;
        private String versionCount;
        private Icon icon;
        private String message;

        @Generated
        public static FileItemBuilder builder() {
            return new FileItemBuilder();
        }

        @Generated
        public FileItem() {
        }

        @Generated
        public FileItem(String id, String sessionId, Snapshot snapshot, String fileId, String name, String path, AIDevFileChangedTypeEnum changedType, int addedLines, int deletedLines, int addedChars, int deletedChars, int lastAddedLines, int lastDeletedLines, int lastAddedChars, int lastDeletedChars, AIDevFileStatusEnum status, String version, String versionCount, Icon icon, String message) {
            this.id = id;
            this.sessionId = sessionId;
            this.snapshot = snapshot;
            this.fileId = fileId;
            this.name = name;
            this.path = path;
            this.changedType = changedType;
            this.addedLines = addedLines;
            this.deletedLines = deletedLines;
            this.addedChars = addedChars;
            this.deletedChars = deletedChars;
            this.lastAddedLines = lastAddedLines;
            this.lastDeletedLines = lastDeletedLines;
            this.lastAddedChars = lastAddedChars;
            this.lastDeletedChars = lastDeletedChars;
            this.status = status;
            this.version = version;
            this.versionCount = versionCount;
            this.icon = icon;
            this.message = message;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getSessionId() {
            return this.sessionId;
        }

        @Generated
        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public AIDevFileChangedTypeEnum getChangedType() {
            return this.changedType;
        }

        @Generated
        public int getAddedLines() {
            return this.addedLines;
        }

        @Generated
        public int getDeletedLines() {
            return this.deletedLines;
        }

        @Generated
        public int getAddedChars() {
            return this.addedChars;
        }

        @Generated
        public int getDeletedChars() {
            return this.deletedChars;
        }

        @Generated
        public int getLastAddedLines() {
            return this.lastAddedLines;
        }

        @Generated
        public int getLastDeletedLines() {
            return this.lastDeletedLines;
        }

        @Generated
        public int getLastAddedChars() {
            return this.lastAddedChars;
        }

        @Generated
        public int getLastDeletedChars() {
            return this.lastDeletedChars;
        }

        @Generated
        public AIDevFileStatusEnum getStatus() {
            return this.status;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getVersionCount() {
            return this.versionCount;
        }

        @Generated
        public Icon getIcon() {
            return this.icon;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Generated
        public void setSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Generated
        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setChangedType(AIDevFileChangedTypeEnum changedType) {
            this.changedType = changedType;
        }

        @Generated
        public void setAddedLines(int addedLines) {
            this.addedLines = addedLines;
        }

        @Generated
        public void setDeletedLines(int deletedLines) {
            this.deletedLines = deletedLines;
        }

        @Generated
        public void setAddedChars(int addedChars) {
            this.addedChars = addedChars;
        }

        @Generated
        public void setDeletedChars(int deletedChars) {
            this.deletedChars = deletedChars;
        }

        @Generated
        public void setLastAddedLines(int lastAddedLines) {
            this.lastAddedLines = lastAddedLines;
        }

        @Generated
        public void setLastDeletedLines(int lastDeletedLines) {
            this.lastDeletedLines = lastDeletedLines;
        }

        @Generated
        public void setLastAddedChars(int lastAddedChars) {
            this.lastAddedChars = lastAddedChars;
        }

        @Generated
        public void setLastDeletedChars(int lastDeletedChars) {
            this.lastDeletedChars = lastDeletedChars;
        }

        @Generated
        public void setStatus(AIDevFileStatusEnum status) {
            this.status = status;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setVersionCount(String versionCount) {
            this.versionCount = versionCount;
        }

        @Generated
        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileItem)) {
                return false;
            }
            FileItem other = (FileItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$sessionId = this.getSessionId();
            String other$sessionId = other.getSessionId();
            if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
                return false;
            }
            Snapshot this$snapshot = this.getSnapshot();
            Snapshot other$snapshot = other.getSnapshot();
            if (this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            AIDevFileChangedTypeEnum this$changedType = this.getChangedType();
            AIDevFileChangedTypeEnum other$changedType = other.getChangedType();
            if (this$changedType == null ? other$changedType != null : !((Object)((Object)this$changedType)).equals((Object)other$changedType)) {
                return false;
            }
            if (this.getAddedLines() != other.getAddedLines()) {
                return false;
            }
            if (this.getDeletedLines() != other.getDeletedLines()) {
                return false;
            }
            if (this.getAddedChars() != other.getAddedChars()) {
                return false;
            }
            if (this.getDeletedChars() != other.getDeletedChars()) {
                return false;
            }
            if (this.getLastAddedLines() != other.getLastAddedLines()) {
                return false;
            }
            if (this.getLastDeletedLines() != other.getLastDeletedLines()) {
                return false;
            }
            if (this.getLastAddedChars() != other.getLastAddedChars()) {
                return false;
            }
            if (this.getLastDeletedChars() != other.getLastDeletedChars()) {
                return false;
            }
            AIDevFileStatusEnum this$status = this.getStatus();
            AIDevFileStatusEnum other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$versionCount = this.getVersionCount();
            String other$versionCount = other.getVersionCount();
            if (this$versionCount == null ? other$versionCount != null : !this$versionCount.equals(other$versionCount)) {
                return false;
            }
            Icon this$icon = this.getIcon();
            Icon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $sessionId = this.getSessionId();
            result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
            Snapshot $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            AIDevFileChangedTypeEnum $changedType = this.getChangedType();
            result = result * 59 + ($changedType == null ? 43 : ((Object)((Object)$changedType)).hashCode());
            result = result * 59 + this.getAddedLines();
            result = result * 59 + this.getDeletedLines();
            result = result * 59 + this.getAddedChars();
            result = result * 59 + this.getDeletedChars();
            result = result * 59 + this.getLastAddedLines();
            result = result * 59 + this.getLastDeletedLines();
            result = result * 59 + this.getLastAddedChars();
            result = result * 59 + this.getLastDeletedChars();
            AIDevFileStatusEnum $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $versionCount = this.getVersionCount();
            result = result * 59 + ($versionCount == null ? 43 : $versionCount.hashCode());
            Icon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AIDevFilePanel.FileItem(id=" + this.getId() + ", sessionId=" + this.getSessionId() + ", snapshot=" + this.getSnapshot() + ", fileId=" + this.getFileId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", changedType=" + this.getChangedType() + ", addedLines=" + this.getAddedLines() + ", deletedLines=" + this.getDeletedLines() + ", addedChars=" + this.getAddedChars() + ", deletedChars=" + this.getDeletedChars() + ", lastAddedLines=" + this.getLastAddedLines() + ", lastDeletedLines=" + this.getLastDeletedLines() + ", lastAddedChars=" + this.getLastAddedChars() + ", lastDeletedChars=" + this.getLastDeletedChars() + ", status=" + this.getStatus() + ", version=" + this.getVersion() + ", versionCount=" + this.getVersionCount() + ", icon=" + this.getIcon() + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public static class FileItemBuilder {
            @Generated
            private String id;
            @Generated
            private String sessionId;
            @Generated
            private Snapshot snapshot;
            @Generated
            private String fileId;
            @Generated
            private String name;
            @Generated
            private String path;
            @Generated
            private AIDevFileChangedTypeEnum changedType;
            @Generated
            private int addedLines;
            @Generated
            private int deletedLines;
            @Generated
            private int addedChars;
            @Generated
            private int deletedChars;
            @Generated
            private int lastAddedLines;
            @Generated
            private int lastDeletedLines;
            @Generated
            private int lastAddedChars;
            @Generated
            private int lastDeletedChars;
            @Generated
            private AIDevFileStatusEnum status;
            @Generated
            private String version;
            @Generated
            private String versionCount;
            @Generated
            private Icon icon;
            @Generated
            private String message;

            @Generated
            FileItemBuilder() {
            }

            @Generated
            public FileItemBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public FileItemBuilder sessionId(String sessionId) {
                this.sessionId = sessionId;
                return this;
            }

            @Generated
            public FileItemBuilder snapshot(Snapshot snapshot) {
                this.snapshot = snapshot;
                return this;
            }

            @Generated
            public FileItemBuilder fileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Generated
            public FileItemBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public FileItemBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public FileItemBuilder changedType(AIDevFileChangedTypeEnum changedType) {
                this.changedType = changedType;
                return this;
            }

            @Generated
            public FileItemBuilder addedLines(int addedLines) {
                this.addedLines = addedLines;
                return this;
            }

            @Generated
            public FileItemBuilder deletedLines(int deletedLines) {
                this.deletedLines = deletedLines;
                return this;
            }

            @Generated
            public FileItemBuilder addedChars(int addedChars) {
                this.addedChars = addedChars;
                return this;
            }

            @Generated
            public FileItemBuilder deletedChars(int deletedChars) {
                this.deletedChars = deletedChars;
                return this;
            }

            @Generated
            public FileItemBuilder lastAddedLines(int lastAddedLines) {
                this.lastAddedLines = lastAddedLines;
                return this;
            }

            @Generated
            public FileItemBuilder lastDeletedLines(int lastDeletedLines) {
                this.lastDeletedLines = lastDeletedLines;
                return this;
            }

            @Generated
            public FileItemBuilder lastAddedChars(int lastAddedChars) {
                this.lastAddedChars = lastAddedChars;
                return this;
            }

            @Generated
            public FileItemBuilder lastDeletedChars(int lastDeletedChars) {
                this.lastDeletedChars = lastDeletedChars;
                return this;
            }

            @Generated
            public FileItemBuilder status(AIDevFileStatusEnum status) {
                this.status = status;
                return this;
            }

            @Generated
            public FileItemBuilder version(String version) {
                this.version = version;
                return this;
            }

            @Generated
            public FileItemBuilder versionCount(String versionCount) {
                this.versionCount = versionCount;
                return this;
            }

            @Generated
            public FileItemBuilder icon(Icon icon) {
                this.icon = icon;
                return this;
            }

            @Generated
            public FileItemBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public FileItem build() {
                return new FileItem(this.id, this.sessionId, this.snapshot, this.fileId, this.name, this.path, this.changedType, this.addedLines, this.deletedLines, this.addedChars, this.deletedChars, this.lastAddedLines, this.lastDeletedLines, this.lastAddedChars, this.lastDeletedChars, this.status, this.version, this.versionCount, this.icon, this.message);
            }

            @Generated
            public String toString() {
                return "AIDevFilePanel.FileItem.FileItemBuilder(id=" + this.id + ", sessionId=" + this.sessionId + ", snapshot=" + this.snapshot + ", fileId=" + this.fileId + ", name=" + this.name + ", path=" + this.path + ", changedType=" + this.changedType + ", addedLines=" + this.addedLines + ", deletedLines=" + this.deletedLines + ", addedChars=" + this.addedChars + ", deletedChars=" + this.deletedChars + ", lastAddedLines=" + this.lastAddedLines + ", lastDeletedLines=" + this.lastDeletedLines + ", lastAddedChars=" + this.lastAddedChars + ", lastDeletedChars=" + this.lastDeletedChars + ", status=" + this.status + ", version=" + this.version + ", versionCount=" + this.versionCount + ", icon=" + this.icon + ", message=" + this.message + ")";
            }
        }
    }
}

