/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.listener;

import com.intellij.openapi.diagnostic.Logger;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;

public class RunInTerminalModelListener
implements TerminalModelListener {
    private static final Logger log = Logger.getInstance(RunInTerminalModelListener.class);
    private static final String SPLIT_SIGNAL = "\n";
    private final ShellTerminalWidget widget;
    private final String command;
    private final Runnable callback;
    private String commandLine;
    private String myPrompt;

    public RunInTerminalModelListener(ShellTerminalWidget widget, String command, Runnable callback) {
        this.widget = widget;
        this.command = command;
        this.callback = callback;
        log.debug("RunInTerminalModelListener command=" + command);
    }

    public void modelChanged() {
        try {
            if (this.widget == null || StringUtils.isBlank((String)this.command) || this.callback == null) {
                return;
            }
            TerminalTextBuffer textBuffer = this.widget.getTerminalTextBuffer();
            if (textBuffer == null) {
                return;
            }
            String output = textBuffer.getScreenLines();
            if (StringUtils.isBlank((String)this.myPrompt)) {
                this.initMyPrompt(output);
            }
            if (StringUtils.isNotBlank((String)this.myPrompt)) {
                this.checkFinished(output);
            }
        }
        catch (Exception e) {
            log.warn("RunInTerminalModelListener error", (Throwable)e);
        }
    }

    private void initMyPrompt(String output) {
        if (output != null && output.contains(this.command)) {
            String[] lines;
            for (String line : lines = output.split(SPLIT_SIGNAL)) {
                int commandIndex;
                String linePrefix;
                if (!line.contains(this.command) || line.indexOf(this.command) <= 0 || !StringUtils.isNotBlank((String)(linePrefix = line.substring(0, commandIndex = line.indexOf(this.command))))) continue;
                this.commandLine = line;
                this.myPrompt = linePrefix;
                log.debug("RunInTerminalModelListener command=" + this.command + " & myPrompt: " + this.myPrompt);
                break;
            }
        }
    }

    private void checkFinished(String output) {
        if (output == null || StringUtils.isBlank((String)this.myPrompt)) {
            return;
        }
        boolean isCommandCompleted = false;
        if (output.contains(this.commandLine)) {
            String[] lines = output.split(SPLIT_SIGNAL);
            List<String> lineList = Arrays.asList(lines);
            int commandLineIndex = lineList.indexOf(this.commandLine);
            if (commandLineIndex >= 0 && lineList.size() > commandLineIndex + 1) {
                for (int i = commandLineIndex + 1; i < lineList.size(); ++i) {
                    if (!lineList.get(i).contains(this.myPrompt)) continue;
                    isCommandCompleted = true;
                    log.debug("RunInTerminalModelListener checkFinished: output=" + output + "&command=" + this.command);
                    break;
                }
            }
        } else if (output.contains(this.myPrompt)) {
            isCommandCompleted = true;
            log.debug("RunInTerminalModelListener checkFinished: " + output);
        }
        if (isCommandCompleted) {
            this.callback.run();
        }
    }
}

