/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaveFileToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(SaveFileToolHandler.class);

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            String filePath = this.getRequestFilePathWithUnderLine(request);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), Map.of("saved", false));
            }
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            VirtualFile file = localFileSystem.findFileByPath(filePath);
            if (file == null) {
                log.warn("Failed to open file, file not found, filePath= " + filePath);
                return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), Map.of("saved", false));
            }
            Document document = FileUtil.getDocument(file);
            if (null == document) {
                log.warn("Failed to get file document, file not found, filePath= " + filePath);
                return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), Map.of("saved", false));
            }
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> FileDocumentManager.getInstance().saveDocument(document)));
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), Map.of("saved", true));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("Failed to save file", (Throwable)e);
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }
}

