/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.excutor.TerminalCommandExecutor;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.tool.ToolRunInTerminalOpenTerminalNotifier;
import com.alibabacloud.intellij.cosy.util.TerminalUtils;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public class RunTerminalToolHandlerV2
extends ToolHandler {
    private static final Logger log = Logger.getInstance(RunTerminalToolHandlerV2.class);
    private static final String TERMINAL_NAME = CosyConfig.isQoderEnabled() ? "QoderTerminal" : "LingmaTerminal";
    private static final int TERMINAL_EXIST_CODE = 130;
    private static final int TERMINAL_NEW_UI_EXIST_CODE = -1;
    private static final int TERMINAL_INSTALL_TERMINAL_PLUGIN_EXIST_CODE = -2;
    private static final int TERMINAL_ENABLE_TERMINAL_PLUGIN_EXIST_CODE = -3;

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        log.debug("RunTerminalToolHandlerV2 handle run_terminal start, toolCallId=" + request.getToolCallId());
        Map<String, Object> params = request.getParameters();
        if (params == null) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "params is null");
        }
        if (params.get("command") == null) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "command is null");
        }
        String command = (String)params.get("command");
        if (StringUtils.isBlank((CharSequence)command)) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "command is blank");
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.plugins.terminal"));
        if (plugin == null) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("exitCode", -2);
            results.put("content", CosyBundle.message("tool.run.terminal.text.need.install.or.enable.terminal.plugin", new Object[0]));
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), results);
        }
        if (!plugin.isEnabled()) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("exitCode", -3);
            results.put("content", CosyBundle.message("tool.run.terminal.text.need.install.or.enable.terminal.plugin", new Object[0]));
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), results);
        }
        String terminalType = TerminalUtils.getNewTerminalType();
        if ("terminal.new.ui".equals(terminalType)) {
            log.debug("RunTerminalToolHandlerV2 NewTerminal type=" + terminalType);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("exitCode", -1);
            results.put("content", CosyBundle.message("tool.run.terminal.text.new.terminal.ui", new Object[0]));
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), results);
        }
        if ("terminal.new.ui.reworked".equals(terminalType)) {
            log.debug("RunTerminalToolHandlerV2 NewTerminal type=" + terminalType);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("exitCode", -1);
            results.put("content", CosyBundle.message("tool.run.terminal.text.new.terminal.2025.ui", new Object[0]));
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), results);
        }
        boolean background = this.getBooleanParamValue(request, "isBackground");
        List<ToolInvokeResponse> responses = this.executeTerminalCommand(project, request.getToolCallId(), request.getName(), command, background);
        if (responses != null && !responses.isEmpty()) {
            log.debug("RunTerminalToolHandlerV2 handle run_terminal end, result=" + JSONObject.toJSONString((Object)responses.get(0)));
            return responses.get(0);
        }
        log.warn("RunTerminalToolHandlerV2 handle run_terminal end, result is null, tooCallId=" + request.getToolCallId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ToolInvokeResponse> executeTerminalCommand(Project project, String toolCallId, String name, String command, boolean background) {
        ArrayList<ToolInvokeResponse> toolInvokeResponseList = new ArrayList<ToolInvokeResponse>();
        HashMap widgetMap = new HashMap();
        HashMap widgetNew = new HashMap();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
                if (toolWindow == null) {
                    toolInvokeResponseList.add(ToolInvokeResponse.failed(toolCallId, name, "toolWindow is null"));
                    log.warn("toolWindow is null, toolCallId=" + toolCallId);
                    return;
                }
                boolean visible = toolWindow.isVisible();
                toolWindow.activate(null);
                try {
                    if (!visible) {
                        ((ToolRunInTerminalOpenTerminalNotifier)project.getMessageBus().syncPublisher(ToolRunInTerminalOpenTerminalNotifier.TOOL_RUN_IN_TERMINAL_OPEN_TERMINAL_NOTIFICATION)).openTerminalWindowNotify(toolCallId);
                    }
                }
                catch (Exception e) {
                    log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
                }
                String workingDirectory = project.getBasePath();
                Pair<Content, ShellTerminalWidget> pair = RunTerminalToolHandlerV2.getSuitableProcess(toolWindow, workingDirectory);
                if (pair != null) {
                    log.debug("RunTerminalToolHandlerV2 runTerminal exist suitable process\uff0ccontentName=" + ((Content)pair.getFirst()).getDisplayName() + ", toolCallId=" + toolCallId);
                    if (!((Content)pair.getFirst()).isSelected()) {
                        toolWindow.getContentManager().setSelectedContent((Content)pair.getFirst());
                    }
                    ShellTerminalWidget widget = (ShellTerminalWidget)pair.getSecond();
                    this.clearTerminalBuffer(widget);
                    TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "" + widget.hashCode());
                    TerminalUtils.addWidget(widget);
                    widgetMap.put(toolCallId, widget);
                    widgetNew.put(widget, false);
                } else {
                    ShellTerminalWidget widget = TerminalView.getInstance((Project)project).createLocalShellWidget(workingDirectory, TERMINAL_NAME);
                    TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "" + widget.hashCode());
                    TerminalUtils.addWidget(widget);
                    widgetMap.put(toolCallId, widget);
                    widgetNew.put(widget, true);
                }
            }
            catch (Exception e) {
                log.warn("RunTerminalToolHandlerV2 runTerminal errorMessage=" + e.getMessage() + ", toolCallId=" + toolCallId, (Throwable)e);
                toolInvokeResponseList.add(ToolInvokeResponse.failed(toolCallId, name, "toolWindow is null"));
            }
        });
        if (CollectionUtils.isNotEmpty(toolInvokeResponseList)) {
            return toolInvokeResponseList;
        }
        try {
            ShellTerminalWidget widget = (ShellTerminalWidget)widgetMap.get(toolCallId);
            TerminalCommandExecutor executor = new TerminalCommandExecutor(widget);
            boolean clear = false;
            try {
                if (((Boolean)widgetNew.get(widget)).booleanValue()) {
                    widget.setListener(this.createCommandExecutionListener(executor.getTerminalStarted(), project, widget));
                } else {
                    clear = true;
                    executor.getTerminalStarted().complete(null);
                }
            }
            catch (Exception e) {
                toolInvokeResponseList.add(ToolInvokeResponse.failed(toolCallId, name, "init terminal error"));
                ArrayList<ToolInvokeResponse> arrayList = toolInvokeResponseList;
                TerminalUtils.removeTerminalCommandExecutor(toolCallId);
                return arrayList;
            }
            ((CompletableFuture)((CompletableFuture)executor.executeCommand(toolCallId, command, background, clear).thenAccept(result -> {
                String terminalId = TerminalUtils.getWidgetHashCode(toolCallId);
                HashMap<String, Object> toolCallResult = new HashMap<String, Object>();
                toolCallResult.put("terminalId", terminalId);
                toolCallResult.put("content", result.getOutput());
                if (result.isOperateCancel()) {
                    toolCallResult.put("exitCode", 130);
                }
                if (result.isOperateRunBackground()) {
                    toolCallResult.put("isBackground", true);
                }
                toolInvokeResponseList.add(ToolInvokeResponse.success(toolCallId, name, toolCallResult));
            })).exceptionally(throwable -> {
                log.warn("RunTerminalToolHandlerV2 Failed to execute command, toolCallId=" + toolCallId, throwable);
                toolInvokeResponseList.add(ToolInvokeResponse.failed(toolCallId, name, throwable.getMessage()));
                return null;
            })).get(240000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.warn("RunTerminalToolHandlerV2 runTerminal error, toolCallId=" + toolCallId, (Throwable)e);
            toolInvokeResponseList.add(ToolInvokeResponse.failed(toolCallId, name, "run terminal error"));
        }
        finally {
            TerminalUtils.removeTerminalCommandExecutor(toolCallId);
        }
        return toolInvokeResponseList;
    }

    public static Pair<Content, ShellTerminalWidget> getSuitableProcess(ToolWindow toolWindow, String workingDirectory) {
        Content[] contents;
        Content selectedContent;
        ContentManager contentManager = toolWindow.getContentManager();
        if (contentManager.getSelectedContent() != null && (selectedContent = contentManager.getSelectedContent()).getDisplayName().startsWith(TERMINAL_NAME) && RunTerminalToolHandlerV2.isTerminalContentSuitable(selectedContent, workingDirectory)) {
            return new Pair((Object)selectedContent, (Object)((ShellTerminalWidget)TerminalView.getWidgetByContent((Content)selectedContent)));
        }
        for (Content content : contents = contentManager.getContents()) {
            String name = content.getDisplayName();
            if (!name.startsWith(TERMINAL_NAME) || !RunTerminalToolHandlerV2.isTerminalContentSuitable(content, workingDirectory)) continue;
            return new Pair((Object)content, (Object)((ShellTerminalWidget)TerminalView.getWidgetByContent((Content)content)));
        }
        return null;
    }

    private static boolean isTerminalContentSuitable(Content content, String workingDirectory) {
        String contentName = content.getDisplayName();
        JBTerminalWidget jbTerminalWidget = TerminalView.getWidgetByContent((Content)content);
        if (!(jbTerminalWidget instanceof ShellTerminalWidget)) {
            log.debug("ToolInvokeProcessor getSuitableProcess " + contentName + " is not ShellTerminalWidget");
            return false;
        }
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)jbTerminalWidget;
        String typedShellCommand = shellTerminalWidget.getTypedShellCommand();
        if (StringUtils.isNotBlank((CharSequence)typedShellCommand)) {
            log.debug("ToolInvokeProcessor getSuitableProcess" + contentName + " getTypedShellCommand is not empty, typedShellCommand=" + typedShellCommand);
            return false;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector((TtyConnector)jbTerminalWidget.getTtyConnector());
        if (processTtyConnector == null) {
            log.debug("ToolInvokeProcessor getSuitableProcess" + contentName + " processTtyConnector is null");
            return false;
        }
        if (TerminalUtil.hasRunningCommands((ProcessTtyConnector)processTtyConnector)) {
            log.debug("ToolInvokeProcessor getSuitableProcess" + contentName + " has running commands");
            return false;
        }
        String currentWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory((JBTerminalWidget)jbTerminalWidget, (String)"");
        if (!FileUtil.pathsEqual((String)workingDirectory, (String)currentWorkingDirectory)) {
            log.debug("ToolInvokeProcessor getSuitableProcess" + contentName + " working directory not same");
            return false;
        }
        return true;
    }

    public JBTerminalWidgetListener createCommandExecutionListener(final CompletableFuture<Void> terminalStarted, final Project project, final ShellTerminalWidget widget) {
        return new JBTerminalWidgetListener(){

            public void onNewSession() {
            }

            public void onTerminalStarted() {
                log.debug("RunTerminalToolHandlerV2 onTerminalStarted");
                if (!terminalStarted.isDone()) {
                    terminalStarted.complete(null);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    block4: {
                        try {
                            ToolWindow terminalToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
                            if (terminalToolWindow == null) break block4;
                            ContentManager contentManager = terminalToolWindow.getContentManager();
                            for (Content content : contentManager.getContents()) {
                                if (TerminalView.getWidgetByContent((Content)content) != widget) continue;
                                String actualDisplayName = content.getDisplayName();
                                if (!StringUtils.isNotBlank((CharSequence)actualDisplayName) || !actualDisplayName.startsWith(TERMINAL_NAME)) {
                                    log.debug("Terminal actual display name before setting: " + actualDisplayName);
                                    content.setDisplayName(TERMINAL_NAME);
                                    log.debug("Terminal display name after setting: " + content.getDisplayName());
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            log.warn("Failed to set terminal display name: " + e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }

            public void onPreviousTabSelected() {
            }

            public void onNextTabSelected() {
            }

            public void onSessionClosed() {
            }

            public void showTabs() {
            }
        };
    }

    private void clearTerminalBuffer(ShellTerminalWidget widget) {
        try {
            widget.getTerminalPanel().clearBuffer();
        }
        catch (Exception e) {
            log.warn("clearTerminalBuffer \u6e05\u7406\u7ec8\u7aef\u7f13\u51b2\u533a\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }
}

