/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import groovy.json.StringEscapeUtils;
import java.util.ArrayList;

public class ReplaceTextByPathToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(ReplaceTextByPathToolHandler.class);

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            String path = this.getRequestFilePath(request);
            String text = this.getRequestText(request);
            VirtualFile virtualFile = project.getProjectFile();
            if (virtualFile == null) {
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "project file not found");
            }
            ArrayList documents = new ArrayList();
            String readResult = (String)ReadAction.compute(() -> {
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(virtualFile.toNioPath().resolve(path));
                if (file == null) {
                    return "file not found";
                }
                if (!GlobalSearchScope.allScope((Project)project).contains(file)) {
                    return "file not found";
                }
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) {
                    return "could not get document";
                }
                documents.add(document);
                return "ok";
            });
            if (!"ok".equals(readResult)) {
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), readResult);
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                Document document = (Document)documents.get(0);
                document.setText((CharSequence)StringEscapeUtils.unescapeJava((String)text));
                FileDocumentManager.getInstance().saveDocument(document);
            });
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), null);
        }
        catch (Exception e) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }

    public String getRequestText(ToolInvokeRequest request) {
        if (request.getParameters() != null && request.getParameters().containsKey("text")) {
            return this.getStringParamValue(request, "text");
        }
        return null;
    }
}

