/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReadFileToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(ReadFileToolHandler.class);

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            String filePath = this.getRequestFilePathWithUnderLine(request);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "filePath is empty");
            }
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            VirtualFile file = localFileSystem.findFileByPath(filePath);
            if (file == null) {
                log.warn("Failed to open file, file not found, filePath= " + filePath);
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "file not found");
            }
            Document document = FileUtil.getDocument(file);
            String content = document == null ? new String(file.contentsToByteArray(), StandardCharsets.UTF_8) : document.getText();
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), Map.of("content", content));
        }
        catch (Exception e) {
            log.warn("Failed to read file", (Throwable)e);
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }
}

