/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.alibabacloud.intellij.cosy.tool.model.ProblemItem;
import com.alibabacloud.intellij.cosy.tool.model.ProblemPosition;
import com.alibabacloud.intellij.cosy.tool.model.ProblemRange;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.impl.CodeSmellDetectorImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GetProblemsToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(GetProblemsToolHandler.class);
    private static final String CODE_SMELL_PROFILE_NAME = "Get Problems";
    private CompletableFuture<Boolean> getProblemFuture = new CompletableFuture();
    private ProgressIndicator getProgressIndicator;

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        long startTime = System.currentTimeMillis();
        try {
            ArrayList<ProblemItem> problemItems;
            block10: {
                block9: {
                    List<String> requestFilePaths = this.getRequestFilePaths(request);
                    if (CollectionUtils.isEmpty(requestFilePaths)) {
                        return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), new HashMap<String, Object>());
                    }
                    problemItems = new ArrayList<ProblemItem>();
                    this.getProblemFuture = new CompletableFuture();
                    try {
                        this.getHighlights(project, requestFilePaths, problemItems);
                    }
                    catch (Exception e) {
                        log.warn("Failed to get highlights", (Throwable)e);
                        if (this.getProblemFuture.isDone()) break block9;
                        this.getProblemFuture.complete(false);
                    }
                }
                try {
                    this.getProblemFuture.get(240000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    log.warn("Problem checking timed out\uff0ctoolCallId=" + request.getToolCallId());
                    this.getProblemFuture.cancel(false);
                    if (this.getProgressIndicator != null && this.getProgressIndicator.isRunning()) {
                        this.getProgressIndicator.cancel();
                    }
                }
                catch (Exception e) {
                    log.warn("Problem checking was interrupted", (Throwable)e);
                    if (this.getProgressIndicator == null || !this.getProgressIndicator.isRunning()) break block10;
                    this.getProgressIndicator.cancel();
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("problems", problemItems);
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), result, startTime, System.currentTimeMillis() - startTime);
        }
        catch (Exception e) {
            log.warn("Failed to handle problems check", (Throwable)e);
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "Failed to process problems: " + e.getMessage());
        }
    }

    private boolean isSupport() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        String appFullApplicationName = appInfo.getFullApplicationName();
        int baselineVersion = appInfo.getBuild().getBaselineVersion();
        Class<?> mainPassesRunnerClass = null;
        try {
            mainPassesRunnerClass = Class.forName("com.intellij.codeInsight.daemon.impl.MainPassesRunner");
        }
        catch (ClassNotFoundException e) {
            log.debug("GetProblemsToolHandler isSupport: class not Support,appFullApplicationName=" + appFullApplicationName + "&baselineVersion=" + baselineVersion);
            return false;
        }
        try {
            mainPassesRunnerClass.getMethod("runMainPasses", List.class);
        }
        catch (NoSuchMethodException e) {
            log.debug("GetProblemsToolHandler isSupport: function not Support,appFullApplicationName=" + appFullApplicationName + "&baselineVersion=" + baselineVersion);
            return false;
        }
        log.debug("GetProblemsToolHandler isSupport: Support,appFullApplicationName=" + appFullApplicationName + "&baselineVersion=" + baselineVersion);
        return true;
    }

    private void getHighlights(final Project project, List<String> filePaths, final List<ProblemItem> problemItems) {
        final List<VirtualFile> virtualFiles = this.getRequestFiles(project, filePaths);
        Task.Backgroundable task = new Task.Backgroundable(project, CODE_SMELL_PROFILE_NAME, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GetProblemsToolHandler.this.getProgressIndicator = indicator;
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                if (GetProblemsToolHandler.this.isSupport()) {
                    GetProblemsToolHandler.this.getHighlightsByRunMainPasses(project, virtualFiles, problemItems);
                } else {
                    GetProblemsToolHandler.this.getHighlightsByCodeSmell(project, virtualFiles, problemItems);
                }
                indicator.setFraction(1.0);
            }

            public void onCancel() {
                super.onCancel();
                if (!GetProblemsToolHandler.this.getProblemFuture.isDone()) {
                    GetProblemsToolHandler.this.getProblemFuture.complete(false);
                }
                log.warn("Problem checking onCancel");
            }

            public void onFinished() {
                super.onFinished();
                if (!GetProblemsToolHandler.this.getProblemFuture.isDone()) {
                    GetProblemsToolHandler.this.getProblemFuture.complete(true);
                }
                log.debug("Problem checking onFinished");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/tool/handler/GetProblemsToolHandler$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new ProgressIndicatorBase());
    }

    public void getHighlightsByRunMainPasses(Project project, List<VirtualFile> virtualFiles, List<ProblemItem> problemItems) {
        try {
            long currentTime = System.currentTimeMillis();
            InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            Class<?> mainPassesRunnerClass = Class.forName("com.intellij.codeInsight.daemon.impl.MainPassesRunner");
            Object runner = mainPassesRunnerClass.getConstructor(Project.class, String.class, InspectionProfile.class).newInstance(project, CODE_SMELL_PROFILE_NAME, currentProfile);
            Method runMainPassesMethod = mainPassesRunnerClass.getMethod("runMainPasses", List.class);
            Map infos = (Map)runMainPassesMethod.invoke(runner, virtualFiles);
            HashMap errorMap = new HashMap();
            for (Map.Entry entry : infos.entrySet()) {
                ArrayList<HighlightInfo> errorHighlights = new ArrayList<HighlightInfo>();
                errorMap.put((Document)entry.getKey(), errorHighlights);
                List highlightInfos = (List)entry.getValue();
                for (HighlightInfo highlightInfo : highlightInfos) {
                    if (!"ERROR".equals(highlightInfo.getSeverity().myName)) continue;
                    errorHighlights.add(highlightInfo);
                }
            }
            for (Map.Entry entry : errorMap.entrySet()) {
                Document document = (Document)entry.getKey();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if (file == null || !file.isValid()) {
                    log.warn("Failed to get file from document");
                    continue;
                }
                for (HighlightInfo highlightInfo : (List)entry.getValue()) {
                    problemItems.add(this.createProblemItem(file, document, highlightInfo));
                }
            }
            this.getProblemFuture.complete(true);
            log.debug("getHighlights time=" + (System.currentTimeMillis() - currentTime) + "problemItems=" + JSONObject.toJSONString(problemItems));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Failed to invoke MainPassesRunner", (Throwable)e);
            this.getProblemFuture.complete(false);
        }
    }

    public void getHighlightsByCodeSmell(Project project, List<VirtualFile> virtualFiles, List<ProblemItem> problemItems) {
        long currentTime = System.currentTimeMillis();
        CodeSmellDetectorImpl codeSmellDetector = new CodeSmellDetectorImpl(project);
        List list = codeSmellDetector.findCodeSmells(virtualFiles);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (CodeSmellInfo codeSmellInfo : list) {
                Document document = codeSmellInfo.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if (file == null || !file.isValid()) {
                    log.warn("Failed to get file from document");
                    continue;
                }
                if (!"ERROR".equals(codeSmellInfo.getSeverity().myName)) continue;
                problemItems.add(this.createProblemItem(file, document, codeSmellInfo));
            }
        }
        this.getProblemFuture.complete(true);
        log.debug("getHighlights time=" + (System.currentTimeMillis() - currentTime) + "&&problemItems=" + JSONObject.toJSONString(problemItems));
    }

    private List<VirtualFile> getRequestFiles(final Project project, final List<String> requestFilePaths) {
        final ArrayList requestFiles = new ArrayList();
        final LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        return (List)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<List<VirtualFile>, RuntimeException>(){

            public List<VirtualFile> compute() {
                for (String filePath : requestFilePaths) {
                    if (StringUtils.isBlank((CharSequence)filePath)) {
                        log.warn("Failed to get file, filePath is blank");
                        continue;
                    }
                    VirtualFile file = localFileSystem.findFileByPath(filePath);
                    if (file == null) {
                        log.warn("Failed to get file, file not found, filePath= " + filePath);
                        continue;
                    }
                    if (!ProjectFileIndex.getInstance((Project)project).isInContent(file)) {
                        log.warn("File is not in project content, skipping, filePath= " + filePath);
                        continue;
                    }
                    requestFiles.add(file);
                }
                return requestFiles;
            }
        });
    }

    public List<String> getRequestFilePaths(ToolInvokeRequest request) {
        List<String> paths = new ArrayList<String>();
        if (request.getParameters() != null && request.getParameters().containsKey("filePaths")) {
            paths = this.getStringArrayParamValue(request, "filePaths");
        }
        return paths;
    }

    private ProblemItem createProblemItem(VirtualFile file, Document document, HighlightInfo highlightInfo) {
        int lineNumber = document.getLineNumber(highlightInfo.getStartOffset());
        int column = highlightInfo.getStartOffset() - document.getLineStartOffset(lineNumber) + 1;
        ProblemItem problemItem = new ProblemItem();
        problemItem.setMessage(highlightInfo.getDescription());
        problemItem.setSeverity(highlightInfo.getSeverity().toString());
        problemItem.setRange(new ProblemRange(new ProblemPosition(lineNumber + 1, 0), new ProblemPosition(lineNumber + 1, column)));
        String sourceCode = document.getText(new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
        problemItem.setSourceCode(sourceCode);
        problemItem.setFilePath(file.getPath());
        return problemItem;
    }

    private ProblemItem createProblemItem(VirtualFile file, Document document, CodeSmellInfo codeSmellInfo) {
        int lineNumber = codeSmellInfo.getStartLine();
        int column = codeSmellInfo.getStartColumn();
        ProblemItem problemItem = new ProblemItem();
        problemItem.setMessage(codeSmellInfo.getDescription());
        problemItem.setSeverity(codeSmellInfo.getSeverity().toString());
        problemItem.setRange(new ProblemRange(new ProblemPosition(lineNumber + 1, 0), new ProblemPosition(lineNumber + 1, column)));
        String sourceCode = document.getText(new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
        problemItem.setSourceCode(sourceCode);
        problemItem.setFilePath(file.getPath());
        return problemItem;
    }
}

