/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;

public class DeleteFileByPathToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(DeleteFileByPathToolHandler.class);
    private static final long DELETE_TIMEOUT_SECONDS = 30L;

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            String filePath = this.getRequestFilePath(request);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "filePath is empty");
            }
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            VirtualFile file = localFileSystem.findFileByPath(filePath);
            if (file == null) {
                log.warn("Failed to open file, file not found, filePath= " + filePath);
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "file not found");
            }
            CompletableFuture deleteResult = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)"Delete File", null, () -> {
                try {
                    file.delete((Object)this);
                    deleteResult.complete(true);
                }
                catch (IOException e) {
                    log.warn("Failed to delete file: " + filePath, (Throwable)e);
                    deleteResult.completeExceptionally(e);
                }
            }, (PsiFile[])new PsiFile[0]));
            try {
                deleteResult.get(30L, TimeUnit.SECONDS);
                return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), null);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("Failed to delete file within timeout", (Throwable)e);
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "Failed to delete file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            }
        }
        catch (Exception e) {
            log.warn("Failed to handle delete file", (Throwable)e);
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }
}

