/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.handler;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.ToolHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import groovy.json.StringEscapeUtils;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class CreateNewFileWithTextToolHandler
extends ToolHandler {
    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            Path path;
            String filePath = this.getRequestFilePath(request);
            String text = this.getRequestText(request);
            if (Paths.get(filePath, new String[0]).isAbsolute()) {
                path = Paths.get(filePath, new String[0]);
            } else {
                VirtualFile projectDir = project.getBaseDir();
                if (projectDir == null) {
                    return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "project dir not found");
                }
                path = Paths.get(projectDir.getPath(), filePath);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            String finalText = StringEscapeUtils.unescapeJava((String)text);
            Files.write(path, finalText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path.toFile());
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), null);
        }
        catch (Exception e) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }

    public String getRequestText(ToolInvokeRequest request) {
        if (request.getParameters() != null && request.getParameters().containsKey("text")) {
            return this.getStringParamValue(request, "text");
        }
        return null;
    }
}

