/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.tool.excutor;

import com.alibabacloud.intellij.cosy.tool.listener.RunInTerminalModelListener;
import com.alibabacloud.intellij.cosy.util.TerminalUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalModelListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;

public class TerminalCommandExecutor {
    private static final Logger log = Logger.getInstance(TerminalCommandExecutor.class);
    private static final String CTRL_C = "\u0003";
    static final int BACKGROUND_RETURN_TIME = 10000;
    static final int TERMINAL_READ_TIME_TIMEOUT = 180000;
    private final ShellTerminalWidget widget;
    private final CompletableFuture<Void> terminalStarted = new CompletableFuture();
    private AtomicBoolean operateRunBackground = new AtomicBoolean(false);
    private AtomicBoolean operateCancel = new AtomicBoolean(false);
    private AtomicBoolean commandExecuteFinished = new AtomicBoolean(false);

    public TerminalCommandExecutor(ShellTerminalWidget widget) {
        this.widget = widget;
    }

    public CompletableFuture<CommandResult> executeCommand(String toolCallId, String command, boolean background, boolean clear) {
        RunInTerminalModelListener listener = new RunInTerminalModelListener(this.widget, command, () -> this.commandExecuteFinished.set(true));
        return this.terminalStarted.thenCompose(v -> CompletableFuture.supplyAsync(() -> {
            try {
                TtyConnector connector = this.widget.getTtyConnector();
                if (connector == null) {
                    throw new IllegalStateException("TtyConnector is null after terminal started");
                }
                if (!background) {
                    this.widget.getTerminalTextBuffer().addModelListener((TerminalModelListener)listener);
                }
                if (clear) {
                    String enterCode = new String(this.widget.getTerminalStarter().getCode(10, 0), StandardCharsets.UTF_8);
                    if (SystemInfo.isWindows) {
                        boolean hasRunningCommands = this.widget.hasRunningCommands();
                        log.info("hasRunningCommands=" + hasRunningCommands);
                        if (hasRunningCommands) {
                            this.widget.executeCommand(this.getExitCommand());
                            ThreadUtil.sleep(1000L);
                            this.widget.executeCommand(command);
                        } else {
                            this.widget.executeCommand(command);
                        }
                    } else {
                        this.widget.executeCommand(this.getExitCommand() + enterCode + command);
                    }
                } else {
                    this.widget.executeCommand(command);
                }
                TerminalUtils.addTerminalCommandExecutor(toolCallId, this);
                CommandResult commandResult = this.waitForCommandCompletion(background);
                return commandResult;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            finally {
                try {
                    this.widget.getTerminalTextBuffer().removeModelListener((TerminalModelListener)listener);
                }
                catch (Exception ex) {
                    log.warn("removeModelListener error", (Throwable)ex);
                }
            }
        }));
    }

    public void runInBackground() {
        this.operateRunBackground.set(true);
    }

    public void cancel() {
        this.operateCancel.set(true);
    }

    private String getExitCommand() {
        return CTRL_C;
    }

    private CommandResult waitForCommandCompletion(boolean background) {
        int readOutputTimeout;
        long startTime = System.currentTimeMillis();
        String lastOutput = "";
        int n = readOutputTimeout = background ? 10000 : 180000;
        while (true) {
            if (System.currentTimeMillis() - startTime > (long)readOutputTimeout) {
                log.warn("TerminalCommandExecutor Command execution timed out, readOutputTimeout=" + readOutputTimeout);
                break;
            }
            if (this.operateRunBackground.get()) {
                return this.captureResult(startTime);
            }
            if (this.operateCancel.get()) {
                TtyConnector connector = this.widget.getTtyConnector();
                if (connector != null) {
                    try {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            try {
                                this.widget.executeCommand(this.getExitCommand());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (RuntimeException ex) {
                        log.warn("Error send exit command", (Throwable)ex);
                    }
                }
                return this.captureResult(startTime);
            }
            try {
                if (!this.widget.hasRunningCommands() || this.commandExecuteFinished.get()) {
                    CommandResult commandResult;
                    if (StringUtils.isBlank((String)lastOutput)) {
                        ThreadUtil.sleep(500L);
                        commandResult = this.captureResult(startTime);
                        lastOutput = commandResult.getOutput();
                    } else {
                        commandResult = this.captureResult(startTime);
                        if (lastOutput.equals(commandResult.getOutput())) {
                            return commandResult;
                        }
                        log.debug("TerminalCommandExecutor lastOutput not equal output");
                        lastOutput = commandResult.getOutput();
                    }
                }
            }
            catch (IllegalStateException e) {
                log.warn("TerminalCommandExecutor Error checking running commands", (Throwable)e);
                if (this.widget.getTtyConnector() == null) break;
            }
            ThreadUtil.sleep(100L);
        }
        return this.captureResult(startTime);
    }

    private CommandResult captureResult(long startTime) {
        String output = TerminalUtils.getText(this.widget);
        long duration = System.currentTimeMillis() - startTime;
        boolean operateRunBackground = this.operateRunBackground.get();
        boolean operateCancel = this.operateCancel.get();
        return new CommandResult(output, duration, operateRunBackground, operateCancel);
    }

    @Generated
    public CompletableFuture<Void> getTerminalStarted() {
        return this.terminalStarted;
    }

    public static class CommandResult {
        private String output;
        private long executionTimeMs;
        private boolean operateRunBackground;
        private boolean operateCancel;

        public CommandResult(String output, long executionTimeMs, boolean operateRunBackground, boolean operateCancel) {
            this.output = output;
            this.executionTimeMs = executionTimeMs;
            this.operateRunBackground = operateRunBackground;
            this.operateCancel = operateCancel;
        }

        public CommandResult(String output, long executionTimeMs) {
            this.output = output;
            this.executionTimeMs = executionTimeMs;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public long getExecutionTimeMs() {
            return this.executionTimeMs;
        }

        @Generated
        public boolean isOperateRunBackground() {
            return this.operateRunBackground;
        }

        @Generated
        public boolean isOperateCancel() {
            return this.operateCancel;
        }

        @Generated
        public void setOutput(String output) {
            this.output = output;
        }

        @Generated
        public void setExecutionTimeMs(long executionTimeMs) {
            this.executionTimeMs = executionTimeMs;
        }

        @Generated
        public void setOperateRunBackground(boolean operateRunBackground) {
            this.operateRunBackground = operateRunBackground;
        }

        @Generated
        public void setOperateCancel(boolean operateCancel) {
            this.operateCancel = operateCancel;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandResult)) {
                return false;
            }
            CommandResult other = (CommandResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$output = this.getOutput();
            String other$output = other.getOutput();
            if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
                return false;
            }
            if (this.getExecutionTimeMs() != other.getExecutionTimeMs()) {
                return false;
            }
            if (this.isOperateRunBackground() != other.isOperateRunBackground()) {
                return false;
            }
            return this.isOperateCancel() == other.isOperateCancel();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CommandResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            long $executionTimeMs = this.getExecutionTimeMs();
            result = result * 59 + (int)($executionTimeMs >>> 32 ^ $executionTimeMs);
            result = result * 59 + (this.isOperateRunBackground() ? 79 : 97);
            result = result * 59 + (this.isOperateCancel() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "TerminalCommandExecutor.CommandResult(output=" + this.getOutput() + ", executionTimeMs=" + this.getExecutionTimeMs() + ", operateRunBackground=" + this.isOperateRunBackground() + ", operateCancel=" + this.isOperateCancel() + ")";
        }
    }
}

