/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.shared.cache.impl;

import com.alibabacloud.intellij.cosy.shared.cache.CacheBase;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PsiClassCache
implements CacheBase {
    private static final Logger log = Logger.getInstance(PsiClassCache.class);
    public static final int MAX_CANDIDATE_LOG = 10;
    private Cache<Object, Map<String, PsiClass>> classMap = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(5000L).build();
    private static final int CACHE_HOUR_LIMIT = 12;

    @Override
    public Optional get(Object name) {
        if (name == null) {
            return Optional.empty();
        }
        Map psiClassMap = (Map)this.classMap.getIfPresent(name);
        if (psiClassMap == null || psiClassMap.values().size() == 0) {
            return Optional.empty();
        }
        Object[] classes = psiClassMap.values().toArray();
        if (classes.length > 0 && log.isDebugEnabled()) {
            if (classes.length < 10) {
                String candidates = Arrays.stream(classes).map(c -> ((PsiClass)c).getQualifiedName()).collect(Collectors.joining(","));
                log.debug(String.format("Guess psi class based on %s, candidates are %s", name, candidates));
            } else {
                log.debug(String.format("Guess psi class based on %s, candidates exceed %d", name, 10));
            }
        }
        return Optional.of(classes[0]);
    }

    public Optional getByFullName(Object name, String fullName) {
        if (fullName == null) {
            return this.get(name);
        }
        Map psiClassMap = (Map)this.classMap.getIfPresent(name);
        if (psiClassMap == null) {
            return Optional.empty();
        }
        PsiClass psiClass = (PsiClass)psiClassMap.get(fullName);
        if (psiClass == null) {
            log.info(String.format("PsiClassCache getByFullName didn't find class based on %s, but its name %s is matched.", fullName, name));
            return Optional.empty();
        }
        return Optional.of(psiClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object item) {
        PsiClass clazz;
        String fullPath;
        if (item == null) {
            return;
        }
        if (!(item instanceof PsiClass) || (fullPath = (clazz = (PsiClass)item).getQualifiedName()) == null) return;
        String name = StringUtils.extractClassNameFromFullPath(fullPath);
        Class<PsiClassCache> clazz2 = PsiClassCache.class;
        synchronized (PsiClassCache.class) {
            ConcurrentHashMap<String, PsiClass> map = (ConcurrentHashMap<String, PsiClass>)this.classMap.getIfPresent((Object)name);
            if (map == null) {
                map = new ConcurrentHashMap<String, PsiClass>();
            }
            if (map.containsKey(fullPath)) return;
            map.put(fullPath, clazz);
            this.classMap.put((Object)name, map);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchSet(PsiClass[] classes) {
        Map<String, List<PsiClass>> batchInput = Arrays.stream(classes).filter(clazz -> clazz != null && clazz.getQualifiedName() != null).collect(Collectors.groupingBy(clazz -> StringUtils.extractClassNameFromFullPath(clazz.getQualifiedName())));
        Class<PsiClassCache> clazz2 = PsiClassCache.class;
        synchronized (PsiClassCache.class) {
            for (String name : batchInput.keySet()) {
                ConcurrentHashMap map = (ConcurrentHashMap)this.classMap.getIfPresent((Object)name);
                if (map == null) {
                    map = new ConcurrentHashMap();
                }
                ConcurrentHashMap toInsert = new ConcurrentHashMap();
                batchInput.get(name).forEach(clazz -> toInsert.putIfAbsent(clazz.getQualifiedName(), clazz));
                map.putAll(toInsert);
                this.classMap.put((Object)name, map);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getSize() {
        return this.classMap.asMap().size();
    }

    @Override
    public void clear() {
        this.classMap.cleanUp();
    }
}

