/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.shared.cache.impl;

import com.alibabacloud.intellij.cosy.shared.cache.CacheBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class ProjectClassTrieCache
implements CacheBase {
    private PatriciaTrie patriciaTrie = new PatriciaTrie();

    @Override
    public Optional get(Object prefix) {
        if (this.patriciaTrie.size() == 0) {
            return Optional.empty();
        }
        SortedMap sortedMap = this.patriciaTrie.prefixMap(prefix);
        if (sortedMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(sortedMap.values().stream().collect(Collectors.toList()));
    }

    public void batchSet(List<String> items) {
        Map<String, String> itemMap = items.stream().distinct().collect(Collectors.toMap(c -> c, c -> c));
        this.patriciaTrie.putAll(itemMap);
    }

    @Override
    public void set(Object item) {
        if (item instanceof String) {
            this.patriciaTrie.put(item, item);
        }
    }

    @Override
    public int getSize() {
        return this.patriciaTrie.size();
    }

    @Override
    public void clear() {
        this.patriciaTrie.clear();
    }
}

