/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.model;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.service.model.BaseTextChangeMetric;
import com.alibabacloud.intellij.cosy.service.model.TextChangeDetailBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TextChangeSummaryBO
extends BaseTextChangeMetric {
    protected Long acceptCompletionCharLength;
    protected Long acceptCompletionNewLineCount;
    protected Long acceptChatCharLength;
    protected Long acceptChatNewLineCount;
    protected Long acceptDeveloperCharLength;
    protected Long acceptDeveloperNewLineCount;
    protected Long acceptAssistantCharLength;
    protected Long acceptAssistantNewLineCount;
    protected Long acceptNesCharLength;
    protected Long acceptNesNewLineCount;
    protected Long acceptInlineEditNewLineCount;
    protected Long acceptInlineEditCharLength;
    protected List<Map<String, String>> details;

    public TextChangeSummaryBO() {
        this.acceptCompletionCharLength = 0L;
        this.acceptCompletionNewLineCount = 0L;
        this.acceptChatCharLength = 0L;
        this.acceptChatNewLineCount = 0L;
        this.acceptDeveloperCharLength = 0L;
        this.acceptDeveloperNewLineCount = 0L;
        this.acceptAssistantCharLength = 0L;
        this.acceptAssistantNewLineCount = 0L;
        this.acceptInlineEditNewLineCount = 0L;
        this.acceptInlineEditCharLength = 0L;
        this.acceptNesCharLength = 0L;
        this.acceptNesNewLineCount = 0L;
        this.details = new ArrayList<Map<String, String>>();
    }

    @Override
    public void fillReportData(Map<String, String> data) {
        super.fillReportData(data);
        data.put("acceptCompletionCharLength", String.valueOf(this.acceptCompletionCharLength));
        data.put("acceptCompletionNewLineCount", String.valueOf(this.acceptCompletionNewLineCount));
        data.put("acceptChatCharLength", String.valueOf(this.acceptChatCharLength));
        data.put("acceptChatNewLineCount", String.valueOf(this.acceptChatNewLineCount));
        data.put("acceptDeveloperCharLength", String.valueOf(this.acceptDeveloperCharLength));
        data.put("acceptDeveloperNewLineCount", String.valueOf(this.acceptDeveloperNewLineCount));
        data.put("acceptAssistantCharLength", String.valueOf(this.acceptAssistantCharLength));
        data.put("acceptAssistantNewLineCount", String.valueOf(this.acceptAssistantNewLineCount));
        data.put("acceptInlineEditCharLength", String.valueOf(this.acceptInlineEditCharLength));
        data.put("acceptInlineEditNewLineCount", String.valueOf(this.acceptInlineEditNewLineCount));
        data.put("acceptNesCharLength", String.valueOf(this.acceptNesCharLength));
        data.put("acceptNesNewLineCount", String.valueOf(this.acceptNesNewLineCount));
        data.put("details", JSON.toJSONString(this.details));
    }

    public void update(TextChangeDetailBO detail, Map<String, String> statData) {
        this.totalNewLineCount = this.totalNewLineCount + detail.getTotalNewLineCount();
        this.totalCharLength = this.totalCharLength + detail.getTotalCharLength();
        this.acceptNewLineCount = this.acceptNewLineCount + detail.getAcceptNewLineCount();
        this.acceptCharLength = this.acceptCharLength + detail.getAcceptCharLength();
        if (this.startTimestamp == 0L || this.endTimestamp == 0L) {
            this.startTimestamp = detail.getStartTimestamp();
            this.endTimestamp = detail.getEndTimestamp();
        } else {
            this.startTimestamp = Math.min(this.startTimestamp, detail.getStartTimestamp());
            this.endTimestamp = Math.max(this.endTimestamp, detail.getEndTimestamp());
        }
        this.editorTypingCount = this.editorTypingCount + this.editorTypingCount;
        this.nonLingmaPastedCharLength = this.nonLingmaPastedCharLength + detail.getNonLingmaPastedCharLength();
        this.nonLingmaPastedNewLineCount = this.nonLingmaPastedNewLineCount + detail.getNonLingmaPastedNewLineCount();
        if (null != detail.getSourceDetail()) {
            if (detail.getSourceDetail().getCompletion() != null) {
                this.acceptCompletionCharLength = this.acceptCompletionCharLength + detail.getSourceDetail().getCompletion().getAcceptCharLength();
                this.acceptCompletionNewLineCount = this.acceptCompletionNewLineCount + detail.getSourceDetail().getCompletion().getAcceptNewLineCount();
            }
            if (detail.getSourceDetail().getChat() != null) {
                this.acceptChatCharLength = this.acceptChatCharLength + detail.getSourceDetail().getChat().getAcceptCharLength();
                this.acceptChatNewLineCount = this.acceptChatNewLineCount + detail.getSourceDetail().getChat().getAcceptNewLineCount();
            }
            if (detail.getSourceDetail().getDeveloper() != null) {
                this.acceptDeveloperCharLength = this.acceptDeveloperCharLength + detail.getSourceDetail().getDeveloper().getAcceptCharLength();
                this.acceptDeveloperNewLineCount = this.acceptDeveloperNewLineCount + detail.getSourceDetail().getDeveloper().getAcceptNewLineCount();
            }
            if (detail.getSourceDetail().getAssistant() != null) {
                this.acceptAssistantCharLength = this.acceptAssistantCharLength + detail.getSourceDetail().getAssistant().getAcceptCharLength();
                this.acceptAssistantNewLineCount = this.acceptAssistantNewLineCount + detail.getSourceDetail().getAssistant().getAcceptNewLineCount();
            }
            if (detail.getSourceDetail().getInlineEdit() != null) {
                this.acceptInlineEditCharLength = this.acceptInlineEditCharLength + detail.getSourceDetail().getInlineEdit().getAcceptCharLength();
                this.acceptInlineEditNewLineCount = this.acceptInlineEditNewLineCount + detail.getSourceDetail().getInlineEdit().getAcceptNewLineCount();
            }
            if (detail.getSourceDetail().getNes() != null) {
                this.acceptNesCharLength = this.acceptNesCharLength + detail.getSourceDetail().getNes().getAcceptCharLength();
                this.acceptNesNewLineCount = this.acceptNesNewLineCount + detail.getSourceDetail().getNes().getAcceptNewLineCount();
            }
        }
        this.details.add(statData);
    }

    @Generated
    protected TextChangeSummaryBO(TextChangeSummaryBOBuilder<?, ?> b) {
        super(b);
        this.acceptCompletionCharLength = b.acceptCompletionCharLength;
        this.acceptCompletionNewLineCount = b.acceptCompletionNewLineCount;
        this.acceptChatCharLength = b.acceptChatCharLength;
        this.acceptChatNewLineCount = b.acceptChatNewLineCount;
        this.acceptDeveloperCharLength = b.acceptDeveloperCharLength;
        this.acceptDeveloperNewLineCount = b.acceptDeveloperNewLineCount;
        this.acceptAssistantCharLength = b.acceptAssistantCharLength;
        this.acceptAssistantNewLineCount = b.acceptAssistantNewLineCount;
        this.acceptNesCharLength = b.acceptNesCharLength;
        this.acceptNesNewLineCount = b.acceptNesNewLineCount;
        this.acceptInlineEditNewLineCount = b.acceptInlineEditNewLineCount;
        this.acceptInlineEditCharLength = b.acceptInlineEditCharLength;
        this.details = b.details;
    }

    @Generated
    public static TextChangeSummaryBOBuilder<?, ?> builder() {
        return new TextChangeSummaryBOBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextChangeSummaryBO)) {
            return false;
        }
        TextChangeSummaryBO other = (TextChangeSummaryBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$acceptCompletionCharLength = this.getAcceptCompletionCharLength();
        Long other$acceptCompletionCharLength = other.getAcceptCompletionCharLength();
        if (this$acceptCompletionCharLength == null ? other$acceptCompletionCharLength != null : !((Object)this$acceptCompletionCharLength).equals(other$acceptCompletionCharLength)) {
            return false;
        }
        Long this$acceptCompletionNewLineCount = this.getAcceptCompletionNewLineCount();
        Long other$acceptCompletionNewLineCount = other.getAcceptCompletionNewLineCount();
        if (this$acceptCompletionNewLineCount == null ? other$acceptCompletionNewLineCount != null : !((Object)this$acceptCompletionNewLineCount).equals(other$acceptCompletionNewLineCount)) {
            return false;
        }
        Long this$acceptChatCharLength = this.getAcceptChatCharLength();
        Long other$acceptChatCharLength = other.getAcceptChatCharLength();
        if (this$acceptChatCharLength == null ? other$acceptChatCharLength != null : !((Object)this$acceptChatCharLength).equals(other$acceptChatCharLength)) {
            return false;
        }
        Long this$acceptChatNewLineCount = this.getAcceptChatNewLineCount();
        Long other$acceptChatNewLineCount = other.getAcceptChatNewLineCount();
        if (this$acceptChatNewLineCount == null ? other$acceptChatNewLineCount != null : !((Object)this$acceptChatNewLineCount).equals(other$acceptChatNewLineCount)) {
            return false;
        }
        Long this$acceptDeveloperCharLength = this.getAcceptDeveloperCharLength();
        Long other$acceptDeveloperCharLength = other.getAcceptDeveloperCharLength();
        if (this$acceptDeveloperCharLength == null ? other$acceptDeveloperCharLength != null : !((Object)this$acceptDeveloperCharLength).equals(other$acceptDeveloperCharLength)) {
            return false;
        }
        Long this$acceptDeveloperNewLineCount = this.getAcceptDeveloperNewLineCount();
        Long other$acceptDeveloperNewLineCount = other.getAcceptDeveloperNewLineCount();
        if (this$acceptDeveloperNewLineCount == null ? other$acceptDeveloperNewLineCount != null : !((Object)this$acceptDeveloperNewLineCount).equals(other$acceptDeveloperNewLineCount)) {
            return false;
        }
        Long this$acceptAssistantCharLength = this.getAcceptAssistantCharLength();
        Long other$acceptAssistantCharLength = other.getAcceptAssistantCharLength();
        if (this$acceptAssistantCharLength == null ? other$acceptAssistantCharLength != null : !((Object)this$acceptAssistantCharLength).equals(other$acceptAssistantCharLength)) {
            return false;
        }
        Long this$acceptAssistantNewLineCount = this.getAcceptAssistantNewLineCount();
        Long other$acceptAssistantNewLineCount = other.getAcceptAssistantNewLineCount();
        if (this$acceptAssistantNewLineCount == null ? other$acceptAssistantNewLineCount != null : !((Object)this$acceptAssistantNewLineCount).equals(other$acceptAssistantNewLineCount)) {
            return false;
        }
        Long this$acceptNesCharLength = this.getAcceptNesCharLength();
        Long other$acceptNesCharLength = other.getAcceptNesCharLength();
        if (this$acceptNesCharLength == null ? other$acceptNesCharLength != null : !((Object)this$acceptNesCharLength).equals(other$acceptNesCharLength)) {
            return false;
        }
        Long this$acceptNesNewLineCount = this.getAcceptNesNewLineCount();
        Long other$acceptNesNewLineCount = other.getAcceptNesNewLineCount();
        if (this$acceptNesNewLineCount == null ? other$acceptNesNewLineCount != null : !((Object)this$acceptNesNewLineCount).equals(other$acceptNesNewLineCount)) {
            return false;
        }
        Long this$acceptInlineEditNewLineCount = this.getAcceptInlineEditNewLineCount();
        Long other$acceptInlineEditNewLineCount = other.getAcceptInlineEditNewLineCount();
        if (this$acceptInlineEditNewLineCount == null ? other$acceptInlineEditNewLineCount != null : !((Object)this$acceptInlineEditNewLineCount).equals(other$acceptInlineEditNewLineCount)) {
            return false;
        }
        Long this$acceptInlineEditCharLength = this.getAcceptInlineEditCharLength();
        Long other$acceptInlineEditCharLength = other.getAcceptInlineEditCharLength();
        if (this$acceptInlineEditCharLength == null ? other$acceptInlineEditCharLength != null : !((Object)this$acceptInlineEditCharLength).equals(other$acceptInlineEditCharLength)) {
            return false;
        }
        List<Map<String, String>> this$details = this.getDetails();
        List<Map<String, String>> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextChangeSummaryBO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $acceptCompletionCharLength = this.getAcceptCompletionCharLength();
        result = result * 59 + ($acceptCompletionCharLength == null ? 43 : ((Object)$acceptCompletionCharLength).hashCode());
        Long $acceptCompletionNewLineCount = this.getAcceptCompletionNewLineCount();
        result = result * 59 + ($acceptCompletionNewLineCount == null ? 43 : ((Object)$acceptCompletionNewLineCount).hashCode());
        Long $acceptChatCharLength = this.getAcceptChatCharLength();
        result = result * 59 + ($acceptChatCharLength == null ? 43 : ((Object)$acceptChatCharLength).hashCode());
        Long $acceptChatNewLineCount = this.getAcceptChatNewLineCount();
        result = result * 59 + ($acceptChatNewLineCount == null ? 43 : ((Object)$acceptChatNewLineCount).hashCode());
        Long $acceptDeveloperCharLength = this.getAcceptDeveloperCharLength();
        result = result * 59 + ($acceptDeveloperCharLength == null ? 43 : ((Object)$acceptDeveloperCharLength).hashCode());
        Long $acceptDeveloperNewLineCount = this.getAcceptDeveloperNewLineCount();
        result = result * 59 + ($acceptDeveloperNewLineCount == null ? 43 : ((Object)$acceptDeveloperNewLineCount).hashCode());
        Long $acceptAssistantCharLength = this.getAcceptAssistantCharLength();
        result = result * 59 + ($acceptAssistantCharLength == null ? 43 : ((Object)$acceptAssistantCharLength).hashCode());
        Long $acceptAssistantNewLineCount = this.getAcceptAssistantNewLineCount();
        result = result * 59 + ($acceptAssistantNewLineCount == null ? 43 : ((Object)$acceptAssistantNewLineCount).hashCode());
        Long $acceptNesCharLength = this.getAcceptNesCharLength();
        result = result * 59 + ($acceptNesCharLength == null ? 43 : ((Object)$acceptNesCharLength).hashCode());
        Long $acceptNesNewLineCount = this.getAcceptNesNewLineCount();
        result = result * 59 + ($acceptNesNewLineCount == null ? 43 : ((Object)$acceptNesNewLineCount).hashCode());
        Long $acceptInlineEditNewLineCount = this.getAcceptInlineEditNewLineCount();
        result = result * 59 + ($acceptInlineEditNewLineCount == null ? 43 : ((Object)$acceptInlineEditNewLineCount).hashCode());
        Long $acceptInlineEditCharLength = this.getAcceptInlineEditCharLength();
        result = result * 59 + ($acceptInlineEditCharLength == null ? 43 : ((Object)$acceptInlineEditCharLength).hashCode());
        List<Map<String, String>> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    @Generated
    public TextChangeSummaryBO(Long acceptCompletionCharLength, Long acceptCompletionNewLineCount, Long acceptChatCharLength, Long acceptChatNewLineCount, Long acceptDeveloperCharLength, Long acceptDeveloperNewLineCount, Long acceptAssistantCharLength, Long acceptAssistantNewLineCount, Long acceptNesCharLength, Long acceptNesNewLineCount, Long acceptInlineEditNewLineCount, Long acceptInlineEditCharLength, List<Map<String, String>> details) {
        this.acceptCompletionCharLength = acceptCompletionCharLength;
        this.acceptCompletionNewLineCount = acceptCompletionNewLineCount;
        this.acceptChatCharLength = acceptChatCharLength;
        this.acceptChatNewLineCount = acceptChatNewLineCount;
        this.acceptDeveloperCharLength = acceptDeveloperCharLength;
        this.acceptDeveloperNewLineCount = acceptDeveloperNewLineCount;
        this.acceptAssistantCharLength = acceptAssistantCharLength;
        this.acceptAssistantNewLineCount = acceptAssistantNewLineCount;
        this.acceptNesCharLength = acceptNesCharLength;
        this.acceptNesNewLineCount = acceptNesNewLineCount;
        this.acceptInlineEditNewLineCount = acceptInlineEditNewLineCount;
        this.acceptInlineEditCharLength = acceptInlineEditCharLength;
        this.details = details;
    }

    @Generated
    public Long getAcceptCompletionCharLength() {
        return this.acceptCompletionCharLength;
    }

    @Generated
    public Long getAcceptCompletionNewLineCount() {
        return this.acceptCompletionNewLineCount;
    }

    @Generated
    public Long getAcceptChatCharLength() {
        return this.acceptChatCharLength;
    }

    @Generated
    public Long getAcceptChatNewLineCount() {
        return this.acceptChatNewLineCount;
    }

    @Generated
    public Long getAcceptDeveloperCharLength() {
        return this.acceptDeveloperCharLength;
    }

    @Generated
    public Long getAcceptDeveloperNewLineCount() {
        return this.acceptDeveloperNewLineCount;
    }

    @Generated
    public Long getAcceptAssistantCharLength() {
        return this.acceptAssistantCharLength;
    }

    @Generated
    public Long getAcceptAssistantNewLineCount() {
        return this.acceptAssistantNewLineCount;
    }

    @Generated
    public Long getAcceptNesCharLength() {
        return this.acceptNesCharLength;
    }

    @Generated
    public Long getAcceptNesNewLineCount() {
        return this.acceptNesNewLineCount;
    }

    @Generated
    public Long getAcceptInlineEditNewLineCount() {
        return this.acceptInlineEditNewLineCount;
    }

    @Generated
    public Long getAcceptInlineEditCharLength() {
        return this.acceptInlineEditCharLength;
    }

    @Generated
    public List<Map<String, String>> getDetails() {
        return this.details;
    }

    @Generated
    public void setAcceptCompletionCharLength(Long acceptCompletionCharLength) {
        this.acceptCompletionCharLength = acceptCompletionCharLength;
    }

    @Generated
    public void setAcceptCompletionNewLineCount(Long acceptCompletionNewLineCount) {
        this.acceptCompletionNewLineCount = acceptCompletionNewLineCount;
    }

    @Generated
    public void setAcceptChatCharLength(Long acceptChatCharLength) {
        this.acceptChatCharLength = acceptChatCharLength;
    }

    @Generated
    public void setAcceptChatNewLineCount(Long acceptChatNewLineCount) {
        this.acceptChatNewLineCount = acceptChatNewLineCount;
    }

    @Generated
    public void setAcceptDeveloperCharLength(Long acceptDeveloperCharLength) {
        this.acceptDeveloperCharLength = acceptDeveloperCharLength;
    }

    @Generated
    public void setAcceptDeveloperNewLineCount(Long acceptDeveloperNewLineCount) {
        this.acceptDeveloperNewLineCount = acceptDeveloperNewLineCount;
    }

    @Generated
    public void setAcceptAssistantCharLength(Long acceptAssistantCharLength) {
        this.acceptAssistantCharLength = acceptAssistantCharLength;
    }

    @Generated
    public void setAcceptAssistantNewLineCount(Long acceptAssistantNewLineCount) {
        this.acceptAssistantNewLineCount = acceptAssistantNewLineCount;
    }

    @Generated
    public void setAcceptNesCharLength(Long acceptNesCharLength) {
        this.acceptNesCharLength = acceptNesCharLength;
    }

    @Generated
    public void setAcceptNesNewLineCount(Long acceptNesNewLineCount) {
        this.acceptNesNewLineCount = acceptNesNewLineCount;
    }

    @Generated
    public void setAcceptInlineEditNewLineCount(Long acceptInlineEditNewLineCount) {
        this.acceptInlineEditNewLineCount = acceptInlineEditNewLineCount;
    }

    @Generated
    public void setAcceptInlineEditCharLength(Long acceptInlineEditCharLength) {
        this.acceptInlineEditCharLength = acceptInlineEditCharLength;
    }

    @Generated
    public void setDetails(List<Map<String, String>> details) {
        this.details = details;
    }

    @Override
    @Generated
    public String toString() {
        return "TextChangeSummaryBO(acceptCompletionCharLength=" + this.getAcceptCompletionCharLength() + ", acceptCompletionNewLineCount=" + this.getAcceptCompletionNewLineCount() + ", acceptChatCharLength=" + this.getAcceptChatCharLength() + ", acceptChatNewLineCount=" + this.getAcceptChatNewLineCount() + ", acceptDeveloperCharLength=" + this.getAcceptDeveloperCharLength() + ", acceptDeveloperNewLineCount=" + this.getAcceptDeveloperNewLineCount() + ", acceptAssistantCharLength=" + this.getAcceptAssistantCharLength() + ", acceptAssistantNewLineCount=" + this.getAcceptAssistantNewLineCount() + ", acceptNesCharLength=" + this.getAcceptNesCharLength() + ", acceptNesNewLineCount=" + this.getAcceptNesNewLineCount() + ", acceptInlineEditNewLineCount=" + this.getAcceptInlineEditNewLineCount() + ", acceptInlineEditCharLength=" + this.getAcceptInlineEditCharLength() + ", details=" + this.getDetails() + ")";
    }

    @Generated
    private static final class TextChangeSummaryBOBuilderImpl
    extends TextChangeSummaryBOBuilder<TextChangeSummaryBO, TextChangeSummaryBOBuilderImpl> {
        @Generated
        private TextChangeSummaryBOBuilderImpl() {
        }

        @Override
        @Generated
        protected TextChangeSummaryBOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TextChangeSummaryBO build() {
            return new TextChangeSummaryBO(this);
        }
    }

    @Generated
    public static abstract class TextChangeSummaryBOBuilder<C extends TextChangeSummaryBO, B extends TextChangeSummaryBOBuilder<C, B>>
    extends BaseTextChangeMetric.BaseTextChangeMetricBuilder<C, B> {
        @Generated
        private Long acceptCompletionCharLength;
        @Generated
        private Long acceptCompletionNewLineCount;
        @Generated
        private Long acceptChatCharLength;
        @Generated
        private Long acceptChatNewLineCount;
        @Generated
        private Long acceptDeveloperCharLength;
        @Generated
        private Long acceptDeveloperNewLineCount;
        @Generated
        private Long acceptAssistantCharLength;
        @Generated
        private Long acceptAssistantNewLineCount;
        @Generated
        private Long acceptNesCharLength;
        @Generated
        private Long acceptNesNewLineCount;
        @Generated
        private Long acceptInlineEditNewLineCount;
        @Generated
        private Long acceptInlineEditCharLength;
        @Generated
        private List<Map<String, String>> details;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B acceptCompletionCharLength(Long acceptCompletionCharLength) {
            this.acceptCompletionCharLength = acceptCompletionCharLength;
            return (B)this.self();
        }

        @Generated
        public B acceptCompletionNewLineCount(Long acceptCompletionNewLineCount) {
            this.acceptCompletionNewLineCount = acceptCompletionNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptChatCharLength(Long acceptChatCharLength) {
            this.acceptChatCharLength = acceptChatCharLength;
            return (B)this.self();
        }

        @Generated
        public B acceptChatNewLineCount(Long acceptChatNewLineCount) {
            this.acceptChatNewLineCount = acceptChatNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptDeveloperCharLength(Long acceptDeveloperCharLength) {
            this.acceptDeveloperCharLength = acceptDeveloperCharLength;
            return (B)this.self();
        }

        @Generated
        public B acceptDeveloperNewLineCount(Long acceptDeveloperNewLineCount) {
            this.acceptDeveloperNewLineCount = acceptDeveloperNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptAssistantCharLength(Long acceptAssistantCharLength) {
            this.acceptAssistantCharLength = acceptAssistantCharLength;
            return (B)this.self();
        }

        @Generated
        public B acceptAssistantNewLineCount(Long acceptAssistantNewLineCount) {
            this.acceptAssistantNewLineCount = acceptAssistantNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptNesCharLength(Long acceptNesCharLength) {
            this.acceptNesCharLength = acceptNesCharLength;
            return (B)this.self();
        }

        @Generated
        public B acceptNesNewLineCount(Long acceptNesNewLineCount) {
            this.acceptNesNewLineCount = acceptNesNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptInlineEditNewLineCount(Long acceptInlineEditNewLineCount) {
            this.acceptInlineEditNewLineCount = acceptInlineEditNewLineCount;
            return (B)this.self();
        }

        @Generated
        public B acceptInlineEditCharLength(Long acceptInlineEditCharLength) {
            this.acceptInlineEditCharLength = acceptInlineEditCharLength;
            return (B)this.self();
        }

        @Generated
        public B details(List<Map<String, String>> details) {
            this.details = details;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TextChangeSummaryBO.TextChangeSummaryBOBuilder(super=" + super.toString() + ", acceptCompletionCharLength=" + this.acceptCompletionCharLength + ", acceptCompletionNewLineCount=" + this.acceptCompletionNewLineCount + ", acceptChatCharLength=" + this.acceptChatCharLength + ", acceptChatNewLineCount=" + this.acceptChatNewLineCount + ", acceptDeveloperCharLength=" + this.acceptDeveloperCharLength + ", acceptDeveloperNewLineCount=" + this.acceptDeveloperNewLineCount + ", acceptAssistantCharLength=" + this.acceptAssistantCharLength + ", acceptAssistantNewLineCount=" + this.acceptAssistantNewLineCount + ", acceptNesCharLength=" + this.acceptNesCharLength + ", acceptNesNewLineCount=" + this.acceptNesNewLineCount + ", acceptInlineEditNewLineCount=" + this.acceptInlineEditNewLineCount + ", acceptInlineEditCharLength=" + this.acceptInlineEditCharLength + ", details=" + this.details + ")";
        }
    }
}

