/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class Measurements {
    Character charBeforeCaret;
    Character charAfterCaret;
    Character charTrimBeforeCaret;
    Character charTrimAfterCaret;
    Integer lastLineLengthBeforeCaret;
    Integer lastLineTrimEndLengthBeforeCaret;
    Integer documentLength;
    Integer caretCharOffset;
    Long completionDelayMs;

    public static Measurements build(@NonNull Editor editor) {
        if (editor == null) {
            throw new NullPointerException("editor is marked @NonNull but is null");
        }
        return (Measurements)ApplicationManager.getApplication().runReadAction(() -> {
            int caretOffset = editor.getCaretModel().getOffset();
            return Measurements.build(editor, caretOffset);
        });
    }

    public static Measurements build(@NonNull Editor editor, int caretOffset) {
        if (editor == null) {
            throw new NullPointerException("editor is marked @NonNull but is null");
        }
        String text = editor.getDocument().getText();
        int lineNumber = editor.getDocument().getLineNumber(caretOffset);
        Measurements measurements = new Measurements();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return measurements;
        }
        measurements.setCaretCharOffset(caretOffset);
        if (text.length() > measurements.getCaretCharOffset()) {
            measurements.setCharAfterCaret(Character.valueOf(text.charAt(measurements.getCaretCharOffset())));
            String suffix = text.substring(measurements.getCaretCharOffset()).trim();
            if (!suffix.isEmpty()) {
                measurements.setCharTrimAfterCaret(Character.valueOf(suffix.charAt(0)));
            }
        }
        if (measurements.getCaretCharOffset() > 1) {
            measurements.setCharBeforeCaret(Character.valueOf(text.charAt(measurements.getCaretCharOffset() - 2)));
            String prefix = text.substring(0, measurements.getCaretCharOffset()).trim();
            if (!prefix.isEmpty()) {
                measurements.setCharTrimBeforeCaret(Character.valueOf(prefix.charAt(prefix.length() - 1)));
            }
        }
        measurements.setDocumentLength(text.length());
        if (lineNumber > 0) {
            int lastLineStartOffset = editor.getDocument().getLineStartOffset(lineNumber - 1);
            int lastLineEndOffset = editor.getDocument().getLineEndOffset(lineNumber - 1);
            String lastLine = editor.getDocument().getText(new TextRange(lastLineStartOffset, lastLineEndOffset));
            measurements.setLastLineLengthBeforeCaret(lastLine.length());
            measurements.setLastLineTrimEndLengthBeforeCaret(StringUtils.stripEnd((String)lastLine, (String)" \t\r\n").length());
        }
        return measurements;
    }

    @Generated
    public Character getCharBeforeCaret() {
        return this.charBeforeCaret;
    }

    @Generated
    public Character getCharAfterCaret() {
        return this.charAfterCaret;
    }

    @Generated
    public Character getCharTrimBeforeCaret() {
        return this.charTrimBeforeCaret;
    }

    @Generated
    public Character getCharTrimAfterCaret() {
        return this.charTrimAfterCaret;
    }

    @Generated
    public Integer getLastLineLengthBeforeCaret() {
        return this.lastLineLengthBeforeCaret;
    }

    @Generated
    public Integer getLastLineTrimEndLengthBeforeCaret() {
        return this.lastLineTrimEndLengthBeforeCaret;
    }

    @Generated
    public Integer getDocumentLength() {
        return this.documentLength;
    }

    @Generated
    public Integer getCaretCharOffset() {
        return this.caretCharOffset;
    }

    @Generated
    public Long getCompletionDelayMs() {
        return this.completionDelayMs;
    }

    @Generated
    public void setCharBeforeCaret(Character charBeforeCaret) {
        this.charBeforeCaret = charBeforeCaret;
    }

    @Generated
    public void setCharAfterCaret(Character charAfterCaret) {
        this.charAfterCaret = charAfterCaret;
    }

    @Generated
    public void setCharTrimBeforeCaret(Character charTrimBeforeCaret) {
        this.charTrimBeforeCaret = charTrimBeforeCaret;
    }

    @Generated
    public void setCharTrimAfterCaret(Character charTrimAfterCaret) {
        this.charTrimAfterCaret = charTrimAfterCaret;
    }

    @Generated
    public void setLastLineLengthBeforeCaret(Integer lastLineLengthBeforeCaret) {
        this.lastLineLengthBeforeCaret = lastLineLengthBeforeCaret;
    }

    @Generated
    public void setLastLineTrimEndLengthBeforeCaret(Integer lastLineTrimEndLengthBeforeCaret) {
        this.lastLineTrimEndLengthBeforeCaret = lastLineTrimEndLengthBeforeCaret;
    }

    @Generated
    public void setDocumentLength(Integer documentLength) {
        this.documentLength = documentLength;
    }

    @Generated
    public void setCaretCharOffset(Integer caretCharOffset) {
        this.caretCharOffset = caretCharOffset;
    }

    @Generated
    public void setCompletionDelayMs(Long completionDelayMs) {
        this.completionDelayMs = completionDelayMs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Measurements)) {
            return false;
        }
        Measurements other = (Measurements)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Character this$charBeforeCaret = this.getCharBeforeCaret();
        Character other$charBeforeCaret = other.getCharBeforeCaret();
        if (this$charBeforeCaret == null ? other$charBeforeCaret != null : !((Object)this$charBeforeCaret).equals(other$charBeforeCaret)) {
            return false;
        }
        Character this$charAfterCaret = this.getCharAfterCaret();
        Character other$charAfterCaret = other.getCharAfterCaret();
        if (this$charAfterCaret == null ? other$charAfterCaret != null : !((Object)this$charAfterCaret).equals(other$charAfterCaret)) {
            return false;
        }
        Character this$charTrimBeforeCaret = this.getCharTrimBeforeCaret();
        Character other$charTrimBeforeCaret = other.getCharTrimBeforeCaret();
        if (this$charTrimBeforeCaret == null ? other$charTrimBeforeCaret != null : !((Object)this$charTrimBeforeCaret).equals(other$charTrimBeforeCaret)) {
            return false;
        }
        Character this$charTrimAfterCaret = this.getCharTrimAfterCaret();
        Character other$charTrimAfterCaret = other.getCharTrimAfterCaret();
        if (this$charTrimAfterCaret == null ? other$charTrimAfterCaret != null : !((Object)this$charTrimAfterCaret).equals(other$charTrimAfterCaret)) {
            return false;
        }
        Integer this$lastLineLengthBeforeCaret = this.getLastLineLengthBeforeCaret();
        Integer other$lastLineLengthBeforeCaret = other.getLastLineLengthBeforeCaret();
        if (this$lastLineLengthBeforeCaret == null ? other$lastLineLengthBeforeCaret != null : !((Object)this$lastLineLengthBeforeCaret).equals(other$lastLineLengthBeforeCaret)) {
            return false;
        }
        Integer this$lastLineTrimEndLengthBeforeCaret = this.getLastLineTrimEndLengthBeforeCaret();
        Integer other$lastLineTrimEndLengthBeforeCaret = other.getLastLineTrimEndLengthBeforeCaret();
        if (this$lastLineTrimEndLengthBeforeCaret == null ? other$lastLineTrimEndLengthBeforeCaret != null : !((Object)this$lastLineTrimEndLengthBeforeCaret).equals(other$lastLineTrimEndLengthBeforeCaret)) {
            return false;
        }
        Integer this$documentLength = this.getDocumentLength();
        Integer other$documentLength = other.getDocumentLength();
        if (this$documentLength == null ? other$documentLength != null : !((Object)this$documentLength).equals(other$documentLength)) {
            return false;
        }
        Integer this$caretCharOffset = this.getCaretCharOffset();
        Integer other$caretCharOffset = other.getCaretCharOffset();
        if (this$caretCharOffset == null ? other$caretCharOffset != null : !((Object)this$caretCharOffset).equals(other$caretCharOffset)) {
            return false;
        }
        Long this$completionDelayMs = this.getCompletionDelayMs();
        Long other$completionDelayMs = other.getCompletionDelayMs();
        return !(this$completionDelayMs == null ? other$completionDelayMs != null : !((Object)this$completionDelayMs).equals(other$completionDelayMs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Measurements;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Character $charBeforeCaret = this.getCharBeforeCaret();
        result = result * 59 + ($charBeforeCaret == null ? 43 : ((Object)$charBeforeCaret).hashCode());
        Character $charAfterCaret = this.getCharAfterCaret();
        result = result * 59 + ($charAfterCaret == null ? 43 : ((Object)$charAfterCaret).hashCode());
        Character $charTrimBeforeCaret = this.getCharTrimBeforeCaret();
        result = result * 59 + ($charTrimBeforeCaret == null ? 43 : ((Object)$charTrimBeforeCaret).hashCode());
        Character $charTrimAfterCaret = this.getCharTrimAfterCaret();
        result = result * 59 + ($charTrimAfterCaret == null ? 43 : ((Object)$charTrimAfterCaret).hashCode());
        Integer $lastLineLengthBeforeCaret = this.getLastLineLengthBeforeCaret();
        result = result * 59 + ($lastLineLengthBeforeCaret == null ? 43 : ((Object)$lastLineLengthBeforeCaret).hashCode());
        Integer $lastLineTrimEndLengthBeforeCaret = this.getLastLineTrimEndLengthBeforeCaret();
        result = result * 59 + ($lastLineTrimEndLengthBeforeCaret == null ? 43 : ((Object)$lastLineTrimEndLengthBeforeCaret).hashCode());
        Integer $documentLength = this.getDocumentLength();
        result = result * 59 + ($documentLength == null ? 43 : ((Object)$documentLength).hashCode());
        Integer $caretCharOffset = this.getCaretCharOffset();
        result = result * 59 + ($caretCharOffset == null ? 43 : ((Object)$caretCharOffset).hashCode());
        Long $completionDelayMs = this.getCompletionDelayMs();
        result = result * 59 + ($completionDelayMs == null ? 43 : ((Object)$completionDelayMs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Measurements(charBeforeCaret=" + this.getCharBeforeCaret() + ", charAfterCaret=" + this.getCharAfterCaret() + ", charTrimBeforeCaret=" + this.getCharTrimBeforeCaret() + ", charTrimAfterCaret=" + this.getCharTrimAfterCaret() + ", lastLineLengthBeforeCaret=" + this.getLastLineLengthBeforeCaret() + ", lastLineTrimEndLengthBeforeCaret=" + this.getLastLineTrimEndLengthBeforeCaret() + ", documentLength=" + this.getDocumentLength() + ", caretCharOffset=" + this.getCaretCharOffset() + ", completionDelayMs=" + this.getCompletionDelayMs() + ")";
    }

    @Generated
    public Measurements() {
    }
}

