/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibabacloud.intellij.cosy.LingmaApplication;
import com.alibabacloud.intellij.cosy.chat.processor.ChatNotificationProcessor;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.LoginResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.LoginStartResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.cosy.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.notifications.PrivacyPolicyDialog;
import com.alibabacloud.intellij.cosy.ui.notifications.StartupNotification;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UserAuthServiceImpl
implements UserAuthService {
    private static Logger log = Logger.getInstance(UserAuthServiceImpl.class);
    private static final long REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static final long CACHE_MINUTE_LIMIT = 5L;
    private static final long MAX_REPORT_MESSAGE_COUNT = 100L;
    private final Cache<String, String> reportMessageCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(100L).build();

    public UserAuthServiceImpl() {
        LingmaApplication.init();
    }

    @Override
    public void login(Project project, JComponent notifyComponent) {
        this.login(project, notifyComponent, LoginParams.fromAliyun());
    }

    @Override
    public void login(Project project, JComponent notifyComponent, LoginParams loginParams) {
        if (!this.checkProject(project, notifyComponent)) {
            return;
        }
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.doLogin(project, notifyComponent, loginParams);
            return;
        }
        File privacyPolicyFile = new File(CosyConfig.getHomeDirectory().toFile(), "cache/policy");
        if (!privacyPolicyFile.exists() && !CosyConfig.isQoderEnabled()) {
            new PrivacyPolicyDialog(privacyPolicyFile, file -> this.doLogin(project, notifyComponent, loginParams), loginParams.getRegionEnv()).show();
        } else {
            this.doLogin(project, notifyComponent, loginParams);
        }
    }

    private boolean checkProject(Project project, JComponent notifyComponent) {
        if (project == null || project.isDefault()) {
            log.warn("project is null/default, ignore login/logout");
            if (notifyComponent != null) {
                NotificationFactory.showToast(notifyComponent, MessageType.ERROR, CosyBundle.message("notifications.required.open.project", new Object[0]));
            } else {
                NotificationFactory.showNotification(project, NotificationType.ERROR, CosyBundle.message("notifications.required.open.project", new Object[0]), new AnAction[0]);
            }
            return false;
        }
        return true;
    }

    private void doLogin(final Project project, final JComponent notifyComponent, final LoginParams loginParams) {
        ProgressManager.getInstance().run((Task)new Task.Modal(project, CosyBundle.message("task.progress.login.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!loginParams.validate()) {
                    UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, AuthStatus.NOT_LOGIN, false, CosyBundle.message("notifications.auth.login.info.invalidate", new Object[0]));
                    return;
                }
                progressIndicator.setText(CosyBundle.message("task.progress.login.progress.check.local.state", new Object[0]));
                try {
                    boolean succeed = ProcessUtils.checkAndWaitCosyState(progressIndicator, project);
                    if (succeed) {
                        LoginResult info;
                        progressIndicator.setText(CosyBundle.messageQoder("task.progress.login.progress.request.auth", new Object[0]));
                        if (CosyConfig.isQoderEnabled() && null != (info = Cosy.INSTANCE.getLanguageService(project).getLoginInfo(2000L))) {
                            if (Boolean.TRUE.equals(info.getSuccess())) {
                                BrowserUtil.browse((String)info.getLoginUrl());
                            } else if ("network_error".equals(info.getErrorCode())) {
                                progressIndicator.cancel();
                                NotificationFactory.showNotification(project, NotificationType.WARNING, CosyBundle.message("error.network.message", new Object[0]), new AnAction[]{new ChatNotificationProcessor.ChatNotificationAction(CosyBundle.message("error.network.configure.proxy", new Object[0]), Void2 -> SwingUtilities.invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(project, CosyConfigurable.class))), new ChatNotificationProcessor.ChatNotificationAction(CosyBundle.message("error.network.view.guide", new Object[0]), Void2 -> BrowserUtil.browse((String)LingmaUrls.NETWORK_ERROR_URL.getRealUrl()))});
                            }
                            return;
                        }
                        LoginUtil.resetLoginResult();
                        LoginStartResult loginStartResult = Cosy.INSTANCE.getLanguageService(project).authLogin(loginParams, 10000L);
                        if (loginStartResult == null || loginStartResult.getSuccess() == null || !loginStartResult.getSuccess().booleanValue()) {
                            UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.message("task.progress.login.msg.request.error", new Object[0]));
                        } else {
                            AuthStatus status = UserAuthServiceImpl.this.checkLoginAuthState(progressIndicator, project, loginStartResult);
                            if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
                                UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, status, true, null);
                            } else {
                                status = status == null ? AuthStatus.NOT_LOGIN : status;
                                String reason = "";
                                reason = status.getStatus() == null ? CosyBundle.message("task.progress.login.msg.auth.error", new Object[0]) : (AuthStateEnum.NETWORK_ERROR.getValue() == status.getStatus().intValue() || AuthStateEnum.ERROR.getValue() == status.getStatus().intValue() ? String.format("%s <a href=\"%s\">%s</a>", CosyBundle.message("notifications.auth.network.error", new Object[0]), LingmaUrls.NETWORK_ERROR_URL.getRealUrl(), CosyBundle.message("notifications.action.button.learn", new Object[0])) : (AuthStateEnum.IP_BANNED_ERROR.getValue() == status.getStatus().intValue() ? CosyBundle.message("notifications.auth.ip.whitelist.error", new Object[0]) : (AuthStateEnum.APP_DISABLED_ERROR.getValue() == status.getStatus().intValue() ? CosyBundle.message("notifications.auth.app.disabled.error", new Object[0]) : CosyBundle.message("task.progress.login.msg.auth.error", new Object[0]))));
                                UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, status, false, reason);
                            }
                        }
                    } else {
                        UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.messageQoder("error.notify.toast.content", new Object[0]));
                    }
                }
                catch (ProcessCanceledException e) {
                    log.warn("auth login has been canceled.");
                    UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, AuthStatus.NOT_LOGIN, false, null);
                }
                catch (Exception e) {
                    log.warn("auth login error. " + e.getMessage(), (Throwable)e);
                    UserAuthServiceImpl.this.notifyLoginResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.message("task.progress.login.msg.internal.error", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/alibabacloud/intellij/cosy/service/impl/UserAuthServiceImpl$1", "run"));
            }
        });
    }

    @Override
    public void logout(final Project project, final JComponent notifyComponent) {
        if (!this.checkProject(project, notifyComponent)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, CosyBundle.message("task.progress.logout.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                progressIndicator.setText(CosyBundle.message("task.progress.logout.progress.check.local.state", new Object[0]));
                try {
                    boolean succeed = ProcessUtils.checkAndWaitCosyState(progressIndicator, project);
                    if (succeed) {
                        progressIndicator.setText(CosyBundle.messageQoder("task.progress.logout.progress.request.auth", new Object[0]));
                        if (Cosy.INSTANCE.getLanguageService(project).authLogout(10000L)) {
                            UserAuthServiceImpl.this.notifyLogoutResult(project, notifyComponent, AuthStatus.NOT_LOGIN, true, null);
                        } else {
                            UserAuthServiceImpl.this.notifyLogoutResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.messageQoder("task.progress.logout.msg.exit.auth", new Object[0]));
                        }
                    } else {
                        UserAuthServiceImpl.this.notifyLogoutResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.messageQoder("error.notify.toast.content", new Object[0]));
                    }
                }
                catch (ProcessCanceledException e) {
                    log.warn("auth login has been canceled.");
                    UserAuthServiceImpl.this.notifyLogoutResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, null);
                }
                catch (Exception e) {
                    log.warn("auth login error. " + e.getMessage(), (Throwable)e);
                    UserAuthServiceImpl.this.notifyLogoutResult(project, notifyComponent, AuthStatus.ERROR_LOGIN, false, CosyBundle.message("task.progress.logout.msg.internal.error", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/alibabacloud/intellij/cosy/service/impl/UserAuthServiceImpl$2", "run"));
            }
        });
    }

    @Override
    public AuthStatus getState(Project project) {
        if (project == null || project.isDefault()) {
            return AuthStatus.NOT_LOGIN;
        }
        if (Cosy.INSTANCE.checkCosy(project)) {
            return Cosy.INSTANCE.getLanguageService(project).authStatus(REQUEST_TIMEOUT, 2);
        }
        ThreadUtil.execute(() -> {
            if (Cosy.INSTANCE.checkAndWaitCosyState(null, project)) {
                try {
                    AuthStatus authStatus = Cosy.INSTANCE.getLanguageService(project).authStatus(10000L);
                    SwingUtilities.invokeAndWait(() -> ((AuthLoginNotifier)project.getMessageBus().syncPublisher(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION)).notifyLoginAuth(authStatus));
                }
                catch (Exception e) {
                    log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
                }
            }
        });
        return null;
    }

    @Override
    public boolean requireLogin(Project project) {
        AuthStatus authStatus = UserAuthService.getInstance().getState(project);
        if (authStatus == null) {
            NotificationFactory.showWarnNotification(project, I18NConstant.LOGIN_MSG_GET_FAILED);
            return false;
        }
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
        if (authStatus.getStatus().intValue() == AuthStateEnum.NETWORK_ERROR.getValue()) {
            GrantAuthorNotification.notifyNetworkErrorDirectly(project, authStatus);
            return false;
        }
        if (authStatus.getStatus().intValue() == AuthStateEnum.IP_BANNED_ERROR.getValue() && StringUtils.isNotBlank((CharSequence)authStatus.getOrgName())) {
            GrantAuthorNotification.notifyIpBannedErrorDirectly(project, authStatus);
            return false;
        }
        if (authStatus.getStatus().intValue() == AuthStateEnum.APP_DISABLED_ERROR.getValue()) {
            GrantAuthorNotification.notifyAppDisabledErrorDirectly(project, authStatus);
            return false;
        }
        if (authStatus.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            GrantAuthorNotification.notifyNeedLoginDirectly(project);
            return false;
        }
        if (authStatus.getWhitelist() == null) {
            NotificationFactory.showWarnNotification(project, CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]));
            return false;
        }
        if (authStatus.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NOT_WHITELIST.getValue()) {
                GrantAuthorNotification.notifyNeedWhitelistDirectly(project, authStatus);
            } else if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
                GrantAuthorNotification.notifyRequireLicenseDirectly(project, authStatus);
            } else if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.ORG_ORDER_EXPIRED.getValue()) {
                NotificationFactory.showWarnNotification(project, String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), authStatus.getName(), authStatus.getOrgName()));
            } else {
                NotificationFactory.showWarnNotification(project, CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]));
            }
            return false;
        }
        return true;
    }

    private AuthStatus checkLoginAuthState(@NotNull ProgressIndicator progressIndicator, @NotNull Project project, LoginStartResult loginStartResult) {
        if (progressIndicator == null) {
            UserAuthServiceImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            UserAuthServiceImpl.$$$reportNull$$$0(1);
        }
        if (StringUtils.isNotBlank((CharSequence)loginStartResult.getUrl())) {
            StringSelection selection = new StringSelection(loginStartResult.getUrl());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
        progressIndicator.setText(CosyBundle.message("task.progress.getting.auth.state", new Object[0]));
        try {
            Notification notification = null;
            boolean showUrlTips = false;
            long maxTime = TimeUnit.MINUTES.toMillis(5L);
            long showTipsTime = TimeUnit.SECONDS.toMillis(5L);
            long doubleCheckDuration = TimeUnit.SECONDS.toMillis(10L);
            long startTime = System.currentTimeMillis();
            long doubleCheckStartTime = System.currentTimeMillis();
            log.info("waiting to get auth login result");
            while (true) {
                ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progressIndicator);
                if (LoginUtil.waitAuthLogin(1L, TimeUnit.SECONDS)) {
                    if (notification != null) {
                        notification.expire();
                    }
                    return LoginUtil.getLoginResult();
                }
                if (System.currentTimeMillis() - startTime > maxTime) {
                    log.info("Checking cosy state: timeout");
                    break;
                }
                if (System.currentTimeMillis() - doubleCheckStartTime > doubleCheckDuration || LoginUtil.getLoginResult() != null) {
                    AuthStatus status = LoginUtil.getAuthStatus(project);
                    log.info("double checking cosy state: " + status);
                    if (AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
                        if (notification != null) {
                            notification.expire();
                        }
                        return status;
                    }
                    doubleCheckStartTime = System.currentTimeMillis();
                }
                if (showUrlTips || System.currentTimeMillis() - startTime <= showTipsTime || !StringUtils.isNotBlank((CharSequence)loginStartResult.getUrl())) continue;
                showUrlTips = true;
                notification = new Notification(ActionUtil.getActionIdWithLowerCase("cosyStickyNotifications"), I18NConstant.COSY_PLUGIN_NAME, CosyBundle.messageQoder("notifications.auth.url.tips", new Object[0]), NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification);
            }
        }
        catch (ProcessCanceledException e) {
            AuthStatus status = LoginUtil.getAuthStatus(project);
            if (AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
                return status;
            }
            throw e;
        }
        catch (Exception e) {
            log.warn("failed to wait auth login. " + e.getMessage());
        }
        AuthStatus status = LoginUtil.getAuthStatus(project);
        if (AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            return status;
        }
        return null;
    }

    private void notifyLoginResult(Project project, JComponent notifyComponent, AuthStatus authStatus, boolean success, String reason) {
        if (success) {
            if (notifyComponent != null) {
                NotificationFactory.showToast(notifyComponent, MessageType.INFO, CosyBundle.message("notifications.auth.login.success", new Object[0]));
            } else {
                NotificationFactory.showNotification(project, NotificationType.INFORMATION, CosyBundle.message("notifications.auth.login.success", new Object[0]), new AnAction[0]);
            }
        } else if (reason != null) {
            if (notifyComponent != null) {
                NotificationFactory.showToast(notifyComponent, MessageType.ERROR, CosyBundle.message("notifications.auth.login.failed", new Object[0]) + reason);
            } else if (CosyBundle.messageQoder("error.notify.toast.content", new Object[0]).equals(reason)) {
                StartupNotification.notifyStartupError(project);
            } else {
                NotificationFactory.showNotification(project, NotificationType.ERROR, CosyBundle.message("notifications.auth.login.failed", new Object[0]), reason);
            }
        }
        try {
            SwingUtilities.invokeAndWait(() -> ((AuthLoginNotifier)project.getMessageBus().syncPublisher(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION)).notifyLoginAuth(authStatus));
        }
        catch (Exception e) {
            log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
        }
    }

    private void notifyLogoutResult(Project project, JComponent notifyComponent, AuthStatus authStatus, boolean success, String reason) {
        if (success) {
            if (notifyComponent != null) {
                NotificationFactory.showToast(notifyComponent, MessageType.INFO, CosyBundle.message("notifications.auth.logout.success", new Object[0]));
            } else {
                NotificationFactory.showNotification(project, NotificationType.INFORMATION, CosyBundle.message("notifications.auth.logout.success", new Object[0]), new AnAction[0]);
            }
        } else if (reason != null) {
            if (notifyComponent != null) {
                NotificationFactory.showToast(notifyComponent, MessageType.ERROR, CosyBundle.message("notifications.auth.logout.failed", new Object[0]) + reason);
            } else {
                NotificationFactory.showNotification(project, NotificationType.ERROR, CosyBundle.message("notifications.auth.logout.failed", new Object[0]), reason);
            }
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
                ((AuthLogoutNotifier)project.getMessageBus().syncPublisher(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION)).notifyLogout(authStatus);
            });
        }
        catch (Exception e) {
            log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authReport(AuthStatus authStatus) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isOpen()) continue;
            if (StringUtils.isNotBlank((CharSequence)authStatus.getMessageId())) {
                String cacheKey = String.format("%s:%s", project.getName(), authStatus.getMessageId());
                String msgId = (String)this.reportMessageCache.getIfPresent((Object)cacheKey);
                if (msgId != null) {
                    log.info("ignore repeat auth message:" + cacheKey);
                    continue;
                }
                Cache<String, String> cache = this.reportMessageCache;
                synchronized (cache) {
                    if (this.reportMessageCache.getIfPresent((Object)cacheKey) != null) {
                        log.info("ignore repeat auth message double-check:" + cacheKey);
                        continue;
                    }
                    this.reportMessageCache.put((Object)cacheKey, (Object)authStatus.getMessageId());
                }
            }
            log.info("receive project auth report:" + project.getName() + " msg:" + authStatus.getMessageId());
            if (StringUtils.isNotBlank((CharSequence)authStatus.getId()) && AuthStateEnum.LOGIN.getValue() == authStatus.getStatus().intValue()) {
                ((AuthLoginNotifier)project.getMessageBus().syncPublisher(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION)).notifyLoginAuth(authStatus);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)authStatus.getId())) continue;
            ((AuthLogoutNotifier)project.getMessageBus().syncPublisher(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION)).notifyLogout(authStatus);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "progressIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/cosy/service/impl/UserAuthServiceImpl";
        objectArray[2] = "checkLoginAuthState";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

